/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.mediation;

import com.dorado.common.exception.OWException;
import com.dorado.core.ejb.ruleengine.OWRuleEngineClient;
import com.dorado.core.mediation.authentication.OWAuthentication;
import com.dorado.core.mediation.base.OWMBeanClient;
import com.dorado.core.mediation.snmp.OWSnmpAuthentication;
import com.dorado.oware.core.mediation.agent.OWAssignmentBean;
import com.dorado.runtime.IOWEventListener;
import com.dorado.runtime.OWEvent;
import com.ngnms.common.AvTrace;
import com.ngnms.mediation.IAvMediationAgentEventListener;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oware.availability.OWMedServerAvailableMgmtEvent;
import oware.availability.OWMedServerDownMgmtEvent;

public class AvMediationServerUtil {
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.mediation.AvMediationServerUtil.debug");
    private static HashSet mediationAgentEventListeners = new HashSet();
    private static OWMedServerAvailableMgmtEvent availListener;
    private static OWMedServerDownMgmtEvent downListener;

    public static OWAssignmentBean getMedAgentForIPAddress(String ipAddress) {
        try {
            Iterator _iter;
            OWMBeanClient _mclient = new OWMBeanClient();
            OWSnmpAuthentication auth = new OWSnmpAuthentication();
            auth.setDeviceID(ipAddress);
            Set _medServers = _mclient.getAgentList((OWAuthentication)auth);
            if (null != _medServers && _medServers.size() > 0 && (_iter = _medServers.iterator()).hasNext()) {
                OWAssignmentBean _agent = (OWAssignmentBean)_iter.next();
                return _agent;
            }
        }
        catch (Exception e) {
            AvTrace.traceln("AvSMS", 1, "Failed to get mediation agent for: " + ipAddress);
        }
        return null;
    }

    public static String getMedPartitionForIPAddress(String ipAddress) {
        OWAssignmentBean medAgent = AvMediationServerUtil.getMedAgentForIPAddress(ipAddress);
        return null != medAgent ? medAgent.getPartitionName() : "";
    }

    public static String getMedAddressForIPAddress(String ipAddress) {
        OWAssignmentBean medAgent = AvMediationServerUtil.getMedAgentForIPAddress(ipAddress);
        if (null != medAgent) {
            return medAgent.getIPAddress();
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            System.out.println("Could not get local IP Address!!!!!");
            return "127.0.0.1";
        }
    }

    public static OWRuleEngineClient getMedServerRuleEngine(String pMedPartition) throws Exception {
        return new OWRuleEngineClient(pMedPartition);
    }

    public static synchronized void addMediationAgentEventListener(IAvMediationAgentEventListener listener) {
        block4: {
            mediationAgentEventListeners.add(listener);
            if (availListener == null) {
                availListener = new OWMedServerAvailableMgmtEvent();
                downListener = new OWMedServerDownMgmtEvent();
                OWMedServerAvailabilityEventListener _mgmtListener = new OWMedServerAvailabilityEventListener();
                try {
                    availListener.addEventListener((IOWEventListener)_mgmtListener);
                    downListener.addEventListener((IOWEventListener)_mgmtListener);
                    if (debugOn) {
                        System.out.println("AvMediationServerUtil: Initialized MediationAgent Listener service.");
                    }
                }
                catch (Exception e) {
                    System.out.println("AvMediationServerUtil: Failed to initialize MediationAgent Listener service.");
                    if (!debugOn) break block4;
                    e.printStackTrace();
                }
            }
        }
    }

    public static synchronized void removeMediationAgentEventListener(IAvMediationAgentEventListener listener) {
        mediationAgentEventListeners.remove(listener);
    }

    private static String getMediationAgentPartition(String pMedIPAddress) {
        block5: {
            try {
                OWMBeanClient _mclient = new OWMBeanClient();
                Set agentList = _mclient.getAllAgents();
                if (agentList != null) {
                    for (OWAssignmentBean _agent : agentList) {
                        if (!pMedIPAddress.equals(_agent.getIPAddress())) continue;
                        String partitionName = _agent.getPartitionName();
                        if (debugOn) {
                            System.out.println("Matched mediation ip: " + pMedIPAddress + " to partition " + partitionName);
                        }
                        return partitionName;
                    }
                }
            }
            catch (Exception e) {
                if (!debugOn) break block5;
                e.printStackTrace();
            }
        }
        return null;
    }

    private static class OWMedServerAvailabilityEventListener
    implements IOWEventListener {
        private OWMedServerAvailabilityEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void action(OWEvent pEvent) throws OWException {
            Class<AvMediationServerUtil> clazz = AvMediationServerUtil.class;
            synchronized (AvMediationServerUtil.class) {
                String medServerIP = (String)pEvent.readProperty("MedServerAddress");
                String medServerPart = AvMediationServerUtil.getMediationAgentPartition(medServerIP);
                int status = pEvent instanceof OWMedServerAvailableMgmtEvent ? 0 : 1;
                for (IAvMediationAgentEventListener listener : mediationAgentEventListeners) {
                    listener.mediationAgentStatusChanged(medServerPart, status);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void disconnectOccurred(String str) {
        }

        public void exceptionOccurred(Exception exception) {
        }
    }
}

