/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.framework;

import com.bwanms.ruledelegator.BaseFormController;
import com.dorado.common.widget.components.OWFCParentPanel;
import com.dorado.common.widget.components.OWImageInfo;
import com.dorado.common.widget.components.explorer.IOWExplorerNode;
import com.dorado.common.widget.components.explorer.IOWExplorerNodeContainer;
import com.dorado.common.widget.components.explorer.OWExplorerNodeContainer;
import com.dorado.common.widget.components.interfaces.IOWGButton;
import com.dorado.common.widget.components.interfaces.IOWGDataWidget;
import com.dorado.common.widget.components.interfaces.IOWGLabel;
import com.dorado.common.widget.components.interfaces.IOWGPasswordField;
import com.dorado.common.widget.components.interfaces.IOWGStandardPanel;
import com.dorado.common.widget.components.interfaces.IOWGTextArea;
import com.dorado.core.security.OWSecurityAPI;
import com.dorado.core.security.OWSecurityLoginException;
import com.dorado.oware.core.security.OWAppSecurityPolicy;
import com.dorado.runtime.IOWEventListener;
import com.dorado.runtime.IOWFormUserMethods;
import com.dorado.runtime.IOWRuntimeForm;
import com.ngnms.framework.AvLoginChangePasswordJAVAGUI;
import java.awt.Cursor;
import java.awt.Window;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import redcell.common.util.RedCellHelpUtil;
import redcell.common.util.RedCellRuntimeUtil;
import redcell.core.usersys.RCUserUtil;

public class AvLoginChangePasswordFormController
extends BaseFormController
implements IOWEventListener,
IOWFormUserMethods,
IOWRuntimeForm {
    public static final String POLICY_TABLE = "policyTableExplorer";
    IOWGPasswordField txtOld;
    IOWGPasswordField txtPassword;
    IOWGPasswordField txtAgain;
    IOWGDataWidget policyTableExplorer;
    IOWGLabel lblPasswordConstraints;
    IOWGTextArea errorTextArea;
    IOWGStandardPanel buttonPanel;
    IOWGButton okButton;
    IOWGButton cancelButton;
    IOWGLabel lblOldPassword;
    IOWGLabel lblConfirmPassword;
    IOWGLabel lblNewPassword;
    IOWGLabel lblCurrent;
    protected String frmChangePassword_title;

    public AvLoginChangePasswordFormController(AvLoginChangePasswordJAVAGUI form) throws SecurityException, NoSuchFieldException {
        super((OWFCParentPanel)form);
        this.bindFields();
    }

    private void bindFields() throws SecurityException, NoSuchFieldException {
        this.txtOld = (IOWGPasswordField)this.getComponent("txtOld");
        this.txtPassword = (IOWGPasswordField)this.getComponent("txtPassword");
        this.txtAgain = (IOWGPasswordField)this.getComponent("txtAgain");
        this.policyTableExplorer = (IOWGDataWidget)this.getComponent(POLICY_TABLE);
        this.lblPasswordConstraints = (IOWGLabel)this.getComponent("lblPasswordConstraints");
        this.errorTextArea = (IOWGTextArea)this.getComponent("errorTextArea");
        this.buttonPanel = (IOWGStandardPanel)this.getComponent("buttonPanel");
        this.okButton = (IOWGButton)this.getComponent("okButton");
        this.cancelButton = (IOWGButton)this.getComponent("cancelButton");
        this.lblOldPassword = (IOWGLabel)this.getComponent("lblOldPassword");
        this.lblConfirmPassword = (IOWGLabel)this.getComponent("lblConfirmPassword");
        this.lblNewPassword = (IOWGLabel)this.getComponent("lblNewPassword");
        this.lblCurrent = (IOWGLabel)this.getComponent("lblCurrent");
    }

    public void HelpBtnClicked() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            RedCellHelpUtil.showHelp((Window)RedCellRuntimeUtil.getLaunchConsole(), (String)System.getProperty("redcell.change_password", "RedcellPortalNavigation"));
        }
        catch (Throwable _e) {
            RedCellRuntimeUtil.printStackTrace((Throwable)_e);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void cancelBtnClicked() {
        if (this.getFormController() != null && this.getFormController().getCurrentFormLauncher() != null) {
            this.getFormController().getCurrentFormLauncher().removePanel(((Object)((Object)this)).getClass().getName(), this.getId());
        }
    }

    public void commit() {
        try {
            String _oldPassword = (String)this.getPropertyValue("txtOld", "Text");
            String _newPassword = (String)this.getPropertyValue("txtPassword", "Text");
            String _reEnterPassword = (String)this.getPropertyValue("txtAgain", "Text");
            if (_newPassword.length() < 1 || _reEnterPassword.length() < 1) {
                this.setPropertyValue("StatusLine", "Text", "Failed - Invalid New Password!");
                return;
            }
            if (!_newPassword.equals(_reEnterPassword)) {
                this.setPropertyValue("StatusLine", "Text", "Failed - The Passwords are different!");
                return;
            }
            try {
                OWSecurityAPI _secAPI = new OWSecurityAPI();
                _secAPI.changePassword(RCUserUtil.getCurrentUser().getLoginName(), _oldPassword, _newPassword);
            }
            catch (OWSecurityLoginException _e) {
                this.setPropertyValue("StatusLine", "Text", "Failed - Authentication Error: Invalid Old Password!");
                _e.printStackTrace();
                return;
            }
            catch (Exception _e) {
                this.setPropertyValue("StatusLine", "Text", "Failed - " + _e.getMessage());
                _e.printStackTrace();
                return;
            }
            this.setPropertyValue("StatusLine", "Text", "Success - Password changed.");
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
    }

    public String getUnits(String pUnit) {
        if (pUnit.equals("boolean") || pUnit.equals("text")) {
            return "";
        }
        return pUnit;
    }

    public void initForm() {
        try {
            OWImageInfo icon = new OWImageInfo("/com/ngnms/framework/icon.gif", null, 0);
            this.getFormController().setIcon(icon);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.translate();
        this.populatePolicyTable("PasswordConstraint");
    }

    public void populatePolicyTable(String pPolicyCategory) {
        try {
            this.callMethod(POLICY_TABLE, "clearNodes", null);
            if (pPolicyCategory != null) {
                IOWExplorerNodeContainer _rootNode = (IOWExplorerNodeContainer)this.callMethod(POLICY_TABLE, "getRoot", null);
                OWSecurityAPI _securityAPI = new OWSecurityAPI();
                this.setPolicyTable(_rootNode, _securityAPI.getAppSecurityPolicies(pPolicyCategory));
            }
            this.callMethod(POLICY_TABLE, "refresh", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPolicyTable(IOWExplorerNodeContainer pRootNode, Collection pPolicyList) {
        try {
            Iterator _policyIter = pPolicyList.iterator();
            if (!_policyIter.hasNext()) {
                return;
            }
            OWExplorerNodeContainer _policyRowNode = null;
            while (_policyIter.hasNext()) {
                OWAppSecurityPolicy _policy = (OWAppSecurityPolicy)_policyIter.next();
                _policyRowNode = new OWExplorerNodeContainer("", _policy.getPolicyId(), "", "");
                _policyRowNode.add((IOWExplorerNodeContainer)new OWExplorerNodeContainer("", _policy.getName(), "", ""));
                _policyRowNode.add((IOWExplorerNodeContainer)new OWExplorerNodeContainer("", _policy.getValue() + " " + this.getUnits(_policy.getUnits()), "", ""));
                pRootNode.add((IOWExplorerNodeContainer)_policyRowNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showMethod() {
    }

    public void translate() {
        try {
            String language = new String(System.getProperty("Language", "en"));
            String country = new String(System.getProperty("Country", "US"));
            Locale currentLocale = new Locale(language, country);
            ResourceBundle bundle = ResourceBundle.getBundle("com.ngnms.framework.AvFrameworkTitlesBundle", currentLocale);
            this.lblOldPassword.setText(bundle.getString(this.lblOldPassword.getText()));
            this.lblNewPassword.setText(bundle.getString(this.lblNewPassword.getText()));
            this.lblConfirmPassword.setText(bundle.getString(this.lblConfirmPassword.getText()));
            this.lblPasswordConstraints.setText(bundle.getString(this.lblPasswordConstraints.getText()));
            IOWExplorerNodeContainer _root = this.policyTableExplorer.getColumnHeaderRoot();
            IOWExplorerNodeContainer _firstRow = (IOWExplorerNodeContainer)_root.getChildren().elementAt(0);
            Iterator _cell = _firstRow.getChildren().iterator();
            while (_cell.hasNext()) {
                IOWExplorerNode node = ((IOWExplorerNodeContainer)_cell.next()).getNode();
                node.setText(bundle.getString(node.getText()));
            }
            this.okButton.setText(bundle.getString(this.okButton.getText()));
            this.cancelButton.setText(bundle.getString(this.cancelButton.getText()));
            this.setTitle(bundle.getString("ChangePassword"));
        }
        catch (Exception _e) {
            RedCellRuntimeUtil.printStackTrace((Exception)_e);
        }
    }

    public String getTitle() {
        return this.frmChangePassword_title;
    }

    public void setTitle(String s) {
        super.setTitle(s);
        this.frmChangePassword_title = s;
    }

    private AvLoginChangePasswordJAVAGUI getThisForm() {
        return (AvLoginChangePasswordJAVAGUI)this.getForm();
    }
}

