/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.framework;

import RedCell.SwingFormContainer;
import com.bwanms.gui.Application;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.gui.about.AboutApplication;
import com.bwanms.gui.managednetwork.ManagedNetworkApplication;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerView;
import com.bwanms.gui.taskmanager.TaskManagerMediator;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerTime;
import com.dorado.common.widget.components.OWFCParentPanel;
import com.dorado.common.widget.components.OWImageBox;
import com.dorado.common.widget.components.OWImageInfo;
import com.dorado.common.widget.components.explorer.IOWExplorerNodeContainer;
import com.dorado.common.widget.components.explorer.IOWExplorerWidget;
import com.dorado.common.widget.components.formlauncher.IOWFormLauncher;
import com.dorado.common.widget.components.formlauncher.IOWFormLauncherModel;
import com.dorado.common.widget.components.formlauncher.OWFormLauncherException;
import com.dorado.common.widget.components.interfaces.IOWGDataWidget;
import com.dorado.common.widget.components.interfaces.IOWGProgressBar;
import com.dorado.core.message.OWMSGQuery;
import com.dorado.redcell.appframework.RCAppFrameCloser;
import com.dorado.redcell.appframework.RCFrameworkHelper;
import com.dorado.redcell.appframework.interfaces.IRCFrameworkForm;
import com.dorado.runtime.IOWRuntimeForm;
import com.dorado.runtime.IOWRuntimeFormDefs;
import com.dorado.runtime.OWBlob;
import com.ngnms.common.AvClientInternationalizer;
import com.ngnms.common.AvPropDefs;
import com.ngnms.common.AvTrace;
import com.ngnms.framework.AvFrameworkOperations;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import redcell.common.util.RCOptionPaneUtil;
import redcell.common.util.RedCellHelpUtil;
import redcell.common.util.RedCellRuntimeUtil;
import redcell.core.usersys.RCUserUtil;
import redcell.core.usersys.RedCellRuntimeUser;

public class AvFrameworkHelper
extends RCFrameworkHelper {
    private static final Logger logger = Logger.getLogger(AvFrameworkHelper.class);
    private static final String BWANMS_MENU_PREFIX = "BWANMS:";
    private SoftReference framework = null;
    private ResourceBundle titlesBundle = null;
    private Internationalizer i18n = Internationalizer.getInternationalizer(AvFrameworkHelper.class);
    private static boolean doAuditLoginOnlyOnce = true;

    public AvFrameworkHelper(IRCFrameworkForm framework) {
        super(framework);
        this.framework = new SoftReference<IRCFrameworkForm>(framework);
    }

    private IRCFrameworkForm derefFramework() {
        return (IRCFrameworkForm)this.framework.get();
    }

    private OWFCParentPanel derefForm() {
        return (OWFCParentPanel)this.framework.get();
    }

    public void init() {
        AvFrameworkOperations.preInit();
        super.init();
        if (doAuditLoginOnlyOnce) {
            ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "UserLogin", "Security", Security.getSecurity().getCurrentUserId(), "Security");
            doAuditLoginOnlyOnce = false;
        }
        AvFrameworkOperations.postInit();
        this.translateFramework();
        this.customizeFramework();
        this.startTraceMemoryStatus();
        this.serverClientTimeDifference();
    }

    private void serverClientTimeDifference() {
        new Runnable(){

            public void run() {
                ServerTime serverTime = ServiceRegistry.getServerUtilService().getTime();
                GregorianCalendar clientTime = new GregorianCalendar();
                System.out.println(" -- " + AvFrameworkHelper.this.i18n.translateString("ServerTime") + " = " + serverTime.getTimeString());
                System.out.println(" -- " + AvFrameworkHelper.this.i18n.translateString("ClientTime") + " = " + clientTime.getTime().toString());
                long diffMillis = Math.abs(clientTime.getTimeInMillis() - serverTime.getTimeLong());
                long diffMins = 0L;
                long diffSecs = 0L;
                if (diffMillis != 0L) {
                    diffSecs = diffMillis / 1000L;
                }
                if (diffSecs != 0L) {
                    diffMins = diffSecs / 60L;
                }
                System.out.println(" -- " + AvFrameworkHelper.this.i18n.translateString("ClientServerTimeDifference", new Object[]{diffMins, diffSecs -= diffMins * 60L}));
                System.out.println();
                if (diffMins > 10L || diffMins == 10L && diffSecs > 0L) {
                    MessageBox.Alert.quickShow(AvFrameworkHelper.this.i18n.translateString("ClientServerTimeDifferenceLargerThat10Minutes"));
                }
            }
        }.run();
    }

    public void confirmLogoff() {
        try {
            if (((OWFCParentPanel)this.getFramework()).getFormType() != 1) {
                return;
            }
            JFrame _frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, (Component)this.getFramework());
            Hashtable _hashParms = RedCellRuntimeUtil.createParameterHash((String)null);
            IOWFormLauncherModel _formLauncher = (IOWFormLauncherModel)this.getFramework().getMainFormLauncher();
            try {
                IOWFormLauncherModel _fl = _formLauncher;
                Class<?> _flClass = _fl.getClass();
                Method _storePropsMeth = _flClass.getMethod("storeProperties", new Class[0]);
                _storePropsMeth.invoke((Object)_fl, new Object[0]);
                RedCellRuntimeUtil.println((String)"Form Coordinates Saved");
            }
            catch (Exception _e2) {
                // empty catch block
            }
            Vector _editors = _formLauncher.getForms(new Object[]{IOWRuntimeFormDefs.TYPE_EDITOR});
            if (_editors.size() == 0) {
                OWMSGQuery _mq = new OWMSGQuery();
                if (RCOptionPaneUtil.showSwingConfirmDialog((Component)_frame, (Object)OWMSGQuery.fetchMessageByNumber((long)102L, (String)"RC_Errors"), (String)OWMSGQuery.fetchMessageByNumber((long)103L, (String)"RC_Errors"), (int)2) == 0) {
                    ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "UserLogout", "Security", Security.getSecurity().getCurrentUserId(), "Security");
                    RCAppFrameCloser.getInstance().closeFrameWithLogging(_frame);
                }
            } else {
                _formLauncher.showPanel(new Object[]{"RedCell.UnsavedEditorsPanel", _hashParms, Boolean.TRUE});
            }
        }
        catch (OWFormLauncherException _fle) {
            if (_fle.getMsgNum() != 1) {
                RedCellRuntimeUtil.printStackTrace((Exception)((Object)_fle));
            }
        }
        catch (Exception _e) {
            RedCellRuntimeUtil.printStackTrace((Exception)_e);
        }
    }

    private void startTraceMemoryStatus() {
        final int traceDelay = Integer.getInteger("com.ngnms.framework.tracememorydelay", 0);
        if (traceDelay > 0) {
            try {
                Runnable tracer = new Runnable(){

                    public void run() {
                        try {
                            while (true) {
                                AvTrace.traceMemoryStatus();
                                Thread.currentThread();
                                Thread.sleep(traceDelay * 1000);
                            }
                        }
                        catch (Exception exception) {
                            return;
                        }
                    }
                };
                new Thread(tracer).start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void showAboutPanel() {
        this.launchEntity("BWANMS:com.bwanms.gui.about.AboutApplication");
    }

    public void showHomePage() {
        try {
            RedCellRuntimeUser _redCellRuntimeUser = RCUserUtil.getCurrentUser();
            String _homePage = _redCellRuntimeUser.getUAttrString("RCHomePageURL", "");
            if (_homePage.equals("") || _homePage.equals("com.ngnms.framework.AvAboutPanel")) {
                _homePage = "BWANMS:com.bwanms.gui.about.AboutApplication";
            }
            this.launchEntity(_homePage);
        }
        catch (Exception _e) {
            RedCellRuntimeUtil.printStackTrace((Exception)_e);
        }
    }

    public void setPortalTitle(String pTitle) {
        JFrame _frm;
        String title = "";
        if (this.titlesBundle == null) {
            try {
                String language = new String(System.getProperty("Language", "en"));
                String country = new String(System.getProperty("Country", "US"));
                Locale currentLocale = new Locale(language, country);
                this.titlesBundle = ResourceBundle.getBundle("com.ngnms.framework.AvFrameworkTitlesBundle", currentLocale);
                title = this.titlesBundle.getString("title");
            }
            catch (Exception e) {}
        } else {
            title = this.titlesBundle.getString("title");
        }
        if (-1 != title.indexOf("%1")) {
            title = title.substring(0, title.indexOf("%1")) + AvPropDefs.getAppName() + title.substring(2 + title.indexOf("%1"));
        }
        if (pTitle != null && !pTitle.startsWith("EmptyForm") && (_frm = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, (Component)this.derefForm())) != null) {
            pTitle = pTitle.length() > 0 ? pTitle + " - " : "";
            _frm.setTitle(pTitle + title);
        }
    }

    private void translateFramework() {
        IRCFrameworkForm frameworkForm = this.derefFramework();
        AvClientInternationalizer clientInternationalizer = new AvClientInternationalizer("com.ngnms.framework.AvFrameworkTitlesBundle");
        if (clientInternationalizer != null) {
            clientInternationalizer.translateNodes((IOWGDataWidget)frameworkForm.getMenu());
            clientInternationalizer.translateNodes((IOWGDataWidget)frameworkForm.getToolbar());
        }
    }

    public void showHelpPanel() {
        try {
            RedCellHelpUtil.showHelp((String)"NgnmsGeneralHelp");
        }
        catch (Throwable _t) {
            RedCellRuntimeUtil.printStackTrace((Throwable)_t);
        }
    }

    private void customizeFramework() {
        try {
            IOWGDataWidget menu = (IOWGDataWidget)this.getFramework().getMenu();
            IOWExplorerNodeContainer objGroupNC = menu.getNodeContainerByPath(new Object[]{"mnuSettings//mnuPermissions//mnuObjectGroup", "name"});
            if (null != objGroupNC) {
                menu.removeNode(objGroupNC);
            } else {
                System.out.println("Node for Object Group not found!");
            }
            ((OWImageBox)this.getFramework().getAltImageBox()).setIcon((Icon)new ImageIcon(new OWBlob("/com/ngnms/framework/brand.gif", null).getData()));
            this.getFramework().getMainFormLauncher().setImage(new OWImageInfo("/com/ngnms/framework/background.jpg", null, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void show() {
        super.show();
        try {
            JFrame _frame;
            if (this.getForm().getFormType() == 1 && (_frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, (Component)this.getForm())) != null) {
                _frame.setIconImage(new ImageIcon(new OWBlob("/com/ngnms/framework/icon", null).getData()).getImage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void newWindow() {
        IOWExplorerWidget _navPane = this.getFramework().getNavPane();
        try {
            IOWExplorerNodeContainer _nodeContainer = _navPane.getSelectedNodeContainer();
            if (_nodeContainer != null) {
                String _form = _nodeContainer.getNode().getValue();
                String[] _args = new String[]{"/f" + _form, "/child"};
                Class<?> _class = Class.forName("com.ngnms.framework.StartNgNMS");
                Constructor<?> _constructor = _class.getConstructor(String[].class);
                _constructor.newInstance(new Object[]{_args});
            }
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launchEntity(String pValue) {
        block27: {
            if (null == pValue || pValue.trim().length() == 0) {
                return;
            }
            if (!pValue.startsWith(BWANMS_MENU_PREFIX)) {
                super.launchEntity(pValue);
                return;
            }
            IOWFormLauncher _formLauncher = this.getFramework().getMainFormLauncher();
            if (null == _formLauncher) {
                RedCellRuntimeUtil.println((String)"  !!!!! Form Launcher not Found !!!!! ");
                return;
            }
            String panelClassName = pValue.substring(BWANMS_MENU_PREFIX.length());
            this.getForm().getFormController().setBusy(true);
            try {
                IOWGProgressBar _progressBar = this.getFramework().getProgressBar();
                Hashtable _hashParms = RedCellRuntimeUtil.createParameterHash((String)null);
                _hashParms.put("launchconsole", "Launched from RedCell Framework");
                _hashParms.put("ProgressBar", _progressBar);
                _hashParms.put("FormLauncher", _formLauncher);
                boolean justFocus = false;
                IOWRuntimeForm focusForm = null;
                if (System.getProperty("rcframework.launch.multiple." + pValue, "false").equals("true")) {
                    _hashParms.put("id", "" + System.currentTimeMillis());
                } else {
                    _hashParms.put("id", panelClassName);
                    for (IOWRuntimeForm zaForm : _formLauncher.getForms()) {
                        if (!panelClassName.equals(zaForm.getId())) continue;
                        justFocus = true;
                        focusForm = zaForm;
                    }
                }
                if (!justFocus) {
                    Application app;
                    Class<?> _class = Class.forName(panelClassName);
                    JComponent uiComponent = null;
                    EntityManagerView theView = null;
                    Application theApp = null;
                    String title = "";
                    if (EntityManagerConfig.class.isAssignableFrom(_class)) {
                        EntityManagerView view = new EntityManagerView((EntityManagerConfig)_class.newInstance());
                        title = view.getTitle();
                        uiComponent = view.getUI();
                        theView = view;
                    } else if (Application.class.isAssignableFrom(_class)) {
                        app = (Application)_class.newInstance();
                        View appView = app.createView();
                        uiComponent = appView.getUI();
                        title = appView.getTitle();
                        theView = appView;
                        theApp = app;
                    } else if (ManagedNetworkApplication.class.isAssignableFrom(_class)) {
                        app = new ManagedNetworkApplication();
                        uiComponent = app.getUI();
                        title = app.getTitle();
                    } else if (TaskManagerMediator.class.isAssignableFrom(_class)) {
                        app = new TaskManagerMediator();
                        title = app.getTitle();
                        uiComponent = app.getUI();
                        theView = app;
                    } else if (View.class.isAssignableFrom(_class)) {
                        theView = (View)_class.newInstance();
                        uiComponent = theView.getUI();
                        title = theView.getTitle();
                    } else if (JComponent.class.isAssignableFrom(_class)) {
                        uiComponent = (JComponent)_class.newInstance();
                    }
                    RedCellRuntimeUtil.println((String)("\n\nLaunch Container: " + pValue));
                    if (uiComponent != null) {
                        if (this.getFramework().getMainFormLauncher().getViewType() == 1) {
                            JScrollPane jScrollPane = new JScrollPane();
                            jScrollPane.setViewportView(uiComponent);
                            JPanel jPane = new JPanel();
                            jPane.setLayout(new BorderLayout());
                            jPane.add((Component)jScrollPane, "Center");
                            _hashParms.put("SwingForm", jPane);
                        } else {
                            _hashParms.put("SwingForm", uiComponent);
                        }
                        if (theView != null) {
                            _hashParms.put("com.bwnams.gui.View", theView);
                        }
                        _hashParms.put("_title", title);
                        boolean _isMaximizeOnOpen = _formLauncher.isMaximizeOnOpen();
                        IOWRuntimeForm form = _formLauncher.addPanel(SwingFormContainerWithScrollBar.class.getName(), _hashParms);
                        form.setPreferredSize(uiComponent.getPreferredSize());
                        _formLauncher.showPanel(form, false);
                        _formLauncher.setMaximizeOnOpen(_isMaximizeOnOpen);
                        if (theApp instanceof AboutApplication && ((AboutApplication)theApp).checkDDInstalled(true)) {
                            // empty if block
                        }
                        break block27;
                    } else {
                        MessageBox.Info.quickShow((Component)this.getForm(), this.i18n.translateString("NoEntitiesFor", new Object[]{title}));
                    }
                    break block27;
                }
                if (focusForm != null) {
                    _formLauncher.showPanel(focusForm, false);
                    _formLauncher.setMaximizeOnOpen(_formLauncher.isMaximizeOnOpen());
                }
            }
            catch (Exception _e) {
                RedCellRuntimeUtil.println((String)("VALUE is :" + pValue));
                RedCellRuntimeUtil.printStackTrace((Exception)_e);
            }
        }
        this.getForm().getFormController().setBusy(false);
    }

    public static class SwingFormContainerWithScrollBar
    extends SwingFormContainer {
        public static final String ATTRIB_VIEW = "com.bwnams.gui.View";
        private View containedView;
        private boolean onCloseCalled = false;
        Dimension d;

        public SwingFormContainerWithScrollBar() {
        }

        public void setPreferredSize(Dimension d) {
            this.d = d;
        }

        public Dimension getPreferredSize() {
            if (this.d == null) {
                return super.getPreferredSize();
            }
            return this.d;
        }

        public void onClose() {
            if (!this.onCloseCalled) {
                this.onCloseCalled = true;
                logger.debug((Object)("onClose " + (this.containedView == null ? " null view " : this.containedView.getClass().getName())));
                if (this.containedView != null) {
                    this.containedView.cleanup();
                }
            }
            super.onClose();
        }

        public SwingFormContainerWithScrollBar(Hashtable arg0) {
            super(arg0);
            this.containedView = (View)arg0.get(ATTRIB_VIEW);
        }

        public SwingFormContainerWithScrollBar(String arg0) {
            super(arg0);
        }
    }
}

