/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.db;

import com.ngnms.db.PooledConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;

class ConnectionPool {
    private static final String CLASS_NAME = "com.ngnms.db.AvJDBCConnectionPool";
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.db.AvJDBCConnectionPool.debug");
    private ArrayList connectionPool = new ArrayList();
    private Hashtable connectionLife = new Hashtable();
    private String url;
    private String user;
    private String password;
    private int initialSize;
    private int maxSize;
    private int increase;
    private int queryTimeout = 0;
    private int maxConnectionLife = 0;
    private int connectionCount = 0;

    public ConnectionPool(String pUrl, String pUser, String pPassword, int pInitialSize, int pMaxSize, int pIncrease) throws Exception {
        this.url = pUrl;
        this.user = pUser;
        this.password = pPassword;
        this.initialSize = pInitialSize;
        this.maxSize = pMaxSize;
        this.increase = pIncrease;
        System.out.println("--------------------------------");
        System.out.println("ConnectionPool: initializing");
        System.out.println("    URL        : " + this.url);
        System.out.println("    initialSize: " + this.initialSize);
        System.out.println("    maxSize    : " + this.maxSize);
        System.out.println("    increase   : " + this.increase);
        System.out.println("--------------------------------");
        this.addConnections(this.initialSize);
    }

    private void addConnections(int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
            PooledConnection pooled = new PooledConnection(conn, this);
            this.connectionPool.add(pooled);
            this.connectionLife.put(pooled, new Long(System.currentTimeMillis()));
        }
        this.connectionCount += count;
        System.out.println("ConnectionPool: added " + count + " connections");
    }

    public synchronized Connection getConnection() {
        PooledConnection conn = null;
        while (conn == null) {
            while (this.connectionPool.size() == 0) {
                if (this.connectionCount < this.maxSize) {
                    try {
                        this.addConnections(Math.min(this.increase, this.maxSize - this.connectionCount));
                    }
                    catch (Exception e) {
                        System.out.println("ConnectionPool: Exception adding new connections");
                        e.printStackTrace();
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    continue;
                }
                try {
                    if (debugOn) {
                        System.out.println("ConnectionPool: no available connection. Will wait.");
                    }
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            conn = (PooledConnection)this.connectionPool.get(0);
            this.connectionPool.remove(0);
            if (this.maxConnectionLife == 0) continue;
            long lived = (Long)this.connectionLife.get(conn);
            if ((System.currentTimeMillis() - lived) / 1000L <= (long)this.maxConnectionLife) continue;
            this.removeConnection(conn);
            if (debugOn) {
                System.out.println("ConnectionPool: connection " + conn + " closed due to aging");
            }
            conn = null;
        }
        if (debugOn) {
            System.out.println("ConnectionPool: getting connection " + conn);
        }
        return conn;
    }

    synchronized void returnConnection(PooledConnection conn) {
        try {
            if (conn.getConn().isClosed()) {
                if (debugOn) {
                    System.out.println("ConnectionPool: Connection " + conn + " was CLOSED!");
                }
                this.removeConnection(conn);
                return;
            }
        }
        catch (SQLException e) {
            if (debugOn) {
                System.out.println("ConnectionPool: Connection " + conn + " was CLOSED!");
            }
            this.removeConnection(conn);
            return;
        }
        this.connectionPool.add(conn);
        if (debugOn) {
            System.out.println("ConnectionPool: returning connection " + conn);
        }
        this.notifyAll();
    }

    private synchronized void removeConnection(PooledConnection conn) {
        this.connectionPool.remove(conn);
        this.connectionLife.remove(conn);
        --this.connectionCount;
        try {
            conn.getConn().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setQueryTimeout(int pQueryTimeout) {
        System.out.println("ConnectionPool: queryTimeout set to " + pQueryTimeout);
        this.queryTimeout = pQueryTimeout;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setMaxConnectionLife(int pMaxConnectionLife) {
        System.out.println("ConnectionPool: maxConnectionLife set to " + pMaxConnectionLife + " seconds");
        this.maxConnectionLife = pMaxConnectionLife;
    }

    public int getMaxConnectionLife() {
        return this.maxConnectionLife;
    }

    public PreparedStatement getPreparedStatement(Connection conn, String statement) throws SQLException {
        PreparedStatement ret = conn.prepareStatement(statement);
        ret.setQueryTimeout(this.queryTimeout);
        return ret;
    }
}

