/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.db;

import com.ngnms.db.ConnectionPool;
import java.sql.Connection;
import java.util.Hashtable;

public class AvJDBCConnectionPool {
    private static final String CLASS_NAME = "com.ngnms.db.AvJDBCConnectionPool";
    private static final String PROP_PREFIX = "com.ngnms.db";
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.db.AvJDBCConnectionPool.debug");
    private static final int DEF_INIT_POOL_SIZE = 10;
    private static final int DEF_MAX_POOL_SIZE = 10;
    private static final int DEF_SIZE_INCREASE = 10;
    private static final int DEF_QUERY_TIMEOUT = 0;
    private static final int DEF_MAX_CONN_LIFE = 600;
    private static final String DEFAULT_POOL = "default";
    private static String driver_name;
    private static Hashtable pools;
    private String poolName;
    private ConnectionPool pool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AvJDBCConnectionPool(String name) {
        this.poolName = name;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.pool = (ConnectionPool)pools.get(this.poolName);
            if (this.pool == null) {
                this.pool = AvJDBCConnectionPool.initializeConnection(name);
                if (this.pool != null) {
                    pools.put(name, this.pool);
                }
            }
        }
    }

    private static synchronized ConnectionPool initializeConnection(String name) {
        if (debugOn) {
            System.out.println("Initializing pool: " + name);
        }
        ConnectionPool pool = null;
        String connPrefix = "com.ngnms.db." + name;
        String driver = System.getProperty(connPrefix + ".driver", driver_name);
        String url = System.getProperty(connPrefix + ".url");
        String user = System.getProperty(connPrefix + ".user");
        String password = System.getProperty(connPrefix + ".password");
        int initialPoolSize = Integer.getInteger(connPrefix + ".initialPoolSize", 10);
        int maxPoolSize = Integer.getInteger(connPrefix + ".maxPoolSize", 10);
        int sizeIncrease = Integer.getInteger(connPrefix + ".sizeIncrease", 10);
        int queryTimeout = Integer.getInteger(connPrefix + ".queryTimeout", 0);
        int maxConnectionLife = Integer.getInteger(connPrefix + ".maxConnectionLife", 600);
        try {
            Class.forName(driver_name);
            pool = new ConnectionPool(url, user, password, initialPoolSize, maxPoolSize, sizeIncrease);
            pool.setQueryTimeout(queryTimeout);
            pool.setMaxConnectionLife(maxConnectionLife);
        }
        catch (Exception e) {
            System.out.println("PANIC: Could not initialize JDBC connection pool");
            e.printStackTrace();
        }
        return pool;
    }

    public static AvJDBCConnectionPool getInstance() {
        return new AvJDBCConnectionPool(DEFAULT_POOL);
    }

    public static AvJDBCConnectionPool getInstance(String name) {
        if (Boolean.getBoolean("com.ngnms.db." + name + ".default")) {
            return new AvJDBCConnectionPool(DEFAULT_POOL);
        }
        return new AvJDBCConnectionPool(name);
    }

    public Connection getConnection() {
        return this.pool.getConnection();
    }

    static {
        pools = new Hashtable();
        String dbms_name = System.getProperty("com.dorado.bom_dbms.name");
        driver_name = System.getProperty("com.dorado.jdbc.t4_driver_name." + dbms_name);
        String db_name = System.getProperty("com.dorado.jdbc.database_name." + dbms_name);
        if (dbms_name.equals("mysql")) {
            db_name = db_name.substring(0, db_name.lastIndexOf(47) + 1) + "bwanms";
        }
        String url = System.getProperty("com.dorado.jdbc.t4_url_name." + dbms_name) + db_name;
        String username = System.getProperty("com.dorado.jdbc.user");
        String password = System.getProperty("com.dorado.jdbc.password");
        String connPrefix = "com.ngnms.db.default";
        System.setProperty(connPrefix + ".driver", driver_name);
        System.setProperty(connPrefix + ".url", url);
        System.setProperty(connPrefix + ".user", username);
        System.setProperty(connPrefix + ".password", password);
    }
}

