/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import RedCell.Config.Authentication;
import RedCell.Config.Equipment;
import RedCell.Config.EquipmentManager;
import RedCell.Config.ManagementInterface;
import RedCell.Config.NetworkResource;
import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.collections.NDictionary;
import com.dorado.common.collections.OWAVPVector;
import com.dorado.common.exception.OWUserException;
import com.dorado.common.utility.OWAttributeValuePair;
import com.dorado.common.utility.OWOID;
import com.dorado.core.bom.IOWBOMInternalUseMarker;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.bom.OWBOMQueryByKey;
import com.dorado.core.bom.OWBOMQueryByOWOIDs;
import com.dorado.core.bom.OWBOMQueryByReferenceAttribute;
import com.dorado.core.bom.OWBOMRequest;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.core.security.OWSecurityAPI;
import com.dorado.extensions.OWRolePrincipal;
import com.dorado.redcell.inventory.auth.Credentials;
import com.dorado.redcell.inventory.auth.GetAllAuthenticationForEquipmentParamSet;
import com.dorado.redcell.inventory.auth.GetAllInterfaceTypesParamSet;
import com.dorado.redcell.inventory.auth.IAuthDefs;
import com.dorado.runtime.IOWBaseBean;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWBaseVector;
import com.dorado.runtime.OWBean;
import com.dorado.runtime.OWEvent;
import com.dorado.runtime.OWHashtable;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.dorado.runtime.OWSet;
import com.dorado.runtime.OWVector;
import com.ngnms.common.AvTrace;
import com.ngnms.common.GetAllAuthenticationForEquipment;
import com.ngnms.services.common.AvMOUtil;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import redcell.common.util.RCBeanProxy;
import redcell.core.security.RCBOMInternalUseMarker;

public class GetAllAuthenticationForEquipmentImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(GetAllAuthenticationForEquipment.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">GetAllAuthenticationForEquipment.run()");
        this.runRule((GetAllAuthenticationForEquipmentParamSet)event);
        AvTrace.traceln("AvCS", 1, "<GetAllAuthenticationForEquipment.run()");
    }

    public void runRule(GetAllAuthenticationForEquipmentParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        OWBaseVector _creds = new OWBaseVector(Credentials.class);
        try {
            OWOID _equipmentOid = pParamSet.getEquipmentOid();
            String _equipmentKey = pParamSet.getEquipmentKey();
            String _equipmentName = pParamSet.getEquipmentName();
            EquipmentManager _equipmentManager = null;
            Equipment _equipment = this.xrl_RedCell_Config_GetEquipment(_equipmentOid, _equipmentKey, _equipmentName);
            if (!this.validateEquipment(_equipment, _equipmentOid, _equipmentKey, _equipmentName)) {
                pParamSet.setCredentials(_creds);
                return;
            }
            if (!(_equipment instanceof EquipmentManager)) {
                try {
                    _equipmentManager = AvMOUtil.getAvDeviceFromMO((NetworkResource)_equipment);
                }
                catch (Exception e) {
                    pParamSet.setCredentials(_creds);
                    return;
                }
                if (_equipmentManager == null) {
                    pParamSet.setCredentials(_creds);
                    return;
                }
            } else {
                _equipmentManager = (EquipmentManager)_equipment;
            }
            NDictionary _supportedIntTypes = this.getAllInterfaceTypes();
            Vector _authVect = this.getAuthentication(_equipmentManager);
            OWVector _miVect = _equipmentManager.getAuthentication();
            if (_authVect == null || _authVect.size() == 0 || _miVect == null || _miVect.size() == 0) {
                pParamSet.setCredentials(_creds);
                return;
            }
            _creds = this.createCredentials(_authVect, _miVect, _supportedIntTypes);
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
        pParamSet.setCredentials(_creds);
    }

    private Authentication getAuthByClassName(Vector pAuthVect, String pClassName) {
        Authentication _auth = null;
        Enumeration _authList = pAuthVect.elements();
        while (_authList.hasMoreElements()) {
            _auth = (Authentication)_authList.nextElement();
            if (!pClassName.equals(_auth.getClass().getName())) continue;
            return _auth;
        }
        return null;
    }

    private Credentials createCredentials(Authentication pAuth, ManagementInterface pMi, RCBeanProxy pAuthTypeProxy) {
        Credentials _cred = new Credentials();
        RCBeanProxy _authProxy = null;
        RCBeanProxy _miProxy = null;
        try {
            if (pAuth != null) {
                _authProxy = (RCBeanProxy)this.xrl_RedCell_Bean2Proxy((OWBean)pAuth, false, false, 0);
            }
            if (pMi != null) {
                _miProxy = (RCBeanProxy)this.xrl_RedCell_Bean2Proxy((OWBean)pMi, false, false, 0);
            }
            _cred.setAuthentication(_authProxy);
            _cred.setManagementInterface(_miProxy);
            _cred.setManagementInterfaceType(pAuthTypeProxy);
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
        return _cred;
    }

    private ManagementInterface getMiByName(OWVector pMIVect, String pMIName) {
        ManagementInterface _mi = null;
        Enumeration _miList = pMIVect.elements();
        while (_miList.hasMoreElements()) {
            _mi = (ManagementInterface)_miList.nextElement();
            if (_mi.getType() == null || !pMIName.equals(_mi.getType().getName())) continue;
            return _mi;
        }
        return null;
    }

    public OWBaseVector createCredentials(Vector pAuthVect, OWVector pMiVect, NDictionary pSupportedIntTypes) {
        OWBaseVector _credVect = new OWBaseVector(Credentials.class);
        Iterator _values = pSupportedIntTypes.values().iterator();
        boolean _hasAuthClass = false;
        String _miTypeName = null;
        while (_values.hasNext()) {
            RCBeanProxy _authTypeProxy = (RCBeanProxy)_values.next();
            String _authClassName = (String)_authTypeProxy.get("AuthClassName");
            Authentication _auth = this.getAuthByClassName(pAuthVect, _authClassName);
            _hasAuthClass = _authClassName != null && _authClassName.length() > 0;
            _miTypeName = (String)_authTypeProxy.get("Name");
            if (_auth == null && _hasAuthClass && _miTypeName != null && !_miTypeName.startsWith("HTTP")) continue;
            ManagementInterface _mi = this.getMiByName(pMiVect, _miTypeName);
            if (_mi == null && (_miTypeName.startsWith("TL1") || _miTypeName.startsWith("ASCII"))) {
                _mi = this.getMiByName(pMiVect, "ICMP");
                if (_mi == null) {
                    System.out.println(IAuthDefs.authMsgUtil.getStringWithSubstitution(1100L, new String[]{"com.dorado.redcell.inventory.auth.GetAllAuthenticationForEquipment", _miTypeName}));
                } else {
                    try {
                        _mi.setPort(23);
                    }
                    catch (Exception _e) {
                        // empty catch block
                    }
                }
            }
            if (_mi == null) continue;
            Credentials _cred = this.createCredentials(_auth, _mi, _authTypeProxy);
            try {
                _credVect.add((IOWBaseBean)_cred);
            }
            catch (Exception _e) {
                _e.printStackTrace();
            }
        }
        return _credVect;
    }

    public RCBeanProxy getManagementInterface(OWVector pMiVector, String pIntType) {
        RCBeanProxy _managementInterface = null;
        if (pMiVector != null && pIntType != null) {
            Enumeration _miList = pMiVector.elements();
            while (_miList.hasMoreElements()) {
                ManagementInterface _mi = (ManagementInterface)_miList.nextElement();
                if (_mi.getType() == null || !_mi.getType().getName().equals(pIntType)) continue;
                _managementInterface = (RCBeanProxy)this.xrl_RedCell_Bean2Proxy((OWBean)_mi, false, false, 0);
                break;
            }
        }
        return _managementInterface;
    }

    private Vector getQualifiedAuthentication(Vector pAuthVect) throws Exception {
        OWSecurityAPI _secAPI = new OWSecurityAPI();
        Collection _roles = _secAPI.getRoles();
        Vector<Authentication> _rtnVect = new Vector<Authentication>();
        if (pAuthVect != null && pAuthVect.size() > 0 && _roles != null && _roles.size() > 0) {
            Enumeration _authList = pAuthVect.elements();
            while (_authList.hasMoreElements()) {
                Authentication _authenticationBean = (Authentication)_authList.nextElement();
                OWSet _authRoles = _authenticationBean.getRoles();
                if (_authRoles == null) continue;
                Enumeration _authRoleList = _authRoles.elements();
                while (_authRoleList.hasMoreElements()) {
                    String _authRole = (String)_authRoleList.nextElement();
                    Iterator _roleList = _roles.iterator();
                    while (_roleList.hasNext()) {
                        String _role = ((OWRolePrincipal)_roleList.next()).getName();
                        if (!_authRole.equals(_role)) continue;
                        _rtnVect.add(_authenticationBean);
                    }
                }
            }
        }
        return _rtnVect;
    }

    public Vector getAuthentication(EquipmentManager pEquip) {
        Vector _authVect = new Vector();
        try {
            OWBOMQueryByReferenceAttribute _refQuery = new OWBOMQueryByReferenceAttribute("RedCell.Config.Authentication", "Equipment", (IOWBean)pEquip, false);
            OWBOMRequest _refRequest = this.getBOM().getObjects((OWBOMQuery)_refQuery);
            _authVect = (Vector)_refRequest.getRtnObject();
            _authVect = this.getQualifiedAuthentication(_authVect);
        }
        catch (OWBOMNotFoundException _bnfe) {
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
        return _authVect;
    }

    public NDictionary getSupportedInterfaceTypes(OWOID pOid, String pKey, String pName) throws Exception {
        GetAllInterfaceTypesParamSet _ps = new GetAllInterfaceTypesParamSet();
        this.callRule("com.dorado.redcell.inventory.auth.GetAllInterfaceTypes", (OWEvent)_ps);
        return _ps.getInterfaceTypes();
    }

    public NDictionary getAllInterfaceTypes() throws Exception {
        GetAllInterfaceTypesParamSet _ps = new GetAllInterfaceTypesParamSet();
        this.callRule("com.dorado.redcell.inventory.auth.GetAllInterfaceTypes", (OWEvent)_ps);
        return _ps.getInterfaceTypes();
    }

    public boolean validateEquipment(Equipment pEquipment, OWOID pOid, String pKey, String pName) {
        String _attribName = "OID";
        String _attribVal = null;
        if (pOid != null) {
            _attribName = "OID";
            _attribVal = pOid.toString();
        } else if (pKey != null) {
            _attribName = "KEY";
            _attribVal = pKey;
        } else if (pName != null) {
            _attribName = "NAME";
            _attribVal = pName;
        }
        if (pEquipment == null) {
            System.out.println(IAuthDefs.authMsgUtil.getStringWithSubstitution(1101L, new String[]{"com.dorado.redcell.inventory.auth.GetAllAuthenticationForEquipment", _attribName, _attribVal}));
            return false;
        }
        return true;
    }

    public Equipment xrl_RedCell_Config_GetEquipment(OWOID pEquipmentOid, String pEquipmentKey, String pEquipmentName) {
        try {
            OWBOMQueryByAttribs _query;
            OWBOMQueryByAttribs _attribQuery;
            if (pEquipmentOid == null && pEquipmentKey == null) {
                _attribQuery = new OWBOMQueryByAttribs("RedCell.Config.Equipment", false);
                _attribQuery.addAttribValueOperator(new OWBOMAttribValueOperator("Name", (Object)pEquipmentName));
                _query = _attribQuery;
            } else if (pEquipmentOid == null) {
                _query = _attribQuery = new OWBOMQueryByKey("RedCell.Config.Equipment", pEquipmentKey, false);
            } else {
                Vector<OWOID> _oids = new Vector<OWOID>(1);
                _oids.add(pEquipmentOid);
                _query = new OWBOMQueryByOWOIDs(_oids, "RedCell.Config.Equipment", false);
            }
            OWBOMRequest _request = this.getBOM().getObjects((OWBOMQuery)_query);
            Vector _objs = (Vector)_request.getRtnObject();
            if (_objs == null || _objs.size() == 0) {
                return null;
            }
            return (Equipment)_objs.get(0);
        }
        catch (OWBOMNotFoundException _e) {
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
        return null;
    }

    public OWAVPVector xrl_RedCell_Bean2ProxyRecursive(OWBean pBean, OWAVPVector pAVPVector, Hashtable pProxyReferenceHash, boolean pPermissions, boolean pObjectGroups, int pDepth) {
        OWAVPVector _retAVPVector = pAVPVector;
        OWAttributeValuePair _avp = null;
        Enumeration _enum = pBean.readPropertiesEnum();
        while (_enum.hasMoreElements()) {
            Enumeration _vecEnum;
            _avp = (OWAttributeValuePair)_enum.nextElement();
            if (_avp.getValue() instanceof OWSet) {
                _vecEnum = ((OWSet)_avp.getValue()).elements();
                Vector _vIntrinsics = new Vector();
                while (_vecEnum.hasMoreElements()) {
                    _vIntrinsics.add(_vecEnum.nextElement());
                }
                _retAVPVector.add(new OWAttributeValuePair(_avp.getAttributeName(), _vIntrinsics));
                continue;
            }
            if (_avp.getValue() instanceof OWHashtable && pDepth > 0) {
                OWHashtable _hash = (OWHashtable)_avp.getValue();
                Enumeration _keys = _hash.getContents().keys();
                Object _key = null;
                Hashtable<Object, Object> _ht = new Hashtable<Object, Object>();
                while (_keys.hasMoreElements()) {
                    _key = _keys.nextElement();
                    _ht.put(_key, this.xrl_RedCell_Bean2ProxyWithReferences((OWBean)_hash.get((String)_key), pProxyReferenceHash, pPermissions, pObjectGroups, pDepth - 1));
                }
                _retAVPVector.add(new OWAttributeValuePair(_avp.getAttributeName(), _ht));
                continue;
            }
            if (_avp.getValue() instanceof OWVector && pDepth > 0) {
                _vecEnum = ((OWVector)_avp.getValue()).elements();
                Vector<Object> _vBeans = new Vector<Object>();
                while (_vecEnum.hasMoreElements()) {
                    OWBean _nextBean = (OWBean)_vecEnum.nextElement();
                    _vBeans.add(this.xrl_RedCell_Bean2ProxyWithReferences(_nextBean, pProxyReferenceHash, pPermissions, pObjectGroups, pDepth - 1));
                }
                _retAVPVector.add(new OWAttributeValuePair(_avp.getAttributeName(), _vBeans));
                continue;
            }
            if (_avp.getValue() instanceof OWBean && pDepth > 0) {
                _retAVPVector.add(new OWAttributeValuePair(_avp.getAttributeName(), this.xrl_RedCell_Bean2ProxyWithReferences((OWBean)_avp.getValue(), pProxyReferenceHash, pPermissions, pObjectGroups, pDepth - 1)));
                continue;
            }
            if (_avp.getValue() instanceof OWSet || _avp.getValue() instanceof OWHashtable || _avp.getValue() instanceof OWVector || _avp.getValue() instanceof OWBean) continue;
            _retAVPVector.add(new OWAttributeValuePair(_avp.getAttributeName(), _avp.getValue()));
        }
        return _retAVPVector;
    }

    public Object xrl_RedCell_Bean2ProxyWithReferences(OWBean pBean, Hashtable pProxyReferenceHash, boolean pPermissions, boolean pObjectGroups, int pDepth) {
        if (pProxyReferenceHash.get(pBean.getHandle().toString()) != null) {
            return (RCBeanProxy)pProxyReferenceHash.get(pBean.getHandle().toString());
        }
        RCBeanProxy _beanProxy = new RCBeanProxy();
        pProxyReferenceHash.put(pBean.getHandle().toString(), _beanProxy);
        _beanProxy.setRCOID(pBean.getHandle());
        _beanProxy.setRCClass(pBean.getClass().getName());
        _beanProxy.setRCPermissionCollection(pBean.getOwarePermissions((IOWBOMInternalUseMarker)RCBOMInternalUseMarker.getInstance()));
        _beanProxy.setRCObjectGroups(pBean.getOwareSecurityGroups((IOWBOMInternalUseMarker)RCBOMInternalUseMarker.getInstance(), true));
        _beanProxy.setRCAVPVector(this.xrl_RedCell_Bean2ProxyRecursive(pBean, new OWAVPVector(), pProxyReferenceHash, pPermissions, pObjectGroups, pDepth));
        return _beanProxy;
    }

    public Object xrl_RedCell_Bean2Proxy(OWBean pBean, boolean pPermissions, boolean pObjectGroups, int pDepth) {
        return this.xrl_RedCell_Bean2ProxyWithReferences(pBean, new Hashtable(), pPermissions, pObjectGroups, pDepth);
    }
}

