/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import com.ngnms.common.AvException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;

public class AvWorkSpace {
    public static int WS_TIMEOUT = Integer.getInteger("redcell.ngnms.general_workspace_timeout", 60);
    private static Hashtable workSpaces = new Hashtable();
    private final Thread threadRef;
    private final String wsName;
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.common.AvWorkSpace.debug");
    private static BufferedWriter logBW;

    public static AvWorkSpace getAndLockWorkSpace(String pWorkSpaceName) throws AvException {
        return AvWorkSpace.getAndLockWorkSpace(pWorkSpaceName, WS_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AvWorkSpace getAndLockWorkSpace(String pWorkSpaceName, int pTimeOut) throws AvException {
        AvWorkSpaceInt _ws = null;
        Hashtable hashtable = workSpaces;
        synchronized (hashtable) {
            _ws = (AvWorkSpaceInt)workSpaces.get(pWorkSpaceName);
            if (null == _ws) {
                AvWorkSpace.log("AvWorkSpace: Creating new internal ws with name " + pWorkSpaceName);
                _ws = new AvWorkSpaceInt(pWorkSpaceName);
                workSpaces.put(pWorkSpaceName, _ws);
            }
        }
        return new AvWorkSpace(_ws, pTimeOut * 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AvWorkSpace(AvWorkSpaceInt pWSInt, long pTimeout) throws AvException {
        this.wsName = pWSInt.getWSName();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.threadRef = Thread.currentThread();
        }
        if (!pWSInt.lock(this.threadRef, pTimeout)) {
            throw new AvException("Could not Lock WorkSpace: " + pWSInt.getWSName());
        }
    }

    public void closeWorkSpace() throws AvException {
        AvWorkSpaceInt _wsint = (AvWorkSpaceInt)workSpaces.get(this.wsName);
        if (null == _wsint || !_wsint.unlock(this.threadRef)) {
            throw new AvException("Could not Close Workspace: " + this.wsName);
        }
    }

    public Object getObject(String pName) throws AvException {
        AvWorkSpaceInt _wsint = (AvWorkSpaceInt)workSpaces.get(this.wsName);
        if (null != _wsint) {
            return _wsint.getObject(this.threadRef, pName);
        }
        throw new AvException("Could not getObject from Workspace: " + this.wsName);
    }

    public void putObject(String pName, Serializable pObjToPut) throws AvException {
        AvWorkSpaceInt _wsint = (AvWorkSpaceInt)workSpaces.get(this.wsName);
        if (null == _wsint) {
            throw new AvException("Could not putObject from Workspace: " + this.wsName);
        }
        _wsint.putObject(this.threadRef, pName, pObjToPut);
    }

    private static void log(String pMsg) {
        if (debugOn) {
            try {
                logBW.write(new Date().toString() + ": ");
                logBW.write(pMsg);
                logBW.newLine();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    static {
        if (debugOn) {
            try {
                logBW = new BufferedWriter(new FileWriter("workspace.log"));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private static class AvWorkSpaceInt {
        public static final int LOCK_WAIT_TIME = 20000;
        private String wsName = null;
        private Hashtable data = new Hashtable();
        private Thread lockedBy = null;
        private int lockCount = 0;
        private long lockedTime = 0L;
        private long lockTimeout = 0L;

        AvWorkSpaceInt(String pWSName) {
            this.wsName = pWSName;
        }

        String getWSName() {
            return this.wsName;
        }

        synchronized Object getObject(Thread pLocker, String pName) throws AvException {
            if (this.lockedBy != pLocker) {
                throw new AvException("WS locked by another or not locked!!!");
            }
            return this.data.get(pName);
        }

        synchronized void putObject(Thread pLocker, String pName, Serializable pObjToPut) throws AvException {
            if (this.lockedBy != pLocker) {
                throw new AvException("WS locked by another or not locked!!!");
            }
            this.data.put(pName, pObjToPut);
        }

        synchronized boolean lock(Thread pLocker, long pTimeout) {
            long _starttm = System.currentTimeMillis();
            while (null != this.lockedBy && this.lockedBy != pLocker) {
                long _tm = System.currentTimeMillis();
                long _untilTimeout = this.lockedTime + this.lockTimeout - _tm;
                if (_untilTimeout <= 0L) {
                    AvWorkSpace.log("AvWorkSpaceInt: LOCKED WS " + this.wsName + " because of timeout.  crt Locker: " + this.lockedBy + " new Locker: " + pLocker);
                    break;
                }
                long _stillToWait = _starttm + 20000L - _tm;
                if (_stillToWait <= 0L) {
                    AvWorkSpace.log("AvWorkSpaceInt: Could not LOCK WS " + this.wsName + " crt Locker is " + this.lockedBy + " new Locker: " + pLocker);
                    return false;
                }
                try {
                    AvWorkSpace.log("AvWorkSpaceInt: Start Wait FOR LOCK WS " + this.wsName + "  crt Locker: " + this.lockedBy + " new Locker: " + pLocker);
                    this.wait(Math.min(_untilTimeout, _stillToWait));
                    AvWorkSpace.log("AvWorkSpaceInt:  Done Wait FOR LOCK WS " + this.wsName + "  crt Locker: " + this.lockedBy + " new Locker: " + pLocker);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
            this.lockedBy = pLocker;
            ++this.lockCount;
            this.lockedTime = System.currentTimeMillis();
            this.lockTimeout = pTimeout;
            AvWorkSpace.log("AvWorkSpaceInt: Locked new WS for name: " + this.wsName + "  with ID " + pLocker);
            return true;
        }

        synchronized boolean unlock(Thread pLocker) {
            if (null != this.lockedBy && this.lockedBy != pLocker) {
                return false;
            }
            if (0 >= --this.lockCount) {
                this.lockedBy = null;
                this.lockCount = 0;
                this.lockedTime = 0L;
                this.lockTimeout = 0L;
                this.notify();
                AvWorkSpace.log("AvWorkSpaceInt: UnLocked new WS for name: " + this.wsName + "  with ID " + pLocker);
            } else {
                AvWorkSpace.log("AvWorkSpaceInt: Lock count decreased for WS for name: " + this.wsName + "  and ID " + pLocker);
            }
            return true;
        }
    }
}

