/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import com.ngnms.common.AvException;
import java.util.StringTokenizer;
import java.util.Vector;

public class AvVersionParser {
    public static final int MIN_ELEMENTS = 2;
    Vector valuePairVector = new Vector();
    private String delimiters = null;

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException("Use: isEquals instead of equals.");
    }

    public AvVersionParser(String pVersion) throws NullPointerException, AvException {
        this(pVersion, ".");
    }

    public AvVersionParser(String pVersion, String pDelimiters) throws NullPointerException, AvException {
        if (pVersion == null) {
            throw new NullPointerException("pVersion");
        }
        if (pDelimiters == null) {
            throw new NullPointerException("pDelimiters");
        }
        StringTokenizer versionTokenizer = new StringTokenizer(pVersion, pDelimiters);
        int tokensQty = versionTokenizer.countTokens();
        if (tokensQty < 2) {
            throw new AvException("Invalid Software Version (Ver=" + pVersion + ", Delim.=" + pDelimiters + "). The number of Elements is less then " + 2 + ". Found " + tokensQty + ".");
        }
        int i = 1;
        while (versionTokenizer.hasMoreTokens()) {
            this.valuePairVector.add(this.getValuePair(versionTokenizer.nextToken()));
            ++i;
        }
        this.delimiters = pDelimiters;
    }

    private AvVersionValuePair getValuePair(String pVer) throws AvException {
        String tail = null;
        int ver = -1;
        int lastNum = -1;
        for (int i = 0; i < pVer.length(); ++i) {
            char chr = pVer.charAt(i);
            if (chr <= '9' && chr >= '0') continue;
            lastNum = i - 1;
            break;
        }
        String verStr = pVer;
        if (lastNum >= 0) {
            verStr = pVer.substring(0, lastNum + 1);
            if (lastNum + 1 <= pVer.length()) {
                tail = pVer.substring(lastNum + 1);
            }
        } else {
            verStr = pVer;
        }
        try {
            ver = Integer.parseInt(verStr);
        }
        catch (Exception e) {
            throw new AvException("Failed to parse Software Version: " + pVer + ". The " + verStr + " is not Integer.");
        }
        return new AvVersionValuePair(ver, tail);
    }

    AvVersionValuePair getValuePairAt(int pPos) {
        if (this.valuePairVector.size() > pPos) {
            return (AvVersionValuePair)this.valuePairVector.elementAt(pPos);
        }
        return null;
    }

    public int size() {
        return this.valuePairVector.size();
    }

    public int getMajor() {
        return this.getValuePairAt((int)0).ver;
    }

    public String getMajorTail() {
        return this.getValuePairAt((int)0).tail;
    }

    AvVersionValuePair getMajorValuePair() {
        return this.getValuePairAt(0);
    }

    public int getMinor() {
        return this.getValuePairAt((int)1).ver;
    }

    public String getMinorTail() {
        return this.getValuePairAt((int)1).tail;
    }

    AvVersionValuePair getMinorValuePair() {
        return this.getValuePairAt(1);
    }

    public int getMaint() {
        AvVersionValuePair versionValuePair = this.getValuePairAt(2);
        if (versionValuePair != null) {
            return versionValuePair.ver;
        }
        return -1;
    }

    public String getMaintTail() {
        AvVersionValuePair versionValuePair = this.getValuePairAt(2);
        if (versionValuePair != null) {
            return versionValuePair.tail;
        }
        return null;
    }

    AvVersionValuePair getMaintValuePair() {
        return this.getValuePairAt(2);
    }

    public int getBuild() {
        AvVersionValuePair versionValuePair = this.getValuePairAt(3);
        if (versionValuePair != null) {
            return versionValuePair.ver;
        }
        return -1;
    }

    public String getBuildTail() {
        AvVersionValuePair versionValuePair = this.getValuePairAt(3);
        if (versionValuePair != null) {
            return versionValuePair.tail;
        }
        return null;
    }

    AvVersionValuePair getBuildValuePair() {
        return this.getValuePairAt(3);
    }

    private int comparePairs(AvVersionValuePair pair1, AvVersionValuePair pair2) {
        if (pair1.ver > pair2.ver) {
            return 1;
        }
        if (pair1.ver < pair2.ver) {
            return -1;
        }
        if (pair1.tail != null && pair2.tail != null) {
            return pair1.tail.compareTo(pair2.tail);
        }
        if (pair1.tail == null && pair2.tail != null) {
            return -1;
        }
        if (pair2.tail == null && pair1.tail != null) {
            return 1;
        }
        return 0;
    }

    private int compareTo(String pVersionString) throws AvException {
        AvVersionParser version = new AvVersionParser(pVersionString, this.delimiters);
        return this.compareTo(version);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int compareTo(AvVersionParser pVersion) throws NullPointerException {
        if (pVersion == null) {
            throw new NullPointerException("pVersion");
        }
        int i = 0;
        while (true) {
            if (i < this.valuePairVector.size()) {
                if (i >= pVersion.size()) return -1;
                int compVal = this.comparePairs(pVersion.getValuePairAt(i), (AvVersionValuePair)this.valuePairVector.elementAt(i));
                if (compVal != 0) {
                    return compVal;
                }
            } else {
                if (i >= pVersion.size()) return 0;
                return 1;
            }
            ++i;
        }
    }

    public boolean isNewerOrEquals(String pVersion) throws NullPointerException, AvException {
        return this.compareTo(pVersion) >= 0;
    }

    public boolean isNewerOrEquals(AvVersionParser pVersion) throws NullPointerException, AvException {
        return this.compareTo(pVersion) >= 0;
    }

    public boolean isOlder(String pVersion) throws NullPointerException, AvException {
        return this.compareTo(pVersion) < 0;
    }

    public boolean isOlder(AvVersionParser pVersion) throws NullPointerException {
        return this.compareTo(pVersion) < 0;
    }

    public boolean isEquals(String pVersion) throws NullPointerException, AvException {
        return this.compareTo(pVersion) == 0;
    }

    public boolean isEquals(AvVersionParser pVersion) throws NullPointerException {
        return this.compareTo(pVersion) == 0;
    }

    public String getVersion() {
        String retVal = "";
        for (int i = 0; i < this.size(); ++i) {
            AvVersionValuePair versionValuePair = this.getValuePairAt(i);
            if (i > 0) {
                retVal = retVal + ".";
            }
            retVal = retVal + versionValuePair.getAsString();
        }
        return retVal;
    }

    public String toString() {
        String retVal = "";
        for (int i = 0; i < this.size(); ++i) {
            AvVersionValuePair versionValuePair = this.getValuePairAt(i);
            switch (i) {
                case 0: {
                    retVal = retVal + "Major = ";
                    break;
                }
                case 1: {
                    retVal = retVal + ", Minor = ";
                    break;
                }
                case 2: {
                    retVal = retVal + ", Maint = ";
                    break;
                }
                case 3: {
                    retVal = retVal + ", Build = ";
                    break;
                }
                default: {
                    retVal = retVal + ", ";
                }
            }
            retVal = retVal + versionValuePair.toString();
        }
        return retVal;
    }

    class AvVersionValuePair {
        public int ver = -1;
        public String tail = null;

        public AvVersionValuePair(int pInitVer, String pInitTail) {
            this.ver = pInitVer;
            this.tail = pInitTail;
        }

        public String toString() {
            if (this.tail != null) {
                return this.ver + "[" + this.tail + "]";
            }
            return "" + this.ver;
        }

        public String getAsString() {
            if (this.tail != null) {
                return this.ver + this.tail;
            }
            return "" + this.ver;
        }
    }
}

