/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import com.ngnms.common.AvTrace;
import java.io.BufferedReader;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AvUtil {
    public static final String UNIX = "Unix";
    public static final String WINDOWS = "Windows";

    public static boolean isAppServerSide() {
        String serverType = System.getProperty("oware.server.type");
        return serverType == null ? false : serverType.equalsIgnoreCase("AppServer");
    }

    public static boolean isMedServerSide() {
        String serverType = System.getProperty("oware.server.type");
        return serverType == null ? false : serverType.equalsIgnoreCase("MedServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getSystemMACAddress(String pOS, String pAddrTitle, BufferedReader pCmdOutput) {
        Vector<String> MACAddress = new Vector<String>();
        String ipcLine = null;
        String delimiter = "";
        try {
            delimiter = pOS.equals(UNIX) ? ":" : "-";
            while ((ipcLine = pCmdOutput.readLine()) != null) {
                int n = ipcLine.indexOf(pAddrTitle);
                if (n <= 0) continue;
                if (pOS.equals(UNIX)) {
                    ipcLine = ipcLine.substring(pAddrTitle.length() + 1, ipcLine.length()).trim();
                } else {
                    int j = ipcLine.indexOf(":");
                    if (j > 0) {
                        ipcLine = ipcLine.substring(j + 1, ipcLine.length()).trim();
                    }
                }
                StringTokenizer st = new StringTokenizer(ipcLine, delimiter);
                String addr = "";
                while (st.hasMoreTokens()) {
                    String digit = st.nextToken();
                    if (digit.length() < 2) {
                        addr = addr.concat("0");
                    }
                    addr = addr.concat(digit);
                }
                MACAddress.addElement(addr);
            }
        }
        catch (Exception e) {
            AvTrace.traceln("AvLS", 3, "Failed to retrieve MAC address");
        }
        finally {
            return MACAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getWindowsMACAddress(String pAddrTitle, BufferedReader pCmdOutput) {
        Vector<String> MACAddress = new Vector<String>();
        String ipcLine = null;
        String delimiter = "";
        try {
            delimiter = "-";
            while ((ipcLine = pCmdOutput.readLine()) != null) {
                int n = ipcLine.indexOf(pAddrTitle);
                if (n <= 0) continue;
                int j = ipcLine.indexOf(":");
                if (j > 0) {
                    ipcLine = ipcLine.substring(j + 1, ipcLine.length()).trim();
                }
                StringTokenizer st = new StringTokenizer(ipcLine, delimiter);
                String addr = "";
                while (st.hasMoreTokens()) {
                    String digit = st.nextToken();
                    if (digit.length() < 2) {
                        addr = addr.concat("0");
                    }
                    addr = addr.concat(digit);
                }
                MACAddress.addElement(addr);
            }
        }
        catch (Exception e) {
            AvTrace.traceln("AvLS", 3, "Failed to retrieve MAC address");
        }
        finally {
            return MACAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getUnixMACAddress(BufferedReader pCmdOutput) {
        Vector<String> MACAddress = new Vector<String>();
        String ipcLine = null;
        String addr = "";
        try {
            String hostAddr = AvUtil.getIPHostAddress();
            String hostName = AvUtil.getIPHostName();
            while ((ipcLine = pCmdOutput.readLine()) != null) {
                int n = ipcLine.indexOf(hostName);
                if (n <= 0) {
                    n = ipcLine.indexOf(hostAddr);
                }
                if (n <= 0) continue;
                StringTokenizer line = new StringTokenizer(ipcLine, " ");
                while (line.hasMoreTokens()) {
                    String tc = line.nextToken();
                    if (tc.indexOf(":") <= 0) continue;
                    StringTokenizer st = new StringTokenizer(tc, ":");
                    addr = "";
                    while (st.hasMoreTokens()) {
                        String digit = st.nextToken();
                        if (digit.length() < 2) {
                            addr = addr.concat("0");
                        }
                        addr = addr.concat(digit);
                    }
                    addr = addr.toUpperCase();
                    MACAddress.addElement(addr);
                }
            }
        }
        catch (Exception e) {
            AvTrace.traceln("AvLS", 3, "Failed to retrieve MAC address");
        }
        finally {
            return MACAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIPHostAddress() {
        String ipHostAddress = null;
        try {
            ipHostAddress = InetAddress.getLocalHost().getHostAddress();
            return ipHostAddress;
        }
        catch (SecurityException e) {
            AvTrace.traceln("AvLS", 3, "Failed to execute InetAddress.getHostAddress(),SecurityException");
        }
        catch (Exception e) {
            AvTrace.traceln("AvLS", 3, "Failed to execute InetAddress.getHostAddress()" + e.getMessage());
        }
        finally {
            return ipHostAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIPHostName() {
        String ipHostName = null;
        try {
            ipHostName = InetAddress.getLocalHost().getHostName();
            return ipHostName;
        }
        catch (SecurityException e) {
            AvTrace.traceln("AvLS", 3, "Failed to execute InetAddress.getHostName(),SecurityException");
        }
        catch (Exception e) {
            AvTrace.traceln("AvLS", 3, "Failed to execute InetAddress.getHostName()" + e.getMessage());
        }
        finally {
            return ipHostName;
        }
    }
}

