/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import com.dorado.common.exception.OWException;
import com.dorado.common.exception.OWUserException;
import com.dorado.common.utility.OWAppServerUtility;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryAllByClass;
import com.dorado.core.ejb.log.OWLogStorageClient;
import com.dorado.core.ejb.ruleengine.OWRuleEngineClient;
import com.dorado.core.logstorage.OWLogMsg;
import com.dorado.runtime.IOWEvent;
import com.ngnms.common.AvClientInternationalizer;
import com.ngnms.common.AvMessageNotFoundException;
import com.ngnms.common.AvPropDefs;
import com.ngnms.common.AvTraceStartupCategory;
import com.ngnms.common.AvUtil;
import com.ngnms.zdebug.trace.AvTraceUploadCategoriesRuleParamSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class AvTrace {
    public static final int LOW = 1;
    public static final int MED = 2;
    public static final int HIGH = 3;
    public static final String TRACE_ALL = "AvTraceAll";
    public static String LOG_USER_ID_APP = AvPropDefs.getAppName();
    private static Hashtable tracingCategoriesHashtable = null;
    private static boolean toPrintCategoryAndSeverity = true;
    private static boolean toTraceOnLog = true;
    private static boolean toLogOnTraceStack = false;
    private static boolean toTraceTime = true;
    private static boolean isClient = false;

    public static void load(IOWBOMClient pBOM) {
        OWBOMQueryAllByClass query = new OWBOMQueryAllByClass("com.ngnms.common.AvTraceStartupCategory");
        try {
            ArrayList categories = pBOM.getObjects((OWBOMQuery)query).getReturnObjects();
            if (!categories.isEmpty()) {
                tracingCategoriesHashtable = new Hashtable();
            }
            for (AvTraceStartupCategory cat : categories) {
                tracingCategoriesHashtable.put(cat.getCategory(), new Integer(cat.getDetail()));
            }
            System.out.println("\nAvTrace - Trace On.\n");
        }
        catch (OWBOMNotFoundException e) {
        }
        catch (Exception e) {
            AvTrace.traceStack(e);
        }
    }

    public static Hashtable getCategories() {
        return tracingCategoriesHashtable == null ? new Hashtable() : tracingCategoriesHashtable;
    }

    public static boolean addTraceCategory(String category, int severity) {
        if (severity > 3 || severity < 1) {
            return false;
        }
        if (tracingCategoriesHashtable == null) {
            tracingCategoriesHashtable = new Hashtable();
            System.out.println("\nAvTrace - Trace On.\n");
        }
        if (tracingCategoriesHashtable.containsKey(category)) {
            System.out.println("\nAvTrace - Trace Category " + category + " already exists!");
        }
        tracingCategoriesHashtable.put(category, new Integer(severity));
        return true;
    }

    public static void removeTraceCategory(String category) {
        if (tracingCategoriesHashtable == null) {
            return;
        }
        if (!tracingCategoriesHashtable.containsKey(category)) {
            System.out.println("\nAvTrace - Trace Category " + category + " does not exist!");
            return;
        }
        tracingCategoriesHashtable.remove(category);
        if (tracingCategoriesHashtable.size() == 0) {
            tracingCategoriesHashtable = null;
            System.out.println("\nAvTrace - Trace Off.\n");
        }
    }

    public static void setToPrintCategoryAndSeverity(boolean newToPrintCategoryAndSeverity) {
        toPrintCategoryAndSeverity = newToPrintCategoryAndSeverity;
    }

    public static boolean isTracing(String category, int severity) {
        if (tracingCategoriesHashtable == null || severity > 3 || severity < 1) {
            return false;
        }
        boolean tracable = false;
        Integer tempSeverity = (Integer)tracingCategoriesHashtable.get(category.trim());
        Integer tempAllSeverity = (Integer)tracingCategoriesHashtable.get(TRACE_ALL);
        if (tempAllSeverity != null) {
            tracable = tempAllSeverity >= severity;
        } else if (tempSeverity != null) {
            tracable = tempSeverity >= severity;
        }
        return tracable;
    }

    private static synchronized void traceInternal(String category, int severity, String message, boolean nextLine) {
        if (tracingCategoriesHashtable == null) {
            return;
        }
        if (AvTrace.isTracing(category, severity)) {
            String prefix = "";
            if (toPrintCategoryAndSeverity) {
                prefix = prefix + category + "." + severity + " ";
            }
            if (toTraceTime && isClient) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss SSS ", Locale.getDefault());
                prefix = prefix + formatter.format(new Date(System.currentTimeMillis()));
            }
            if (toPrintCategoryAndSeverity || toTraceTime && isClient) {
                prefix = prefix + "-> ";
            }
            if (message == null) {
                System.out.println(prefix);
            } else if (nextLine) {
                System.out.println(prefix + message);
            } else {
                System.out.print(prefix + message);
            }
        }
    }

    public static void trace(String category, int severity, String message) {
        AvTrace.traceInternal(category, severity, message, false);
    }

    public static void traceln(String category, int severity, String message) {
        AvTrace.traceInternal(category, severity, message, true);
    }

    public static void traceln(String category) {
        AvTrace.traceInternal(category, 3, null, true);
    }

    public static void traceStack(String category, int severity, Exception e) {
        if (tracingCategoriesHashtable == null) {
            return;
        }
        if (AvTrace.isTracing(category, severity)) {
            String msg = "";
            if (toPrintCategoryAndSeverity) {
                msg = msg + category + "." + severity + " >>> ";
            }
            System.out.println(msg + e.getMessage() + "\n");
            AvTrace.traceStack(e);
        }
        if (AvTrace.isLogOnTraceStack()) {
            AvTrace.logError(e, category, "");
        }
    }

    public static void traceStack(Exception e) {
        if (e instanceof OWUserException) {
            System.out.println(((OWUserException)e).createStackTrace() + "\n");
        } else if (e instanceof OWException) {
            System.out.println(((OWException)e).getTraceString() + "\n");
        } else {
            e.printStackTrace();
        }
    }

    public static void traceMemoryStatus() {
        Long freeMem = new Long(Runtime.getRuntime().freeMemory());
        Long totalMem = new Long(Runtime.getRuntime().totalMemory());
        Long memInUse = new Long(totalMem - freeMem);
        System.out.println();
        System.out.println("| Memory Status");
        System.out.println("| -------------");
        System.out.println("| Total Memory  = " + totalMem);
        System.out.println("| Free Memory   = " + freeMem);
        System.out.println("| Memory in Use = " + memInUse);
        System.out.println();
    }

    public static boolean isTraceOnLog() {
        return toTraceOnLog;
    }

    public static void setTraceOnLog(boolean newToTraceOnLog) {
        toTraceOnLog = newToTraceOnLog;
    }

    public static boolean isLogOnTraceStack() {
        return toLogOnTraceStack;
    }

    public static void setLogOnTraceStack(boolean newToLogOnTraceStack) {
        toLogOnTraceStack = newToLogOnTraceStack;
    }

    public static void setTraceTime(boolean newTraceTime) {
        toTraceTime = newTraceTime;
    }

    public static boolean isTraceTime() {
        return toTraceTime;
    }

    public static boolean isPrintCategoryAndSeverity() {
        return toPrintCategoryAndSeverity;
    }

    public static void logMessage(String category, String userID, String entity, String principal, String messageText) {
        OWLogMsg logMsg = new OWLogMsg(new Long(0L), new Date(), category, userID, entity, principal, messageText);
        logMsg.emit();
        if (AvTrace.isTraceOnLog()) {
            AvTrace.traceln(category, 1, messageText);
        }
    }

    public static void logMessage(String bundleFile, String category, String userID, String entity, String principal, String messageID) throws AvMessageNotFoundException {
        AvTrace.logMessage(bundleFile, category, userID, entity, principal, messageID, null);
    }

    public static void logMessage(String bundleFile, String category, String userID, String entity, String principal, String messageID, String[] params) throws AvMessageNotFoundException {
        String msg = AvClientInternationalizer.getFormattedMessageFromBundle(bundleFile, category, messageID, params);
        AvClientInternationalizer internationalizer = new AvClientInternationalizer(bundleFile);
        AvTrace.traceln("AvLog", 1, "Before translateText: category = " + category + ", entity = " + entity);
        category = internationalizer.translateText(category);
        entity = internationalizer.translateText(entity);
        AvTrace.traceln("AvLog", 1, "After translateText:  category = " + category + ", entity = " + entity);
        AvTrace.logMessage(category, userID, entity, principal, msg);
    }

    public static void logError(Exception e, String entity, String principal) {
        try {
            OWLogStorageClient logClient = new OWLogStorageClient(true);
            logClient.logException((Throwable)e);
        }
        catch (Exception ex) {
            AvTrace.traceStack(ex);
        }
    }

    static {
        try {
            if (!AvUtil.isAppServerSide()) {
                OWRuleEngineClient ruleEngine = null;
                if (AvUtil.isMedServerSide()) {
                    ruleEngine = new OWRuleEngineClient(OWAppServerUtility.getExternalAppServerName());
                } else {
                    isClient = true;
                    ruleEngine = new OWRuleEngineClient();
                }
                AvTraceUploadCategoriesRuleParamSet pSet = new AvTraceUploadCategoriesRuleParamSet();
                pSet.setUploadToClient(true);
                ruleEngine.callRule("com.ngnms.zdebug.trace.AvTraceUploadCategoriesRule", (IOWEvent)pSet);
                Hashtable cats = pSet.getCategories();
                Enumeration e = cats.keys();
                while (e.hasMoreElements()) {
                    String cat = (String)e.nextElement();
                    int severity = (Integer)cats.get(cat);
                    AvTrace.addTraceCategory(cat, severity);
                }
                AvTrace.setLogOnTraceStack(pSet.getToLogOnTraceStack());
                AvTrace.setToPrintCategoryAndSeverity(pSet.getToPrintCategoryAndSeverity());
                AvTrace.setTraceOnLog(pSet.getToTraceOnLog());
                AvTrace.setTraceTime(pSet.getToTraceTime());
            }
        }
        catch (Exception ex) {
            System.out.println("AvTrace >>> Could not initialize tracing.");
            ex.printStackTrace();
        }
    }
}

