/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import com.bwanms.ruledelegator.BaseRuleImpl;
import com.bwanms.security.Security;
import com.bwanms.services.PlatformServiceLocator;
import com.bwanms.services.ServiceRegistry;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.ejb.ruleengine.OWRuleEngineBaseClient;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.core.security.IOWSecurityDef;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.common.AvException;
import com.ngnms.common.AvStartupDispatcherRuleParamSet;
import com.ngnms.common.AvTrace;
import com.ngnms.setup.AvModuleUtil;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.security.auth.Subject;
import redcell.common.util.snmp.RedCellSNMPUtil;

public class AvStartupDispatcherRuleImpl
extends BaseRuleImpl {
    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvStartupDispatcherRule.run()");
        this.runRule((AvStartupDispatcherRuleParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvStartupDispatcherRule.run()");
    }

    public void runRule(AvStartupDispatcherRuleParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        System.setProperty("NGNMS_ROOT", System.getProperty("oware.user.root") + "/owareapps/ngnms");
        AvTrace.load(this.getBOM());
        AvTrace.traceln("AvServerStartup", 1, "AvStartupDispatcherRule. Invoked");
        AvTrace.traceln("AvServerStartup", 2, "AvStartupDispatcherRule. pParamSet = \n" + pParamSet.toString());
        final AvStartupDispatcherRuleParamSet paramSet = pParamSet;
        try {
            Subject sysSubject = new Subject();
            sysSubject.getPrincipals().add((Principal)IOWSecurityDef.OWARE_SYSTEM_USER_PRINCIPAL);
            Subject.doAs(sysSubject, new PrivilegedExceptionAction(){

                public Object run() throws PrivilegedActionException {
                    try {
                        AvModuleUtil.getServerModules(AvStartupDispatcherRuleImpl.this.getBOM());
                        AvStartupDispatcherRuleImpl.this.callStartupRule("com.ngnms.common.AvStartupLookupRule", paramSet);
                        RedCellSNMPUtil.loadSNMPMIBs();
                        String[] rules = new String[]{"com.ngnms.services.cm.AvCMStartupRule"};
                        for (int i = 0; i < rules.length; ++i) {
                            AvStartupDispatcherRuleImpl.this.callStartupRule(rules[i], paramSet);
                        }
                        return null;
                    }
                    catch (Exception e) {
                        throw new PrivilegedActionException(e);
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            pae.getException().printStackTrace();
        }
        catch (Exception e) {
            AvTrace.traceStack((Exception)((Object)new AvException(e, "Failure to startup one or more components")));
        }
        ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "SystemStartup", "System", "System", "System");
        PlatformServiceLocator.getPlatformService().sendInitializationSignal();
    }

    private void callStartupRule(String pRuleName, AvStartupDispatcherRuleParamSet pParamSet) throws AvException {
        try {
            OWEvent owEvent = OWRuleEngineBaseClient.getRuleParameter((String)pRuleName);
            owEvent.storeProperties((List)pParamSet.readProperties());
            this.callRule(pRuleName, (IOWEvent)owEvent);
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to run " + pRuleName);
        }
    }
}

