/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import RedCell.Config.Role;
import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWBaseBean;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.common.AvBeanProxy;
import com.ngnms.common.AvDeviceUtil;
import com.ngnms.common.AvException;
import com.ngnms.common.AvRoleOperateRule;
import com.ngnms.common.AvRoleOperateRuleParamSet;
import com.ngnms.common.AvTrace;
import org.apache.log4j.Logger;

public class AvRoleOperateRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvRoleOperateRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvRoleOperateRule.run()");
        this.runRule((AvRoleOperateRuleParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvRoleOperateRule.run()");
    }

    public void runRule(AvRoleOperateRuleParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        String operation = pParamSet.getOperation();
        AvTrace.traceln("AvDeviceUtil", 1, "AvRoleOperate Invoked for: " + operation);
        try {
            AvBeanProxy deviceProxy = pParamSet.getDeviceProxy();
            String roleName = pParamSet.getRoleName();
            String roleType = pParamSet.getRoleType();
            if (roleName == null) {
                throw new AvException("RoleName can't be NULL");
            }
            AvTrace.traceln("AvDeviceUtil", 1, "roleName: " + roleName);
            AvTrace.traceln("AvDeviceUtil", 1, "roleType: " + roleType);
            if (operation.equals("GET_ROLE")) {
                Role role = AvDeviceUtil.getRole(this.getBOM(), roleName, roleType);
                pParamSet.setRoleOut(new AvBeanProxy((OWBaseBean)role));
            } else {
                if (deviceProxy == null) {
                    throw new AvException("Device can't be NULL");
                }
                AvTrace.traceln("AvDeviceUtil", 1, "  device: " + deviceProxy.getAsString("Name"));
                if (operation.equals("SET_ROLE")) {
                    AvDeviceUtil.setRole(this.getBOM(), deviceProxy, roleName, roleType);
                } else if (operation.equals("REMOVE_ROLE")) {
                    AvDeviceUtil.removeRole(this.getBOM(), deviceProxy, roleName);
                } else {
                    throw new AvException("Unknown Operation: " + operation);
                }
                AvBeanProxy.commitAll(this.getBOM());
            }
            pParamSet.setResponseStatus("AvServices_RESPONSE_OK");
        }
        catch (Exception e) {
            pParamSet.setResponseStatus(e.getMessage());
        }
    }
}

