/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import RedCell.Config.Equipment;
import RedCell.Config.EquipmentManager;
import RedCell.Config.NetworkResource;
import RedCell.Config.NetworkResourceKey;
import com.bwanms.ruledelegator.redcell.RCGenericQueryRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.common.utility.OWOID;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByKey;
import com.dorado.core.bom.OWBOMQueryByOWOID;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.redcell.inventory.base.commandhandler.RCQueryCommandParamSet;
import com.dorado.redcell.inventory.base.commandhandler.RCQueryResults;
import com.dorado.redcell.inventory.equipment.RCRolesInterrogator;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.apps.pmcollection.AvExportFileNameInterrogator;
import com.ngnms.common.AvIPAddressInterrogator;
import com.ngnms.common.AvQueryEquipment;
import com.ngnms.common.AvTrace;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AvQueryEquipmentImpl
extends RCGenericQueryRuleImpl {
    private String equipmentBaseClassName = "RedCell.Config.EquipmentManager";
    private static final Logger log4j = Logger.getLogger(AvQueryEquipment.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvQueryEquipment.run()");
        this.runRule((RCQueryCommandParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvQueryEquipment.run()");
    }

    public void runRule(RCQueryCommandParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        String baseClassName = pParamSet.getEntityClassName();
        if (null != baseClassName) {
            if ("com.ngnms.common.AvEquipment".equals(baseClassName)) {
                this.equipmentBaseClassName = "RedCell.Config.Equipment";
            } else {
                try {
                    Class<?> baseClass = Class.forName(baseClassName);
                    if (EquipmentManager.class.isAssignableFrom(baseClass)) {
                        this.equipmentBaseClassName = baseClassName;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        pParamSet.setEntityClassName(this.equipmentBaseClassName);
        super.runRule(pParamSet);
    }

    public Collection getAttributeInterrogators() {
        Vector<Object> _vect = new Vector<Object>();
        try {
            _vect.add(new RCRolesInterrogator(this.getBOM()));
            _vect.add((Object)new AvExportFileNameInterrogator());
            _vect.add((Object)new AvIPAddressInterrogator());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return _vect;
    }

    public OWBOMQuery getQueryForOid(OWOID pOid) {
        try {
            IOWBOMClient _bom = this.getBOM();
            OWBOMQueryByOWOID _qbo = new OWBOMQueryByOWOID(pOid);
            Object _obj = ((Vector)_bom.getObjects((OWBOMQuery)_qbo).getRtnObject()).get(0);
            if (_obj instanceof NetworkResourceKey) {
                NetworkResourceKey _key = (NetworkResourceKey)_obj;
                String _keyStr = _key.getKey();
                return new OWBOMQueryByKey(this.equipmentBaseClassName, _keyStr);
            }
            return _qbo;
        }
        catch (Exception _e) {
            _e.printStackTrace();
            return null;
        }
    }

    public String getParentOidString(IOWBean pBean) {
        Equipment _bean = (Equipment)pBean;
        NetworkResourceKey _key = _bean.getKey();
        if (_key == null) {
            return "";
        }
        NetworkResourceKey _parentKey = _key.getParentKey();
        if (_parentKey == null) {
            return "";
        }
        NetworkResource _parentBean = _parentKey.getNetworkResource();
        if (_parentBean == null) {
            return "";
        }
        return _parentBean.getHandle().toString();
    }

    public void sortResults(RCQueryResults pResults) {
    }
}

