/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import RedCell.Config.GenericMODeleteRuleParamSet;
import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.common.utility.OWOID;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.apps.license.AvLSUtil;
import com.ngnms.common.AvClientInternationalizer;
import com.ngnms.common.AvDeviceUtil;
import com.ngnms.common.AvException;
import com.ngnms.common.AvLookup;
import com.ngnms.common.AvLookupItemNotFoundException;
import com.ngnms.common.AvMODeleteRule;
import com.ngnms.common.AvTrace;
import java.util.Date;
import org.apache.log4j.Logger;
import redcell.common.util.RCBeanProxy;
import redcell.common.util.RCBeanProxyUtil;
import redcell.core.usersys.RCUserUtil;

public class AvMODeleteRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvMODeleteRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvMODeleteRule.run()");
        this.runRule((GenericMODeleteRuleParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvMODeleteRule.run()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRule(GenericMODeleteRuleParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvDeviceUtil", 2, "INSIDE AvMODeleteRule !!!");
        OWOID deviceOWOID = pParamSet.getMOOID();
        AvTrace.traceln("AvDeviceUtil", 2, "Device OWOID = " + deviceOWOID.getOID());
        String responseStatus = "AvServices_RESPONSE_OK";
        try {
            AvDeviceUtil.deleteDeviceComponents(this.getEngine(), deviceOWOID);
            this.deletePMData(deviceOWOID);
            RCBeanProxy device = RCBeanProxyUtil.getProxyBean((OWOID)deviceOWOID);
            RCBeanProxy logicalEntitiesBP = device.getAsProxy("LogicalEntities");
            if (null == logicalEntitiesBP) {
                pParamSet.setMOStatus(true);
                pParamSet.setMOMessage(responseStatus);
                return;
            }
            OWOID logicalEntitiesOWOID = logicalEntitiesBP.getRCOID();
            AvTrace.traceln("AvDeviceUtil", 3, "Device LogicalEntity OWOID = " + logicalEntitiesOWOID);
            responseStatus = this.deleteLogicalEntities(logicalEntitiesOWOID);
            if (responseStatus.startsWith("AvServices_RESPONSE_OK")) {
                AvTrace.traceln("AvDeviceUtil", 3, "Success in AvMODeleteRule, status = " + responseStatus);
                String licenseClassName = device.getRCClass();
                try {
                    AvTrace.traceln("AvDeviceUtil", 2, "Searching ParentClass for equipmentClassName = " + licenseClassName);
                    licenseClassName = AvLookup.get("ParentClass", licenseClassName);
                    AvTrace.traceln("AvDeviceUtil", 2, "licenseClassName = " + licenseClassName);
                }
                catch (AvLookupItemNotFoundException e) {
                    AvTrace.traceln("AvDeviceUtil", 1, "No Parent Class found for equipmentClassName = " + licenseClassName + " - Will use current Class.");
                }
                if (null == licenseClassName) {
                    licenseClassName = device.getRCClass();
                }
                AvTrace.traceln("AvDeviceUtil", 2, "Deleting the device from license: " + licenseClassName);
                if (!device.getAsString("Model").startsWith("Undiscovered")) {
                    AvLSUtil.deleteDevice(licenseClassName);
                }
            } else {
                AvTrace.traceln("AvDeviceUtil", 2, "Failure in AvMODeleteRule, status = " + responseStatus);
            }
            AvDeviceUtil.removeDeviceFromMOMFile(deviceOWOID.getOID());
            this.logDeleteMessage(device);
        }
        catch (Exception e) {
            responseStatus = "AvServices_RESPONSE_ERROR";
            AvTrace.traceStack("AvDeviceUtil", 1, (Exception)((Object)new AvException(e, "Exceptional Failure in AvMODeleteRule, status = " + responseStatus + "  " + e.getMessage())));
        }
        finally {
            pParamSet.setMOStatus(true);
            pParamSet.setMOMessage(responseStatus);
        }
    }

    private void deletePMData(OWOID pDeviceOWOID) throws AvException {
    }

    protected String deleteLogicalEntities(OWOID pLogicalEntitiesOWOID) throws AvException {
        throw new RuntimeException("OLD VERSION EXCEPTION!!!");
    }

    private void logDeleteMessage(RCBeanProxy device) {
        AvClientInternationalizer internationalizer = new AvClientInternationalizer("AvCommonTitlesBundle");
        String radioBand = device.getAsString("RadioBand");
        String deviceName = device.getAsString("Name");
        String deviceID = deviceName + " (" + device.getAsString("Model") + ")";
        String logMsg = new Date() + "\n" + internationalizer.translateText("Device") + " " + deviceID + "\n";
        logMsg = logMsg + internationalizer.translateText("MacAddress") + " " + device.getAsString("MacAddress") + "\n";
        logMsg = logMsg + internationalizer.translateText("SoftwareVersion") + " " + device.getAsString("SoftwareVersion") + "\n";
        if (radioBand != null && !radioBand.equals("")) {
            logMsg = logMsg + internationalizer.translateText("RadioBand") + " " + radioBand + "\n";
        }
        AvTrace.logMessage(internationalizer.translateText("DeletedEquipment"), RCUserUtil.getCurrentUser().getLoginName(), deviceName, "DeletedEquipment", logMsg);
    }
}

