/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import RedCell.Config.NetworkResource;
import com.dorado.common.collections.OWAVPVector;
import com.dorado.common.utility.OWAttributeValuePair;
import com.dorado.common.utility.OWOID;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAPIException;
import com.dorado.runtime.IOWIntrinsic;
import com.dorado.runtime.OWBean;
import com.dorado.runtime.OWEvent;
import com.dorado.runtime.OWHashtable;
import com.dorado.runtime.OWSet;
import com.dorado.runtime.OWVector;
import com.ngnms.common.AvException;
import com.ngnms.common.AvIniReader;
import com.ngnms.common.AvLookupItemNotFoundException;
import com.ngnms.common.AvLookupRuleParamSet;
import com.ngnms.common.AvSnmpLeaf;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvUnsupportedFeatureException;
import com.ngnms.common.AvUtil;
import com.ngnms.services.common.AvMOUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import redcell.common.util.RCBOMUtil;
import redcell.common.util.RedCellRuleEngineUtil;

public abstract class AvLookup {
    private static TreeMap lookupAVPV = null;
    private static final String ruleName = "com.ngnms.common.AvLookupRule";
    public static final String DEVICE_CLASS_NAME = "LookupDeviceClassName";
    public static final String TOP_LEVEL_DEVICE_CLASS_NAME = "LookupTopLevelDeviceClassName";
    public static final String MO_CLASS_NAME = "LookupClassName";
    public static final String SUB_KEY = "LookupCustomSubKey";
    public static final String EMPTY_RECORD = "AvLookupEmpty";
    public static final String WILDCARD = "{AvAny}";
    public static final String SEPARATOR = "{AvSep}";
    public static final String SECTION_CONTENT = "AvLookupSectionContent";
    public static final String TOP_LEVEL = "LookupTopLevel_";

    public static String get(String pQuery, String pStr) throws AvLookupItemNotFoundException, AvException {
        if (AvUtil.isAppServerSide()) {
            return AvLookup.getValueFromString(pQuery, pStr);
        }
        AvLookupRuleParamSet lookupRuleParamSet = new AvLookupRuleParamSet();
        lookupRuleParamSet.setQuery(pQuery);
        lookupRuleParamSet.setParamString(pStr);
        return (String)((Object)AvLookup.getFromLookupRule(lookupRuleParamSet));
    }

    public static String get(IOWBOMClient pBOM, String pQuery, OWOID pOWOID) throws AvLookupItemNotFoundException, AvUnsupportedFeatureException, AvException {
        return AvLookup.get(pBOM, pQuery, pOWOID, null);
    }

    public static String get(IOWBOMClient pBOM, String pQuery, OWOID pOWOID, String pSubKey) throws AvLookupItemNotFoundException, AvUnsupportedFeatureException, AvException {
        if (AvUtil.isAppServerSide()) {
            try {
                NetworkResource nr = (NetworkResource)RCBOMUtil.getOWObject((IOWBOMClient)pBOM, (OWOID)pOWOID);
                AvTrace.traceln("AvLookup", 1, "AvLookupRule - NetworkResource Name = " + nr.getName());
                return AvLookup.getValueFromParamX(pQuery, nr, pSubKey);
            }
            catch (OWBOMAPIException e) {
                throw new AvException(e, "Failed to Retrieve NetworkResource with OWOID = " + pOWOID.getOID());
            }
        }
        throw new AvUnsupportedFeatureException("Unsupported Client \"Server\" with IOWBOMClient.");
    }

    public static String get(String pQuery, OWOID pOWOID) throws AvLookupItemNotFoundException, AvUnsupportedFeatureException, AvException {
        return AvLookup.get(pQuery, pOWOID, null);
    }

    public static String get(String pQuery, OWOID pOWOID, String pSubKey) throws AvLookupItemNotFoundException, AvUnsupportedFeatureException, AvException {
        if (AvUtil.isAppServerSide()) {
            throw new AvUnsupportedFeatureException("Unsupported Client \"Server\" with no IOWBOMClient.");
        }
        AvLookupRuleParamSet lookupRuleParamSet = new AvLookupRuleParamSet();
        lookupRuleParamSet.setQuery(pQuery);
        lookupRuleParamSet.setBeanOWOID(pOWOID);
        lookupRuleParamSet.setSubKey(pSubKey);
        return (String)((Object)AvLookup.getFromLookupRule(lookupRuleParamSet));
    }

    public static String get(String pQuery, NetworkResource pNetworkResource) throws AvLookupItemNotFoundException, AvUnsupportedFeatureException, AvException {
        return AvLookup.get(pQuery, pNetworkResource, null);
    }

    public static String get(String pQuery, NetworkResource pNetworkResource, String pSubKey) throws AvLookupItemNotFoundException, AvUnsupportedFeatureException, AvException {
        if (AvUtil.isAppServerSide()) {
            return AvLookup.getValueFromParamX(pQuery, pNetworkResource, pSubKey);
        }
        throw new AvUnsupportedFeatureException("Unsupported Client \"get\" with NetworkResource.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OWAVPVector getSectionContent(String pQuery) throws AvException, AvLookupItemNotFoundException {
        OWAVPVector retVal = null;
        if (AvUtil.isAppServerSide()) {
            OWAVPVector sectionDataAVPV = (OWAVPVector)lookupAVPV.get(pQuery);
            AvTrace.traceln("AvLookup", 3, "Server Side - AvLookup.getSectionContent [" + pQuery + "]");
            if (null == sectionDataAVPV) throw new AvLookupItemNotFoundException("The Section [" + pQuery + "] - Not Found.");
            return (OWAVPVector)sectionDataAVPV.clone();
        }
        AvTrace.traceln("AvLookup", 3, "Client Side - AvLookup.getSectionContent [" + pQuery + "]");
        AvLookupRuleParamSet lookupRuleParamSet = new AvLookupRuleParamSet();
        lookupRuleParamSet.setQuery(pQuery);
        lookupRuleParamSet.setParamString(SECTION_CONTENT);
        return (OWAVPVector)AvLookup.getFromLookupRule(lookupRuleParamSet);
    }

    private static Serializable getFromLookupRule(AvLookupRuleParamSet pLookupRuleParamSet) throws AvException, AvLookupItemNotFoundException {
        try {
            RedCellRuleEngineUtil.callRule((String)ruleName, (OWEvent)pLookupRuleParamSet);
            Serializable retVal = pLookupRuleParamSet.getRetVal();
            if (retVal == null) {
                throw new AvLookupItemNotFoundException("No Item Found.");
            }
            if (retVal instanceof AvException) {
                throw (AvException)((Object)retVal);
            }
            return retVal;
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to run Rule: com.ngnms.common.AvLookupRule");
        }
    }

    private static String getValueFromString(String pQuery, String pStr) throws AvLookupItemNotFoundException, AvException {
        if (null == lookupAVPV) {
            throw new AvLookupItemNotFoundException("No *.ini fils loaded");
        }
        String retVal = null;
        OWAVPVector sectionDataAVPV = (OWAVPVector)lookupAVPV.get(pQuery);
        AvTrace.traceln("AvLookup", 3, "AvLookup.getValueFromString [" + pQuery + "]");
        if (null != sectionDataAVPV) {
            Enumeration e = sectionDataAVPV.elements();
            while (e.hasMoreElements()) {
                OWAttributeValuePair sectionDataValuePair = (OWAttributeValuePair)e.nextElement();
                String key = sectionDataValuePair.getAttributeName();
                if (!AvLookup.compareWildcard(pStr, key, WILDCARD)) continue;
                retVal = (String)sectionDataValuePair.getValue();
                AvTrace.traceln("AvLookup", 3, "AvLookup.getValueFromString " + pStr + " = " + retVal);
                if (retVal == null) {
                    throw new AvLookupItemNotFoundException("No " + pStr + " found in [" + pQuery + "].");
                }
                break;
            }
        } else {
            throw new AvLookupItemNotFoundException("The Section [" + pQuery + "] - Not Found.");
        }
        return retVal;
    }

    private static String getValueFromParamX(String pQuery, NetworkResource pNR, String pSubKey) throws AvLookupItemNotFoundException, AvException {
        if (null == lookupAVPV) {
            throw new AvLookupItemNotFoundException("No *.ini fils loaded");
        }
        String retVal = null;
        OWAVPVector sectionDataAVPV = (OWAVPVector)lookupAVPV.get(pQuery);
        AvTrace.traceln("AvLookup", 3, "AvLookup.getValueFromParamX [" + pQuery + "]");
        if (sectionDataAVPV != null) {
            String lookupKey = AvLookup.createKeyFromParamX(sectionDataAVPV, pNR, pQuery, pSubKey);
            AvTrace.traceln("AvLookup", 2, "AvLookup.getValueFromParamX - KeyFromNR = " + lookupKey);
            Enumeration e = sectionDataAVPV.elements();
            while (e.hasMoreElements()) {
                OWAttributeValuePair sectionDataValuePair = (OWAttributeValuePair)e.nextElement();
                String key = sectionDataValuePair.getAttributeName();
                if (!AvLookup.compareWildcard(lookupKey, key, WILDCARD)) continue;
                retVal = (String)sectionDataValuePair.getValue();
                AvTrace.traceln("AvLookup", 3, "AvLookup.getValueFromParamX " + lookupKey + " = " + retVal);
                break;
            }
            if (retVal == null) {
                throw new AvLookupItemNotFoundException("Key " + lookupKey + " - Not Found.");
            }
        } else {
            throw new AvLookupItemNotFoundException(pQuery + " - Not Found.");
        }
        return retVal;
    }

    private static String createKeyFromParamX(OWAVPVector pSectionDataAVPV, NetworkResource pNR, String pQuery, String pSubKey) throws AvLookupItemNotFoundException, AvException {
        String retVal;
        block23: {
            String value;
            AvTrace.traceln("AvLookup", 2, "AvLookup.getValueFromParamX.createKeyFromParamX - pQuery = " + pQuery + ", pSubKey = " + pSubKey);
            retVal = null;
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable<String, String> values = new Hashtable<String, String>();
            for (int j = 0; j < pSectionDataAVPV.size(); ++j) {
                OWAttributeValuePair sectionDataValuePair = pSectionDataAVPV.get(j);
                String key = sectionDataValuePair.getAttributeName();
                value = (String)sectionDataValuePair.getValue();
                if (key.startsWith("Param")) {
                    params.put(key, value);
                    continue;
                }
                values.put(key, value);
            }
            if (params.size() > 0) {
                try {
                    Object device = null;
                    Object topLevelDevice = null;
                    int i = 0;
                    value = null;
                    while ((value = (String)params.get("Param" + ++i)) != null) {
                        String parameterValue = null;
                        if (value.equals(MO_CLASS_NAME)) {
                            parameterValue = pNR.getClass().getName();
                        } else if (value.equals(DEVICE_CLASS_NAME)) {
                            if (device == null) {
                                device = AvMOUtil.getAvEquipmentOrAvDeviceFromMO(pNR, false);
                            }
                            parameterValue = device.getClass().getName();
                        } else if (value.equals(TOP_LEVEL_DEVICE_CLASS_NAME)) {
                            if (topLevelDevice == null) {
                                topLevelDevice = AvMOUtil.getTopLevelDeviceFromMO(pNR);
                            }
                            parameterValue = topLevelDevice.getClass().getName();
                        } else if (value.equals(SUB_KEY)) {
                            if (pSubKey != null && pSubKey.length() > 0) {
                                parameterValue = pSubKey;
                            }
                        } else if (value.startsWith(TOP_LEVEL)) {
                            if (topLevelDevice == null) {
                                topLevelDevice = AvMOUtil.getTopLevelDeviceFromMO(pNR);
                            }
                            parameterValue = AvLookup.getParameterValue((NetworkResource)topLevelDevice, value.substring(TOP_LEVEL.length()));
                        } else {
                            if (device == null) {
                                device = AvMOUtil.getAvEquipmentOrAvDeviceFromMO(pNR, false);
                            }
                            parameterValue = AvLookup.getParameterValue((NetworkResource)device, value);
                        }
                        AvTrace.traceln("AvLookup", 2, "AvLookup.getValueFromParamX.createKeyFromParamX - Param" + i + ": " + value + " = " + parameterValue);
                        if (retVal == null) {
                            retVal = parameterValue;
                            continue;
                        }
                        retVal = retVal + "+" + parameterValue;
                    }
                    if (i == 1) {
                        throw new AvException("There is no \"Param#\" in " + pQuery);
                    }
                    break block23;
                }
                catch (Exception e) {
                    throw new AvException(e, "Failed to create Keys From Param(#) and Network Resource");
                }
            }
            throw new AvException("There is no \"Param#\" keys in " + pQuery);
        }
        AvTrace.traceln("AvLookup", 2, "AvLookup.getValueFromParamX.createKeyFromParamX = " + retVal);
        return retVal;
    }

    private static String getParameterValue(NetworkResource pDevice, String pPath) throws AvException {
        String retVal = null;
        StringTokenizer stringTokenizer = new StringTokenizer(pPath, ".");
        int depth = stringTokenizer.countTokens();
        if (depth == 0) {
            throw new AvException("Invalid Parameter Path String: parameterPath = " + pPath);
        }
        NetworkResource owBean = pDevice;
        while (stringTokenizer.hasMoreTokens()) {
            String propertyName = stringTokenizer.nextToken();
            Object property = null;
            try {
                property = owBean.readProperty(propertyName);
            }
            catch (Exception ex) {
                AvTrace.traceln("AvLookup", 1, "AvLookup.getValueFromParamX.createKeyFromParamX.getParameterValue - " + propertyName + " is NULL");
            }
            if (property == null) {
                retVal = "";
                continue;
            }
            if (property instanceof OWBean) {
                owBean = (OWBean)property;
                if (stringTokenizer.hasMoreTokens()) continue;
                throw new AvException("Invalid Parameter: The " + pPath + " is too Short.");
            }
            if (stringTokenizer.hasMoreTokens()) {
                throw new AvException("Invalid Parameter: The " + pPath + " is too Long.");
            }
            if (property instanceof OWVector || property instanceof OWHashtable || property instanceof OWSet) {
                throw new AvException("Not supported Property Type. Property : " + propertyName + " Type of: " + property.getClass().getName());
            }
            try {
                if (property instanceof Serializable && propertyName.startsWith("AvLeaf_")) {
                    retVal = ((AvSnmpLeaf)property).getDataAsString();
                    continue;
                }
                if (property instanceof IOWIntrinsic) {
                    retVal = ((IOWIntrinsic)property).getJavaWrapperType().toString();
                    continue;
                }
                retVal = property.toString();
            }
            catch (Exception ex) {
                throw new AvException(ex, "Failed to Parse Property: " + propertyName + " Form " + owBean.getClass().getName());
            }
        }
        return retVal;
    }

    public static void load(IOWBOMClient pBOM) throws AvException {
        try {
            IniFileFilter iniFileFilter = new IniFileFilter();
            lookupAVPV = new TreeMap();
            String owareRoot = System.getenv("OWARE_USER_ROOT");
            File deploymentRoot = new File(owareRoot, "owareapps");
            File[] modules = deploymentRoot.listFiles();
            for (int i = 0; i < modules.length; ++i) {
                if (!modules[i].isDirectory()) continue;
                File[] moduleFiles = modules[i].listFiles(iniFileFilter);
                for (int j = 0; j < moduleFiles.length; ++j) {
                    String iniFilePath = moduleFiles[j].getAbsolutePath();
                    AvTrace.traceln("AvLookup", 1, iniFilePath);
                    AvTrace.traceln("AvLookup", 1, "----------------------------------------");
                    AvLookup.loadFile(iniFilePath);
                }
            }
        }
        catch (Exception ex) {
            throw new AvException(ex, "Failed to load ini files.");
        }
    }

    private static void loadFile(String pFilePath) throws AvException {
        try {
            AvIniReader iniReader = new AvIniReader(pFilePath);
            OWAVPVector keysAndValsAVPV = null;
            Iterator iterator = iniReader.lines();
            while (iterator.hasNext()) {
                String value;
                String key;
                String line = (String)iterator.next();
                if (line.startsWith("[") && line.endsWith("]")) {
                    String sectionName = line.substring(1, line.length() - 1);
                    keysAndValsAVPV = (OWAVPVector)lookupAVPV.get(sectionName);
                    if (null == keysAndValsAVPV) {
                        keysAndValsAVPV = new OWAVPVector();
                        lookupAVPV.put(sectionName, keysAndValsAVPV);
                    }
                    AvTrace.traceln("AvLookup", 2, "[" + sectionName + "]");
                    continue;
                }
                if (keysAndValsAVPV == null) {
                    throw new Exception("Invalid line: " + line);
                }
                int signIndex = line.indexOf(61);
                if (signIndex > -1) {
                    key = line.substring(0, signIndex);
                    value = line.substring(signIndex + 1, line.length());
                } else {
                    key = line;
                    value = "";
                }
                OWAttributeValuePair sectionDataValuePair = keysAndValsAVPV.firstElementWith(key);
                if (sectionDataValuePair == null) {
                    keysAndValsAVPV.add(new OWAttributeValuePair(key.trim(), (Object)value.trim()));
                    AvTrace.traceln("AvLookup", 2, key + " = " + value);
                    continue;
                }
                AvTrace.traceln("AvLookup", 2, key + " - Already Exist.");
            }
        }
        catch (FileNotFoundException e) {
            AvTrace.traceln("AvLookup", 1, "File \"" + pFilePath + "\" not found.");
            throw new AvException(e, "File \"" + pFilePath + "\" not found.");
        }
        catch (IOException e) {
            AvTrace.traceln("AvLookup", 1, "Failed to read from File \"" + pFilePath + "\".");
            throw new AvException(e, "Failed to read from File \"" + pFilePath + "\".");
        }
        catch (Exception e) {
            AvTrace.traceln("AvLookup", 1, "Failed to load File: \"" + pFilePath + "\".");
            throw new AvException(e, "Failed to load File: \"" + pFilePath + "\".");
        }
    }

    private static void traceLookup() {
        AvTrace.traceln("AvLookup");
        AvTrace.traceln("AvLookup", 2, "_________________________________________________");
        AvTrace.traceln("AvLookup");
        AvTrace.traceln("AvLookup", 2, "All Lookup ...");
        for (String sectionName : lookupAVPV.keySet()) {
            OWAVPVector keysAndValsAVPV = (OWAVPVector)lookupAVPV.get(sectionName);
            AvTrace.traceln("AvLookup", 3, "[" + sectionName + "]");
            Enumeration ee = keysAndValsAVPV.elements();
            while (ee.hasMoreElements()) {
                OWAttributeValuePair sectionDataValuePair = (OWAttributeValuePair)ee.nextElement();
                String key = sectionDataValuePair.getAttributeName();
                String value = (String)sectionDataValuePair.getValue();
                AvTrace.traceln("AvLookup", 3, "{" + key + "}={" + value + "}");
            }
        }
    }

    private static boolean compareWildcard(String pStr, String pWildcardStr, String pDelimiter) {
        String sourceStr = new String(pStr);
        boolean retVal = true;
        Vector tokens = AvLookup.getTokensVector(pWildcardStr, pDelimiter, true);
        boolean pastDelimiter = false;
        Enumeration e = tokens.elements();
        while (e.hasMoreElements()) {
            String str = (String)e.nextElement();
            if (str.equals(pDelimiter)) {
                pastDelimiter = true;
                continue;
            }
            if (pastDelimiter) {
                int strPos = sourceStr.indexOf(str);
                if (strPos == -1) {
                    return false;
                }
                if (strPos > sourceStr.length()) {
                    return false;
                }
                sourceStr = sourceStr.substring(strPos);
            }
            if (str.length() > sourceStr.length()) {
                return false;
            }
            if (!sourceStr.substring(0, str.length()).equals(str)) {
                return false;
            }
            sourceStr = sourceStr.substring(str.length());
            pastDelimiter = false;
        }
        if (sourceStr.length() > 0 && !pastDelimiter) {
            return false;
        }
        return retVal;
    }

    public static Vector getTokensVector(String pWildcardStr, String pDelimiter, boolean pRerurnDelimiter) {
        Vector<String> retVal = new Vector<String>();
        boolean done = false;
        String wildcardStr = new String(pWildcardStr);
        while (!done) {
            int wildcardPos = wildcardStr.indexOf(pDelimiter);
            if (wildcardPos == -1) {
                if (wildcardStr != null && wildcardStr.length() > 0) {
                    retVal.add(wildcardStr);
                }
                done = true;
                continue;
            }
            String str = wildcardStr.substring(0, wildcardPos);
            retVal.add(str);
            if (pRerurnDelimiter) {
                retVal.add(pDelimiter);
            }
            wildcardStr = wildcardStr.substring(wildcardPos + pDelimiter.length());
        }
        return retVal;
    }

    private static class IniFileFilter
    implements FileFilter {
        private IniFileFilter() {
        }

        public boolean accept(File file) {
            return !file.isDirectory() && file.getName().endsWith(".ini");
        }
    }
}

