/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import com.ngnms.common.AvTrace;
import com.ngnms.common.AvUtil;
import java.io.InputStream;

public final class AvIpConfigCmdOutput {
    private InputStream outStream;
    private String os;

    public AvIpConfigCmdOutput() {
        this.getIPConfigCommandOutput();
    }

    public InputStream getDataInputStream() {
        return this.outStream;
    }

    public String getOS() {
        return this.os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getIPConfigCommandOutput() {
        Process ipcProc = null;
        try {
            ipcProc = Runtime.getRuntime().exec("ipconfig.exe /all");
            this.os = "Windows";
        }
        catch (Exception e) {
            try {
                String hostId = AvUtil.getIPHostName();
                if (hostId == null) {
                    hostId = AvUtil.getIPHostAddress();
                }
                if (hostId != null) {
                    AvTrace.traceln("AvLS", 1, "Host Id : " + hostId);
                    String command = "/usr/sbin/arp -a | grep " + hostId;
                    AvTrace.traceln("AvLS", 1, "command is : " + command);
                    ipcProc = Runtime.getRuntime().exec(command);
                    this.os = "Unix";
                }
            }
            catch (Exception x) {
                AvTrace.traceln("AvLS", 3, "Failed to execute ipconfig and ifconfig commands");
            }
        }
        finally {
            this.outStream = ipcProc != null ? ipcProc.getInputStream() : null;
        }
    }
}

