/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class AvIniWriter {
    private String fileName = null;
    private Vector fileBufferVector = null;
    private boolean autoUpdate = true;
    private boolean gapBetweenSections = true;

    public AvIniWriter(String newFileName) throws NullPointerException, FileNotFoundException, IOException {
        this.fileName = newFileName;
        this.FillFileBuffer();
    }

    public AvIniWriter(String newFileName, boolean newAutoUpdate) throws NullPointerException, FileNotFoundException, IOException {
        this(newFileName);
        this.autoUpdate = newAutoUpdate;
    }

    private void FillFileBuffer() throws NullPointerException, IOException {
        try {
            BufferedReader bufferedReader = null;
            String line = null;
            if (this.fileName == null) {
                throw new NullPointerException("Ini file name can't ne null");
            }
            if (this.fileBufferVector == null) {
                this.fileBufferVector = new Vector();
            }
            bufferedReader = new BufferedReader(new FileReader(this.fileName));
            this.fileBufferVector.removeAllElements();
            int lines = 0;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.length() > 0) {
                    this.fileBufferVector.add(line.trim());
                }
                ++lines;
            }
        }
        catch (FileNotFoundException e) {
            new BufferedWriter(new FileWriter(this.fileName));
        }
    }

    public void UpdateFile() throws NullPointerException, FileNotFoundException, IOException, SecurityException {
        BufferedWriter bufferedWriter = null;
        if (this.fileName == null) {
            throw new NullPointerException("Ini file name can't ne null");
        }
        if (this.fileBufferVector != null && !this.fileBufferVector.isEmpty()) {
            bufferedWriter = new BufferedWriter(new FileWriter(this.fileName));
            int lines = 0;
            Enumeration e = this.fileBufferVector.elements();
            while (e.hasMoreElements()) {
                String line = (String)e.nextElement();
                if (line == null || line.length() == 0) continue;
                if (this.isGapBetweenSections() && line.startsWith("[") && line.endsWith("]")) {
                    bufferedWriter.write("\r\n");
                }
                bufferedWriter.write(line + "\r\n");
                ++lines;
            }
            bufferedWriter.flush();
        }
    }

    public void setValue(String section, String key, String value) throws NullPointerException, FileNotFoundException, IOException, SecurityException {
        if (section == null) {
            throw new NullPointerException("section can't ne null");
        }
        if (key == null) {
            throw new NullPointerException("key can't ne null");
        }
        int index = this.getKeyIndex(section, key, true);
        if (index >= 0) {
            this.setValue(key, value, index);
            if (this.isAutoUpdate()) {
                this.UpdateFile();
            }
        }
    }

    private void setValue(String key, String value, int index) {
        this.fileBufferVector.setElementAt(key + "=" + value, index);
    }

    public boolean isSectionExist(String section) {
        return this.getSectionIndex(section, false) >= 0;
    }

    public boolean isKeyExist(String section, String key) {
        return this.getKeyIndex(section, key, false) >= 0;
    }

    private int getSectionIndex(String section, boolean forceExistance) {
        for (int i = 0; i < this.fileBufferVector.size(); ++i) {
            String line = (String)this.fileBufferVector.elementAt(i);
            if (!line.equals("[" + section + "]")) continue;
            return i;
        }
        if (forceExistance) {
            this.fileBufferVector.addElement("[" + section + "]");
            return this.fileBufferVector.size() - 1;
        }
        return -1;
    }

    private int getKeyIndex(String section, String key, boolean forceExistance) {
        String line;
        int sectionIndex = this.getSectionIndex(section, forceExistance);
        int keyIndex = -1;
        if (sectionIndex < 0) {
            return -1;
        }
        for (keyIndex = sectionIndex + 1; !(keyIndex >= this.fileBufferVector.size() || (line = (String)this.fileBufferVector.elementAt(keyIndex)).startsWith("[") && line.endsWith("]")); ++keyIndex) {
            int index = line.indexOf("=");
            String tempKey = line.substring(0, index > -1 ? index : 0);
            if (!tempKey.equals(key)) continue;
            return keyIndex;
        }
        if (forceExistance) {
            this.fileBufferVector.insertElementAt(key + "=", keyIndex);
            return keyIndex;
        }
        return -1;
    }

    public void setAutoUpdate(boolean newAutoUpdate) {
        this.autoUpdate = newAutoUpdate;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setGapBetweenSections(boolean newGapBetweenSections) {
        this.gapBetweenSections = newGapBetweenSections;
    }

    public boolean isGapBetweenSections() {
        return this.gapBetweenSections;
    }

    public void createSection(String section) {
        this.getSectionIndex(section, true);
    }

    public void deleteKey(String section, String key) throws NullPointerException, FileNotFoundException, IOException, SecurityException {
        int keyIndex = this.getKeyIndex(section, key, false);
        if (keyIndex >= 0) {
            this.fileBufferVector.removeElementAt(keyIndex);
        }
        if (this.isAutoUpdate()) {
            this.UpdateFile();
        }
    }

    public void deleteKeyOnMatchValue(String section, String key, String value) throws NullPointerException, FileNotFoundException, IOException, SecurityException {
        String actualValue = this.getKeyValue(section, key);
        if (actualValue != null && actualValue.equals(value)) {
            this.deleteKey(section, key);
        }
    }

    public String getKeyValue(String section, String key) {
        int keyIndex = this.getKeyIndex(section, key, false);
        if (keyIndex >= 0) {
            String line = (String)this.fileBufferVector.elementAt(keyIndex);
            int pos = line.indexOf(61);
            String value = line.substring(pos + 1);
            return value;
        }
        return null;
    }

    public void deleteAllSections() throws NullPointerException, FileNotFoundException, IOException {
        Enumeration theEnum = this.getSections().elements();
        while (theEnum.hasMoreElements()) {
            this.deleteSection((String)theEnum.nextElement());
        }
    }

    public void deleteSection(String section) throws NullPointerException, FileNotFoundException, IOException {
        int sectionIndex = this.getSectionIndex(section, false);
        if (sectionIndex >= 0) {
            String line;
            for (int i = sectionIndex; !(i >= this.fileBufferVector.size() || (line = (String)this.fileBufferVector.elementAt(i)).startsWith("[") && line.endsWith("]") && sectionIndex != i); ++i) {
                this.fileBufferVector.setElementAt("", i);
            }
            if (this.isAutoUpdate()) {
                this.UpdateFile();
            }
        }
    }

    public Vector getSections() {
        Vector<String> retVal = new Vector<String>();
        for (int i = 0; i < this.fileBufferVector.size(); ++i) {
            String line = ((String)this.fileBufferVector.elementAt(i)).trim();
            if (!line.startsWith("[") || !line.endsWith("]")) continue;
            retVal.add(line.substring(1, line.length() - 1));
        }
        return retVal;
    }

    public String toString() {
        String retVal = "";
        for (int i = 0; i < this.fileBufferVector.size(); ++i) {
            retVal = retVal + this.fileBufferVector.elementAt(i) + "\n";
        }
        return retVal;
    }
}

