/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class AvIniReader {
    private String fileName = null;

    public AvIniReader(String newFileName) {
        this.fileName = newFileName;
    }

    private String readLine(BufferedReader pBufferedReader) throws IOException {
        int index;
        String line = pBufferedReader.readLine();
        if (line != null && (index = (line = line.trim()).indexOf("#")) >= 0) {
            line = line.substring(0, index).trim();
        }
        return line;
    }

    public Vector getKeysLines(String sectionName) throws NullPointerException, FileNotFoundException, IOException {
        BufferedReader bufferedReader = null;
        String line = null;
        Vector<String> retVal = new Vector<String>();
        if (this.fileName == null) {
            throw new NullPointerException("Ini file name can't ne null");
        }
        if (sectionName == null) {
            throw new NullPointerException("Section name can't ne null");
        }
        bufferedReader = new BufferedReader(new FileReader(this.fileName));
        boolean done = false;
        while (!done && (line = this.readLine(bufferedReader)) != null) {
            if (!line.equalsIgnoreCase("[" + sectionName + "]")) continue;
            done = true;
        }
        if (!done) {
            return null;
        }
        done = false;
        while (!done && (line = this.readLine(bufferedReader)) != null) {
            if (line.startsWith("[")) {
                done = true;
                continue;
            }
            retVal.add(line);
        }
        return retVal;
    }

    private String getCleanLine(String line) {
        StringBuffer sBuffer = new StringBuffer(line);
        this.removeCharFromString(sBuffer, ' ');
        this.removeCharFromString(sBuffer, '\t');
        return sBuffer.toString();
    }

    private StringBuffer removeCharFromString(StringBuffer buffer, char c) {
        for (int i = 0; i < buffer.length(); ++i) {
            if (buffer.charAt(i) != c) continue;
            buffer = buffer.deleteCharAt(i);
        }
        return buffer;
    }

    public Vector getSections(boolean includeBrackets) throws NullPointerException, FileNotFoundException, IOException {
        BufferedReader bufferedReader = null;
        String line = null;
        Vector<String> retVal = new Vector<String>();
        if (this.fileName == null) {
            throw new NullPointerException("Ini file name can't ne null");
        }
        bufferedReader = new BufferedReader(new FileReader(this.fileName));
        while ((line = this.readLine(bufferedReader)) != null) {
            if (!line.startsWith("[") || !line.endsWith("]")) continue;
            if (includeBrackets) {
                retVal.add(line);
                continue;
            }
            retVal.add(line.substring(1, line.length() - 1));
        }
        return retVal;
    }

    public Vector getSections() throws NullPointerException, FileNotFoundException, IOException {
        return this.getSections(false);
    }

    public boolean isSectionExist(String sectionName) throws NullPointerException, FileNotFoundException, IOException {
        Vector sections = this.getSections();
        for (int i = 0; i < sections.size(); ++i) {
            if (!((String)sections.elementAt(i)).equals("[" + sectionName + "]")) continue;
            return true;
        }
        return false;
    }

    public Vector getKeys(String sectionName) throws NullPointerException, FileNotFoundException, IOException {
        Vector lines = this.getKeysLines(sectionName);
        String key = null;
        if (lines == null) {
            return null;
        }
        for (int i = 0; i < lines.size(); ++i) {
            key = (String)lines.elementAt(i);
            int signIndex = key.indexOf(61);
            if (signIndex > -1) {
                lines.setElementAt(key.substring(0, signIndex), i);
                continue;
            }
            if (key.length() <= 0) continue;
            lines.setElementAt(key, i);
        }
        return lines;
    }

    public String getValue(String sectionName, String keyName) throws NullPointerException, FileNotFoundException, IOException {
        Vector lines = this.getKeysLines(sectionName);
        String value = null;
        String line = null;
        String key = null;
        if (lines == null) {
            return null;
        }
        for (int i = 0; value == null && i < lines.size(); ++i) {
            line = (String)lines.elementAt(i);
            int signIndex = line.indexOf(61);
            if (signIndex <= -1 || !(key = line.substring(0, signIndex)).equals(keyName)) continue;
            value = line.substring(signIndex + 1, line.length());
        }
        return value;
    }

    public Hashtable getSectionData(String section) throws NullPointerException, FileNotFoundException, IOException {
        Vector keys = this.getKeys(section);
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (keys != null && keys.size() > 0) {
            for (int i = 0; i < keys.size(); ++i) {
                String key = (String)keys.elementAt(i);
                String value = this.getValue(section, key);
                if (value == null || key == null) continue;
                table.put(key, value);
            }
        }
        return table;
    }

    public Hashtable getSectionModifiedData(String section) throws NullPointerException, FileNotFoundException, IOException {
        Vector keys = this.getKeys(section);
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (keys != null && keys.size() > 0) {
            for (int i = 0; i < keys.size(); ++i) {
                String key = (String)keys.elementAt(i);
                String value = this.getValue(section, key);
                if (key == null || value == null) continue;
                if (value.length() != 0) {
                    table.put(key, value);
                    continue;
                }
                table.put(key, key);
            }
        }
        return table;
    }

    public Iterator lines() throws NullPointerException, FileNotFoundException, IOException {
        return new AvLinesIterator();
    }

    public Hashtable mapToHashTableOfHashtables() throws NullPointerException, FileNotFoundException, IOException, Exception {
        Hashtable sections = new Hashtable();
        Hashtable<String, String> sectionData = null;
        String line = null;
        Iterator iterator = this.lines();
        while (iterator.hasNext()) {
            String value;
            String key;
            line = (String)iterator.next();
            if (line.startsWith("[") && line.endsWith("]")) {
                String sectionName = line.substring(1, line.length() - 1);
                sectionData = new Hashtable<String, String>();
                sections.put(sectionName, sectionData);
                continue;
            }
            if (sectionData == null) {
                throw new Exception("Invalid line: " + line);
            }
            int signIndex = line.indexOf(61);
            if (signIndex > -1) {
                key = line.substring(0, signIndex);
                value = line.substring(signIndex + 1, line.length());
            } else {
                key = line;
                value = "";
            }
            sectionData.put(key, value);
        }
        return sections;
    }

    class AvLinesIterator
    implements Iterator {
        BufferedReader bufferedReader = null;
        String line = null;

        public AvLinesIterator() throws NullPointerException, FileNotFoundException, IOException {
            if (AvIniReader.this.fileName == null || AvIniReader.this.fileName.length() == 0) {
                throw new NullPointerException("File Name is Empty.");
            }
            this.bufferedReader = new BufferedReader(new FileReader(AvIniReader.this.fileName));
            this.line = this.readLineInt();
        }

        private String readLineInt() throws IOException {
            String retLine = null;
            while ((retLine = AvIniReader.this.readLine(this.bufferedReader)) != null && retLine.length() == 0) {
            }
            return retLine;
        }

        public boolean hasNext() {
            return this.line != null;
        }

        public Object next() throws NoSuchElementException {
            if (this.line == null) {
                throw new NoSuchElementException();
            }
            String retVal = this.line;
            try {
                this.line = this.readLineInt();
            }
            catch (IOException e) {
                throw new NoSuchElementException("Failed read line due to IOException: " + e.getMessage());
            }
            return retVal;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

