/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import RedCell.Config.GenericMOUpdateRuleParamSet;
import RedCell.Config.NetworkResourceIPLookup;
import RedCell.RCUpdateBeanRuleParamSet;
import RedCell.RCUpdateBeansRuleParamSet;
import com.dorado.common.collections.OWAVPVector;
import com.dorado.common.utility.OWOID;
import com.dorado.common.utility.OWStringUtility;
import com.dorado.common.widget.components.OWFCParentPanel;
import com.dorado.common.widget.components.OWPanel;
import com.dorado.common.widget.components.OWSplitPaneContainer;
import com.dorado.common.widget.components.OWTabPanelContainer;
import com.dorado.common.widget.components.OWTabbedPaneContainer;
import com.dorado.common.widget.components.explorer.IOWExplorerNode;
import com.dorado.common.widget.components.explorer.IOWExplorerNodeContainer;
import com.dorado.common.widget.components.explorer.IOWExplorerWidget;
import com.dorado.common.widget.components.explorer.OWExplorerNode;
import com.dorado.common.widget.components.explorer.OWExplorerNodeContainer;
import com.dorado.common.widget.components.formlauncher.IOWFormLauncher;
import com.dorado.common.widget.components.interfaces.IOWGButton;
import com.dorado.common.widget.components.interfaces.IOWGCheckBox;
import com.dorado.common.widget.components.interfaces.IOWGComponent;
import com.dorado.common.widget.components.interfaces.IOWGDataWidget;
import com.dorado.common.widget.components.interfaces.IOWGDateSelect;
import com.dorado.common.widget.components.interfaces.IOWGIPTextField;
import com.dorado.common.widget.components.interfaces.IOWGLabel;
import com.dorado.common.widget.components.interfaces.IOWGNumberTextField;
import com.dorado.common.widget.components.interfaces.IOWGPanel;
import com.dorado.common.widget.components.interfaces.IOWGPathSelect;
import com.dorado.common.widget.components.interfaces.IOWGSpinner;
import com.dorado.common.widget.components.interfaces.IOWGSplitPane;
import com.dorado.common.widget.components.interfaces.IOWGTabbedPane;
import com.dorado.common.widget.components.interfaces.IOWGTabbedPanel;
import com.dorado.common.widget.components.interfaces.IOWGTextField;
import com.dorado.common.widget.components.interfaces.IOWGTimeSelect;
import com.dorado.core.mediation.snmp.OWSNMPRuntimeException;
import com.dorado.core.mediation.snmp.OWSnmpTxlateUtility;
import com.dorado.core.servlet.OWWebBuilderPanel;
import com.dorado.core.servlet.OWWebSplitPane;
import com.dorado.core.servlet.OWWebTabbedPane;
import com.dorado.core.servlet.OWWebTabbedPanel;
import com.dorado.redcell.inventory.base.RCFilterPanelDataNPC;
import com.dorado.redcell.inventory.base.RCSaveFilterParamSet;
import com.dorado.redcell.inventory.base.commandhandler.RCRuleStatus;
import com.dorado.runtime.OWBaseVector;
import com.dorado.runtime.OWEvent;
import com.dorado.runtime.OWSet;
import com.dorado.runtime.OWVector;
import com.ngnms.common.AvBeanProxy;
import com.ngnms.common.AvClientInternationalizer;
import com.ngnms.common.AvDeviceLicenseMapBase;
import com.ngnms.common.AvException;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvWorkSpace;
import com.ngnms.security.AvSecurityUtil;
import com.ngnms.services.common.AvServiceUtil;
import java.awt.Component;
import java.awt.Window;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import redcell.common.interfaces.IRCOptionPaneListener;
import redcell.common.util.RCBeanProxy;
import redcell.common.util.RCBeanProxyUtil;
import redcell.common.util.RCOptionPaneUtil;
import redcell.common.util.RCQueryBlock;
import redcell.common.util.RedCellHelpUtil;
import redcell.common.util.RedCellRuleEngineUtil;
import redcell.common.util.RedCellRuntimeUtil;
import redcell.common.util.RedCellWorkSpaceUtil;
import redcell.core.usersys.RCUserUtil;

public class AvEmsUtil {
    public static final String FORM_MENU = "FormMenu";
    public static final String FORM_PANEL = "FormPanel";
    public static final String FORM_TABBED_PANE = "FormTabbedPane";
    public static final String CURRENT_MO = "CurrentMO";
    public static final String CURRENT_MO_OID = "OWOIDCurrentMO";
    public static final String PARENT_MO = "ParentMO";
    public static final String PARENT_MO_OID = "OWOIDParentMO";
    public static final String ADDING_NEW = "AddingNew";
    public static final String DEVICE_LIST = "DeviceList";
    public static final String PRODUCTLINE_NAME = "ProductLineName";
    public static final String DEVICES_LISTBOX = "DevicesListbox";
    public static final String FUNC_CONFIGMULTIPLEEQUIP = "Av:ConfigureMultipleEquipment";
    public static final String FUNC_SOFTWAREUPGRADE = "Av:SoftwareUpdrade";
    public static final String FUNC_DISCOVERY = "Av:DeviceDiscovery";
    public static final String FUNC_RESYNC = "Av:DeviceResync";
    public static final String FUNC_PMCOLLECTION = "Av:PmDataCollection";
    public static final String NOT_APPLICABLE_STR = "255";
    public static final String WHITE_SPACES_STRING = "     ";
    public static final String NOT_AV_DEVICE = "NotAvDevice";
    public static final String NOT_SAME_PRODUCT_LINE = "NotTheSameProductLine";
    public static final String THE_SAME_PRODUCT_LINE = "TheSameProductLine";
    public static final String NOT_DISCOVERED_DEVICE = "NotDiscoveredDevice";
    public static final String ERROR = "Error";
    public static final String HELP_DEFAULT = "NgnmsGeneralHelp";
    public static final String ATTRIB_HELP_TOPIC = "ngnms.HelpTopic";
    public static final String NOT_SELECTED = "ComboBox_NotSelected";
    private static SimpleDateFormat WIDGET_DATETIME_FORMAT = new SimpleDateFormat("M/d/yyyy h:m:s a");
    private static SimpleDateFormat WIDGET_DATE_FORMAT = new SimpleDateFormat("M/d/yyyy");
    private static SimpleDateFormat WIDGET_TIME_FORMAT = new SimpleDateFormat("h:m:s a");
    private static Hashtable internationalizers = new Hashtable();

    public static long roundToMinutes(long pCrtTime, long pMinutes) {
        long interval = pMinutes * 60L * 1000L;
        if (pMinutes > 59L) {
            AvTrace.traceln("AvEms", 3, "Wrong input parameters");
            return 0L;
        }
        Calendar cal = Calendar.getInstance();
        long zoneOffset = cal.get(15);
        double crtZoneTime = pCrtTime + zoneOffset;
        long newZoneTime = Math.round(crtZoneTime / (double)interval) * interval;
        long newTime = newZoneTime - zoneOffset;
        return newTime;
    }

    public static String getPeriodOfTimeString(long pPeriodOfTime, String pBundleFile) {
        AvClientInternationalizer internationalizer = AvEmsUtil.getInternationalizer(pBundleFile);
        return AvEmsUtil.getPeriodOfTimeString(pPeriodOfTime, internationalizer);
    }

    public static String getPeriodOfTimeString(long pPeriodOfTime, AvClientInternationalizer pInternationalizer) {
        long minutes;
        long hours;
        if (pPeriodOfTime <= 0L) {
            return "";
        }
        long tempPoriodLong = pPeriodOfTime;
        long days = tempPoriodLong / 86400000L;
        if (days > 0L) {
            tempPoriodLong %= 86400000L;
        }
        if ((hours = tempPoriodLong / 3600000L) > 0L) {
            tempPoriodLong %= 3600000L;
        }
        if ((minutes = tempPoriodLong / 60000L) > 0L) {
            tempPoriodLong %= 60000L;
        }
        long seconds = tempPoriodLong / 1000L;
        String retVal = "";
        if (days > 0L) {
            retVal = retVal + days + " " + pInternationalizer.translateText(days == 1L ? "Day" : "Days");
        }
        if (hours > 0L || retVal.length() > 0) {
            if (retVal.length() > 0) {
                retVal = retVal + ", ";
            }
            retVal = retVal + hours + " " + pInternationalizer.translateText(hours == 1L ? "Hour" : "Hours");
        }
        if (minutes > 0L || retVal.length() > 0) {
            if (retVal.length() > 0) {
                retVal = retVal + ", ";
            }
            retVal = retVal + minutes + " " + pInternationalizer.translateText(minutes == 1L ? "Minute" : "Minutes");
        }
        if (seconds > 0L || retVal.length() > 0) {
            if (retVal.length() > 0) {
                retVal = retVal + ", ";
            }
            retVal = retVal + seconds + " " + pInternationalizer.translateText(seconds == 1L ? "Second" : "Seconds");
        }
        return retVal;
    }

    public static OWOID saveEquipment(RCBeanProxy pEquipmentProxy, boolean pIsLocationChanged) {
        RCUpdateBeanRuleParamSet _ps;
        OWOID ret = null;
        try {
            if (pIsLocationChanged) {
                OWVector objGroups = AvSecurityUtil.getOWObjectGroups((RCBeanProxy)pEquipmentProxy.get("Location"));
                pEquipmentProxy.setRCObjectGroups(objGroups);
            }
            _ps = new RCUpdateBeanRuleParamSet();
            _ps.setRCBeanProxy((Serializable)pEquipmentProxy);
            RedCellRuleEngineUtil.callRule((String)"RedCell.RCUpdateBeanRule", (OWEvent)_ps);
            if (!_ps.getSuccess()) {
                AvTrace.traceln("AvEms", 2, "Problem saving mo and key: " + _ps.getMessage());
            } else {
                ret = _ps.getOutHandle();
            }
        }
        catch (Exception _e) {
            AvTrace.traceStack("AvEms", 1, _e);
            return null;
        }
        _ps = new GenericMOUpdateRuleParamSet();
        _ps.setMOKey((String)((RCBeanProxy)pEquipmentProxy.get("Key")).get("Key"));
        RedCellRuleEngineUtil.callRule((String)"RedCell.Config.GenericMOUpdateRule", (OWEvent)_ps);
        return ret;
    }

    public static boolean updateEquipmentProxyList(Vector pEquipmentList, RCBeanProxy pNewLocation) {
        try {
            OWVector objGroups = AvSecurityUtil.getOWObjectGroups(pNewLocation);
            for (RCBeanProxy equip : pEquipmentList) {
                equip.setRCObjectGroups(objGroups);
            }
            RCUpdateBeansRuleParamSet _ps = new RCUpdateBeansRuleParamSet();
            _ps.setRCBeanProxys((Serializable)pEquipmentList);
            RedCellRuleEngineUtil.callRule((String)"RedCell.RCUpdateBeansRule", (OWEvent)_ps);
            if (!_ps.getSuccess()) {
                AvTrace.traceln("AvEms", 2, "Problem saving mo and key: " + _ps.getMessage());
                return false;
            }
        }
        catch (Exception _e) {
            AvTrace.traceStack("AvEms", 1, _e);
            return false;
        }
        return true;
    }

    public static void closeOptionPane(OWFCParentPanel pOptionPane) {
        RCOptionPaneUtil.closeOptionPane((OWFCParentPanel)pOptionPane);
    }

    public static AvClientInternationalizer getInternationalizer(String pBundleFile) {
        AvClientInternationalizer internationalizer = (AvClientInternationalizer)internationalizers.get(pBundleFile);
        if (internationalizer == null) {
            internationalizer = new AvClientInternationalizer(pBundleFile);
            internationalizers.put(pBundleFile, internationalizer);
        }
        return internationalizer;
    }

    public static OWFCParentPanel showConfirmDialog(IOWFormLauncher pFormLauncher, IRCOptionPaneListener pListener, String pMessage, String pHeading, String pBundleFile) {
        return AvEmsUtil.showConfirmDialog(pFormLauncher, pListener, pMessage, pHeading, AvEmsUtil.getInternationalizer(pBundleFile));
    }

    public static OWFCParentPanel showConfirmDialog(IOWFormLauncher pFormLauncher, IRCOptionPaneListener pListener, String pMessage, String pHeading, AvClientInternationalizer pInternationalizer) {
        return RCOptionPaneUtil.showConfirmDialog((IOWFormLauncher)pFormLauncher, (IRCOptionPaneListener)pListener, (String)pInternationalizer.translateText(pMessage), (String)pInternationalizer.translateText(pHeading));
    }

    public static OWFCParentPanel showConfirmDialog(IOWFormLauncher pFormLauncher, IRCOptionPaneListener pListener, String[] pMessage, String pHeading, AvClientInternationalizer pInternationalizer) {
        StringBuffer _message = new StringBuffer("");
        if (pMessage.length > 0) {
            _message.append(pInternationalizer.translateText(pMessage[0]));
            for (int i = 1; i < pMessage.length; ++i) {
                _message.append("\n");
                _message.append(pInternationalizer.translateText(pMessage[i]));
            }
        }
        return RCOptionPaneUtil.showConfirmDialog((IOWFormLauncher)pFormLauncher, (IRCOptionPaneListener)pListener, (String)pInternationalizer.translateText(_message.toString()), (String)pInternationalizer.translateText(pHeading));
    }

    public static OWFCParentPanel showConfirmDialog(IOWFormLauncher pFormLauncher, IRCOptionPaneListener pListener, String pMessage, String[] pParams, String pHeading, AvClientInternationalizer pInternationalizer) {
        return RCOptionPaneUtil.showConfirmDialog((IOWFormLauncher)pFormLauncher, (IRCOptionPaneListener)pListener, (String)pInternationalizer.translateText(pMessage, pParams), (String)pInternationalizer.translateText(pHeading));
    }

    public static int showConfirmDialog(IOWFormLauncher pFormLauncher, int pFormType, String pMessage, String[] pParams, String pHeading, AvClientInternationalizer pInternationalizer) {
        return AvEmsUtil.showConfirmDialog(pFormLauncher, pFormType, pInternationalizer.translateText(pMessage, pParams), pHeading, pInternationalizer);
    }

    public static int showConfirmDialog(IOWFormLauncher pFormLauncher, int pFormType, String[] pMessage, String pHeading, AvClientInternationalizer pInternationalizer) {
        String message = new String();
        if (pMessage.length > 0) {
            message = pInternationalizer.translateText(pMessage[0]);
            for (int i = 1; i < pMessage.length; ++i) {
                message = message + "\n" + pInternationalizer.translateText(pMessage[i]);
            }
        }
        return AvEmsUtil.showConfirmDialog(pFormLauncher, pFormType, message, pHeading, pInternationalizer);
    }

    public static int showConfirmDialog(IOWFormLauncher pFormLauncher, int pFormType, String pMessage, String pHeading, AvClientInternationalizer pInternationalizer) {
        final int formType = pFormType;
        final Hashtable retValueHolder = new Hashtable();
        IRCOptionPaneListener optionPaneListener = new IRCOptionPaneListener(){

            public void optionPaneButtonClicked(int pButton) {
                retValueHolder.put("ButtonPressed", "" + pButton);
            }

            public int getFormType() {
                return formType;
            }
        };
        AvEmsUtil.showConfirmDialog(pFormLauncher, optionPaneListener, pMessage, pHeading, pInternationalizer);
        String buttonPressedStr = (String)retValueHolder.get("ButtonPressed");
        if (buttonPressedStr == null) {
            return 3;
        }
        return Integer.parseInt(buttonPressedStr);
    }

    public static OWFCParentPanel showWarningMessage(IOWFormLauncher pFormLauncher, IRCOptionPaneListener pListener, String pMessage, String pHeading, String pBundleFile) {
        return AvEmsUtil.showWarningMessage(pFormLauncher, pListener, pMessage, pHeading, AvEmsUtil.getInternationalizer(pBundleFile));
    }

    public static OWFCParentPanel showWarningMessage(IOWFormLauncher pFormLauncher, IRCOptionPaneListener pListener, String pMessage, String pHeading, AvClientInternationalizer pInternationalizer) {
        return RCOptionPaneUtil.showWarningMessage((IOWFormLauncher)pFormLauncher, (IRCOptionPaneListener)pListener, (String)pInternationalizer.translateText(pMessage), (String)pInternationalizer.translateText(pHeading));
    }

    public static OWFCParentPanel showWarningMessage(IOWFormLauncher pFormLauncher, IRCOptionPaneListener pListener, String pMessage, String[] pParams, String pHeading, String pBundleFile) {
        return AvEmsUtil.showWarningMessage(pFormLauncher, pListener, pMessage, pParams, pHeading, AvEmsUtil.getInternationalizer(pBundleFile));
    }

    public static OWFCParentPanel showWarningMessage(IOWFormLauncher pFormLauncher, IRCOptionPaneListener pListener, String pMessage, String[] pParams, String pHeading, AvClientInternationalizer pInternationalizer) {
        try {
            return RCOptionPaneUtil.showWarningMessage((IOWFormLauncher)pFormLauncher, (IRCOptionPaneListener)pListener, (String)pInternationalizer.translateText(pMessage, pParams), (String)pInternationalizer.translateText(pHeading));
        }
        catch (Exception _e) {
            return RCOptionPaneUtil.showWarningMessage((IOWFormLauncher)pFormLauncher, (IRCOptionPaneListener)pListener, (String)pMessage, (String)pHeading);
        }
    }

    public static OWFCParentPanel showWarningMessage(IOWFormLauncher pFormLauncher, IRCOptionPaneListener pListener, String pMessage, String pHeading, String[] pHeadingParams, AvClientInternationalizer pInternationalizer) {
        try {
            return RCOptionPaneUtil.showWarningMessage((IOWFormLauncher)pFormLauncher, (IRCOptionPaneListener)pListener, (String)pInternationalizer.translateText(pMessage), (String)pInternationalizer.translateText(pHeading, pHeadingParams));
        }
        catch (Exception e) {
            return RCOptionPaneUtil.showWarningMessage((IOWFormLauncher)pFormLauncher, (IRCOptionPaneListener)pListener, (String)pMessage, (String)pHeading);
        }
    }

    public static OWFCParentPanel showWarningMessage(IOWFormLauncher pFormLauncher, IRCOptionPaneListener pListener, String pMessage, String[] pMessageParams, String pHeading, String[] pHeadingParams, AvClientInternationalizer pInternationalizer) {
        try {
            return RCOptionPaneUtil.showWarningMessage((IOWFormLauncher)pFormLauncher, (IRCOptionPaneListener)pListener, (String)pInternationalizer.translateText(pMessage, pMessageParams), (String)pInternationalizer.translateText(pHeading, pHeadingParams));
        }
        catch (Exception e) {
            return RCOptionPaneUtil.showWarningMessage((IOWFormLauncher)pFormLauncher, (IRCOptionPaneListener)pListener, (String)pMessage, (String)pHeading);
        }
    }

    public static OWFCParentPanel showInformationMessage(IOWFormLauncher pFormLauncher, IRCOptionPaneListener pListener, String pMessage, String pHeading, String pBundleFile) {
        return AvEmsUtil.showInformationMessage(pFormLauncher, pListener, pMessage, pHeading, AvEmsUtil.getInternationalizer(pBundleFile));
    }

    public static OWFCParentPanel showInformationMessage(IOWFormLauncher pFormLauncher, IRCOptionPaneListener pListener, String pMessage, String pHeading, AvClientInternationalizer pInternationalizer) {
        return RCOptionPaneUtil.showInformationMessage((IOWFormLauncher)pFormLauncher, (IRCOptionPaneListener)pListener, (String)pInternationalizer.translateText(pMessage), (String)pInternationalizer.translateText(pHeading));
    }

    public static boolean isIPFormat(String str) {
        try {
            AvEmsUtil.getIPTokens(str);
        }
        catch (AvException ave) {
            AvTrace.traceln("AvEms", 2, ave.getMessage());
            return false;
        }
        return true;
    }

    public static boolean isIPSubnetMaskFormat(String str) {
        try {
            int[] tokens = AvEmsUtil.getIPTokens(str);
            boolean bZeroFound = false;
            int oneCount = 0;
            for (int i = 0; i < tokens.length; ++i) {
                int value = tokens[i];
                for (int k = 128; k > 0; k /= 2) {
                    boolean bSet;
                    boolean bl = bSet = 0 != (value & k);
                    if (bSet) {
                        if (bZeroFound) {
                            throw new AvException("Not a Subnet Mask - Format Error at Byte " + (1 + i));
                        }
                        ++oneCount;
                        continue;
                    }
                    bZeroFound = true;
                }
            }
            if (oneCount < 1) {
                throw new AvException("Not a Subnet Mask - Not class A, B or C Subnet.");
            }
        }
        catch (AvException ave) {
            AvTrace.traceln("AvEms", 2, ave.getMessage());
            return false;
        }
        return true;
    }

    private static int[] getIPTokens(String str) throws AvException {
        AvTrace.traceln("AvEms", 3, "Process IP String: " + str);
        if (str.endsWith(".")) {
            throw new AvException("IP Address ends with .");
        }
        String newStr = OWStringUtility.stripCharFromString((String)str, (char)' ');
        String[] tokens = OWStringUtility.splitString((String)newStr, (String)".");
        if (tokens.length != 4 && tokens.length != 6) {
            AvTrace.traceln("AvEms", 3, "Wrong number of tokens = " + tokens.length);
            throw new AvException("Wrong Number of tokens: " + tokens.length);
        }
        int[] _result = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (!OWStringUtility.isNumeric((String)token)) {
                throw new AvException("Token is not numeric: " + token);
            }
            int value = Integer.parseInt(token);
            if (value < 0 || value > 255) {
                throw new AvException("Wrong token value: " + value);
            }
            _result[i] = value;
        }
        return _result;
    }

    public static boolean isPhonePadDigits(String str) {
        if (OWStringUtility.isNumeric((String)str)) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == 'A' || str.charAt(i) == 'a' || str.charAt(i) == 'B' || str.charAt(i) == 'b' || str.charAt(i) == 'C' || str.charAt(i) == 'c' || str.charAt(i) == 'D' || str.charAt(i) == 'd' || str.charAt(i) == '#' || str.charAt(i) == '*' || Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void addEmptyNodeToDataWidget(IOWGDataWidget pWidget) throws AvException {
        IOWExplorerNodeContainer _n = pWidget.getNodeContainerByNodeAttribValue(pWidget.getRoot(), NOT_APPLICABLE_STR, 2);
        if (_n != null) {
            if (_n.getNode().getText().trim().equals("")) {
                _n.getNode().setText(WHITE_SPACES_STRING);
                pWidget.nodeChanged(_n);
                pWidget.setCellHeightSpacing(pWidget.getCellHeightSpacing() + 1);
                pWidget.setSelectedNode(_n.getNode());
            }
        } else {
            try {
                _n = (IOWExplorerNodeContainer)((IOWExplorerNodeContainer)pWidget.getRoot().getChildren().elementAt(0)).clone();
                _n.getNode().setText(WHITE_SPACES_STRING);
                _n.getNode().setValue(NOT_APPLICABLE_STR);
                AvTrace.traceln("AvEms", 1, "New Empty Node StyleName = " + _n.getNode().getStyleID());
                pWidget.insertNode(pWidget.getRoot(), _n, 0);
                pWidget.setCellHeightSpacing(pWidget.getCellHeightSpacing() + 1);
                pWidget.refresh();
                pWidget.setSelectedNode(_n.getNode());
            }
            catch (Exception e) {
                throw new AvException(e, "Failed to add Empty Node !");
            }
        }
    }

    public static IOWExplorerNodeContainer getNodeContainerByValue(IOWGDataWidget pDataWidget, String pValue) {
        return pDataWidget.getNodeContainerByNodeAttribValue(pDataWidget.getRoot(), pValue, 2);
    }

    public static IOWExplorerNodeContainer getNodeContainerByName(IOWGDataWidget pDataWidget, String pName) {
        return pDataWidget.getNodeContainerByNodeAttribValue(pDataWidget.getRoot(), pName, 1);
    }

    public static void selectNodeByValue(IOWGDataWidget pDataWidget, String pValue) throws NullPointerException {
        if (pDataWidget == null) {
            throw new NullPointerException("pDataWidget (IOWGDataWidget) is NULL !!!");
        }
        String oldValue = pDataWidget.getSelectedValue();
        AvTrace.traceln("AvEms", 1, "In selectNodeByValue for " + pDataWidget.getName() + " - Old Val = " + oldValue + ", New Val = " + pValue);
        if (oldValue != null && oldValue.equals(pValue)) {
            return;
        }
        IOWExplorerNodeContainer node = pDataWidget.getNodeContainerByNodeAttribValue(pDataWidget.getRoot(), pValue, 2);
        if (node == null) {
            throw new NullPointerException(pValue + " - Not Found in IOWGDataWidget " + pDataWidget.getName());
        }
        pDataWidget.setSelectedNode(node.getNode());
    }

    public static void fillComboBox(Vector pValuesSet, String pSelectedValue, IOWGDataWidget pComboBox, Vector pDisplayStringsSet) {
        try {
            AvTrace.traceln("AvEms", 1, "in fillComboBox");
            if (pValuesSet.size() == 0 || pDisplayStringsSet.size() == 0) {
                AvTrace.traceln("AvEms", 1, "Wrong parameters");
                return;
            }
            OWExplorerNodeContainer root = (OWExplorerNodeContainer)pComboBox.getRoot();
            root.removeAll();
            for (int i = 0; i < pDisplayStringsSet.size(); ++i) {
                String displayString = (String)pDisplayStringsSet.elementAt(i);
                String value = (String)pValuesSet.elementAt(i);
                OWExplorerNode cell = new OWExplorerNode();
                cell.setText(displayString);
                cell.setValue(value);
                root.add((IOWExplorerNodeContainer)new OWExplorerNodeContainer((IOWExplorerNode)cell));
                AvTrace.traceln("AvEms", 1, "String = " + displayString + ", Value = " + value);
            }
            pComboBox.setCellHeightSpacing(Math.min(12, root.getChildren().size()));
            pComboBox.refresh();
            if (pSelectedValue != null && pSelectedValue.length() > 0) {
                AvEmsUtil.selectNodeByValue(pComboBox, pSelectedValue);
            }
        }
        catch (Exception e) {
            AvTrace.traceStack("AvEms", 1, e);
        }
    }

    public static OWAVPVector getMIBKeywords(String pProductLine) {
        AvTrace.traceln("AvCS", 3, "getKeywordsFromMIB for ProductLine: " + pProductLine);
        AvWorkSpace wrkSpc = null;
        try {
            wrkSpc = AvWorkSpace.getAndLockWorkSpace("AvSMS_WorkSpace", AvServiceUtil.getWorkSpaceTimeout());
            OWAVPVector map = (OWAVPVector)wrkSpc.getObject("AttributeToLeafMap");
            wrkSpc.closeWorkSpace();
            OWAVPVector productMap = (OWAVPVector)map.firstValueWith(pProductLine);
            if (productMap != null) {
                return (OWAVPVector)productMap.firstValueWith("Keywords");
            }
            return null;
        }
        catch (AvException e) {
            try {
                wrkSpc.closeWorkSpace();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static Vector getMIBPrefixes(String pProductLine) {
        AvTrace.traceln("AvCS", 3, "getPrefixesFromMIB for ProductLine: " + pProductLine);
        AvWorkSpace wrkSpc = null;
        try {
            wrkSpc = AvWorkSpace.getAndLockWorkSpace("AvSMS_WorkSpace", AvServiceUtil.getWorkSpaceTimeout());
            OWAVPVector map = (OWAVPVector)wrkSpc.getObject("AttributeToLeafMap");
            wrkSpc.closeWorkSpace();
            OWAVPVector productMap = (OWAVPVector)map.firstValueWith(pProductLine);
            if (productMap != null) {
                return (Vector)productMap.firstValueWith("Prefixes");
            }
            return null;
        }
        catch (AvException e) {
            try {
                wrkSpc.closeWorkSpace();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static String getAttrNameFromMIB(Vector pPrefixes, OWAVPVector pKeys, String pAttributeName) {
        String newName;
        String attrName = OWStringUtility.replaceStringWithString((String)"AvLeaf_", (String)"", (String)pAttributeName);
        if (pPrefixes != null) {
            for (int i = 0; i < pPrefixes.size(); ++i) {
                String newName2 = (String)pPrefixes.get(i) + attrName;
                try {
                    String oid = OWSnmpTxlateUtility.mapNameToOid((String)newName2);
                    if (oid != null && !oid.equals("")) {
                        return newName2;
                    }
                    continue;
                }
                catch (OWSNMPRuntimeException e) {
                    // empty catch block
                }
            }
        }
        if (pKeys != null && (newName = (String)pKeys.firstValueWith(attrName)) != null) {
            return newName;
        }
        return attrName;
    }

    public static String checkProductLine(OWOID[] pDevices, String pProductLine) throws AvException {
        try {
            for (int i = 0; i < pDevices.length; ++i) {
                AvBeanProxy deviceProxy = new AvBeanProxy(pDevices[i]);
                if (!deviceProxy.isInstanceOf("com.ngnms.common.AvDevice")) {
                    return NOT_AV_DEVICE;
                }
                if (i == 0 && pProductLine.equals("")) {
                    pProductLine = deviceProxy.getAsString(PRODUCTLINE_NAME);
                }
                if (!deviceProxy.getAsString(PRODUCTLINE_NAME).equals(pProductLine)) {
                    return NOT_SAME_PRODUCT_LINE;
                }
                if (!deviceProxy.getAsString("Model").startsWith("Undiscovered")) continue;
                return NOT_DISCOVERED_DEVICE;
            }
            return THE_SAME_PRODUCT_LINE;
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to Check Product Line.");
        }
    }

    public static String checkServicesProductLine(OWOID[] pServices, String pProductLine) throws AvException {
        String productLine = pProductLine;
        if (!productLine.equals("")) {
            productLine = productLine.toLowerCase();
        }
        AvTrace.traceln("AvEms", 3, "AvEmsUtil: check Services Product Line for [" + productLine + "]");
        String serviceProductLine = "";
        try {
            for (int i = 0; i < pServices.length; ++i) {
                AvBeanProxy service = new AvBeanProxy(pServices[i], 0);
                String[] tokens = OWStringUtility.splitString((String)service.getClassName(), (String)".");
                for (int j = 0; j < tokens.length; ++j) {
                    if (!tokens[j].equals("products")) continue;
                    try {
                        serviceProductLine = tokens[j + 1];
                        AvTrace.traceln("AvEms", 3, "AvEmsUtil: the Service Product Line = [" + serviceProductLine + "]");
                        break;
                    }
                    catch (Exception e) {
                        return NOT_AV_DEVICE;
                    }
                }
                if (serviceProductLine.equals("")) {
                    return NOT_AV_DEVICE;
                }
                if (i == 0 && productLine.equals("")) {
                    productLine = serviceProductLine.toLowerCase();
                }
                if (serviceProductLine.toLowerCase().equals(productLine)) continue;
                return NOT_SAME_PRODUCT_LINE;
            }
            return THE_SAME_PRODUCT_LINE;
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to Check Service Product Line.");
        }
    }

    public static boolean checkStringIsInIntegerRange(String str, int minValue, int maxValue) {
        int intValue = Integer.parseInt(str);
        return intValue >= minValue && intValue <= maxValue;
    }

    public static boolean checkStringIsInLongRange(String str, long minValue, long maxValue) {
        long longValue = Long.parseLong(str);
        return longValue >= minValue && longValue <= maxValue;
    }

    public static boolean checkStringIsInDoubleRange(String str, double minValue, double maxValue) {
        double dblValue = Double.parseDouble(str);
        return dblValue >= minValue && dblValue <= maxValue;
    }

    public static String updateOctetStringForSet(String pStrToUpdate) {
        AvTrace.traceln("AvEms", 1, "AvEmsUtil:  strToUpdate= [" + pStrToUpdate + "]");
        String str = OWStringUtility.stripCharFromString((String)pStrToUpdate, (char)' ');
        str = OWStringUtility.stripCharFromString((String)str, (char)'-');
        int numOfOctets = str.length() / 2;
        String strToSet = new String();
        AvTrace.traceln("AvEms", 1, "AvEmsUtil: numOfOctets = " + numOfOctets);
        for (int i = 0; i < numOfOctets; ++i) {
            strToSet = strToSet + str.substring(2 * i, 2 * i + 2) + ":";
        }
        strToSet = '\'' + strToSet.substring(0, strToSet.length() - 1) + '\'';
        AvTrace.traceln("AvEms", 1, "AvEmsUtil: strToSet = [" + strToSet + "]");
        return strToSet;
    }

    public static String updateOctetStringForRowInstance(String pStrToUpdate, boolean fixedLength) {
        String str = OWStringUtility.stripCharFromString((String)pStrToUpdate, (char)' ');
        str = OWStringUtility.stripCharFromString((String)str, (char)'-');
        AvTrace.traceln("AvEms", 3, "Input String :" + str);
        int numOfOctets = str.length() / 2;
        AvTrace.traceln("AvEms", 3, "Octet String length :" + numOfOctets);
        String rowInstance = new String();
        if (!fixedLength) {
            rowInstance = String.valueOf(numOfOctets);
        }
        for (int i = 0; i < numOfOctets; ++i) {
            int bb = Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16);
            rowInstance = rowInstance + Integer.toString(bb, 10) + ".";
        }
        rowInstance = rowInstance.substring(0, rowInstance.lastIndexOf("."));
        return rowInstance;
    }

    public static boolean isMacAddressFormat(String pStr) {
        String strMacAddress = OWStringUtility.stripCharFromString((String)pStr, (char)' ');
        strMacAddress = OWStringUtility.stripCharFromString((String)strMacAddress, (char)'-');
        boolean error = false;
        if (strMacAddress.length() != 12) {
            error = true;
        }
        if (!error && !strMacAddress.startsWith("00")) {
            error = true;
        }
        if (!error) {
            for (int i = 0; i < strMacAddress.length(); ++i) {
                char ch = strMacAddress.charAt(i);
                if (Character.digit(ch, 16) != -1) continue;
                error = true;
                break;
            }
        }
        return !error;
    }

    public static boolean testDeviceLicenseBit(String pLicenseBitmap, int[] pBitArray) {
        if (pBitArray == null || pLicenseBitmap == null || pLicenseBitmap.equals("") || pBitArray.length == 0) {
            return true;
        }
        String octetString = OWStringUtility.stripCharFromString((String)pLicenseBitmap, (char)' ');
        int length = octetString.length();
        for (int i = 0; i < pBitArray.length; ++i) {
            int bitNumber = pBitArray[i];
            BigInteger hexDigit = new BigInteger(String.valueOf(octetString.charAt(length - 1 - bitNumber / 4)), 16);
            if (!hexDigit.testBit(bitNumber % 4)) continue;
            AvTrace.traceln("AvEms", 3, "Device License: in LicenseBitmap {" + octetString + "} bit [" + bitNumber + "]=1.");
            return true;
        }
        return false;
    }

    public static void updateComponentsByLicense(Component[] pComps, String pDeviceLicenseMapClassName, String pDeviceLicenseBitmap) {
        if (pComps == null || pDeviceLicenseMapClassName == null || pDeviceLicenseMapClassName.equals("") || pDeviceLicenseBitmap == null || pDeviceLicenseBitmap.equals("")) {
            return;
        }
        AvDeviceLicenseMapBase deviceLicenseMap = null;
        String deviceLicenseBitmap = OWStringUtility.stripCharFromString((String)pDeviceLicenseBitmap, (char)' ');
        try {
            deviceLicenseMap = (AvDeviceLicenseMapBase)Class.forName(pDeviceLicenseMapClassName).getMethod("getInstance", new Class[0]).invoke(Class.forName(pDeviceLicenseMapClassName), new Object[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (deviceLicenseMap == null) {
            return;
        }
        for (int i = 0; i < pComps.length; ++i) {
            try {
                int[] bits;
                AvTrace.traceln("AvEms", 3, "In updateComponentsByLicense >>>> Processing " + pComps[i].getName() + "; Class = " + pComps[i].getClass().getName());
                String componentName = "";
                if (pComps[i] instanceof IOWGDataWidget || pComps[i] instanceof IOWExplorerWidget) {
                    int viewType = ((IOWExplorerWidget)pComps[i]).getViewType();
                    AvTrace.traceln("AvEms", 3, "In updateComponentsByLicense >>>> Process DataWidget " + pComps[i].getName() + "; viewType = " + viewType);
                    if (viewType == 5) {
                        componentName = OWStringUtility.replaceStringWithString((String)"Listbox", (String)"", (String)pComps[i].getName());
                    } else if (viewType == 7) {
                        componentName = OWStringUtility.replaceStringWithString((String)"ComboBox", (String)"", (String)pComps[i].getName());
                    } else if (viewType == 6) {
                        componentName = pComps[i].getName();
                    }
                }
                if (pComps[i] instanceof IOWGLabel) {
                    componentName = OWStringUtility.replaceStringWithString((String)"lbl", (String)"", (String)pComps[i].getName());
                }
                if (pComps[i] instanceof IOWGTextField) {
                    componentName = OWStringUtility.replaceStringWithString((String)"txt", (String)"", (String)pComps[i].getName());
                }
                if (pComps[i] instanceof IOWGPathSelect) {
                    componentName = OWStringUtility.replaceStringWithString((String)"PathSelect", (String)"", (String)pComps[i].getName());
                }
                if (pComps[i] instanceof IOWGButton) {
                    componentName = OWStringUtility.replaceStringWithString((String)"btn", (String)"", (String)pComps[i].getName());
                }
                if (pComps[i] instanceof IOWGIPTextField) {
                    componentName = OWStringUtility.replaceStringWithString((String)"txt", (String)"", (String)pComps[i].getName());
                }
                if (pComps[i] instanceof IOWGSpinner) {
                    componentName = OWStringUtility.replaceStringWithString((String)"Spinner", (String)"", (String)pComps[i].getName());
                }
                if (pComps[i] instanceof IOWGNumberTextField) {
                    componentName = OWStringUtility.replaceStringWithString((String)"numTxt", (String)"", (String)pComps[i].getName());
                }
                if (pComps[i] instanceof IOWGCheckBox) {
                    componentName = OWStringUtility.replaceStringWithString((String)"CheckBox", (String)"", (String)pComps[i].getName());
                }
                if (!componentName.equals("") && (bits = deviceLicenseMap.get(componentName)) != null) {
                    if (!AvEmsUtil.testDeviceLicenseBit(deviceLicenseBitmap, bits)) {
                        AvTrace.traceln("AvEms", 3, "In updateComponentsByLicense >>>> Disable " + componentName);
                        try {
                            ((IOWGComponent)pComps[i]).setEnabled(false);
                        }
                        catch (Exception e) {}
                    } else {
                        AvTrace.traceln("AvEms", 3, "In updateComponentsByLicense >>>> Enable " + componentName);
                        try {
                            ((IOWGComponent)pComps[i]).setEnabled(true);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (!(pComps[i] instanceof IOWGPanel)) continue;
                AvEmsUtil.updatePanelByLicense((IOWGPanel)pComps[i], pDeviceLicenseMapClassName, deviceLicenseBitmap);
                continue;
            }
            catch (Exception e) {
                AvTrace.traceStack("AvEms", 3, e);
            }
        }
    }

    public static void updateEntirePanelByLicense(IOWGPanel pPanel, boolean pDisable) {
        AvTrace.traceln("AvEms", 3, "Inside  updateEntirePanelByLicense >>>> " + pPanel.getName());
        try {
            Component[] _comps = new Component[]{};
            if (pPanel instanceof OWPanel) {
                _comps = ((OWPanel)pPanel).getComponents();
            } else if (pPanel instanceof OWWebBuilderPanel) {
                _comps = ((OWWebBuilderPanel)pPanel).getComponents();
            }
            if (pDisable) {
                for (int i = 0; i < _comps.length; ++i) {
                    try {
                        ((IOWGComponent)_comps[i]).setEnabled(false);
                        if (!(_comps[i] instanceof IOWGPanel)) continue;
                        AvEmsUtil.updateEntirePanelByLicense((IOWGPanel)_comps[i], pDisable);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            } else {
                for (int i = 0; i < _comps.length; ++i) {
                    try {
                        ((IOWGComponent)_comps[i]).setEnabled(true);
                        if (!(_comps[i] instanceof IOWGPanel)) continue;
                        AvEmsUtil.updateEntirePanelByLicense((IOWGPanel)_comps[i], pDisable);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updatePanelByLicense(IOWGPanel pPanel, String pDeviceLicenseMapClassName, String pDeviceLicenseBitmap) {
        AvTrace.traceln("AvEms", 3, "Inside  updatePanelByLicense >>>> ");
        if (pPanel == null || pDeviceLicenseMapClassName == null || pDeviceLicenseMapClassName.equals("") || pDeviceLicenseBitmap == null || pDeviceLicenseBitmap.equals("")) {
            return;
        }
        Component[] _comps = new Component[]{};
        try {
            AvDeviceLicenseMapBase deviceLicenseMap = null;
            try {
                deviceLicenseMap = (AvDeviceLicenseMapBase)Class.forName(pDeviceLicenseMapClassName).getMethod("getInstance", new Class[0]).invoke(Class.forName(pDeviceLicenseMapClassName), new Object[0]);
            }
            catch (Exception e) {
                AvTrace.traceln("AvEms", 3, "in updatePanelByLicense   >>>> Failed to get deviceLicenseMap ");
            }
            if (deviceLicenseMap == null) {
                return;
            }
            String deviceLicenseBitmap = OWStringUtility.stripCharFromString((String)pDeviceLicenseBitmap, (char)' ');
            String panelName = OWStringUtility.replaceStringWithString((String)"Panel", (String)"", (String)pPanel.getName());
            int[] bits = deviceLicenseMap.get(panelName);
            if (bits != null) {
                AvEmsUtil.updateEntirePanelByLicense(pPanel, !AvEmsUtil.testDeviceLicenseBit(deviceLicenseBitmap, bits));
            } else {
                if (pPanel instanceof OWPanel) {
                    _comps = ((OWPanel)pPanel).getComponents();
                } else if (pPanel instanceof OWWebBuilderPanel) {
                    _comps = ((OWWebBuilderPanel)pPanel).getComponents();
                }
                AvEmsUtil.updateComponentsByLicense(_comps, pDeviceLicenseMapClassName, deviceLicenseBitmap);
            }
        }
        catch (Exception _e) {
            AvTrace.traceStack(_e);
        }
    }

    public static void updateTabbedPaneByLicense(IOWGTabbedPane pTabbedPane, String pDeviceLicenseMapClassName, String pDeviceLicenseBitmap) {
        if (pTabbedPane == null || pDeviceLicenseMapClassName == null || pDeviceLicenseMapClassName.equals("") || pDeviceLicenseBitmap == null || pDeviceLicenseBitmap.equals("")) {
            return;
        }
        Component[] _comps = new Component[]{};
        if (pTabbedPane instanceof OWWebTabbedPane) {
            _comps = ((OWWebTabbedPane)pTabbedPane).getComponents();
        } else if (pTabbedPane instanceof OWTabbedPaneContainer) {
            _comps = ((OWTabbedPaneContainer)pTabbedPane).getComponents();
        }
        for (int i = 0; i < _comps.length; ++i) {
            if (!(_comps[i] instanceof IOWGTabbedPanel)) continue;
            if (_comps[i] instanceof OWTabPanelContainer) {
                AvEmsUtil.updateComponentsByLicense(((OWTabPanelContainer)_comps[i]).getComponents(), pDeviceLicenseMapClassName, pDeviceLicenseBitmap);
                continue;
            }
            if (!(_comps[i] instanceof OWWebTabbedPanel)) continue;
            AvEmsUtil.updateComponentsByLicense(((OWWebTabbedPanel)_comps[i]).getComponents(), pDeviceLicenseMapClassName, pDeviceLicenseBitmap);
        }
    }

    public static void updateTabPanelByLicense(IOWGTabbedPanel pTabPanel, String pDeviceLicenseMapClassName, String pDeviceLicenseBitmap) {
        if (pTabPanel == null || pDeviceLicenseMapClassName == null || pDeviceLicenseMapClassName.equals("") || pDeviceLicenseBitmap == null || pDeviceLicenseBitmap.equals("")) {
            return;
        }
        Component[] _comps = new Component[]{};
        if (pTabPanel instanceof OWTabPanelContainer) {
            _comps = ((OWTabPanelContainer)pTabPanel).getComponents();
        } else if (pTabPanel instanceof OWWebTabbedPanel) {
            _comps = ((OWWebTabbedPanel)pTabPanel).getComponents();
        }
        AvEmsUtil.updateComponentsByLicense(_comps, pDeviceLicenseMapClassName, pDeviceLicenseBitmap);
    }

    public static void setOctetString(IOWGTabbedPanel pTabPanel, String pDeviceLicenseMapClassName, String pDeviceLicenseBitmap) {
        if (pTabPanel == null || pDeviceLicenseMapClassName == null || pDeviceLicenseMapClassName.equals("") || pDeviceLicenseBitmap == null || pDeviceLicenseBitmap.equals("")) {
            return;
        }
        Component[] _comps = new Component[]{};
        if (pTabPanel instanceof OWTabPanelContainer) {
            _comps = ((OWTabPanelContainer)pTabPanel).getComponents();
        } else if (pTabPanel instanceof OWWebTabbedPanel) {
            _comps = ((OWWebTabbedPanel)pTabPanel).getComponents();
        }
        AvEmsUtil.updateComponentsByLicense(_comps, pDeviceLicenseMapClassName, pDeviceLicenseBitmap);
    }

    public static long getWidgetDateTime(IOWGDateSelect pDateSelect, IOWGTimeSelect pTimeSelect) {
        AvTrace.traceln("AvEms", 3, "In getWidgetDateTime");
        String dateString = pDateSelect.getDate();
        String timeString = pTimeSelect != null ? pTimeSelect.getTime() : "0:0:0 am";
        String fullDateString = dateString + " " + timeString;
        AvTrace.traceln("AvEms", 1, "DateTime string : " + fullDateString);
        try {
            Date retVal = WIDGET_DATETIME_FORMAT.parse(fullDateString);
            return retVal.getTime();
        }
        catch (Exception e) {
            AvTrace.traceStack("AvEms", 1, e);
            return 0L;
        }
    }

    public static void setWidgetDateTime(long pTime, IOWGDateSelect pDateSelect, IOWGTimeSelect pTimeSelect) {
        Date date = new Date(pTime);
        if (pDateSelect != null) {
            pDateSelect.setDate(WIDGET_DATE_FORMAT.format(date));
        }
        if (pTimeSelect != null) {
            pTimeSelect.setTime(WIDGET_TIME_FORMAT.format(date));
        }
    }

    public static void showHelp(IOWFormLauncher pFormLauncher, String pHelpTopic) {
        AvTrace.traceln("AvEms", 1, "Inside showHelp with id  [" + pHelpTopic + "]");
        try {
            RedCellHelpUtil.showHelp((Window)RedCellRuntimeUtil.getLaunchConsole(), (String)RedCellWorkSpaceUtil.getProperty((String)pHelpTopic, (String)HELP_DEFAULT));
        }
        catch (Exception _e) {
            AvTrace.traceStack("AvEms", 2, _e);
            IRCOptionPaneListener nullOptionPaneListener = new IRCOptionPaneListener(){

                public int getFormType() {
                    return 1;
                }

                public void optionPaneButtonClicked(int pButton) {
                }
            };
            AvEmsUtil.showWarningMessage(pFormLauncher, nullOptionPaneListener, "HelpNotAvailable", "Helpcouldnotbeshownduetoanerror", "AvCommonTitlesBundle");
        }
    }

    public static String toScreenIPAddress(String ipAddress) {
        return ipAddress.equals("0.0.0.0") ? "" : ipAddress;
    }

    public static String fromScreenIPAddress(String ipAddress) {
        return ipAddress.equals("") ? "0.0.0.0" : ipAddress;
    }

    public static String toScreenSubnetMask(String ipAddress) {
        return ipAddress.equals("255.255.255.255") ? "" : ipAddress;
    }

    public static String fromScreenSubnetMask(String ipAddress) {
        return ipAddress.equals("") ? "255.255.255.255" : ipAddress;
    }

    public static RCFilterPanelDataNPC createFilterPanelData(String pFilterPanelName, OWSet pValues) {
        try {
            RCFilterPanelDataNPC _fpd = new RCFilterPanelDataNPC();
            _fpd.setFilterPanelName(pFilterPanelName);
            _fpd.setValues(pValues);
            return _fpd;
        }
        catch (Exception e) {
            AvTrace.traceStack("AvEms", 1, e);
            return null;
        }
    }

    public static RCRuleStatus createManagerFilter(String pMngrName, String pFilterName, String pFilterTitle, OWBaseVector pFilterPanelData, String pOwner, String pRuleName, String pPermission, boolean pSetAsDefault) {
        AvTrace.traceln("AvEms", 3, "createManagerFilter: Manager = " + pMngrName + "; FilterName = " + pFilterName);
        RCRuleStatus _status = new RCRuleStatus();
        if (pFilterPanelData == null || pFilterPanelData.size() == 0) {
            try {
                _status.setSuccess(false);
                _status.setMessage("You must specify at least one attribute to filter by.");
            }
            catch (Exception e) {
                AvTrace.traceStack("AvEms", 3, e);
            }
            AvTrace.traceln("AvEms", 3, _status.getMessage());
            return _status;
        }
        RCQueryBlock qb = new RCQueryBlock("FilterName", (Object)pFilterName, "=");
        Vector _qbaTest = RCBeanProxyUtil.getProxysByAttrib((String)"com.dorado.redcell.inventory.base.RCFilterDef", (RCQueryBlock)qb, (boolean)false);
        if (_qbaTest != null && !_qbaTest.isEmpty()) {
            try {
                _status.setMessage("A Filter named " + pFilterName + " already exists.");
                _status.setSuccess(true);
            }
            catch (Exception e) {
                AvTrace.traceStack("AvEms", 3, e);
            }
            if (pSetAsDefault) {
                RCUserUtil.getCurrentUser().setUAttrValue(pMngrName + "_DEFAULT_FILTER", (Object)pFilterName);
                RCUserUtil.getCurrentUser().saveUAttrValues();
            }
            AvTrace.traceln("AvEms", 3, _status.getMessage());
            return _status;
        }
        RCSaveFilterParamSet _ps = new RCSaveFilterParamSet();
        _ps.setNew(true);
        _ps.setTitleMsgCat("");
        _ps.setTitleMsgNum(0);
        _ps.setTitle(pFilterTitle);
        _ps.setPermission(pPermission);
        _ps.setManagerName(pMngrName);
        _ps.setFilterName(pFilterName);
        _ps.setData(pFilterPanelData);
        _ps.setOwner(pOwner.equals("") ? "AV" : pOwner);
        _ps.setRuleName(pRuleName);
        RedCellRuleEngineUtil.callRule((String)"com.dorado.redcell.inventory.base.RCSaveFilter", (OWEvent)_ps);
        AvTrace.traceln("AvEms", 3, "Success  = " + _ps.getStatus().getSuccess() + "(" + _ps.getStatus().getMessage() + ")");
        if (pSetAsDefault && _ps.getStatus().getSuccess()) {
            RCUserUtil.getCurrentUser().setUAttrValue(pMngrName + "_DEFAULT_FILTER", (Object)pFilterName);
            RCUserUtil.getCurrentUser().saveUAttrValues();
        }
        return _ps.getStatus();
    }

    public static Vector findDevicesByName(String pName, String pDeviceClass, boolean pSubclasses) {
        Vector<RCQueryBlock> _qbks = new Vector<RCQueryBlock>(2);
        _qbks.addElement(new RCQueryBlock("Name", (Object)new String(pName), "="));
        _qbks.addElement(new RCQueryBlock("Model", (Object)new String("Undiscovered*"), "LIKE", "NOT"));
        return RCBeanProxyUtil.getProxysByAttrib((String)pDeviceClass, _qbks, (boolean)pSubclasses);
    }

    public static AvBeanProxy findSingleDeviceByName(String pName, String pDeviceClass, boolean pSubclasses) {
        try {
            AvBeanProxy device = new AvBeanProxy(pDeviceClass, 0);
            Vector<RCQueryBlock> blocks = new Vector<RCQueryBlock>(2);
            blocks.addElement(new RCQueryBlock("Name", (Object)new String(pName), "="));
            blocks.addElement(new RCQueryBlock("Model", (Object)new String("Undiscovered*"), "LIKE", "NOT"));
            Vector vec = RCBeanProxyUtil.getProxysByAttrib((String)pDeviceClass, blocks, (boolean)pSubclasses);
            if (vec != null && !vec.isEmpty()) {
                if (vec.size() > 1) {
                    AvTrace.traceln("AvEms", 2, "Multiple " + pDeviceClass + " devices with Name = " + pName);
                    device.setStatus("NonUniqueDeviceName");
                    return device;
                }
                RCBeanProxy devProxy = (RCBeanProxy)vec.firstElement();
                AvTrace.traceln("AvEms", 2, "Found  Device = " + devProxy.get("Name"));
                device = new AvBeanProxy(devProxy.getRCOID(), 0);
                device.setUseGetFromServer(true);
                device.setStatus("AvServices_RESPONSE_OK");
                return device;
            }
            AvTrace.traceln("AvEms", 2, "Cannot find any " + pDeviceClass + " device with Name = " + pName);
            device.setStatus("InvalidDevice");
            return device;
        }
        catch (Exception e) {
            AvTrace.traceStack("AvEms", 3, e);
            return null;
        }
    }

    public static Vector findDevicesByIPAddress(String pIPAddress, String pDeviceClass, boolean pSubclasses) {
        try {
            Vector vec = new Vector();
            if (!AvEmsUtil.isIPFormat(pIPAddress)) {
                AvTrace.traceln("AvEms", 2, "Invalid IP Address format = " + pIPAddress);
                return vec;
            }
            Vector ipLookup = new Vector();
            if (!pSubclasses) {
                Vector<RCQueryBlock> qBlocks = new Vector<RCQueryBlock>(2);
                qBlocks.addElement(new RCQueryBlock("IPAddress", (Object)new String(pIPAddress), "="));
                qBlocks.addElement(new RCQueryBlock("ClassName", (Object)new String(pDeviceClass), "=", "AND"));
                ipLookup = RCBeanProxyUtil.getProxysByAttrib((String)NetworkResourceIPLookup.class.getName(), qBlocks);
            } else {
                RCQueryBlock qb = new RCQueryBlock("IPAddress", (Object)new String(pIPAddress), "=");
                ipLookup = RCBeanProxyUtil.getProxysByAttrib((String)NetworkResourceIPLookup.class.getName(), (RCQueryBlock)qb);
            }
            if (ipLookup == null || ipLookup.isEmpty()) {
                AvTrace.traceln("AvEms", 2, "Unknown IP Address = " + pIPAddress);
                return vec;
            }
            Vector<String> keyValues = new Vector<String>();
            Enumeration objList = ipLookup.elements();
            while (objList.hasMoreElements()) {
                RCBeanProxy ipLookupProxy = (RCBeanProxy)objList.nextElement();
                keyValues.add(ipLookupProxy.getAsString("KeyValue"));
            }
            Vector<RCQueryBlock> qb = new Vector<RCQueryBlock>(2);
            qb.addElement(new RCQueryBlock("KeyValue", keyValues, "IN"));
            qb.addElement(new RCQueryBlock("Model", (Object)new String("Undiscovered*"), "LIKE", "NOT"));
            vec = RCBeanProxyUtil.getProxysByAttrib((String)pDeviceClass, qb, (boolean)pSubclasses);
            if (vec == null || vec.isEmpty()) {
                AvTrace.traceln("AvEms", 2, "Cannot find  " + pDeviceClass + " devices with NetworkResourceIPLookup = " + pIPAddress);
                return vec;
            }
            return vec;
        }
        catch (Exception e) {
            AvTrace.traceStack("AvEms", 3, e);
            return null;
        }
    }

    public static AvBeanProxy findSingleDeviceByIPAddress(String pIPAddress, String pDeviceClass, boolean pSubclasses) {
        try {
            AvBeanProxy device = new AvBeanProxy(pDeviceClass, 0);
            if (!AvEmsUtil.isIPFormat(pIPAddress)) {
                AvTrace.traceln("AvEms", 2, "Invalid IP Address format = " + pIPAddress);
                device.setStatus("InvalidDevice");
                return device;
            }
            Vector ipLookup = new Vector();
            if (!pSubclasses) {
                Vector<RCQueryBlock> qBlocks = new Vector<RCQueryBlock>(2);
                qBlocks.addElement(new RCQueryBlock("IPAddress", (Object)new String(pIPAddress), "="));
                qBlocks.addElement(new RCQueryBlock("ClassName", (Object)new String(pDeviceClass), "=", "AND"));
                ipLookup = RCBeanProxyUtil.getProxysByAttrib((String)NetworkResourceIPLookup.class.getName(), qBlocks);
            } else {
                RCQueryBlock qb = new RCQueryBlock("IPAddress", (Object)new String(pIPAddress), "=");
                ipLookup = RCBeanProxyUtil.getProxysByAttrib((String)NetworkResourceIPLookup.class.getName(), (RCQueryBlock)qb);
            }
            if (ipLookup == null || ipLookup.isEmpty()) {
                AvTrace.traceln("AvEms", 2, "Unknown IP Address = " + pIPAddress);
                device.setStatus("UnknownIPAddress");
                return device;
            }
            if (!pSubclasses && ipLookup.size() > 1) {
                AvTrace.traceln("AvEms", 2, "Multiple " + pDeviceClass + " devices with IPAddress = " + pIPAddress);
                device.setStatus("NonUniqueDeviceIPAddress");
                return device;
            }
            if (!pSubclasses) {
                try {
                    String keyValue = ((RCBeanProxy)ipLookup.firstElement()).getAsString("KeyValue");
                    Vector<RCQueryBlock> blocks = new Vector<RCQueryBlock>(2);
                    blocks.addElement(new RCQueryBlock("KeyValue", (Object)new String(keyValue), "="));
                    blocks.addElement(new RCQueryBlock("Model", (Object)new String("Undiscovered*"), "LIKE", "NOT"));
                    RCBeanProxy devProxy = (RCBeanProxy)RCBeanProxyUtil.getProxysByAttrib((String)pDeviceClass, blocks).firstElement();
                    AvTrace.traceln("AvEms", 2, "Found Device by IP (" + pIPAddress + ") = " + devProxy.get("Name"));
                    device = new AvBeanProxy(devProxy.getRCOID(), 0);
                    device.setUseGetFromServer(true);
                    device.setStatus("AvServices_RESPONSE_OK");
                    return device;
                }
                catch (Exception e) {
                    AvTrace.traceln("AvEms", 2, "Cannot find " + pDeviceClass + " device with NetworkResourceIPLookup = " + pIPAddress);
                    device.setStatus("InvalidDevice");
                    return device;
                }
            }
            Vector<String> keyValues = new Vector<String>();
            Enumeration objList = ipLookup.elements();
            while (objList.hasMoreElements()) {
                RCBeanProxy ipLookupProxy = (RCBeanProxy)objList.nextElement();
                keyValues.add(ipLookupProxy.getAsString("KeyValue"));
            }
            Vector<RCQueryBlock> queryBlks = new Vector<RCQueryBlock>(2);
            queryBlks.addElement(new RCQueryBlock("KeyValue", keyValues, "IN"));
            queryBlks.addElement(new RCQueryBlock("Model", (Object)new String("Undiscovered*"), "LIKE", "NOT"));
            Vector vec = RCBeanProxyUtil.getProxysByAttrib((String)pDeviceClass, queryBlks, (boolean)pSubclasses);
            if (vec == null || vec.isEmpty()) {
                AvTrace.traceln("AvEms", 2, "Cannot find subclasses of " + pDeviceClass + " with NetworkResourceIPLookup = " + pIPAddress);
                device.setStatus("InvalidDevice");
                return device;
            }
            if (vec.size() > 1) {
                AvTrace.traceln("AvEms", 2, "Multiple " + pDeviceClass + " devices with IPAddress = " + pIPAddress);
                device.setStatus("NonUniqueDeviceIPAddress");
                return device;
            }
            RCBeanProxy devProxy = (RCBeanProxy)vec.firstElement();
            AvTrace.traceln("AvEms", 2, "Found Device by IP (" + pIPAddress + ") = " + devProxy.get("Name"));
            device = new AvBeanProxy(devProxy.getRCOID(), 0);
            device.setUseGetFromServer(true);
            device.setStatus("AvServices_RESPONSE_OK");
            return device;
        }
        catch (Exception e) {
            AvTrace.traceStack("AvEms", 3, e);
            return null;
        }
    }

    public static AvBeanProxy findSingleDeviceByNameOrIPAddress(String pNameOrIPAddress, String pDeviceClass, boolean pSubclasses) {
        if (!AvEmsUtil.isIPFormat(pNameOrIPAddress)) {
            return AvEmsUtil.findSingleDeviceByName(pNameOrIPAddress, pDeviceClass, pSubclasses);
        }
        return AvEmsUtil.findSingleDeviceByIPAddress(pNameOrIPAddress, pDeviceClass, pSubclasses);
    }

    public static void setComponentsEnabled(IOWGComponent comp, boolean enabled) {
        Component[] _comps = null;
        if (comp instanceof IOWGPanel) {
            if (comp instanceof OWPanel) {
                _comps = ((OWPanel)comp).getComponents();
            } else if (comp instanceof OWWebBuilderPanel) {
                _comps = ((OWWebBuilderPanel)comp).getComponents();
            }
        } else if (comp instanceof IOWGSplitPane) {
            if (comp instanceof OWWebSplitPane) {
                _comps = ((OWWebSplitPane)comp).getComponents();
            } else if (comp instanceof OWSplitPaneContainer) {
                _comps = ((OWSplitPaneContainer)comp).getComponents();
            }
        } else if (comp instanceof IOWGTabbedPane) {
            if (comp instanceof OWWebTabbedPane) {
                _comps = ((OWWebTabbedPane)comp).getComponents();
            } else if (comp instanceof OWTabbedPaneContainer) {
                _comps = ((OWTabbedPaneContainer)comp).getComponents();
            }
        } else if (comp instanceof IOWGTabbedPanel) {
            if (comp instanceof OWTabPanelContainer) {
                _comps = ((OWTabPanelContainer)comp).getComponents();
            } else if (comp instanceof OWWebTabbedPanel) {
                _comps = ((OWWebTabbedPanel)comp).getComponents();
            }
        }
        if (_comps != null) {
            for (int i = 0; i < _comps.length; ++i) {
                AvEmsUtil.setComponentsEnabled((IOWGComponent)_comps[i], enabled);
            }
        } else {
            comp.setEnabled(enabled);
        }
    }
}

