/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import RedCell.Config.AlarmState;
import RedCell.Config.Contact;
import RedCell.Config.Equipment;
import RedCell.Config.GenericMODeleteRuleParamSet;
import RedCell.Config.Location;
import RedCell.Config.ManagementInterface;
import RedCell.Config.NetworkResource;
import RedCell.Config.NetworkResourceIPLookup;
import RedCell.Config.NetworkResourceKey;
import RedCell.Config.Role;
import RedCell.Config.Vendor;
import RedCell.GenericCreateBeanRuleParamSet;
import RedCell.Service.GetSMFRelationsParamSet;
import com.dorado.common.utility.OWAttributeValuePair;
import com.dorado.common.utility.OWOID;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.IOWBOMInternalUseMarker;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.bom.OWBOMQueryByKey;
import com.dorado.core.bom.OWBOMQueryByOWOID;
import com.dorado.core.ejb.ruleengine.IOWRuleEngineRuleInterface;
import com.dorado.oware.core.security.OWObjectGroup;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWBean;
import com.dorado.runtime.OWEvent;
import com.dorado.runtime.OWSet;
import com.dorado.runtime.OWVector;
import com.ngnms.common.AvBeanProxy;
import com.ngnms.common.AvCard;
import com.ngnms.common.AvDevice;
import com.ngnms.common.AvDeviceDescription;
import com.ngnms.common.AvEquipment;
import com.ngnms.common.AvException;
import com.ngnms.common.AvIniWriter;
import com.ngnms.common.AvLookup;
import com.ngnms.common.AvLookupItemNotFoundException;
import com.ngnms.common.AvPort;
import com.ngnms.common.AvPropDefs;
import com.ngnms.common.AvRoleOperateRuleParamSet;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvUtil;
import com.ngnms.common.AvWirelessLink;
import com.ngnms.common.AvWorkSpace;
import com.ngnms.common.IAvUpdateDeviceCommunity;
import com.ngnms.security.AvSecurityUtil;
import com.ngnms.services.common.AvMOUtil;
import com.ngnms.services.common.AvServiceUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import redcell.apps.config.managedobjects.RedCellRuntimeManagedObject;
import redcell.common.util.RCBOMUtil;
import redcell.common.util.RedCellRuleEngineUtil;
import redcell.core.security.RCBOMInternalUseMarker;
import redcell.core.security.RCObjectGroupUtility;

public abstract class AvDeviceUtil {
    public static final String DEVICE_UTIL_WS_NAME = "AvDeviceUtil_WorkSpace";
    public static final String MOM_INI_FILE_FULL_PATH = "AvMOMIniFileFullPath";
    public static final int MAX_COMMUNITY_STRING_LEN = 23;

    public static AvDevice getAvDevice(IOWBOMClient pBOM, OWOID pDeviceOWOID) throws AvException {
        AvDevice avDevice = null;
        try {
            avDevice = (AvDevice)RCBOMUtil.getOWObject((IOWBOMClient)pBOM, (OWOID)pDeviceOWOID);
        }
        catch (OWBOMNotFoundException not) {
            AvTrace.traceln("AvDeviceUtil", 3, "AvDeviceUtil.getAvDevice - AvDevice: " + pDeviceOWOID + " - Not Found.");
            avDevice = null;
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to Retrieve AvDevice.");
        }
        return avDevice;
    }

    private static void setDeviceStatusOnOff(IOWBOMClient pBOM, NetworkResource pDevice, boolean pIsOn) throws Exception {
        AvTrace.traceln("AvDeviceUtil", 3, "setDeviceStatusOnOff = pDevice Name" + pDevice.getName() + ", pIsOn = " + pIsOn);
        if (pIsOn) {
            AvMOUtil.getObjectForUpdate(pBOM, (IOWBean)pDevice);
            AvDeviceUtil.setDeviceIcon(pBOM, pDevice);
            pBOM.commitObject((IOWBean)pDevice);
        } else {
            String disconnectedDeviceIcon = null;
            try {
                AvTrace.traceln("AvDeviceUtil", 1, "Searching DisconnectedDeviceIcon for Device = " + pDevice.getName());
                disconnectedDeviceIcon = AvLookup.get("DisconnectedDeviceIcon", pDevice);
            }
            catch (AvLookupItemNotFoundException e) {
                AvTrace.traceln("AvDeviceUtil", 1, "WARNING: DisconnectedDeviceIcon NOT FOUND. Skipping");
                return;
            }
            AvTrace.traceln("AvDeviceUtil", 1, "disconnectedDeviceIcon = " + disconnectedDeviceIcon);
            if (disconnectedDeviceIcon != null && disconnectedDeviceIcon.length() > 0) {
                AvMOUtil.getObjectForUpdate(pBOM, (IOWBean)pDevice);
                pDevice.setIcon(disconnectedDeviceIcon);
                pBOM.commitObject((IOWBean)pDevice);
            }
        }
    }

    private static void setDeviceAndComponentsStatus(IOWBOMClient pBOM, NetworkResource pDevice, boolean pIsOn) throws Exception {
        AvTrace.traceln("AvDeviceUtil", 3, "setDeviceAndComponentsStatus = pDevice Name" + pDevice.getName());
        AvDeviceUtil.setDeviceStatusOnOff(pBOM, pDevice, pIsOn);
        NetworkResourceKey key = pDevice.getKey();
        OWVector components = key.getComponents();
        if (components == null) {
            return;
        }
        for (int i = 0; i < components.size(); ++i) {
            NetworkResourceKey componentKey = (NetworkResourceKey)components.elementAt(i);
            NetworkResource nr = componentKey.getNetworkResource();
            if (nr == null) continue;
            AvDeviceUtil.setDeviceAndComponentsStatus(pBOM, nr, pIsOn);
        }
    }

    public static void setDevicesStatusOnOff(IOWBOMClient pBOM, NetworkResource pDevice, boolean pFromRootDevice, boolean pIsOn) {
        try {
            if (pDevice == null) {
                AvTrace.traceln("AvDeviceUtil", 3, "WARNING: setDevicesStatusOnOff - The pDevice is NULL !!!");
                return;
            }
            NetworkResource device = pDevice;
            if (pFromRootDevice && (device = AvMOUtil.getTopLevelDeviceFromMO(pDevice)) == null) {
                AvTrace.traceln("AvDeviceUtil", 3, "WARNING: setDevicesStatusOnOff - The Root Device is NULL !!!");
                return;
            }
            AvTrace.traceln("AvDeviceUtil", 3, "setDevicesStatusOnOff = pDevice Name" + pDevice.getName());
            AvTrace.traceln("AvDeviceUtil", 3, "setDevicesStatusOnOff =  device Name" + device.getName());
            AvDeviceUtil.setDeviceAndComponentsStatus(pBOM, device, pIsOn);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvDeviceUtil", 1, e);
        }
    }

    public static void setDeviceIcon(IOWBOMClient pBOM, NetworkResource pDevice) throws AvException {
        try {
            String deviceIconSectionName = null;
            try {
                AvTrace.traceln("AvDeviceUtil", 1, "Searching DeviceIconSectionName for Device = " + pDevice.getName());
                deviceIconSectionName = AvLookup.get("DeviceIconSectionName", pDevice);
            }
            catch (AvLookupItemNotFoundException e) {
                // empty catch block
            }
            if (deviceIconSectionName == null || deviceIconSectionName.length() == 0) {
                deviceIconSectionName = "DeviceIcon";
            }
            AvTrace.traceln("AvDeviceUtil", 1, "deviceIconSectionName = " + deviceIconSectionName);
            AlarmState alarmState = RedCellRuntimeManagedObject.getAlarmStateFromNetworkResource((IOWBOMClient)pBOM, (NetworkResource)pDevice);
            int alarmSeverity = RedCellRuntimeManagedObject.getAlarmSeverity((int)0, (AlarmState)alarmState);
            AvTrace.traceln("AvDeviceUtil", 1, "Searching DeviceIcon for Device = " + pDevice.getName());
            String iconClass = AvLookup.get(deviceIconSectionName, pDevice);
            AvTrace.traceln("AvDeviceUtil", 1, "DeviceIcon = " + iconClass);
            String iconSuffix = "";
            try {
                if (pDevice instanceof AvDevice) {
                    iconSuffix = AvLookup.get("DeviceIconAlarmSuffix", ((AvDevice)pDevice).getProductLineName() + "+" + alarmSeverity);
                } else if (pDevice instanceof AvEquipment) {
                    iconSuffix = AvLookup.get("DeviceIconAlarmSuffix", ((AvEquipment)pDevice).getProductLineName() + "+" + alarmSeverity);
                }
                AvTrace.traceln("AvDeviceUtil", 1, "DeviceIconAlarmSuffix = " + iconSuffix);
            }
            catch (Exception e) {
                AvTrace.traceln("AvDeviceUtil", 3, "DeviceIconAlarmSuffix not found");
            }
            if (iconSuffix != null && iconSuffix.length() > 0) {
                iconClass = iconClass + iconSuffix;
            }
            pDevice.setIcon(iconClass);
        }
        catch (AvLookupItemNotFoundException e) {
            AvTrace.traceln("AvDeviceUtil", 1, "No DeviceIcon found.");
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to Set Device Icon.");
        }
    }

    public static String getDeviceIcon(IOWBOMClient pBOM, AvDevice pDevice) throws AvException {
        try {
            AlarmState alarmState = RedCellRuntimeManagedObject.getAlarmStateFromNetworkResource((IOWBOMClient)pBOM, (NetworkResource)pDevice);
            int alarmSeverity = RedCellRuntimeManagedObject.getAlarmSeverity((int)0, (AlarmState)alarmState);
            AvTrace.traceln("AvDeviceUtil", 1, "Searching DeviceIcon for Device = " + pDevice.getName());
            String iconClass = AvLookup.get("DeviceIcon", (NetworkResource)pDevice);
            AvTrace.traceln("AvDeviceUtil", 1, "DeviceIcon = " + iconClass);
            String iconSuffix = "";
            try {
                iconSuffix = AvLookup.get("DeviceIconAlarmSuffix", pDevice.getProductLineName() + "+" + alarmSeverity);
                AvTrace.traceln("AvDeviceUtil", 1, "DeviceIconAlarmSuffix = " + iconSuffix);
            }
            catch (Exception e) {
                AvTrace.traceln("AvDeviceUtil", 3, "DeviceIconAlarmSuffix not found");
            }
            return iconClass + iconSuffix;
        }
        catch (AvLookupItemNotFoundException e) {
            AvTrace.traceln("AvDeviceUtil", 1, "No DeviceIcon found.");
            return null;
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to Set Device Icon.");
        }
    }

    public static NetworkResourceIPLookup getNetworkResourceIPLookup(IOWBOMClient pBOM, NetworkResource pNR) throws AvException {
        NetworkResourceIPLookup nrIPLookup = null;
        try {
            String key = pNR.getKeyValue();
            AvTrace.traceln("AvDeviceUtil", 1, "In getNetworkResourceIPLookup for: " + key);
            OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs("RedCell.Config.NetworkResourceIPLookup", new OWBOMAttribValueOperator("KeyValue", "=", (Object)key), false);
            Vector results = (Vector)pBOM.getObjects((OWBOMQuery)qba).getRtnObject();
            if (results != null && !results.isEmpty()) {
                nrIPLookup = (NetworkResourceIPLookup)results.elementAt(0);
                AvTrace.traceln("AvDeviceUtil", 1, "Found NetworkResourceIPLookup. Name = " + nrIPLookup.getName());
            }
        }
        catch (OWBOMNotFoundException e) {
            AvTrace.traceln("AvDeviceUtil", 1, "WARNING: NetworkResourceIPLookup for: " + pNR.getKeyValue() + " NOT FOUND.");
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to Retrieve NetworkResourceIPLookup for IP = " + pNR.getName());
        }
        return nrIPLookup;
    }

    public static String getDeviceIPAddress(AvBeanProxy pDeviceProxy) throws AvException {
        if (pDeviceProxy == null) {
            throw new AvException("Device Can't be NULL !!!");
        }
        if (!pDeviceProxy.isInstanceOf("com.ngnms.common.AvDevice")) {
            throw new AvException("Failed to get Device IP Address - The pDeviceProxy parameter is not a Device AvBeanProxy.");
        }
        String ipAddress = null;
        try {
            AvBeanProxy managementInterfaceProxy;
            Vector authVec = pDeviceProxy.getAsVector("Authentication");
            if (authVec != null && authVec.size() > 0 && (managementInterfaceProxy = (AvBeanProxy)authVec.firstElement()) != null) {
                ipAddress = managementInterfaceProxy.getAsString("IPAddress");
            }
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to get Device IP Address.");
        }
        return ipAddress;
    }

    public static String getDeviceIPAddress(AvDevice pDevice) throws AvException {
        if (null == pDevice) {
            throw new AvException("Device Can't be NULL !!!");
        }
        String ipAddress = null;
        try {
            ManagementInterface managementInterface;
            OWVector authVec = pDevice.getAuthentication();
            if (authVec != null && authVec.size() > 0 && (managementInterface = (ManagementInterface)authVec.firstElement()) != null) {
                ipAddress = managementInterface.getIPAddress();
            }
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to get IPAddress from Managementlnterface of: " + pDevice.getName());
        }
        return ipAddress;
    }

    public static Vector getDevicesByMacAddress(IOWBOMClient pBOM, String pMacAddress, String pClassName) throws AvException {
        Vector vec = null;
        AvTrace.traceln("AvDeviceUtil");
        AvTrace.traceln("AvDeviceUtil", 1, "In getDeviceByMacAddress (Mac:" + pMacAddress + ")");
        try {
            OWBOMAttribValueOperator attr = new OWBOMAttribValueOperator("MacAddress", "=", (Object)pMacAddress);
            OWBOMQueryByAttribs request = new OWBOMQueryByAttribs(pClassName, attr, false);
            vec = (Vector)pBOM.getObjects((OWBOMQuery)request).getRtnObject();
        }
        catch (OWBOMNotFoundException e) {
            AvTrace.traceln("AvDeviceUtil", 1, pClassName + " with MAC: " + pMacAddress + " - Not Found.");
            return null;
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to query for Device - MAC = " + pMacAddress);
        }
        return vec;
    }

    public static boolean deleteDevice(IOWRuleEngineRuleInterface pRuleEngine, IOWBOMClient pBOM, AvDevice pDevice) throws AvException {
        if (pDevice == null) {
            throw new AvException("Can't Delete NULL Device.");
        }
        AvTrace.traceln("AvDeviceUtil", 1, "In deleteDevice (Name:" + pDevice.getName() + ")");
        return AvDeviceUtil.deleteDevice(pRuleEngine, pBOM, pDevice.getHandle());
    }

    public static boolean deleteDevice(IOWRuleEngineRuleInterface pRuleEngine, IOWBOMClient pBOM, OWOID pDeviceOWOID) throws AvException {
        AvTrace.traceln("AvDeviceUtil", 1, "In deleteDevice (OWOID:" + pDeviceOWOID.getOID() + ")");
        return AvDeviceUtil.deleteNetworkResource(pRuleEngine, pBOM, pDeviceOWOID);
    }

    public static boolean deleteCard(IOWRuleEngineRuleInterface pRuleEngine, IOWBOMClient pBOM, AvCard pCard) throws AvException {
        if (pCard == null) {
            throw new AvException("Can't Delete NULL Card.");
        }
        AvTrace.traceln("AvDeviceUtil", 1, "In deleteCard (Name:" + pCard.getName() + ")");
        return AvDeviceUtil.deleteCard(pRuleEngine, pBOM, pCard.getHandle());
    }

    public static boolean deleteCard(IOWRuleEngineRuleInterface pRuleEngine, IOWBOMClient pBOM, OWOID pCardOWOID) throws AvException {
        AvTrace.traceln("AvDeviceUtil", 1, "In deleteCard (OWOID:" + pCardOWOID.getOID() + ")");
        return AvDeviceUtil.deleteNetworkResource(pRuleEngine, pBOM, pCardOWOID);
    }

    public static boolean deletePort(IOWRuleEngineRuleInterface pRuleEngine, IOWBOMClient pBOM, AvPort pPort) throws AvException {
        if (pPort == null) {
            throw new AvException("Can't Delete NULL Port.");
        }
        AvTrace.traceln("AvDeviceUtil", 1, "In deletePort (Name:" + pPort.getName() + ")");
        return AvDeviceUtil.deletePort(pRuleEngine, pBOM, pPort.getHandle());
    }

    public static boolean deletePort(IOWRuleEngineRuleInterface pRuleEngine, IOWBOMClient pBOM, OWOID pPortOWOID) throws AvException {
        AvTrace.traceln("AvDeviceUtil", 1, "In deletePort (OWOID:" + pPortOWOID.getOID() + ")");
        return AvDeviceUtil.deleteNetworkResource(pRuleEngine, pBOM, pPortOWOID);
    }

    private static boolean deleteNetworkResource(IOWRuleEngineRuleInterface pRuleEngine, IOWBOMClient pBOM, OWOID pOWOID) throws AvException {
        boolean statusOK = false;
        AvTrace.traceln("AvDeviceUtil", 1, "In deleteNetworkResource (OWOID:" + pOWOID.getOID() + ")");
        try {
            GenericMODeleteRuleParamSet paramSet = new GenericMODeleteRuleParamSet();
            paramSet.setMOOID(pOWOID);
            AvTrace.traceln("AvDeviceUtil", 2, "Deleting MO ... ");
            pRuleEngine.callRule("RedCell.Config.GenericMODeleteRule", (IOWEvent)paramSet);
            statusOK = paramSet.getMOStatus();
            if (!statusOK) {
                AvTrace.traceln("AvDeviceUtil", 2, "Error Deleting MO - " + paramSet.getMOMessage());
            } else {
                AvTrace.traceln("AvDeviceUtil", 2, "MO Deleted OK.");
                AvDeviceUtil.removeDeviceFromMOMFile(pOWOID.getOID());
            }
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to DELETE MO - OWOID = " + pOWOID.getOID());
        }
        return statusOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String deleteDeviceComponents(IOWRuleEngineRuleInterface pRuleEngine, OWOID pOWOID) throws AvException {
        NetworkResource device;
        String status;
        block10: {
            status = "AvServices_RESPONSE_OK";
            device = null;
            if (pOWOID == null) {
                throw new AvException("pOWOID can't be NULL !!!");
            }
            try {
                OWBOMQueryByOWOID query = new OWBOMQueryByOWOID(pOWOID);
                device = (NetworkResource)pRuleEngine.getBOM().getObject((OWBOMQueryByKey)query).getRtnObject();
            }
            catch (Exception e) {
                AvTrace.traceStack("AvDeviceUtil", 1, e);
            }
            finally {
                if (device != null) break block10;
                status = "Device with OWOID = " + pOWOID.getOID() + " Not Found";
                AvTrace.traceln("AvDeviceUtil", 1, "In deleteDeviceEquipmentsLogicalEntities - " + status);
                return status;
            }
        }
        AvTrace.traceln("AvDeviceUtil", 2, "In deleteDeviceEquipmentsLogicalEntities for " + device.getClass().getName() + " - " + device.getName() + " (OWOID=" + pOWOID.getOID() + ")");
        NetworkResourceKey deviceKey = device.getKey();
        if (deviceKey == null) {
            status = "Device Key (Device OWOID = " + pOWOID.getOID() + ") is NULL";
            AvTrace.traceln("AvDeviceUtil", 1, "In deleteDeviceEquipmentsLogicalEntities - " + status);
            return status;
        }
        OWVector components = deviceKey.getComponents();
        AvTrace.traceln("AvDeviceUtil", 2, "Found " + components.size() + " Components.");
        for (NetworkResourceKey key : components) {
            NetworkResource nr = key.getNetworkResource();
            if (null == nr) continue;
            try {
                AvDeviceUtil.deleteNetworkResource(pRuleEngine, pRuleEngine.getBOM(), nr.getHandle());
            }
            catch (Exception e) {
                status = "Failed to Delete NetworkResource: " + nr.getClass().getName();
                AvTrace.traceln("AvDeviceUtil", 1, "status is: " + status);
                AvTrace.traceStack("AvDeviceUtil", 1, e);
                return status;
            }
        }
        return status;
    }

    public static Contact getContact(IOWBOMClient pBOM, String pContactID, boolean pToCommitAll) throws AvException {
        Contact contact = (Contact)AvDeviceUtil.getRCBean(pBOM, pContactID, "RedCell.Config.Contact", "ContactID", pToCommitAll);
        try {
            contact.setIcon("RedCell.Images.Contact.Contact");
        }
        catch (Exception e) {
            AvTrace.traceStack("AvDeviceUtil", 3, e);
        }
        return contact;
    }

    public static Location getLocation(IOWBOMClient pBOM, String pLocationID) throws AvException {
        return AvDeviceUtil.getLocation(pBOM, pLocationID, true);
    }

    public static Location getLocation(IOWBOMClient pBOM, String pLocationID, boolean pCreateIfNotFound) throws AvException {
        return AvDeviceUtil.getLocation(pBOM, pLocationID, "RedCell.Config.Location", pCreateIfNotFound, true, false);
    }

    public static Location getLocation(IOWBOMClient pBOM, String pLocationID, String pLocationClassName, boolean pToCommitAll) throws AvException {
        return AvDeviceUtil.getLocation(pBOM, pLocationID, pLocationClassName, true, pToCommitAll, false);
    }

    public static Location getLocation(IOWBOMClient pBOM, String pLocationID, String pLocationClassName, boolean pCreateIfNotFound, boolean pToCommitAll, boolean pSecurityEnabled) throws AvException {
        Location location = null;
        try {
            location = (Location)RCBOMUtil.getOWObject((IOWBOMClient)pBOM, (String)pLocationClassName, (String)pLocationID);
        }
        catch (OWBOMNotFoundException e) {
            AvTrace.traceln("AvDeviceUtil", 3, pLocationClassName + ": " + pLocationID + " - Not Found.");
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to Query " + pLocationClassName + " - pID = " + pLocationID);
        }
        if (null == location && pCreateIfNotFound) {
            AvWorkSpace ws = null;
            try {
                ws = AvWorkSpace.getAndLockWorkSpace(DEVICE_UTIL_WS_NAME);
                AvTrace.traceln("AvDeviceUtil", 3, "Creating new Location: " + pLocationID);
                try {
                    location = (Location)RCBOMUtil.getOWObject((IOWBOMClient)pBOM, (String)pLocationClassName, (String)pLocationID);
                }
                catch (OWBOMNotFoundException nfe) {
                    // empty catch block
                }
                if (null != location) {
                    Location nfe = location;
                    return nfe;
                }
                location = new Location();
                location.setLocationID(pLocationID);
                Vector<Object> commitVector = new Vector<Object>();
                if (pSecurityEnabled) {
                    OWObjectGroup definedObjGroup = RCObjectGroupUtility.getInstance().newObjectGroup(pLocationID + " Location");
                    commitVector.add(definedObjGroup);
                }
                AvDeviceUtil.updateLocationSecurityRec(pBOM, location, null, null, commitVector);
                if (!commitVector.contains(location)) {
                    commitVector.add(location);
                }
                pBOM.commitObjects(commitVector);
                if (pToCommitAll) {
                    pBOM.commitAll();
                }
            }
            catch (Exception e) {
                throw new AvException(e, "Failed to Create " + pLocationClassName + " - pID = " + pLocationID);
            }
            finally {
                if (null != ws) {
                    try {
                        ws.closeWorkSpace();
                    }
                    catch (AvException ave) {
                        AvTrace.traceStack((Exception)((Object)ave));
                    }
                }
            }
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocationParent(IOWBOMClient pBOM, Location pLocation, Location pParent) {
        AvWorkSpace ws = null;
        try {
            ws = AvWorkSpace.getAndLockWorkSpace(DEVICE_UTIL_WS_NAME);
            AvMOUtil.getObjectForUpdate(pBOM, (IOWBean)pLocation);
            Vector<Location> commitVector = new Vector<Location>();
            pLocation.setParent(pParent.getLocationID());
            commitVector.add(pLocation);
            OWObjectGroup definedObjGroup = AvSecurityUtil.getObjectGroup(pBOM, pLocation.getLocationID(), "Location");
            AvDeviceUtil.updateLocationSecurityRec(pBOM, pLocation, pParent, definedObjGroup, commitVector);
            pBOM.commitObjects(commitVector);
            pBOM.commitAll();
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLocation", 1, e);
        }
        finally {
            if (null != ws) {
                try {
                    ws.closeWorkSpace();
                }
                catch (AvException ave) {
                    ave.printStackTrace();
                }
            }
        }
    }

    public static void updateLocationSecurityRec(IOWBOMClient pBOM, Location pLocation, Location pParent, OWObjectGroup pDefinedObjGroup, Vector pCommitVector) throws Exception {
        AvTrace.traceln("AvLocation", 3, "updateLocationSecurityRec - location: " + pLocation.getLocationID() + "  parent: " + (null != pParent ? pParent.getLocationID() : "null") + "  definedObjGroup: " + (null != pDefinedObjGroup ? pDefinedObjGroup.getGroupID() : "null"));
        RCBOMInternalUseMarker marker = RCBOMInternalUseMarker.getInstance();
        OWVector parentObjGroups = null != pParent ? pParent.getOwareSecurityGroups((IOWBOMInternalUseMarker)marker) : new OWVector(OWObjectGroup.class);
        OWObjectGroup parentObjGroup = parentObjGroups.isEmpty() ? null : (OWObjectGroup)parentObjGroups.get(0);
        OWVector crtObjGroups = pLocation.getOwareSecurityGroups((IOWBOMInternalUseMarker)marker);
        OWObjectGroup crtObjGroup = crtObjGroups.isEmpty() ? null : (OWObjectGroup)crtObjGroups.get(0);
        boolean bNewObjGroup = false;
        if (null == crtObjGroup) {
            crtObjGroup = AvSecurityUtil.getObjectGroup(pBOM, pLocation.getLocationID() + " Location_", null);
            if (null == crtObjGroup) {
                crtObjGroup = AvSecurityUtil.createObjectGroup(pLocation.getLocationID() + " Location_");
                bNewObjGroup = true;
            }
            crtObjGroups.add((IOWBean)crtObjGroup);
            IOWBean bean = AvDeviceUtil.findOWBeanInVector(pCommitVector, (IOWBean)pLocation);
            if (null != bean) {
                pLocation = (Location)bean;
            } else {
                AvMOUtil.getObjectForUpdate(pBOM, (IOWBean)pLocation);
                pCommitVector.add(pLocation);
            }
            pLocation.setOwareSecurityGroups((IOWBOMInternalUseMarker)marker, crtObjGroups);
        }
        boolean bPermsChanged = false;
        if (null != parentObjGroup) {
            if (null != pDefinedObjGroup) {
                AvTrace.traceln("AvLocation", 3, "updateLocationSecurityRec - ADD parent to default permissions");
                bPermsChanged = AvSecurityUtil.setPermissions(crtObjGroup, AvSecurityUtil.addPermissions(parentObjGroup, pDefinedObjGroup));
            } else {
                AvTrace.traceln("AvLocation", 3, "updateLocationSecurityRec - SET parent permissions");
                bPermsChanged = AvSecurityUtil.setPermissions(crtObjGroup, parentObjGroup.getPerms());
            }
        } else if (null != pDefinedObjGroup) {
            AvTrace.traceln("AvLocation", 3, "updateLocationSecurityRec - SET defined permissions");
            bPermsChanged = AvSecurityUtil.setPermissions(crtObjGroup, pDefinedObjGroup.getPerms());
        } else {
            AvTrace.traceln("AvLocation", 3, "updateLocationSecurityRec - SET Default permissions");
            OWObjectGroup defaultObjGroup = AvSecurityUtil.getObjectGroup(pBOM, "Default", null);
            if (null != defaultObjGroup) {
                bPermsChanged = AvSecurityUtil.setPermissions(crtObjGroup, defaultObjGroup.getPerms());
            }
        }
        AvTrace.traceln("AvLocation", 3, "updateLocationSecurityRec - bNewObjGroup: " + bNewObjGroup + "  bPermsChanged: " + bPermsChanged);
        if (bNewObjGroup || bPermsChanged) {
            OWObjectGroup bean = (OWObjectGroup)AvDeviceUtil.findOWBeanInVector(pCommitVector, (IOWBean)crtObjGroup);
            if (null != bean) {
                AvSecurityUtil.setPermissions(bean, crtObjGroup.getPerms());
                crtObjGroup = bean;
            } else {
                AvMOUtil.getObjectForUpdate(pBOM, (IOWBean)crtObjGroup);
                pCommitVector.add(crtObjGroup);
            }
        }
        if (bPermsChanged) {
            try {
                OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs("RedCell.Config.Location", new OWBOMAttribValueOperator("Parent", "=", (Object)pLocation.getLocationID()), false);
                Vector locVector = (Vector)pBOM.getObjects((OWBOMQuery)qba).getRtnObject();
                for (Location location : locVector) {
                    OWObjectGroup bean;
                    AvTrace.traceln("AvLocation", 3, "updateLocationSecurityRec - location: " + location.getLocationID());
                    OWObjectGroup definedObjGroup = AvSecurityUtil.getObjectGroup(pBOM, location.getLocationID(), "Location");
                    if (null != definedObjGroup && null != (bean = (OWObjectGroup)AvDeviceUtil.findOWBeanInVector(pCommitVector, (IOWBean)definedObjGroup))) {
                        definedObjGroup = bean;
                    }
                    AvDeviceUtil.updateLocationSecurityRec(pBOM, location, pLocation, definedObjGroup, pCommitVector);
                }
            }
            catch (OWBOMNotFoundException nfe) {
                // empty catch block
            }
        }
    }

    private static IOWBean findOWBeanInVector(Vector pBeans, IOWBean pBean) {
        if (pBean.isNewInstance()) {
            return null;
        }
        for (IOWBean bean : pBeans) {
            if (bean.isNewInstance() || !bean.getHandle().equals((Object)pBean.getHandle())) continue;
            return bean;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OWBean getRCBean(IOWBOMClient pBOM, String pID, String pClassName, String pIDPropertyName, boolean pToCommitAll) throws AvException {
        OWBean bean = null;
        try {
            bean = RCBOMUtil.getOWObject((IOWBOMClient)pBOM, (String)pClassName, (String)pID);
        }
        catch (OWBOMNotFoundException e) {
            bean = null;
            AvTrace.traceln("AvDeviceUtil", 3, pClassName + ": " + pID + " - Not Found.");
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to Query " + pClassName + " - pID = " + pID);
        }
        if (bean == null) {
            AvTrace.traceln("AvDeviceUtil", 3, "Creating new " + pClassName + ": " + pID);
            try {
                bean = (OWBean)Class.forName(pClassName).newInstance();
                AvMOUtil.getObjectForUpdate(pBOM, (IOWBean)bean);
                bean.storeProperty(pIDPropertyName, (Object)pID);
                pBOM.commitObject((IOWBean)bean);
                if (!pToCommitAll) return bean;
                pBOM.commitAll();
                return bean;
            }
            catch (Exception e) {
                throw new AvException(e, "Failed to Create " + pClassName + " - pID = " + pID);
            }
        } else {
            AvTrace.traceln("AvDeviceUtil", 3, pClassName + ": " + pID + " - Exist.");
        }
        return bean;
    }

    public static void moveDeviceToDefaultLocation(IOWBOMClient pBOM, Equipment pDevice) throws AvException {
        AvDeviceUtil.moveDeviceToLocation(pBOM, pDevice, "Default");
    }

    public static void moveDeviceToLocation(IOWBOMClient pBOM, Equipment pDevice, String pLocationID) throws AvException {
        Location location = AvDeviceUtil.getLocation(pBOM, pLocationID);
        AvDeviceUtil.moveDeviceToLocation(pBOM, pDevice, location, true);
    }

    public static void moveDeviceToLocation(IOWBOMClient pBOM, Equipment pDevice, Location pLocation) throws AvException {
        AvDeviceUtil.moveDeviceToLocation(pBOM, pDevice, pLocation, true);
    }

    public static void moveDeviceToLocation(IOWBOMClient pBOM, Equipment pDevice, Location pLocation, boolean pCommitDevice) throws AvException {
        if (pLocation == null) {
            throw new AvException("new Location can't be NULL.");
        }
        try {
            Location deviceLocation = pDevice.getLocation();
            if (null != deviceLocation) {
                String oldLocationName = deviceLocation.getLocationID();
                if (pLocation.getLocationID().equals(oldLocationName)) {
                    AvTrace.traceln("AvDeviceUtil", 3, "moveDeviceToLocation Device: " + pDevice.getName() + " is already on " + pLocation.getLocationID());
                    return;
                }
            }
            AvTrace.traceln("AvDeviceUtil", 3, "moveDeviceToLocation Location: " + pDevice.getName() + " to " + pLocation.getLocationID());
            if (pCommitDevice) {
                AvMOUtil.getObjectForUpdate(pBOM, (IOWBean)pDevice);
            }
            pDevice.setLocation(pLocation);
            RCBOMInternalUseMarker marker = RCBOMInternalUseMarker.getInstance();
            OWVector objGroups = null;
            objGroups = null != pLocation ? pLocation.getOwareSecurityGroups((IOWBOMInternalUseMarker)marker) : new OWVector(OWObjectGroup.class);
            AvSecurityUtil.checkObjectGroups(pBOM, objGroups);
            pDevice.setOwareSecurityGroups((IOWBOMInternalUseMarker)marker, new OWVector(OWObjectGroup.class, (Collection)objGroups.getCollection()));
            if (pCommitDevice) {
                pBOM.commitObject((IOWBean)pDevice);
            }
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to move Device to Location.");
        }
        AvTrace.traceln("AvDeviceUtil", 3, "moveDeviceToLocation done.");
    }

    public static Vendor getVendor(IOWBOMClient pBOM) {
        Vendor vendor = null;
        String vendorName = AvPropDefs.getVendor();
        try {
            vendor = (Vendor)RCBOMUtil.getOWObject((IOWBOMClient)pBOM, (String)"RedCell.Config.Vendor", (String)vendorName);
        }
        catch (OWBOMNotFoundException e) {
            vendor = null;
            AvTrace.traceln("AvDeviceUtil", 3, "getVendor: " + vendorName + " - Not Found.");
        }
        catch (Exception e) {
            vendor = null;
            AvTrace.traceStack("AvDeviceUtil", 1, e);
        }
        if (null == vendor) {
            AvTrace.traceln("AvDeviceUtil", 3, "getVendor Creating new Vendor: " + vendorName);
            vendor = new Vendor();
            try {
                AvMOUtil.getObjectForUpdate(pBOM, (IOWBean)vendor);
                vendor.setVendorID(vendorName);
                vendor.setIcon("RedCell.Images.Vendor.Vendor");
                pBOM.commitObject((IOWBean)vendor);
                pBOM.commitAll();
            }
            catch (Exception e) {
                AvTrace.traceStack("AvDeviceUtil", 1, e);
            }
        } else {
            AvTrace.traceln("AvDeviceUtil", 3, "getVendor: " + vendorName + " - Exist.");
        }
        return vendor;
    }

    public static void removeRole(AvBeanProxy pDeviceProxy, String pRoleName) throws AvException {
        if (AvUtil.isAppServerSide()) {
            throw new AvException("Should be called by client");
        }
        AvTrace.traceln("AvDeviceUtil", 1, "removeRole (Client Side) - Name = " + pRoleName);
        AvRoleOperateRuleParamSet ps = new AvRoleOperateRuleParamSet();
        ps.setOperation("REMOVE_ROLE");
        ps.setDeviceProxy(pDeviceProxy);
        ps.setRoleName(pRoleName);
        RedCellRuleEngineUtil.callRule((String)"com.ngnms.common.AvRoleOperateRule", (OWEvent)ps);
    }

    public static void removeRole(IOWBOMClient pBOM, AvBeanProxy pDeviceProxy, String pRoleName) throws AvException {
        if (!AvUtil.isAppServerSide()) {
            throw new AvException("Should be called by Server");
        }
        AvTrace.traceln("AvDeviceUtil", 1, "removeRole (Server Side) - Name = " + pRoleName);
        Vector rols = pDeviceProxy.getAsVector("Role");
        if (rols == null) {
            return;
        }
        for (int r = rols.size() - 1; r >= 0; --r) {
            AvBeanProxy roleProxy = (AvBeanProxy)rols.elementAt(r);
            if (!roleProxy.getAsString("Name").equals(pRoleName)) continue;
            rols.remove(roleProxy);
        }
        pDeviceProxy.setVector("Role", rols);
        pDeviceProxy.update(pBOM);
    }

    public static void setRole(AvBeanProxy pDeviceProxy, String pRoleName, String pRoleType) throws AvException {
        if (AvUtil.isAppServerSide()) {
            throw new AvException("Should be called by client");
        }
        AvTrace.traceln("AvDeviceUtil", 1, "setRole (Client Side) - Name: " + pRoleName + ", Type: " + pRoleType);
        AvRoleOperateRuleParamSet ps = new AvRoleOperateRuleParamSet();
        ps.setOperation("SET_ROLE");
        ps.setDeviceProxy(pDeviceProxy);
        ps.setRoleName(pRoleName);
        ps.setRoleType(pRoleType);
        RedCellRuleEngineUtil.callRule((String)"com.ngnms.common.AvRoleOperateRule", (OWEvent)ps);
    }

    public static void setRole(IOWBOMClient pBOM, AvBeanProxy pDeviceProxy, String pRoleName, String pRoleType) throws AvException {
        AvDeviceUtil.setRole(pBOM, pDeviceProxy, pRoleName, pRoleType, true);
    }

    public static void setRole(IOWBOMClient pBOM, AvBeanProxy pDeviceProxy, String pRoleName, String pRoleType, boolean pToUpdate) throws AvException {
        if (!AvUtil.isAppServerSide()) {
            throw new AvException("Should be called by Server");
        }
        try {
            AvTrace.traceln("AvDeviceUtil", 1, "setRole (Server Side) - Name: " + pRoleName + ", Type: " + pRoleType + ", ToUpdate: " + pToUpdate);
            Vector<Role> rols = pDeviceProxy.getAsVector("Role");
            if (rols == null) {
                rols = new Vector<Role>();
            }
            for (int r = rols.size() - 1; r >= 0; --r) {
                AvBeanProxy roleProxy = (AvBeanProxy)rols.elementAt(r);
                if (!roleProxy.getAsString("Type").equals(pRoleType)) continue;
                rols.remove(roleProxy);
            }
            Role newRole = AvDeviceUtil.getRole(pBOM, pRoleName, pRoleType);
            rols.add(newRole);
            pDeviceProxy.setVector("Role", rols);
            if (pToUpdate) {
                pDeviceProxy.update(pBOM);
            }
            AvTrace.traceln("AvDeviceUtil");
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to Set Role.");
        }
    }

    public static void setRole(IOWBOMClient pBOM, AvDevice pDevice, String pRoleName, String pRoleType) throws AvException {
        if (!AvUtil.isAppServerSide()) {
            throw new AvException("Should be called by Server");
        }
        try {
            AvTrace.traceln("AvDeviceUtil", 1, "setRole (Server Side) - Name = " + pRoleName);
            OWVector rols = pDevice.getRole();
            for (int r = rols.size() - 1; r >= 0; --r) {
                Role role = (Role)rols.elementAt(r);
                if (!role.getType().equals(pRoleType)) continue;
                rols.remove((IOWBean)role);
            }
            Role newRole = AvDeviceUtil.getRole(pBOM, pRoleName, pRoleType);
            rols.add((IOWBean)newRole);
            pDevice.setRole(rols);
            pBOM.commitObject((IOWBean)pDevice);
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to Set Role.");
        }
    }

    public static Role getRole(IOWBOMClient pBOM, String pRoleName, String pRoleType) throws AvException {
        Role role;
        block18: {
            if (!AvUtil.isAppServerSide()) {
                throw new AvException("Should be called by Server");
            }
            AvTrace.traceln("AvDeviceUtil", 1, "getRole (Server Side) - Name = " + pRoleName);
            role = null;
            AvWorkSpace workSpace = null;
            try {
                workSpace = AvWorkSpace.getAndLockWorkSpace("AvRoleCreateSemaphore", AvServiceUtil.getWorkSpaceTimeout());
                if (pRoleName != null && !pRoleName.equals("")) {
                    OWBOMQueryByKey que = new OWBOMQueryByKey("RedCell.Config.Role", pRoleName);
                    role = (Role)RCBOMUtil.getOWObject((IOWBOMClient)pBOM, (OWBOMQueryByKey)que);
                    break block18;
                }
                throw new AvException("Failed to Retrieve Role - Role Name is Empty or NULL !!!");
            }
            catch (OWBOMNotFoundException nfe) {
                try {
                    AvTrace.traceln("AvDeviceUtil", 1, "getRole - Creating new Role: " + pRoleName + ", Type: " + pRoleType);
                    role = new Role();
                    role.setName(pRoleName);
                    role.setType(pRoleType);
                    pBOM.commitObject((IOWBean)role);
                }
                catch (Exception e) {
                    throw new AvException(e, "Failed to Create new Role - " + pRoleName);
                }
            }
            catch (Exception e) {
                throw new AvException(e, "Failed to Retrieve Role");
            }
            finally {
                try {
                    if (null != workSpace) {
                        workSpace.closeWorkSpace();
                    }
                }
                catch (Exception e) {
                    AvTrace.traceStack("AvDeviceUtil", 1, e);
                    throw new AvException(e, "Failed to Close Work Space.");
                }
            }
        }
        return role;
    }

    public static void setDeviceModel(AvDevice pDevice) {
        String modelName = null;
        String sysObjectID = pDevice.getSysObjectID();
        try {
            modelName = AvLookup.get("ModelName", sysObjectID);
            if (modelName != null) {
                pDevice.setModel(modelName);
            }
        }
        catch (AvLookupItemNotFoundException e) {
            AvTrace.traceln("AvDeviceUtil", 1, "No ModelName found for sysObjectID = " + sysObjectID);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvDeviceUtil", 1, e);
        }
    }

    public static Vector getLinksToDevice(IOWRuleEngineRuleInterface pRE, AvDevice pDevice) {
        Vector<String> linkAttribs = new Vector<String>();
        linkAttribs.add("Name");
        linkAttribs.add("AEndPoint.EndPoint.NetworkResource.Name");
        linkAttribs.add("AEndPoint.EndPoint.NetworkResource.LogicalEntities.IpParams.AvLeaf_IpAddress");
        linkAttribs.add("ZEndPoint.EndPoint.NetworkResource.Name");
        linkAttribs.add("ZEndPoint.EndPoint.NetworkResource.LogicalEntities.IpParams.AvLeaf_IpAddress");
        return AvDeviceUtil.getLinksToDevice(pRE, pDevice, linkAttribs);
    }

    public static Vector getLinksToDevice(IOWRuleEngineRuleInterface pRE, AvDevice pDevice, Vector pLinkAttribs) {
        GetSMFRelationsParamSet relationsParamSet = new GetSMFRelationsParamSet();
        try {
            AvTrace.traceln("AvDeviceUtil", 3, "getLinksToDevice: " + pDevice.getName());
            Vector<String> colObjectsVector = new Vector<String>();
            colObjectsVector.add(pDevice.getKeyValue());
            relationsParamSet.setColObjects(colObjectsVector);
            relationsParamSet.setColAttributeNames((Serializable)pLinkAttribs);
            pRE.callRule("RedCell.Service.GetLinksForNetworkResourceKeys", (IOWEvent)relationsParamSet);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvDeviceUtil", 1, e);
        }
        return (Vector)relationsParamSet.getColResults();
    }

    public static void createWirelessLink(IOWRuleEngineRuleInterface pRuleEngine, AvCard aPoint, AvDevice zPoint, String pLogCategory) {
        AvDeviceUtil.createWirelessLinkInt(pRuleEngine, (Equipment)aPoint, (Equipment)zPoint, pLogCategory);
    }

    public static void createWirelessLink(IOWRuleEngineRuleInterface pRuleEngine, AvDevice aPoint, AvDevice zPoint, String pLogCategory) {
        AvDeviceUtil.createWirelessLinkInt(pRuleEngine, (Equipment)aPoint, (Equipment)zPoint, pLogCategory);
    }

    public static void createWirelessLinkInt(IOWRuleEngineRuleInterface pRuleEngine, Equipment aPoint, Equipment zPoint, String pLogCategory) {
        try {
            GenericCreateBeanRuleParamSet evt = new GenericCreateBeanRuleParamSet();
            evt.setInUserID("UserID");
            evt.setInBeanClass("com.ngnms.common.AvWirelessLink");
            String linkName = AvDeviceUtil.getWirelessLinkName(aPoint, zPoint);
            OWSet avpSet = new OWSet(OWAttributeValuePair.class);
            OWAttributeValuePair avPair = new OWAttributeValuePair("Key.Name", (Object)linkName);
            avpSet.addElement((Serializable)avPair);
            avPair = new OWAttributeValuePair("Name", (Object)linkName);
            avpSet.addElement((Serializable)avPair);
            avPair = new OWAttributeValuePair("AEndPoint", (Object)aPoint.getKey().getHandle());
            avpSet.addElement((Serializable)avPair);
            avPair = new OWAttributeValuePair("ZEndPoint", (Object)zPoint.getKey().getHandle());
            avpSet.addElement((Serializable)avPair);
            avPair = new OWAttributeValuePair("LinkType", (Object)"Explicit");
            avpSet.addElement((Serializable)avPair);
            avPair = new OWAttributeValuePair("LineWidth", (Object)new Integer(1));
            avpSet.addElement((Serializable)avPair);
            evt.setInData((Serializable)avpSet);
            pRuleEngine.callRule("RedCell.Config.LinkCreateBeanRule", (IOWEvent)evt);
            AvDeviceUtil.updateMOMWithLink(aPoint, zPoint);
            String linkLabel = "( " + aPoint.getName() + " ) to ( " + zPoint.getName() + " )";
            AvTrace.logMessage("AvNEDiscoveryResyncBundle", pLogCategory, AvTrace.LOG_USER_ID_APP, "Wireless Link: " + linkLabel, "", "LogDiscoveredWirelessLink", new String[]{linkLabel});
        }
        catch (Exception e) {
            AvTrace.traceStack("AvDeviceUtil", 1, e);
        }
    }

    public static void updateMOMWithLink(Equipment aPoint, Equipment zPoint) {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            String sectionName = "LINK: " + AvDeviceUtil.getWirelessLinkName(aPoint, zPoint);
            AvTrace.traceln("AvDeviceUtil", 3, "In updateMOMWithLink - sectionName = " + sectionName);
            hashtable.put("Type", "WirelessLink");
            hashtable.put("APoint", aPoint.getHandle().getOID());
            hashtable.put("ZPoint", zPoint.getHandle().getOID());
            AvDeviceUtil.updateMOMFile(sectionName, hashtable);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvDeviceUtil", 1, e);
        }
    }

    public static void updateMOMFile(String pSectionName, Hashtable pParamsHashtable) {
        try {
            AvTrace.traceln("AvDeviceUtil", 3, "In updateMOMWithLink - pSectionName = " + pSectionName);
            String iniFilePath = System.getProperty(MOM_INI_FILE_FULL_PATH);
            if (iniFilePath == null || iniFilePath.length() == 0) {
                return;
            }
            AvIniWriter iniWriter = new AvIniWriter(iniFilePath, false);
            Enumeration theEnum = pParamsHashtable.keys();
            while (theEnum.hasMoreElements()) {
                String key = (String)theEnum.nextElement();
                String val = (String)pParamsHashtable.get(key);
                iniWriter.setValue(pSectionName, key, val);
            }
            iniWriter.UpdateFile();
        }
        catch (Exception e) {
            AvTrace.traceStack("AvDeviceUtil", 1, e);
        }
    }

    public static void removeDeviceFromMOMFile(String pDeviceOIDStr) {
        try {
            AvTrace.traceln("AvDeviceUtil", 3, "In removeDeviceFromMOMFile - pDeviceOIDStr = " + pDeviceOIDStr);
            String iniFilePath = System.getProperty(MOM_INI_FILE_FULL_PATH);
            if (iniFilePath != null && iniFilePath.length() > 0) {
                AvIniWriter iniWriter = new AvIniWriter(iniFilePath, false);
                Vector sections = iniWriter.getSections();
                for (int i = 0; i < sections.size(); ++i) {
                    String section = (String)sections.elementAt(i);
                    if (section.indexOf(pDeviceOIDStr) < 0) continue;
                    AvTrace.traceln("AvDeviceUtil", 3, "Deleting Section: " + section);
                    iniWriter.deleteSection(section);
                }
                iniWriter.UpdateFile();
            }
        }
        catch (Exception e) {
            AvTrace.traceStack("AvDeviceUtil", 3, e);
        }
    }

    public static String getWirelessLinkName(Equipment aPoint, Equipment zPoint) {
        return "Wireless Link: " + aPoint.getName() + "(" + aPoint.getHandle().getOID() + ") to " + zPoint.getName() + "(" + zPoint.getHandle().getOID() + ")";
    }

    public static AvWirelessLink getWirelessLinkByName(IOWBOMClient pBOM, String pLinkName) {
        AvWirelessLink link = null;
        try {
            Vector vec = null;
            OWBOMAttribValueOperator attr = new OWBOMAttribValueOperator("Name", "=", (Object)pLinkName);
            OWBOMQueryByAttribs request = new OWBOMQueryByAttribs("com.ngnms.common.AvWirelessLink", attr, false);
            vec = (Vector)pBOM.getObjects((OWBOMQuery)request).getRtnObject();
            if (vec != null && vec.size() > 0) {
                link = (AvWirelessLink)vec.firstElement();
            }
        }
        catch (OWBOMNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            AvTrace.traceStack("AvDeviceUtil", 1, e);
            return null;
        }
        return link;
    }

    public static String getLicenseClassName(String pEquipmentClassName) throws AvException {
        String licenseClassName = null;
        try {
            AvTrace.traceln("AvDeviceUtil", 1, "Searching ParentClass for equipmentClassName = " + pEquipmentClassName);
            licenseClassName = AvLookup.get("ParentClass", pEquipmentClassName);
        }
        catch (AvLookupItemNotFoundException e) {
            AvTrace.traceln("AvDeviceUtil", 1, "No Parent Class found for equipmentClassName = " + pEquipmentClassName + " - Will use current Class.");
        }
        if (licenseClassName == null) {
            licenseClassName = pEquipmentClassName;
        }
        AvTrace.traceln("AvDeviceUtil", 1, "licenseClassName = " + licenseClassName);
        return licenseClassName;
    }

    public static void changeEquipmentCommunity(Equipment pEquipment, String pReadCommunity, String pWriteCommunity, IOWBOMClient pBOM) throws AvException {
        try {
            if (pEquipment != null && (pEquipment instanceof AvDevice || pEquipment instanceof AvCard)) {
                IAvUpdateDeviceCommunity updateDeviceCommunity = AvDeviceUtil.getUpdateDeviceCommunity(pEquipment);
                if (updateDeviceCommunity != null) {
                    AvMOUtil.getObjectForUpdate(pBOM, (IOWBean)pEquipment);
                    updateDeviceCommunity.updateCommunity(pEquipment, pReadCommunity, pWriteCommunity);
                    pBOM.commitObject((IOWBean)pEquipment);
                } else if (pEquipment instanceof AvDevice) {
                    AvDevice device = (AvDevice)pEquipment;
                    AvMOUtil.getObjectForUpdate(pBOM, (IOWBean)device);
                    device.setReadCommunity(pReadCommunity);
                    device.setWriteCommunity(pWriteCommunity);
                    pBOM.commitObject((IOWBean)device);
                }
            } else if (pEquipment != null) {
                AvTrace.traceln("AvDeviceUtil", 1, "Required change community for not supported device");
            }
        }
        catch (Exception e) {
            throw new AvException(e, "Problem to change device community");
        }
    }

    public static IAvUpdateDeviceCommunity getUpdateDeviceCommunity(Equipment pEquipment) throws AvException {
        IAvUpdateDeviceCommunity updateCommunity = null;
        String productLine = "";
        try {
            if (pEquipment instanceof AvDevice) {
                productLine = ((AvDevice)pEquipment).getProductLineName();
            } else if (pEquipment instanceof AvCard) {
                productLine = ((AvCard)pEquipment).getProductLineName();
            } else {
                AvTrace.traceln("AvDeviceUtil", 3, "In AvNetConfigFormSet Rule: Not supported Equipment");
                return updateCommunity;
            }
            String updateCommunityClassName = AvLookup.get("UpdateDeviceCommunity", productLine);
            if (updateCommunityClassName != null) {
                updateCommunity = (IAvUpdateDeviceCommunity)Class.forName(updateCommunityClassName).newInstance();
            }
        }
        catch (Exception e) {
            AvTrace.traceln("AvDeviceUtil", 3, "WARNING: UpdateDeviceCommunity not Found  for " + productLine + " !!!");
        }
        return updateCommunity;
    }

    public static String getDeviceDescription(String pDeviceDescription, boolean isParent) {
        try {
            AvDeviceDescription descr = new AvDeviceDescription(pDeviceDescription, isParent);
            if (!isParent) {
                return descr.getDeviceName() + " " + descr.getType() + " (" + descr.getParentName() + " IP:" + descr.getIPAddress() + ")";
            }
            return descr.getDeviceName() + " (" + descr.getIPAddress() + ")";
        }
        catch (Exception e) {
            AvTrace.traceStack("AvDeviceUtil", 1, e);
            return "";
        }
    }

    public static String getDeviceDescription(AvBeanProxy pDeviceProxy) {
        try {
            boolean isParent = Class.forName("com.ngnms.common.AvChassisDevice").isAssignableFrom(Class.forName(pDeviceProxy.getClassName()));
            return AvDeviceUtil.getDeviceDescription(pDeviceProxy.getAsString("DeviceDescription"), isParent);
        }
        catch (Exception e) {
            return "";
        }
    }
}

