/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import RedCell.Config.Equipment;
import com.ngnms.common.AvBeanProxy;
import com.ngnms.common.AvChassisDevice;
import com.ngnms.common.AvException;
import com.ngnms.common.AvTrace;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class AvDeviceDescription {
    private String ipAddress = null;
    private String parentName = null;
    private String type = null;
    private String deviceName = null;
    private String location = null;

    public AvDeviceDescription(Equipment pDevice) throws AvException {
        this(pDevice.getDeviceDescription(), pDevice instanceof AvChassisDevice);
    }

    public AvDeviceDescription(AvBeanProxy pDevice) throws AvException {
        this(pDevice.getAsString("DeviceDescription"), pDevice.isInstanceOf("com.ngnms.common.AvChassisDevice"));
    }

    public AvDeviceDescription(String pDeviceDescr, boolean pIsParent) throws AvException {
        AvTrace.traceln("AvMOUtil", 1, "In AvDeviceDescription - pDeviceDescr = " + pDeviceDescr + ", pIsParent = " + pIsParent);
        try {
            StringTokenizer stk;
            if (pDeviceDescr != null && pDeviceDescr.length() > 0 && (stk = new StringTokenizer(pDeviceDescr, ",")) != null) {
                try {
                    this.parentName = stk.nextToken().trim();
                    this.ipAddress = stk.nextToken().trim();
                    this.type = stk.nextToken().trim();
                    this.deviceName = pIsParent ? this.parentName : stk.nextToken().trim();
                    this.location = stk.nextToken().trim();
                }
                catch (NoSuchElementException e) {
                    AvTrace.traceln("AvMOUtil", 1, "WARNING: Failed to Parse Device Description: " + pDeviceDescr);
                }
            }
        }
        catch (Exception e) {
            throw new AvException("Device description could not be received");
        }
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public String getType() {
        return this.type;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "AvDeviceDescription: ParentName = " + this.getParentName() + ", IPAddress = " + this.getIPAddress() + ", Type = " + this.getType() + ", DeviceName = " + this.getDeviceName() + ", getLocation = " + this.getLocation();
    }
}

