/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import RedCell.Config.EquipmentManager;
import com.dorado.common.collections.NDictionary;
import com.dorado.common.collections.OWAVPVector;
import com.dorado.common.exception.OWRemoteException;
import com.dorado.common.utility.OWAttributeValuePair;
import com.dorado.common.utility.OWOID;
import com.dorado.common.widget.components.OWFCParentPanel;
import com.dorado.common.widget.components.formlauncher.IOWFormLauncher;
import com.dorado.redcell.inventory.auth.Credentials;
import com.dorado.redcell.inventory.auth.GetAllAuthenticationForEquipmentParamSet;
import com.dorado.redcell.inventory.auth.RCCutThruEvent;
import com.dorado.redcell.inventory.base.commandhandler.RCEntityRow;
import com.dorado.runtime.IOWBaseBean;
import com.dorado.runtime.IOWRuntimeForm;
import com.dorado.runtime.OWBaseBean;
import com.dorado.runtime.OWBaseVector;
import com.dorado.runtime.OWEvent;
import com.ngnms.common.AvLookup;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import redcell.common.commandhandler.RCAbstractCommandHandler;
import redcell.common.commandhandler.RCCutThruCommandHandler;
import redcell.common.interfaces.IRCEntityEditor;
import redcell.common.interfaces.IRCEntityManager;
import redcell.common.util.ICallBackNewItemPanel;
import redcell.common.util.IRCNewItemPanel;
import redcell.common.util.LaunchBrowser;
import redcell.common.util.RCBeanProxy;
import redcell.common.util.RCBeanProxyUtil;
import redcell.common.util.RedCellRuleEngineUtil;
import redcell.common.util.RedCellRuntimeUtil;
import redcell.core.usersys.RCUserUtil;

public class AvCutThruCommandHandler
extends RCAbstractCommandHandler
implements ICallBackNewItemPanel {
    private static Logger log = Logger.getLogger(RCCutThruCommandHandler.class);
    private OWBaseVector credentials = null;
    private IOWRuntimeForm manager = null;
    private OWOID selectedOid = null;
    private static final String CT_SSH = "SSH";
    private static final String CT_TELNET = "Telnet";
    private static final String CT_TL1 = "TL1";
    private static final String CT_SIMPLE = "Simple Telnet";
    private static final String CT_HTTP = "HTTP";
    private static final String CT_HTTPS = "HTTPS";
    private static final String CT_FTP = "FTP";
    private static final String CT_SNMP = "SNMP";
    private static final String[] VALID_CUT_THRU_TYPES = new String[]{"SSH", "Telnet", "TL1", "Simple Telnet", "HTTP", "HTTPS", "FTP", "SNMP"};

    public void setProperties(HashMap pHash) {
        log.debug((Object)"setProperties");
        super.setProperties(pHash);
        this.setButtonName("btnCutThru");
        this.setButtonText(rb.getString(28L));
        this.setToolTipText(rb.getString(29L));
        this.setHotKey(rb.getString(30L));
    }

    public void execute(IRCEntityManager pManager) {
        log.debug((Object)"execute");
        if (pManager.getSelection() == null || pManager.getSelection().length == 0) {
            return;
        }
        this.initiateCutThru(pManager, pManager.getSelection()[0]);
    }

    public void initiateCutThru(Object pManager, OWOID pOid) {
        log.debug((Object)"initiateCutThru");
        this.selectedOid = pOid;
        this.manager = (IOWRuntimeForm)pManager;
        GetAllAuthenticationForEquipmentParamSet _ps = new GetAllAuthenticationForEquipmentParamSet();
        this.manager.getFormController().setBusy(true);
        _ps.setEquipmentOid(this.selectedOid);
        RedCellRuleEngineUtil.callRule((String)"com.ngnms.common.GetAllAuthenticationForEquipment", (OWEvent)_ps);
        this.credentials = _ps.getCredentials();
        if (!this.checkAuthList()) {
            this.manager.getFormController().setBusy(false);
            this.showMessage((IOWRuntimeForm)pManager, false, "Cannot initiate cut thru for this device.  No Credentials Found.", "Cut Thru Failed");
        } else if (this.credentials.size() == 1) {
            Credentials _cred = (Credentials)this.credentials.get(0);
            this.launchCutThru(_cred);
        } else {
            this.manager.getFormController().setBusy(false);
            IOWFormLauncher _formLauncher = ((OWFCParentPanel)pManager).getFormLauncher();
            Hashtable<String, Object> _props = new Hashtable<String, Object>();
            NDictionary _classHash = new NDictionary();
            Enumeration _credList = this.credentials.elements();
            while (_credList.hasMoreElements()) {
                Credentials _cred = (Credentials)_credList.nextElement();
                RCBeanProxy _authProxy = _cred.getAuthentication();
                RCBeanProxy _miProxy = _cred.getManagementInterface();
                RCBeanProxy _mitProxy = _cred.getManagementInterfaceType();
                Vector<Object> _columnData = new Vector<Object>();
                StringBuffer _paramsStingBuffer = new StringBuffer();
                _columnData.add(_mitProxy.get("Name"));
                boolean _firstParamSet = false;
                if (_miProxy.get("IPAddress") != null) {
                    if (_firstParamSet) {
                        _paramsStingBuffer.append(", ");
                    }
                    _paramsStingBuffer.append((String)_miProxy.get("IPAddress"));
                    _firstParamSet = true;
                }
                if (_miProxy.get("Port") != null) {
                    if (_firstParamSet) {
                        _paramsStingBuffer.append(", ");
                    }
                    _paramsStingBuffer.append(String.valueOf(_miProxy.get("Port")));
                    _firstParamSet = true;
                }
                if (_authProxy != null) {
                    OWAVPVector _authProps = _authProxy.getRCAVPVector();
                    Enumeration _authPropList = _authProps.elements();
                    while (_authPropList.hasMoreElements()) {
                        OWAttributeValuePair _avp = (OWAttributeValuePair)_authPropList.nextElement();
                        if (_avp.getAttributeName().equals("Roles") || _avp.getAttributeName().indexOf("Password") != -1 || _avp.getValue() == null) continue;
                        if (_firstParamSet) {
                            _paramsStingBuffer.append(", ");
                        }
                        _paramsStingBuffer.append(String.valueOf(_avp.getValue()));
                        _firstParamSet = true;
                    }
                }
                _columnData.add(_paramsStingBuffer.toString());
                _classHash.put((Object)String.valueOf(_cred.hashCode()), _columnData);
            }
            _props.put("id", String.valueOf(_props.hashCode()));
            _props.put("_columns", new String[]{"Type", "Parameters"});
            _props.put("NewItemPanel.CallBack", (Object)this);
            _props.put("NewItemPanel.Values", _classHash);
            _props.put("_title", "Please Choose an Authentication Record");
            _props.put("FormLauncher", _formLauncher);
            RedCellRuntimeUtil.showPanel((Object[])new Object[]{"RedCell.NewItemPanel", _props, Boolean.TRUE});
        }
    }

    public boolean isEnabled(IRCEntityManager pManager, boolean pIsSelectionNative, int pSelectionCnt) {
        boolean _rtnVal = super.isEnabled(pManager, pIsSelectionNative, pSelectionCnt);
        if (_rtnVal) {
            Vector _selectionData = pManager.getSelectionData();
            RCEntityRow _row = (RCEntityRow)_selectionData.get(0);
            String _entityClassName = _row.getEntityClassName();
            String cutThruEquipment = null;
            try {
                Class<?> _class = Class.forName(_entityClassName);
                _rtnVal = EquipmentManager.class.isAssignableFrom(_class);
                if (!(_rtnVal || (cutThruEquipment = AvLookup.get("CutThruEquipment", new OWOID(_row.getOidString()))) == null || cutThruEquipment.equals("") || cutThruEquipment.equals("AvLookupEmpty"))) {
                    _rtnVal = true;
                }
            }
            catch (OWRemoteException _re) {
                _rtnVal = false;
            }
            catch (Exception _e) {
                _rtnVal = false;
            }
        }
        return _rtnVal;
    }

    private boolean checkAuthList() {
        log.debug((Object)"checkAuthList");
        if (this.credentials == null) {
            return false;
        }
        Vector<Credentials> _credsToRemove = new Vector<Credentials>();
        log.debug((Object)("checkAuthList: credentials.size() = " + this.credentials.size()));
        Enumeration _list = this.credentials.elements();
        while (_list.hasMoreElements()) {
            Credentials _cred = (Credentials)_list.nextElement();
            RCBeanProxy _mitProxy = _cred.getManagementInterfaceType();
            RCBeanProxy _miProxy = _cred.getManagementInterface();
            RCBeanProxy _authProxy = _cred.getAuthentication();
            String _typeName = (String)_mitProxy.get("Name");
            log.debug((Object)("checkAuthList: typeName = " + _typeName));
            if (_mitProxy == null || _miProxy == null) {
                _credsToRemove.add(_cred);
                continue;
            }
            if (_typeName.equalsIgnoreCase(CT_HTTP) || _typeName.equalsIgnoreCase(CT_HTTPS) || _typeName.equalsIgnoreCase(CT_SIMPLE)) continue;
            if (_authProxy == null) {
                _credsToRemove.add(_cred);
                continue;
            }
            String _cutThruPanelName = (String)_mitProxy.get("CutThruPanelName");
            String _setupRuleName = (String)_mitProxy.get("SetupRuleName");
            if (_cutThruPanelName != null && !_cutThruPanelName.trim().equals("") && (_setupRuleName == null || !_setupRuleName.trim().equals("com.dorado.redcell.inventory.auth.SetupSNMP"))) continue;
            _credsToRemove.add(_cred);
        }
        Enumeration _removeList = _credsToRemove.elements();
        while (_removeList.hasMoreElements()) {
            this.credentials.remove((IOWBaseBean)((OWBaseBean)_removeList.nextElement()));
        }
        return this.credentials.size() != 0;
    }

    private void launchCutThru(Credentials pCred) {
        log.debug((Object)"launchCutThru");
        RCBeanProxy _authProxy = pCred.getAuthentication();
        RCBeanProxy _miProxy = pCred.getManagementInterface();
        RCBeanProxy _mitProxy = pCred.getManagementInterfaceType();
        RCBeanProxy _proxy = null;
        OWOID _oid = null;
        if (this.manager instanceof IRCEntityManager) {
            _proxy = ((IRCEntityManager)this.manager).getSelectionAsProxy()[0];
            _oid = _proxy.getRCOID();
        } else {
            try {
                _oid = this.selectedOid;
                _proxy = RCBeanProxyUtil.getProxyBean((OWOID)this.selectedOid);
            }
            catch (Exception e) {
                log.error((Object)("unable to get proxy bean for oid " + this.selectedOid), (Throwable)e);
                return;
            }
        }
        String _equipmentName = (String)_proxy.get("Name");
        String _eqKey = (String)_proxy.get("KeyValue");
        String _eqSysObjId = (String)_proxy.get("SysObjectID");
        OWOID _equipmentOid = _proxy.getRCOID();
        String _miTypeName = (String)_mitProxy.get("Name");
        if (_miTypeName.equalsIgnoreCase(CT_HTTP) || _miTypeName.equalsIgnoreCase(CT_HTTPS)) {
            this.launchWebPage((OWBaseBean)pCred);
            this.manager.getFormController().setBusy(false);
            return;
        }
        this.emitInitiateEvent((String)_mitProxy.get("Name"), _oid);
        if (((String)_mitProxy.get("Name")).equalsIgnoreCase(CT_SIMPLE)) {
            String _ip = (String)_miProxy.get("IPAddress");
            this.launchSimpleTelnetCutThru(_ip);
            this.manager.getFormController().setBusy(false);
            return;
        }
        Hashtable _formProps = RedCellRuntimeUtil.createParameterHash((IOWFormLauncher)((OWFCParentPanel)this.manager).getFormLauncher());
        String _title = (String)_mitProxy.get("Description");
        _title = _title + " CutThru (" + _equipmentName + ")";
        _formProps.put("id", _title);
        _formProps.put("_title", _title);
        _formProps.put("_equipmentOid", _equipmentOid);
        _formProps.put("_eqkey", _eqKey);
        _formProps.put("_eqSysObjId", _eqSysObjId);
        _formProps.put("_equipmentName", _equipmentName);
        _formProps.put("_credentials", pCred);
        if (log.isDebugEnabled()) {
            log.debug((Object)("CutThruPanelName: " + _mitProxy.get("CutThruPanelName")));
        }
        RedCellRuntimeUtil.showPanel((Object[])new Object[]{_mitProxy.get("CutThruPanelName"), _formProps});
        this.manager.getFormController().setBusy(false);
    }

    public void launchSimpleTelnetCutThru(String pIP) {
        log.debug((Object)"launchSimpleTelnetCutThru");
        String _telnetCmd = System.getProperty("redcell.telnetcmd");
        boolean _useDefault = _telnetCmd == null;
        Runtime _rt = Runtime.getRuntime();
        if (File.separator.equals("\\")) {
            _telnetCmd = _useDefault ? "cmd /C start telnet " : _telnetCmd;
        } else {
            String string = _telnetCmd = _useDefault ? "/usr/openwin/bin/xterm -e telnet " : _telnetCmd;
        }
        if (!_telnetCmd.endsWith(" ")) {
            _telnetCmd = _telnetCmd + " ";
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Issuing command: " + _telnetCmd + pIP));
            log.info((Object)"If this command is not appropriate for your system please");
            log.info((Object)"set/reset your redcell.telnetcmd property in your property file.");
        }
        try {
            _rt.exec(_telnetCmd + pIP);
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
    }

    private void launchWebPage(OWBaseBean pCred) {
        log.debug((Object)"launchWebPage");
        Credentials _cred = (Credentials)pCred;
        RCBeanProxy _mitProxy = _cred.getManagementInterfaceType();
        String _miTypeName = (String)_mitProxy.get("Name");
        RCBeanProxy _authProxy = _cred.getAuthentication();
        try {
            this.emitInitiateEvent(_miTypeName, null);
            String _url = (String)_cred.getManagementInterface().get("IPAddress");
            String _userID = null;
            String _password = null;
            String _port = ((Integer)_cred.getManagementInterface().get("Port")).toString();
            _url = _url + ":" + _port;
            if (_authProxy != null) {
                _userID = (String)_authProxy.get("UserID");
                if (_userID != null && _userID.trim().length() > 0) {
                    _password = (String)_authProxy.get("Password");
                    _url = _miTypeName.toLowerCase() + "://" + _userID + ":" + _password + "@" + _url;
                } else {
                    _url = _miTypeName.toLowerCase() + "://" + _url;
                }
            } else {
                _url = "http://" + _url;
            }
            ((OWFCParentPanel)this.manager).getFormController().setBusy(true);
            LaunchBrowser.openURL((String)_url);
        }
        catch (IOException e) {
            log.error((Object)"IO problem launchging web page!", (Throwable)e);
        }
        ((OWFCParentPanel)this.manager).getFormController().setBusy(false);
    }

    public void updateForm(Object pNewItem) {
        log.debug((Object)"updateForm");
        String _compHashString = ((IRCNewItemPanel)pNewItem).getSelectedValue();
        Enumeration _credList = this.credentials.elements();
        while (_credList.hasMoreElements()) {
            Credentials _cred = (Credentials)_credList.nextElement();
            String _hashString = String.valueOf(_cred.hashCode());
            if (!_hashString.equals(_compHashString)) continue;
            String _miTypeName = (String)_cred.getManagementInterfaceType().get("Name");
            if (_miTypeName.equalsIgnoreCase(CT_HTTP) || _miTypeName.equalsIgnoreCase(CT_HTTPS)) {
                this.launchWebPage((OWBaseBean)_cred);
            } else {
                this.launchCutThru(_cred);
            }
            return;
        }
    }

    private void emitInitiateEvent(String pCutThruType, OWOID pOid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("emitInitiateEvent, " + pCutThruType + " for oid " + pOid));
        }
        try {
            RCCutThruEvent _cutThruEvent = new RCCutThruEvent();
            _cutThruEvent.setCutThruType(pCutThruType);
            _cutThruEvent.setUserID(RCUserUtil.getCurrentUser().getLoginName());
            _cutThruEvent.setDateTime(new Date());
            _cutThruEvent.setAction("initiating cut thru");
            _cutThruEvent.setOWOID(pOid);
            _cutThruEvent.emit();
        }
        catch (Exception e) {
            log.error((Object)"problem emitting cut through event", (Throwable)e);
        }
    }

    public void execute(IRCEntityEditor pEditor) {
        log.debug((Object)"execute <NOT IMPLEMENTED>");
    }

    public void onHelp() {
    }

    public static void main(String[] pArgs) {
        RCCutThruCommandHandler _handler = new RCCutThruCommandHandler();
        _handler.launchSimpleTelnetCutThru("192.168.0.162");
    }
}

