/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import com.dorado.common.utility.OWStringUtility;
import com.dorado.common.widget.components.OWPanel;
import com.dorado.common.widget.components.OWSplitPaneContainer;
import com.dorado.common.widget.components.OWTabPanelContainer;
import com.dorado.common.widget.components.OWTabbedPaneContainer;
import com.dorado.common.widget.components.explorer.IOWExplorerNodeContainer;
import com.dorado.common.widget.components.explorer.IOWExplorerWidget;
import com.dorado.common.widget.components.explorer.OWExplorerNodeContainer;
import com.dorado.common.widget.components.explorer.OWGDataWidget;
import com.dorado.common.widget.components.interfaces.IOWGAbstractButton;
import com.dorado.common.widget.components.interfaces.IOWGComponent;
import com.dorado.common.widget.components.interfaces.IOWGDataWidget;
import com.dorado.common.widget.components.interfaces.IOWGLabel;
import com.dorado.common.widget.components.interfaces.IOWGPanel;
import com.dorado.common.widget.components.interfaces.IOWGPathSelect;
import com.dorado.common.widget.components.interfaces.IOWGSplitPane;
import com.dorado.common.widget.components.interfaces.IOWGTabbedPane;
import com.dorado.common.widget.components.interfaces.IOWGTabbedPanel;
import com.dorado.core.message.OWMSGQuery;
import com.dorado.core.servlet.OWWebBuilderPanel;
import com.dorado.core.servlet.OWWebSplitPane;
import com.dorado.core.servlet.OWWebTabbedPane;
import com.dorado.core.servlet.OWWebTabbedPanel;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvUtil;
import java.awt.Component;
import java.awt.Font;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.border.TitledBorder;
import redcell.common.util.RedCellWorkSpaceUtil;

public class AvClientInternationalizer {
    private ResourceBundle bundle;
    private String language;
    private String country;
    private Locale currentLocale = Locale.getDefault();
    private String dfltLanguage;
    private String dfltCountry;
    private Locale dfltCurrentLocale;
    private static Font userFont;

    public AvClientInternationalizer(String bundleFile) {
        this.language = this.currentLocale.getLanguage();
        this.country = this.currentLocale.getCountry();
        this.dfltLanguage = new String(System.getProperty("Language", "en"));
        this.dfltCountry = new String(System.getProperty("Country", "US"));
        this.dfltCurrentLocale = new Locale(this.dfltLanguage, this.dfltCountry);
        AvTrace.traceln("AvIntl", 3, "System Language = " + this.language + "; country = " + this.country + "; Locale = " + this.currentLocale);
        AvTrace.traceln("AvIntl", 3, "Dflt   Language = " + this.dfltLanguage + "; country = " + this.dfltCountry + "; Locale = " + this.dfltCurrentLocale);
        AvTrace.traceln("AvIntl", 3, "bundleFile      = " + bundleFile);
        int titlesBundleIndex = bundleFile.indexOf("TitlesBundle");
        if (titlesBundleIndex >= 0) {
            String deviceBundle = "";
            try {
                deviceBundle = "com.ngnms.products." + bundleFile.substring(2, titlesBundleIndex).toLowerCase() + "." + bundleFile;
                this.bundle = ResourceBundle.getBundle(deviceBundle, this.currentLocale);
            }
            catch (Exception ex) {
                try {
                    this.bundle = ResourceBundle.getBundle(deviceBundle, this.dfltCurrentLocale);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
        }
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("com.ngnms.apps.common." + bundleFile, this.currentLocale);
            }
            catch (RuntimeException ex) {
                try {
                    this.bundle = ResourceBundle.getBundle("com.ngnms.apps.common." + bundleFile, this.dfltCurrentLocale);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
        }
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle(bundleFile, this.currentLocale);
            }
            catch (RuntimeException ex) {
                this.bundle = ResourceBundle.getBundle(bundleFile, this.dfltCurrentLocale);
            }
        }
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public Locale getDfltCurrentLocale() {
        return this.dfltCurrentLocale;
    }

    public static Font getFont() {
        if (AvUtil.isAppServerSide()) {
            return null;
        }
        return userFont;
    }

    public void translateNodes(IOWGDataWidget node) {
        if (AvUtil.isAppServerSide()) {
            return;
        }
        node.setFont(userFont);
        AvTrace.traceln("AvIntl", 3, "Set Widget Font = " + userFont.getFontName());
        IOWExplorerNodeContainer _root = node.getRoot();
        Vector _nodes = _root.getChildren();
        this.translateSubNodes(_nodes, node);
        node.refresh();
    }

    public void translateHeader(IOWGDataWidget node) {
        if (AvUtil.isAppServerSide()) {
            return;
        }
        try {
            node.setFont(userFont);
            AvTrace.traceln("AvIntl", 3, "Set Column Header Font = " + userFont.getFontName());
            IOWExplorerNodeContainer _root = node.getColumnHeaderRoot();
            Vector _nodes = _root.getChildren();
            Iterator _nodesIter = _nodes.iterator();
            while (_nodesIter.hasNext()) {
                try {
                    String _nodeStyle = ((IOWExplorerNodeContainer)_nodesIter.next()).getNode().getStyleID();
                    AvTrace.traceln("AvIntl", 3, "Update Font for Column Header Style = " + _nodeStyle);
                    node.getRowHeaderStyle(_nodeStyle).setFont(userFont);
                    AvTrace.traceln("AvIntl", 3, "Set Column Header Node Font = " + userFont.getFontName());
                }
                catch (Exception e) {}
            }
            AvTrace.traceln("AvIntl", 3, "Table ColumnHeaderRoot Nodes size = " + _nodes.size());
            this.translateSubNodes(_nodes, node);
            node.refresh();
        }
        catch (MissingResourceException _e) {
            AvTrace.traceStack("AvIntl", 3, _e);
        }
        catch (Exception _e) {
            AvTrace.traceStack("AvIntl", 3, _e);
        }
    }

    public void translateRowHeader(IOWGDataWidget node) {
        if (AvUtil.isAppServerSide()) {
            return;
        }
        try {
            node.setFont(userFont);
            AvTrace.traceln("AvIntl", 3, "Set Row Header Font = " + userFont.getFontName());
            IOWExplorerNodeContainer _root = node.getRowHeaderRoot();
            Vector _nodes = _root.getChildren();
            Iterator _nodesIter = _nodes.iterator();
            while (_nodesIter.hasNext()) {
                try {
                    String _nodeStyle = ((IOWExplorerNodeContainer)_nodesIter.next()).getNode().getStyleID();
                    AvTrace.traceln("AvIntl", 3, "Update Font for Row Header Style = " + _nodeStyle);
                    node.getColumnHeaderStyle(_nodeStyle).setFont(userFont);
                    AvTrace.traceln("AvIntl", 3, "Set Row Header Node Font = " + userFont.getFontName());
                }
                catch (Exception e) {}
            }
            AvTrace.traceln("AvIntl", 3, "Table RowHeaderRoot Nodes size = " + _nodes.size());
            this.translateSubNodes(_nodes, node);
            node.refresh();
        }
        catch (MissingResourceException _e) {
            AvTrace.traceStack("AvIntl", 3, _e);
        }
        catch (Exception _e) {
            AvTrace.traceStack("AvIntl", 3, _e);
        }
    }

    public void translateSubNodes(Vector subNodes, IOWGDataWidget widget) {
        if (AvUtil.isAppServerSide()) {
            return;
        }
        if (subNodes.size() == 0) {
            return;
        }
        try {
            for (int i = 0; i < subNodes.size(); ++i) {
                String oldSubStr = ((IOWExplorerNodeContainer)subNodes.elementAt(i)).getNode().getText().trim();
                if (oldSubStr.equals("") || !OWStringUtility.isAlphaNumericWithNoSpaces((String)oldSubStr)) continue;
                String newSubStr = this.translateText(oldSubStr);
                ((IOWExplorerNodeContainer)subNodes.elementAt(i)).getNode().setText(newSubStr);
                AvTrace.traceln("AvIntl", 3, oldSubStr + " = " + newSubStr);
                try {
                    String _nodeStyle = ((IOWExplorerNodeContainer)subNodes.elementAt(i)).getNode().getStyleID();
                    AvTrace.traceln("AvIntl", 3, "Update Font for Style = " + _nodeStyle);
                    widget.getStyle(_nodeStyle).setFont(userFont);
                    AvTrace.traceln("AvIntl", 3, "Set Node Font = " + userFont.getFontName());
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.translateSubNodes(((OWExplorerNodeContainer)subNodes.elementAt(i)).getChildren(), widget);
            }
        }
        catch (Exception _e) {
            AvTrace.traceStack("AvIntl", 3, _e);
        }
    }

    public void translateTabbedPane(IOWGTabbedPane tabbedPane) {
        if (AvUtil.isAppServerSide()) {
            return;
        }
        if (tabbedPane == null) {
            AvTrace.traceln("AvIntl", 3, "TabbedPane to translate is NULL !");
            return;
        }
        tabbedPane.setFont(userFont);
        AvTrace.traceln("AvIntl", 3, "Set TabbedPane Font = " + userFont.getFontName());
        Component[] _comps = new Component[]{};
        if (tabbedPane instanceof OWWebTabbedPane) {
            _comps = ((OWWebTabbedPane)tabbedPane).getComponents();
        } else if (tabbedPane instanceof OWTabbedPaneContainer) {
            _comps = ((OWTabbedPaneContainer)tabbedPane).getComponents();
            if (((OWTabbedPaneContainer)tabbedPane).getBorder() instanceof TitledBorder) {
                this.translateTitledBorder((TitledBorder)((OWTabbedPaneContainer)tabbedPane).getBorder());
            }
        }
        for (int i = 0; i < _comps.length; ++i) {
            if (!(_comps[i] instanceof IOWGTabbedPanel)) continue;
            AvTrace.traceln("AvIntl", 3, "translateTabPanel: IOWGTabbedPanel ----> ");
            this.translateTabPanel((IOWGTabbedPanel)_comps[i]);
        }
    }

    public void translateTabPanel(IOWGTabbedPanel tab) {
        if (AvUtil.isAppServerSide()) {
            return;
        }
        Component[] _comps = new Component[]{};
        if (tab == null) {
            AvTrace.traceln("AvIntl", 3, "TabPanel to translate is NULL !");
            return;
        }
        try {
            tab.setFont(userFont);
            AvTrace.traceln("AvIntl", 3, "Set Tab Panel Title Font = " + userFont.getFontName());
            tab.setTitle(this.translateText(tab.getTitle()));
        }
        catch (Exception _e) {
            AvTrace.traceStack("AvIntl", 3, _e);
        }
        try {
            if (tab instanceof OWTabPanelContainer) {
                _comps = ((OWTabPanelContainer)tab).getComponents();
            } else if (tab instanceof OWWebTabbedPanel) {
                _comps = ((OWWebTabbedPanel)tab).getComponents();
            }
            for (int i = 0; i < _comps.length; ++i) {
                if (!(_comps[i] instanceof IOWGComponent)) continue;
                this.translateComponent((IOWGComponent)_comps[i]);
            }
        }
        catch (Exception _e) {
            AvTrace.traceStack("AvIntl", 3, _e);
        }
    }

    public void translatePanel(IOWGPanel panel) {
        if (AvUtil.isAppServerSide()) {
            return;
        }
        if (panel == null) {
            AvTrace.traceln("AvIntl", 3, "Panel to translate is NULL !");
            return;
        }
        try {
            Component[] _comps = new Component[]{};
            if (panel instanceof OWPanel) {
                _comps = ((OWPanel)panel).getComponents();
                if (((OWPanel)panel).getBorder() instanceof TitledBorder) {
                    this.translateTitledBorder((TitledBorder)((OWPanel)panel).getBorder());
                }
            } else if (panel instanceof OWWebBuilderPanel) {
                _comps = ((OWWebBuilderPanel)panel).getComponents();
            }
            for (int i = 0; i < _comps.length; ++i) {
                if (!(_comps[i] instanceof IOWGComponent)) continue;
                this.translateComponent((IOWGComponent)_comps[i]);
            }
        }
        catch (Exception _e) {
            AvTrace.traceStack("AvIntl", 3, _e);
        }
    }

    public void translateTitledBorder(TitledBorder tb) {
        if (AvUtil.isAppServerSide()) {
            return;
        }
        tb.setTitle(this.translateText(tb.getTitle()));
    }

    public String translateText(String text) {
        if (text == null) {
            return null;
        }
        try {
            return this.bundle.getString(text);
        }
        catch (Exception e) {
            AvTrace.traceln("AvIntl", 1, "--> ERROR: " + e.getMessage());
            return text;
        }
    }

    public String translateText(String pText, String[] pParams) {
        String translatedText = pText;
        try {
            translatedText = this.translateText(pText);
            if (pParams != null) {
                return OWMSGQuery.substParms((String)translatedText, (String[])pParams);
            }
            return translatedText;
        }
        catch (Exception e) {
            AvTrace.traceln("AvIntl", 1, "--> ERROR: " + e.getMessage());
            return translatedText;
        }
    }

    private void translateComponent(IOWGComponent pComp) {
        AvTrace.traceln("AvIntl", 3, "translateComponent: " + pComp.getClass().getName());
        String text = pComp.getToolTipText();
        if (text != null) {
            pComp.setToolTipText(this.translateText(text));
        }
        if (pComp instanceof IOWGDataWidget) {
            if (((IOWExplorerWidget)pComp).getViewType() == 6) {
                this.translateHeader((IOWGDataWidget)pComp);
            }
            if (pComp instanceof OWGDataWidget && ((OWGDataWidget)pComp).getBorder() instanceof TitledBorder) {
                this.translateTitledBorder((TitledBorder)((OWGDataWidget)pComp).getBorder());
            }
        } else if (pComp instanceof IOWGLabel) {
            if (!"".equals(((IOWGLabel)pComp).getText())) {
                AvTrace.traceln("AvIntl", 3, "translatePanel: IOWGLabel ----> " + ((IOWGLabel)pComp).getText());
                ((IOWGLabel)pComp).setText(this.translateText(((IOWGLabel)pComp).getText()));
            }
        } else if (pComp instanceof IOWGAbstractButton) {
            text = ((IOWGAbstractButton)pComp).getText();
            if (!"".equals(text)) {
                ((IOWGAbstractButton)pComp).setText(this.translateText(text));
            }
        } else if (pComp instanceof IOWGPathSelect) {
            text = ((IOWGPathSelect)pComp).getTitle();
            ((IOWGPathSelect)pComp).setTitle(this.translateText(text));
        } else if (pComp instanceof IOWGPanel) {
            this.translatePanel((IOWGPanel)pComp);
        } else if (pComp instanceof IOWGSplitPane) {
            this.translateSplitPane((IOWGSplitPane)pComp);
        } else if (pComp instanceof IOWGTabbedPane) {
            this.translateTabbedPane((IOWGTabbedPane)pComp);
        }
    }

    public void translateSplitPane(IOWGSplitPane splitPane) {
        if (AvUtil.isAppServerSide()) {
            return;
        }
        Component[] _comps = new Component[]{};
        splitPane.setFont(userFont);
        if (splitPane instanceof OWWebSplitPane) {
            _comps = ((OWWebSplitPane)splitPane).getComponents();
        } else if (splitPane instanceof OWSplitPaneContainer) {
            _comps = ((OWSplitPaneContainer)splitPane).getComponents();
            if (((OWSplitPaneContainer)splitPane).getBorder() instanceof TitledBorder) {
                this.translateTitledBorder((TitledBorder)((OWSplitPaneContainer)splitPane).getBorder());
            }
        }
        for (int i = 0; i < _comps.length; ++i) {
            if (!(_comps[i] instanceof IOWGPanel)) continue;
            this.translatePanel((IOWGPanel)_comps[i]);
        }
    }

    public static String getMessageKey(String category, String messageID) {
        return category + "." + messageID;
    }

    public static String getFormattedMessageFromBundle(String pBundleFile, String pCategory, String pMessageID, String[] pParams) {
        AvClientInternationalizer internationalizer = new AvClientInternationalizer(pBundleFile);
        String key = AvClientInternationalizer.getMessageKey(pCategory, pMessageID);
        String msg = internationalizer.translateText(key, pParams);
        if (msg.equals(key)) {
            msg = internationalizer.translateText(pMessageID, pParams);
        }
        return msg;
    }

    static {
        if (!AvUtil.isAppServerSide()) {
            try {
                StringTokenizer _st = new StringTokenizer(RedCellWorkSpaceUtil.getProperty((String)"redcell.userFont", (String)"Arial Unicode MS,0,12"), ",");
                userFont = new Font(_st.nextToken(), Integer.parseInt(_st.nextToken()), Integer.parseInt(_st.nextToken()));
            }
            catch (Exception _e) {
                AvTrace.traceln("AvIntl", 3, "Error parsing redcell.userFont; using default (" + _e.getMessage() + ")");
                userFont = new Font("Arial Unicode MS", 0, 12);
            }
        }
    }
}

