/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.common;

import com.ngnms.common.AvException;
import com.ngnms.common.AvFormID;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;

public class AvClientID
implements Serializable {
    private static AvClientID instance = null;
    private String id;

    private AvClientID(String pAppName, String pIpAddress, String pStartTime) {
        this.id = pAppName + "_" + pIpAddress + "_" + pStartTime;
    }

    public static AvClientID getInstance() throws AvException {
        if (instance == null) {
            String appName = System.getProperty("AV_APP_NAME");
            String ipAddress = null;
            try {
                ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                throw new AvException(e, "Failure To Get Local Host IP Address");
            }
            String startTime = new Long(new Date().getTime()).toString();
            instance = new AvClientID(appName, ipAddress, startTime);
        }
        return instance;
    }

    public String getID() {
        return this.id;
    }

    public String getAppName() {
        return this.id.substring(0, this.id.indexOf("_"));
    }

    public String getIpAddress() {
        return this.id.substring(this.id.indexOf("_") + 1, this.id.lastIndexOf("_"));
    }

    public String getStartTime() {
        return this.id.substring(this.id.lastIndexOf("_") + 1);
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(AvFormID pClientID) {
        return this.id.equals(pClientID.getID());
    }
}

