/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.swupgrade;

import com.dorado.common.utility.OWOID;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.ejb.ruleengine.IOWRuleEngineRuleInterface;
import com.dorado.runtime.IOWBean;
import com.ngnms.apps.common.AvSessionScheduler;
import com.ngnms.apps.common.AvSessionUtil;
import com.ngnms.apps.swupgrade.AvSwUpgradeActiveSession;
import com.ngnms.apps.swupgrade.AvSwUpgradeJobDescriptor;
import com.ngnms.apps.swupgrade.AvSwUpgradeSession;
import com.ngnms.apps.swupgrade.AvSwUpgradeSessions;
import com.ngnms.common.AvBeanProxy;
import com.ngnms.common.AvException;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvWorkSpace;
import com.ngnms.services.common.AvJobID;
import com.ngnms.services.common.AvServiceUtil;
import com.ngnms.services.common.AvSimpleJobItems;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import redcell.common.util.RCBOMUtil;

public class AvSwUpgradeUtil
extends AvSessionUtil {
    private static final String SCHEDULE_EVENT_NAME = "com.ngnms.apps.swupgrade.AvSwUpgradeScheduledRuleParamSet";
    public static final String WORKSPACE_NAME = "AvSwUpgrade_WorkSpace";
    public static final String TFTP_SESSION_PREFIX = "SWUPG_";
    public static final String TFTP_LISTENER_ID = "SWUPG";
    public static final String TFTP_UPLOAD_OPERATION = "Upload";
    public static final String TFTP_DOWNLOAD_OPERATION = "Download";
    public static final String MODE_ALWAYS = "ALWAYS";
    public static final String MODE_DIF_CURRENT = "DIFFERENT_FROM_CURRENT";
    public static final String MODE_DIF_SHADOW = "DIFFERENT_FROM_SHADOW";
    public static final String MODE_DIF_BOTH = "DIFFERENT_FROM_BOTH";
    public static final String FINISHED_DEVICE_STATUS_IGNORED = "IGNORED";
    public static final String RELATIVE_PATH_NOT_FOUND = "RelativeLocalFilePath_NotFound";
    public static final int SW_UPGRADE_WS_TIMEOUT = 2 * AvServiceUtil.getWorkSpaceTimeout();

    public static void executeJob(IOWRuleEngineRuleInterface pRE, AvSwUpgradeJobDescriptor pJob) throws AvException {
        block4: {
            try {
                String sessionName = pJob.getRequestorID();
                AvSwUpgradeSession session = AvSwUpgradeUtil.getSessionByName(pRE.getBOM(), sessionName);
                if (session != null) {
                    AvTrace.traceln("SWUpgrade", 2, "^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                    AvTrace.traceln("SWUpgrade", 2, "In AvSwUpgradeUtil.executeJob - sessionName = " + sessionName);
                    AvSwUpgradeUtil.lockSession(sessionName);
                    boolean setJobBusyOK = AvSwUpgradeUtil.setJobBusy(pRE, session.getJobID());
                    AvSwUpgradeUtil.unlockSession(sessionName);
                    AvTrace.traceln("SWUpgrade", 2, "setJobBusyOK  = " + setJobBusyOK);
                    int cycleProgress = session.getCycleProgress();
                    AvTrace.traceln("SWUpgrade", 2, "cycleProgress = " + cycleProgress);
                    if (setJobBusyOK) {
                        AvSwUpgradeActiveSession activeSession = AvSwUpgradeSessions.getActiveSession(pRE, sessionName);
                        activeSession.initialize(pRE, session);
                        activeSession.logSession(pRE);
                        activeSession.startSession(pRE);
                    }
                    break block4;
                }
                throw new AvException("Session: " + sessionName + " could not be found.");
            }
            catch (Exception e) {
                throw new AvException(e, "Failed to Execute Job.");
            }
        }
    }

    public static AvJobID scheduleSession(IOWRuleEngineRuleInterface pRE, AvBeanProxy pSessionProxy, boolean pRetry) throws AvException {
        long nowLong;
        String sessionName = pSessionProxy.getAsString("Name");
        AvBeanProxy schedulerProxy = pSessionProxy.getAsProxy("Scheduler");
        int intervalUnits = schedulerProxy.getAsInt("IntervalUnits");
        int intervalValue = schedulerProxy.getAsInt("IntervalValue");
        long startDateLong = schedulerProxy.getAsLong("StartDate");
        if (startDateLong < (nowLong = System.currentTimeMillis())) {
            startDateLong = nowLong;
        }
        long endDateLong = 0L;
        if (intervalUnits == 2) {
            endDateLong = startDateLong + (long)(intervalValue * 1000 * 60);
        } else if (intervalUnits == 4) {
            endDateLong = startDateLong + (long)(intervalValue * 1000 * 60 * 60);
        }
        AvTrace.traceln("SWUpgrade", 2, "StartDate: " + new Date(startDateLong).toString());
        AvJobID jobID = null;
        try {
            IOWBOMClient bomAPI = pRE.getBOM();
            AvSwUpgradeUtil.lockSession(sessionName);
            AvSwUpgradeSession session = AvSwUpgradeUtil.getSessionByName(bomAPI, sessionName);
            bomAPI.getObjectForUpdate((IOWBean)session);
            session.setAction(pRetry ? "AvSession_RETRY" : "AvSession_START");
            bomAPI.commitObject((IOWBean)session);
            bomAPI.commitAll();
            AvSwUpgradeJobDescriptor descriptor = new AvSwUpgradeJobDescriptor(pSessionProxy.getAsString("Name"), new AvSimpleJobItems(new Vector()), 1, startDateLong, endDateLong, 1, 0);
            jobID = AvSwUpgradeUtil.scheduleJob(pRE, descriptor, SCHEDULE_EVENT_NAME);
            AvTrace.traceln("SWUpgrade", 2, "Job ID :" + jobID.getOID());
            AvSwUpgradeActiveSession activeSession = AvSwUpgradeSessions.getActiveSession(pRE, sessionName);
            activeSession.initialize(pRE, session);
            activeSession.sessionScheduled(pRE);
            activeSession.logSession(pRE);
            AvSwUpgradeUtil.unlockSession(sessionName);
        }
        catch (Exception e) {
            AvTrace.traceln("SWUpgrade", 1, "Could not schedule Job: " + jobID);
            throw new AvException(e, "ErrorStartingSession");
        }
        return jobID;
    }

    public static void resumeSession(IOWRuleEngineRuleInterface pRE, AvBeanProxy pSessionProxy) throws AvException {
        AvJobID jobID = null;
        try {
            String sessionName = pSessionProxy.getAsString("Name");
            AvSwUpgradeUtil.lockSession(sessionName);
            AvSwUpgradeSession session = (AvSwUpgradeSession)RCBOMUtil.getOWObjectForUpdate((IOWBOMClient)pRE.getBOM(), (OWOID)pSessionProxy.getOWOID());
            session.setAction("AvSession_RESUME");
            pRE.getBOM().commitObject((IOWBean)session);
            pRE.getBOM().commitAll();
            jobID = (AvJobID)pSessionProxy.get("JobID");
            AvSessionUtil.resumeJob(pRE, jobID);
            AvSwUpgradeUtil.unlockSession(sessionName);
        }
        catch (Exception e) {
            AvTrace.traceln("SWUpgrade", 1, "Could not resume Job: " + jobID);
        }
    }

    public static void pauseSession(IOWRuleEngineRuleInterface pRE, AvBeanProxy pSessionProxy) throws AvException {
        AvJobID jobID = null;
        try {
            String sessionName = pSessionProxy.getAsString("Name");
            AvSwUpgradeSession session = AvSwUpgradeUtil.getSessionByName(pRE.getBOM(), sessionName);
            AvSwUpgradeActiveSession activeSession = AvSwUpgradeSessions.getActiveSession(pRE, pSessionProxy.getAsString("Name"));
            activeSession.pauseSession(pRE);
            AvSwUpgradeUtil.lockSession(sessionName);
            jobID = (AvJobID)pSessionProxy.get("JobID");
            AvSessionUtil.pauseJob(pRE, jobID);
            AvSwUpgradeUtil.unlockSession(sessionName);
        }
        catch (Exception e) {
            AvTrace.traceln("SWUpgrade", 1, "Could not pauseJob: " + jobID);
            AvTrace.traceStack("SWUpgrade", 2, e);
        }
    }

    public static void stopSession(IOWRuleEngineRuleInterface pRE, AvBeanProxy pSessionProxy) throws AvException {
        AvJobID jobID = null;
        try {
            IOWBOMClient bomAPI = pRE.getBOM();
            String sessionName = pSessionProxy.getAsString("Name");
            AvSwUpgradeUtil.lockSession(sessionName);
            AvSwUpgradeSession session = AvSwUpgradeUtil.getSessionByName(bomAPI, pSessionProxy.getAsString("Name"));
            AvSwUpgradeActiveSession activeSession = AvSwUpgradeSessions.getActiveSession(pRE, sessionName);
            String sessionStatus = session.getStatus();
            if (!("AvSession_SCHEDULED".equals(sessionStatus) || "AvSession_FINISHED".equals(sessionStatus) || "AvSession_ABORTED".equals(sessionStatus))) {
                activeSession.cancelSession(pRE);
            }
            jobID = (AvJobID)pSessionProxy.get("JobID");
            AvSessionUtil.deleteJob(pRE, jobID);
            bomAPI.refreshObject((IOWBean)session);
            bomAPI.getObjectForUpdate((IOWBean)session);
            session.getScheduler().setEndDate(System.currentTimeMillis());
            bomAPI.commitObject((IOWBean)session);
            bomAPI.commitAll();
            activeSession.logSession(pRE);
            AvSwUpgradeUtil.unlockSession(sessionName);
        }
        catch (Exception e) {
            AvTrace.traceln("SWUpgrade", 1, "Could not deleteJob: " + jobID);
            throw new AvException(e, "CouldNotStopSession");
        }
    }

    public static AvSwUpgradeSession getSessionByName(IOWBOMClient pBOM, String pName) throws AvException {
        try {
            OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs("com.ngnms.apps.swupgrade.AvSwUpgradeSession", new OWBOMAttribValueOperator("Name", false, "=", pName), false);
            Vector res = (Vector)pBOM.getObjects((OWBOMQuery)qba).getRtnObject();
            return (AvSwUpgradeSession)res.firstElement();
        }
        catch (OWBOMNotFoundException nfe) {
            throw new AvException("SW Upgrade Session with name " + pName + " NOT FOUND!");
        }
        catch (Exception e) {
            throw new AvException(e, "Could not retrieve SW Upgrade Session with name " + pName);
        }
    }

    public static void updateStatus(IOWRuleEngineRuleInterface pRE, String pSessionID, String pDeviceOID, String pOperation, String pService, String pStatusString, String pDetailString, Object pDetailData) throws AvException {
        try {
            AvSwUpgradeActiveSession activeSession = AvSwUpgradeSessions.getActiveSession(pRE, pSessionID);
            activeSession.updateStatus(pRE, pDeviceOID, pOperation, pService, pStatusString, pDetailString, pDetailData);
        }
        catch (Exception e) {
            AvTrace.traceStack("SWUpgrade", 1, e);
            throw new AvException(e, "Failed to Execute Job.");
        }
    }

    public static void finalizeSession(IOWRuleEngineRuleInterface pRE, AvSwUpgradeSession pSession, String pSessionStatus) {
        AvTrace.traceln("SWUpgrade", 1, "In AvSwUpgradeUtil.finalizeSession - sessionName = " + pSession.getName());
        try {
            IOWBOMClient bomAPI = pRE.getBOM();
            String sessionName = pSession.getName();
            AvSwUpgradeUtil.lockSession(sessionName);
            pSession = (AvSwUpgradeSession)bomAPI.getObjectForUpdate((IOWBean)pSession);
            pSession.setStatus(pSessionStatus);
            bomAPI.commitObject((IOWBean)pSession);
            bomAPI.commitAll();
            AvSessionScheduler scheduler = pSession.getScheduler();
            bomAPI.getObjectForUpdate((IOWBean)scheduler);
            scheduler.setEndDate(System.currentTimeMillis());
            bomAPI.commitObject((IOWBean)scheduler);
            bomAPI.commitAll();
            AvSwUpgradeActiveSession activeSession = AvSwUpgradeSessions.getActiveSession(pSession.getName());
            activeSession.logSession(pRE);
            AvSwUpgradeUtil.unlockSession(sessionName);
        }
        catch (Exception e) {
            AvTrace.traceln("SWUpgrade", 1, "Could not finalize session: " + pSession.getName());
            AvTrace.traceStack("SWUpgrade", 2, e);
        }
    }

    public static Collection getActiveSessionsForDevice(IOWRuleEngineRuleInterface pRE, String pDeviceOID) {
        return AvSwUpgradeSessions.getActiveSessionsForDevice(pRE, pDeviceOID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean lockSession(String pSessionName) throws Exception {
        AvTrace.traceln("SWUpgrade", 2, "LOCK session: " + pSessionName);
        AvWorkSpace ws = null;
        ws = AvWorkSpace.getAndLockWorkSpace("AvSwUpgradeSession_WorkSpace", AvSessionUtil.getWorkSpaceTimeout());
        HashSet<String> busySessions = (HashSet<String>)ws.getObject("BusySessions");
        if (null == busySessions) {
            busySessions = new HashSet<String>();
        }
        if (busySessions.contains(pSessionName)) {
            ws.closeWorkSpace();
            ws = null;
            AvTrace.traceln("SWUpgrade", 2, "Update Session: SESSION IS BUSY.");
            boolean bl = false;
            return bl;
        }
        busySessions.add(pSessionName);
        ws.putObject("BusySessions", busySessions);
        ws.closeWorkSpace();
        ws = null;
        boolean bl = true;
        return bl;
        finally {
            if (null != ws) {
                try {
                    ws.closeWorkSpace();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlockSession(String pSessionName) throws Exception {
        AvTrace.traceln("SWUpgrade", 2, "UNLOCK session: " + pSessionName);
        AvWorkSpace ws = null;
        try {
            ws = AvWorkSpace.getAndLockWorkSpace("AvSwUpgradeSession_WorkSpace", AvSessionUtil.getWorkSpaceTimeout());
            HashSet busySessions = (HashSet)ws.getObject("BusySessions");
            if (busySessions != null) {
                busySessions.remove(pSessionName);
                ws.putObject("BusySessions", busySessions);
            }
            ws.closeWorkSpace();
            ws = null;
        }
        finally {
            if (null != ws) {
                try {
                    ws.closeWorkSpace();
                }
                catch (Exception exception) {}
            }
        }
    }
}

