/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.swupgrade;

import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.core.rulemgmt.OWRuleInfo;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.apps.swupgrade.AvSwUpgradeSession;
import com.ngnms.apps.swupgrade.AvSwUpgradeStartupRule;
import com.ngnms.common.AvException;
import com.ngnms.common.AvServerStartupEvent;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvWorkSpace;
import com.ngnms.services.common.AvServiceUtil;
import java.util.HashSet;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AvSwUpgradeStartupRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvSwUpgradeStartupRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvSwUpgradeStartupRule.run()");
        this.runRule((AvServerStartupEvent)event);
        AvTrace.traceln("AvCS", 1, "<AvSwUpgradeStartupRule.run()");
    }

    public void runRule(AvServerStartupEvent pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        try {
            AvTrace.traceln("SWUpgrade", 3, "AvSwUpgradeStartupRule ...");
            this.loadRule(new OWRuleInfo("com.ngnms.apps.swupgrade.AvSwUpgradeScheduledRule", 1, 1, false));
            AvTrace.traceln("SWUpgrade", 3, "AvSwUpgradeStartupRule: Initializing the AvSwUpgrade_WorkSpace");
            AvWorkSpace avws = AvWorkSpace.getAndLockWorkSpace("AvSwUpgrade_WorkSpace", AvServiceUtil.getWorkSpaceTimeout());
            avws.putObject("Initialized", new Boolean(true));
            avws.closeWorkSpace();
            AvTrace.traceln("SWUpgrade", 3, "AvSwUpgradeStartupRule: Initializing the AvSwUpgradeSession_WorkSpace");
            avws = AvWorkSpace.getAndLockWorkSpace("AvSwUpgradeSession_WorkSpace", AvServiceUtil.getWorkSpaceTimeout());
            avws.putObject("BusySessions", new HashSet());
            avws.closeWorkSpace();
            String[] rules = new String[]{"com.ngnms.apps.swupgrade.AvSwUpgradeTFTPNotificationListener"};
            int[] ruleCount = new int[]{5};
            try {
                for (int i = 0; i < rules.length; ++i) {
                    int count = Integer.getInteger(rules[i] + ".count", ruleCount[i]);
                    this.loadRule(new OWRuleInfo(rules[i], 1, count, false));
                    AvTrace.traceln("SWUpgrade", 1, "Loaded: " + rules[i] + ", " + count + " instances");
                }
            }
            catch (Exception e) {
                throw new AvException(e, "Failed to initialize the Sw Upgrade");
            }
            this.initSessions();
        }
        catch (Exception e) {
            throw new AvException(e, "Failure to initialize the Sw Upgrade.");
        }
    }

    private void initSessions() throws Exception {
        try {
            OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs("com.ngnms.apps.swupgrade.AvSwUpgradeSession", false);
            OWBOMAttribValueOperator avo = new OWBOMAttribValueOperator("NumOfRunning", ">", (Object)new Integer(0));
            qba.addAttribValueOperator(avo);
            Vector results = (Vector)this.getBOM().getObjects((OWBOMQuery)qba).getRtnObject();
            AvTrace.traceln("SWUpgrade", 1, "Sessions with (NumOfRunning > 0): " + results.size());
            for (int i = 0; i < results.size(); ++i) {
                AvSwUpgradeSession session = (AvSwUpgradeSession)results.elementAt(i);
                this.getBOM().getObjectForUpdate((IOWBean)session);
                session.setNumOfRunning(0);
                AvTrace.traceln("SWUpgrade", 1, "Session: " + session.getName() + " - Initialized.");
                this.getBOM().commitObject((IOWBean)session);
            }
            this.getBOM().commitAll();
        }
        catch (OWBOMNotFoundException e) {
            AvTrace.traceln("SWUpgrade", 1, "Sessions with (NumOfRunning > 0) Not Found.");
        }
    }
}

