/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.swupgrade;

import com.dorado.core.bom.OWBOMQueryByKey;
import com.dorado.core.ejb.ruleengine.IOWRuleEngineRuleInterface;
import com.ngnms.apps.swupgrade.AvSwUpgradeActiveSession;
import com.ngnms.apps.swupgrade.AvSwUpgradeSession;
import com.ngnms.common.AvLookup;
import com.ngnms.common.AvTrace;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;

public class AvSwUpgradeSessions {
    public static final String SW_UPGRADE_SESSION_CLASSNAME = "com.ngnms.apps.swupgrade.AvSwUpgradeSession";
    private static Hashtable activeSessions = new Hashtable();

    private AvSwUpgradeSessions() {
    }

    public static AvSwUpgradeActiveSession getActiveSession(String pName) {
        return (AvSwUpgradeActiveSession)activeSessions.get(pName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AvSwUpgradeActiveSession getActiveSession(IOWRuleEngineRuleInterface pRE, String pName) {
        AvTrace.traceln("SWUpgrade", 3, "In getActiveSession " + pName);
        AvSwUpgradeActiveSession session = null;
        Hashtable hashtable = activeSessions;
        synchronized (hashtable) {
            session = AvSwUpgradeSessions.getActiveSession(pName);
            if (null == session) {
                try {
                    session = AvSwUpgradeSessions.createSwUpgradeActiveSession(pRE, pName);
                    activeSessions.put(pName, session);
                }
                catch (Exception _e) {
                    AvTrace.traceln("SWUpgrade", 1, "ERROR: Could not retrieve session " + pName);
                    AvTrace.traceStack("SWUpgrade", 2, _e);
                }
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeActiveSession(String pName) {
        Hashtable hashtable = activeSessions;
        synchronized (hashtable) {
            AvSwUpgradeActiveSession session = (AvSwUpgradeActiveSession)activeSessions.get(pName);
            if (null != session) {
                activeSessions.remove(pName);
            }
        }
    }

    public static Collection getActiveSessionsForDevice(IOWRuleEngineRuleInterface pRE, String pDeviceOID) {
        Vector<AvSwUpgradeActiveSession> ret = new Vector<AvSwUpgradeActiveSession>();
        for (AvSwUpgradeActiveSession session : activeSessions.values()) {
            if (!session.servicesDevice(pRE, pDeviceOID)) continue;
            ret.add(session);
        }
        return ret;
    }

    private static AvSwUpgradeActiveSession createSwUpgradeActiveSession(IOWRuleEngineRuleInterface pRE, String pName) throws Exception {
        OWBOMQueryByKey qbk = new OWBOMQueryByKey(SW_UPGRADE_SESSION_CLASSNAME, pName, false);
        AvSwUpgradeSession swSession = (AvSwUpgradeSession)pRE.getBOM().getObject(qbk).getRtnObject();
        String productLine = swSession.getProductLineName();
        String className = AvLookup.get("SwUpgradeSessionOperations", productLine);
        Class<?> clazz = Class.forName(className);
        AvSwUpgradeActiveSession activeSession = (AvSwUpgradeActiveSession)clazz.newInstance();
        activeSession.initialize(pRE, swSession);
        return activeSession;
    }
}

