/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.swupgrade;

import RedCell.Config.NetworkResource;
import com.dorado.common.utility.OWOID;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.bom.OWBOMQueryByOWOIDs;
import com.dorado.core.bom.OWBOMQueryByReferenceAttribute;
import com.dorado.core.ejb.ruleengine.IOWRuleEngineRuleInterface;
import com.dorado.runtime.IOWBean;
import com.ngnms.apps.common.AvSession;
import com.ngnms.apps.common.AvSessionUtil;
import com.ngnms.apps.common.IAvSessionHandler;
import com.ngnms.apps.swupgrade.AvSwUpgradeDevice;
import com.ngnms.apps.swupgrade.AvSwUpgradeUtil;
import com.ngnms.common.AvBeanProxy;
import com.ngnms.common.AvException;
import com.ngnms.common.AvLookup;
import com.ngnms.common.AvLookupItemNotFoundException;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvWorkSpace;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;

public class AvSwUpgradeSessionHelper
implements IAvSessionHandler {
    public static final String SW_UPGRADE_WORKSPACE = "AvSwUpgradeSession_WorkSpace";
    public static final String SW_UPGRADE_DEV_CLS_NAME = "AvSwUpgradeDeviceClassName";
    public static String SW_UPGRADE_ENTITY_CLASS = "com.ngnms.apps.swupgrade.AvSwUpgradeDevice";

    public String performSessionAction(IOWRuleEngineRuleInterface pRE, AvBeanProxy pSessionProxy, String pAction, String pUserID) {
        AvTrace.traceln("SWUpgrade", 2, "performSessionAction: " + pAction);
        String errorString = null;
        if (pAction.equals("AvSession_DELETE")) {
            if (!AvSwUpgradeSessionHelper.deleteSession(pRE, pSessionProxy)) {
                errorString = "SessionDeletionFailed";
            }
        } else {
            try {
                String sessionStatus = pSessionProxy.getAsString("Status");
                if (pAction.equals("AvSession_START") || pAction.equals("AvSession_RETRY")) {
                    int numOfRunning = pSessionProxy.getAsInt("NumOfRunning");
                    if (sessionStatus.equals("AvSession_RUNNING") || sessionStatus.equals("AvSession_SCHEDULED")) {
                        AvTrace.traceln("SWUpgrade", 1, "Invalid Action - Session Is Not Up ToDate - Try Again");
                        errorString = "InvalidAction_SessionIsNotUpToDate_TryAgain";
                    } else if (0 == this.getSessionEntityCount(pRE.getBOM(), pSessionProxy)) {
                        AvTrace.traceln("SWUpgrade", 1, "Entities Vector is Empty");
                        errorString = "DevicesVectorIsEmpty";
                    } else {
                        AvSwUpgradeUtil.scheduleSession(pRE, pSessionProxy, pAction.equals("AvSession_RETRY"));
                    }
                } else if (pAction.equals("AvSession_STOP")) {
                    if (!(sessionStatus.equals("AvSession_RUNNING") || sessionStatus.equals("AvSession_PAUSED") || sessionStatus.equals("AvSession_SCHEDULED"))) {
                        errorString = "InvalidAction_SessionIsNotUpToDate_TryAgain";
                    } else {
                        AvSwUpgradeUtil.stopSession(pRE, pSessionProxy);
                    }
                } else if (pAction.equals("AvSession_PAUSE")) {
                    if (!sessionStatus.equals("AvSession_RUNNING") && !sessionStatus.equals("AvSession_SCHEDULED")) {
                        errorString = "InvalidAction_SessionIsNotUpToDate_TryAgain";
                    } else {
                        AvSwUpgradeUtil.pauseSession(pRE, pSessionProxy);
                    }
                } else if (pAction.equals("AvSession_RESUME")) {
                    if (!sessionStatus.equals("AvSession_PAUSED")) {
                        errorString = "InvalidAction_SessionIsNotUpToDate_TryAgain";
                    } else {
                        AvSwUpgradeUtil.resumeSession(pRE, pSessionProxy);
                    }
                } else {
                    AvTrace.traceln("SWUpgrade", 1, "UNKNOWN ACTION: " + pAction + " !!!");
                    errorString = "InvalidAction";
                }
            }
            catch (Exception e) {
                AvTrace.traceStack("SWUpgrade", 1, e);
                errorString = "SessionActionFailed";
            }
        }
        return errorString;
    }

    public String getHelpCategory() {
        return "redcell.ngnms.help.swupgrade.session";
    }

    public Vector getSessionEntities(IOWBOMClient pBOM, AvSession pSession) throws AvException {
        return AvSwUpgradeSessionHelper.getSessionAvDevices(pBOM, pSession.getName());
    }

    public IOWBean getSessionEntity(IOWBOMClient pBOM, AvSession pSession, OWOID pEntityOWOID) throws AvException {
        try {
            OWBOMQueryByReferenceAttribute qbr = new OWBOMQueryByReferenceAttribute(SW_UPGRADE_ENTITY_CLASS, "TargetNR", pEntityOWOID, false);
            qbr.addAttribValueOperator(new OWBOMAttribValueOperator("AND", "SessionName", "=", (Object)pSession.getName()));
            return (IOWBean)((Vector)pBOM.getObjects((OWBOMQuery)qbr).getRtnObject()).firstElement();
        }
        catch (OWBOMNotFoundException nfe) {
            AvTrace.traceln("AvPmCollection", 2, "No Pm Collection Session Entities Found.");
        }
        catch (Exception e) {
            throw new AvException(e, "Could not get devices count");
        }
        return null;
    }

    public int getSessionEntityCount(IOWBOMClient pBOM, AvSession pSession) throws AvException {
        return AvSwUpgradeSessionHelper.getSessionDevicesCount(pBOM, pSession.getName());
    }

    public int getSessionEntityCount(IOWBOMClient pBOM, AvBeanProxy pSessionProxy) throws AvException {
        return AvSwUpgradeSessionHelper.getSessionDevicesCount(pBOM, pSessionProxy.getAsString("Name"));
    }

    public static Vector getSessionAvDevices(IOWBOMClient pBOM, String pSessionName) throws AvException {
        Vector swUpgradeDevices = AvSwUpgradeSessionHelper.getSwUpgradeDevices(pBOM, pSessionName, 1);
        Vector<NetworkResource> ret = new Vector<NetworkResource>();
        for (AvSwUpgradeDevice _swdev : swUpgradeDevices) {
            NetworkResource nr = _swdev.getTargetNR();
            if (null == nr) continue;
            try {
                OWBOMQueryByAttribs qba2 = new OWBOMQueryByAttribs(nr.getClass().getName(), new OWBOMAttribValueOperator("KeyValue", "=", (Object)nr.getKeyValue()));
                nr = (NetworkResource)((Vector)pBOM.getObjects((OWBOMQuery)qba2).getRtnObject()).firstElement();
                ret.add(nr);
            }
            catch (OWBOMNotFoundException nfe) {
                throw new AvException("SessionAccessDenied");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new AvException(e, "ErrorAccessingSession");
            }
        }
        return ret;
    }

    public static Vector getSwUpgradeDevices(IOWBOMClient pBOM, String pSessionName) throws AvException {
        return AvSwUpgradeSessionHelper.getSwUpgradeDevices(pBOM, pSessionName, 1);
    }

    public static Vector getSwUpgradeDevices(IOWBOMClient pBOM, String pSessionName, int pDepth) throws AvException {
        Vector ret = new Vector();
        try {
            OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs(SW_UPGRADE_ENTITY_CLASS, new OWBOMAttribValueOperator("SessionName", false, "=", pSessionName), false);
            qba.setMaxQuerySize(0);
            qba.setDepth(pDepth);
            Vector result = (Vector)pBOM.getObjects((OWBOMQuery)qba).getRtnObject();
        }
        catch (OWBOMNotFoundException nfe) {
            AvTrace.traceln("SWUpgrade", 2, "No SWDevices found for session " + pSessionName);
        }
        catch (Exception e) {
            throw new AvException(e, "Could not retrieve SW Session Devices.");
        }
        return ret;
    }

    public static int getSessionDevicesCount(IOWBOMClient pBOM, String pSessionName) throws AvException {
        return AvSessionUtil.getSessionEntityCount(pBOM, SW_UPGRADE_ENTITY_CLASS, pSessionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String updateSession(IOWRuleEngineRuleInterface pRE, AvBeanProxy pSessionProxy, List pDevices) {
        String ret = "";
        AvWorkSpace ws = null;
        String sessionName = null;
        try {
            sessionName = pSessionProxy.getAsString("Name");
            ws = AvWorkSpace.getAndLockWorkSpace(SW_UPGRADE_WORKSPACE, AvSessionUtil.getWorkSpaceTimeout());
            HashSet busySessions = (HashSet)ws.getObject("BusySessions");
            if (null == busySessions) {
                busySessions = new HashSet();
            }
            if (busySessions.contains(sessionName)) {
                ws.closeWorkSpace();
                ws = null;
                AvTrace.traceln("SWUpgrade", 2, "Update Session: SESSION IS BUSY.");
                String string = "SessionIsBusy";
                return string;
            }
            busySessions.add(sessionName);
            ws.putObject("BusySessions", busySessions);
            ws.closeWorkSpace();
            pSessionProxy.update(pRE.getBOM());
            AvBeanProxy.commitAll(pRE.getBOM());
            long _tm = System.currentTimeMillis();
            Vector devices = AvSwUpgradeSessionHelper.updateSwDevices(pRE.getBOM(), pSessionProxy, pDevices);
            AvTrace.traceln("SWUpgrade", 3, "TIME SPENT IN updateSession(): " + (System.currentTimeMillis() - _tm) + " millis. ( devices size: " + devices.size() + " )");
        }
        catch (Exception e) {
            AvTrace.traceStack("SWUpgrade", 1, e);
            ret = "SessionUpdateFailed";
        }
        finally {
            if (null != ws) {
                try {
                    ws = AvWorkSpace.getAndLockWorkSpace(SW_UPGRADE_WORKSPACE, AvSessionUtil.getWorkSpaceTimeout());
                    HashSet busySessions = (HashSet)ws.getObject("BusySessions");
                    if (null != busySessions) {
                        busySessions.remove(sessionName);
                    }
                    ws.putObject("BusySessions", busySessions);
                    ws.closeWorkSpace();
                }
                catch (Exception we) {
                    AvTrace.traceStack("SWUpgrade", 1, we);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteSession(IOWRuleEngineRuleInterface pRE, AvBeanProxy pSessionProxy) {
        boolean bResult = true;
        AvWorkSpace ws = null;
        String sessionName = null;
        try {
            sessionName = pSessionProxy.getAsString("Name");
            ws = AvWorkSpace.getAndLockWorkSpace(SW_UPGRADE_WORKSPACE, AvSessionUtil.getWorkSpaceTimeout());
            HashSet busySessions = (HashSet)ws.getObject("BusySessions");
            if (null == busySessions) {
                busySessions = new HashSet();
            }
            if (busySessions.contains(sessionName)) {
                ws.closeWorkSpace();
                ws = null;
                AvTrace.traceln("SWUpgrade", 2, "DELETE Session: SESSION IS BUSY.");
                boolean bl = false;
                return bl;
            }
            busySessions.add(sessionName);
            ws.putObject("BusySessions", busySessions);
            ws.closeWorkSpace();
            long _tm = System.currentTimeMillis();
            Vector devices = AvSwUpgradeSessionHelper.updateSwDevices(pRE.getBOM(), pSessionProxy, new Vector());
            AvTrace.traceln("SWUpgrade", 3, "TIME SPENT IN DELETE: " + (System.currentTimeMillis() - _tm) + " millis.");
            pSessionProxy.setDeleted();
            pSessionProxy.update(pRE.getBOM());
            AvBeanProxy.commitAll(pRE.getBOM());
        }
        catch (Exception e) {
            bResult = false;
            AvTrace.traceStack("", 1, e);
        }
        finally {
            if (null != ws) {
                try {
                    ws = AvWorkSpace.getAndLockWorkSpace(SW_UPGRADE_WORKSPACE, AvSessionUtil.getWorkSpaceTimeout());
                    HashSet busySessions = (HashSet)ws.getObject("BusySessions");
                    if (null != busySessions) {
                        busySessions.remove(sessionName);
                    }
                    ws.putObject("BusySessions", busySessions);
                    ws.closeWorkSpace();
                }
                catch (Exception we) {
                    AvTrace.traceStack("SWUpgrade", 1, we);
                }
            }
        }
        return bResult;
    }

    private static Vector updateSwDevices(IOWBOMClient pBOM, AvBeanProxy pSessionProxy, List pDevices) throws Exception {
        String sessionName = pSessionProxy.getAsString("Name");
        TreeSet devicesKeys = new TreeSet();
        devicesKeys.addAll(pDevices);
        AvTrace.traceln("SWUpgrade", 3, "devicesKeys size: " + devicesKeys.size());
        int commitSize = 100;
        try {
            OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs(SW_UPGRADE_ENTITY_CLASS, new OWBOMAttribValueOperator("SessionName", false, "=", sessionName), false);
            qba.setMaxQuerySize(0);
            List _swdevs = (List)pBOM.getObjects((OWBOMQuery)qba).getRtnObject();
            Vector<AvSwUpgradeDevice> toDelete = new Vector<AvSwUpgradeDevice>();
            for (AvSwUpgradeDevice dev : _swdevs) {
                if (devicesKeys.remove(dev.getTargetNRKey())) continue;
                pBOM.getObjectForUpdate((IOWBean)dev);
                toDelete.add(dev);
                if (toDelete.size() < commitSize) continue;
                AvTrace.traceln("SWUpgrade", 3, "SessDevices Creation:  toDelete size: " + toDelete.size());
                pBOM.deleteObjects(toDelete);
                pBOM.commitObjects(toDelete);
                pBOM.commitAll();
                toDelete.clear();
            }
            if (toDelete.size() > 0) {
                AvTrace.traceln("SWUpgrade", 3, "SessDevices Creation:  toDelete size: " + toDelete.size());
                pBOM.deleteObjects(toDelete);
                pBOM.commitObjects(toDelete);
                pBOM.commitAll();
            }
        }
        catch (OWBOMNotFoundException _nfe) {
            AvTrace.traceln("SWUpgrade", 3, "No SWUpgDevices found for session " + sessionName);
        }
        String productLine = pSessionProxy.getAsString("ProductLineName");
        if (null == productLine || productLine.equals("")) {
            throw new AvException("Product Line Not Set in SW Upgrade Session!");
        }
        Class swDevsClass = AvSwUpgradeSessionHelper.getSwUpgradeDeviceClass(productLine);
        Vector<OWOID> queryKeys = new Vector<OWOID>(commitSize);
        Iterator it = devicesKeys.iterator();
        while (it.hasNext()) {
            String _key = (String)it.next();
            queryKeys.add(new OWOID(_key));
            if (queryKeys.size() < commitSize && (queryKeys.size() <= 0 || it.hasNext())) continue;
            Vector _crtdevs = new Vector();
            try {
                OWBOMQueryByOWOIDs qbo = new OWBOMQueryByOWOIDs(queryKeys);
                qbo.setDepth(0);
                _crtdevs = (Vector)pBOM.getObjects((OWBOMQuery)qbo).getRtnObject();
            }
            catch (OWBOMNotFoundException _nfe) {
                AvTrace.traceln("AvPmCollection", 2, "Not found AvDevice");
            }
            queryKeys.clear();
            Vector<AvSwUpgradeDevice> toAdd = new Vector<AvSwUpgradeDevice>(_crtdevs.size());
            for (NetworkResource device : _crtdevs) {
                AvSwUpgradeDevice _swdev = (AvSwUpgradeDevice)swDevsClass.newInstance();
                _swdev.setSessionName(sessionName);
                _swdev.setTargetNR(device);
                _swdev.setTargetNRKey(device.getHandle().toString());
                toAdd.add(_swdev);
            }
            pBOM.commitObjects(toAdd);
            pBOM.commitAll();
        }
        return new Vector(pDevices);
    }

    private static Class getSwUpgradeDeviceClass(String pRoductLine) {
        try {
            String clsName = AvLookup.get(SW_UPGRADE_DEV_CLS_NAME, pRoductLine);
            return Class.forName(clsName);
        }
        catch (ClassNotFoundException cnfe) {
            AvTrace.traceln("SWUpgrade", 1, cnfe.getMessage());
        }
        catch (AvLookupItemNotFoundException linfe) {
            AvTrace.traceln("SWUpgrade", 2, "Specific SW Upgrade class name not found for " + pRoductLine);
        }
        catch (AvException ave) {
            AvTrace.traceStack("SWUpgrade", 1, (Exception)((Object)ave));
        }
        return AvSwUpgradeDevice.class;
    }
}

