/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.swupgrade;

import RedCell.NewItemPanel;
import com.bwanms.ruledelegator.BaseFormController;
import com.dorado.common.widget.components.OWFCParentPanel;
import com.dorado.common.widget.components.formlauncher.IOWFormLauncher;
import com.dorado.common.widget.components.interfaces.IOWGButton;
import com.dorado.common.widget.components.interfaces.IOWGDropInPanel;
import com.dorado.common.widget.components.interfaces.IOWGPanel;
import com.dorado.common.widget.components.interfaces.IOWGStandardPanel;
import com.dorado.runtime.IOWEventListener;
import com.dorado.runtime.IOWFormUserMethods;
import com.dorado.runtime.IOWRuntimeForm;
import com.dorado.runtime.IOWRuntimeFormDefs;
import com.dorado.runtime.OWEvent;
import com.dorado.runtime.OWEventAttribValueOperator;
import com.dorado.runtime.OWEventSelector;
import com.ngnms.apps.common.AvSessionActionRuleParamSet;
import com.ngnms.apps.common.AvSessionActionRuleResponse;
import com.ngnms.apps.common.AvSessionChangedEvent;
import com.ngnms.apps.common.AvSessionDeviceChangedEvent;
import com.ngnms.apps.log.AvLogUtil;
import com.ngnms.apps.swupgrade.AvSwUpgradeGetSessionParamSet;
import com.ngnms.apps.swupgrade.AvSwUpgradeGetSessionResponse;
import com.ngnms.apps.swupgrade.AvSwUpgradePanelJAVAGUI;
import com.ngnms.apps.swupgrade.AvSwUpgradePanelStopSessionListener;
import com.ngnms.apps.swupgrade.AvSwUpgradeUpdateRuleParamSet;
import com.ngnms.apps.swupgrade.IAvSwUpgradePanel;
import com.ngnms.apps.swupgrade.IAvSwUpgradePanelHelper;
import com.ngnms.common.AvBeanProxy;
import com.ngnms.common.AvClientInternationalizer;
import com.ngnms.common.AvEmsUtil;
import com.ngnms.common.AvException;
import com.ngnms.common.AvFormID;
import com.ngnms.common.AvLookup;
import com.ngnms.common.AvServerToFormEvent;
import com.ngnms.common.AvTrace;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import redcell.common.interfaces.IRCOptionPaneListener;
import redcell.common.util.RedCellRuleEngineUtil;
import redcell.core.usersys.RCUserUtil;

public class AvSwUpgradePanelFormController
extends BaseFormController
implements IOWEventListener,
IOWFormUserMethods,
IOWRuntimeForm,
IAvSwUpgradePanelHelper,
IRCOptionPaneListener {
    public boolean initialized = false;
    public Vector sessionDevices = null;
    public AvBeanProxy sessionProxy = null;
    public boolean editingMode;
    public AvServerToFormEvent serverToFormEvent = null;
    public IAvSwUpgradePanel swUpgradePanel = null;
    public String productLine = null;
    public String formID = null;
    public AvClientInternationalizer internationalizer = null;
    public AvSessionChangedEvent sessionChangedEvent = null;
    public AvSessionDeviceChangedEvent sessionDeviceChangedEvent = null;
    IOWGDropInPanel SwUpgradeDropInPanel;
    IOWGStandardPanel ButtonsPanel;
    IOWGButton btnRefresh;
    IOWGButton btnSave;
    IOWGButton btnHelp;
    IOWGButton btnClose;
    protected String SwUpgradePanel_title;

    public AvSwUpgradePanelFormController(AvSwUpgradePanelJAVAGUI form) throws SecurityException, NoSuchFieldException {
        super((OWFCParentPanel)form);
        this.bindFields();
    }

    private void bindFields() throws SecurityException, NoSuchFieldException {
        this.SwUpgradeDropInPanel = (IOWGDropInPanel)this.getComponent("SwUpgradeDropInPanel");
        this.ButtonsPanel = (IOWGStandardPanel)this.getComponent("ButtonsPanel");
        this.btnRefresh = (IOWGButton)this.getComponent("btnRefresh");
        this.btnSave = (IOWGButton)this.getComponent("btnSave");
        this.btnHelp = (IOWGButton)this.getComponent("btnHelp");
        this.btnClose = (IOWGButton)this.getComponent("btnClose");
    }

    public void action(OWEvent pEvent) {
        AvTrace.traceln("SWUpgrade", 3, "action: " + pEvent.getClass().getName());
        if (pEvent instanceof AvSwUpgradeGetSessionResponse) {
            AvTrace.traceln("SWUpgrade", 3, "AvFormGetQueryResponseEvent received");
            this.processSwUpgradeGetSessionEvent((AvSwUpgradeGetSessionResponse)pEvent);
        } else if (pEvent instanceof AvSessionActionRuleResponse) {
            AvTrace.traceln("SWUpgrade", 3, "AvSessionActionRuleResponse received");
            this.processSessionActionRuleResponse((AvSessionActionRuleResponse)pEvent);
        } else if (pEvent instanceof AvSessionChangedEvent) {
            this.processSessionChangedEvent((AvSessionChangedEvent)pEvent);
        } else if (pEvent instanceof AvSessionDeviceChangedEvent) {
            this.processSessionDeviceChangedEvent((AvSessionDeviceChangedEvent)pEvent);
        } else {
            AvTrace.traceln("SWUpgrade", 1, "Unknown event received.");
        }
    }

    public void actionClose() {
        AvBeanProxy panelSessionProxy = this.swUpgradePanel.getSessionProxy(false);
        Vector panelDevices = this.swUpgradePanel.getSessionDevices(false);
        if (panelSessionProxy == null || panelSessionProxy.isNewInstance() || panelSessionProxy.isChanged() || this.changedSessionDevices(panelDevices)) {
            final int formType = this.getFormType();
            IRCOptionPaneListener listener = new IRCOptionPaneListener(){

                public int getFormType() {
                    return formType;
                }

                public void optionPaneButtonClicked(int pButton) {
                    if (0 == pButton) {
                        if (AvSwUpgradePanelFormController.this.saveSession()) {
                            AvSwUpgradePanelFormController.this.closeForm();
                        }
                    } else {
                        AvSwUpgradePanelFormController.this.closeForm();
                    }
                }
            };
            AvEmsUtil.showConfirmDialog(this.getFormLauncher(), listener, "DoYouWantToSaveChanges", "Warning", this.internationalizer);
        } else {
            this.closeForm();
        }
    }

    public void actionHelp() {
        AvEmsUtil.showHelp(this.getFormLauncher(), this.swUpgradePanel.getHelpTopic());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionInit() {
        AvTrace.traceln("SWUpgrade");
        AvTrace.traceln("SWUpgrade", 1, "initSwUpgradePanelForm");
        this.getFormController().setBusy(true);
        this.internationalizer = new AvClientInternationalizer("AvPmCollectionTitlesBundle");
        try {
            this.formID = new AvFormID(this.getThisForm().getClass().getName()).getID();
            AvTrace.traceln("SWUpgrade", 1, "FormID = " + this.formID);
            this.serverToFormEvent = new AvServerToFormEvent();
            OWEventSelector evs = this.serverToFormEvent.getSelector();
            OWEventAttribValueOperator avo = new OWEventAttribValueOperator("FormID", "=", (Serializable)((Object)this.formID));
            evs.addAttribValueOperator(avo);
            this.serverToFormEvent.addEventListener((IOWEventListener)this.getThisForm());
            this.editingMode = (Boolean)this.getUserProperty(IOWRuntimeFormDefs.TYPE_EDITOR);
            if (this.editingMode) {
                AvTrace.traceln("SWUpgrade", 2, "Edit Session");
                this.sessionProxy = (AvBeanProxy)this.getUserProperty("AvForm_MANAGED_OBJECT");
                this.productLine = this.sessionProxy.getAsString("ProductLineName");
            } else {
                this.productLine = (String)this.getUserProperty("AvSelectedValue");
                AvTrace.traceln("SWUpgrade", 2, "New Session");
            }
            AvTrace.traceln("SWUpgrade", 1, "Product Line = " + this.productLine);
        }
        catch (Exception e) {
            AvTrace.traceStack("SWUpgrade", 2, e);
        }
        finally {
            this.getFormController().setBusy(false);
        }
    }

    public void actionRefresh() {
        this.refreshSession();
    }

    public void actionSave() {
        this.saveSession();
    }

    public void actionShow() {
        this.translate();
        try {
            this.loadDropInPanel();
            if (this.sessionProxy != null) {
                this.swUpgradePanel.setSessionProxy(this.sessionProxy);
                try {
                    this.registerNotificationListeners(this.sessionProxy.getAsString("Name"));
                }
                catch (Exception e) {
                    AvTrace.traceStack("SWUpgrade", 1, e);
                }
            }
            this.showDropInPanel();
        }
        catch (Exception e) {
            AvTrace.traceStack("SWUpgrade", 3, e);
            AvEmsUtil.showWarningMessage(this.getFormLauncher(), (IRCOptionPaneListener)this.getThisForm(), "ErrorShowingSessionEditor", "Error", this.internationalizer);
            return;
        }
        this.updateControlsState(false);
        this.refreshSession();
        this.initialized = true;
    }

    public boolean changedSessionDevices(Vector pSessionDevices) {
        if (this.sessionDevices == null ? !pSessionDevices.isEmpty() : pSessionDevices.size() != this.sessionDevices.size()) {
            return true;
        }
        for (AvBeanProxy sessionDevice : pSessionDevices) {
            if (!sessionDevice.isNewInstance() && !sessionDevice.isChanged()) continue;
            return true;
        }
        return false;
    }

    public void closeForm() {
        AvTrace.traceln("SWUpgrade", 1, "In closeForm");
        IOWFormLauncher formLauncher = (IOWFormLauncher)this.getUserProperty("FormLauncher");
        OWFCParentPanel form = (OWFCParentPanel)formLauncher.getSelectedPanelContainer().getPanel();
        formLauncher.removePanel(form.getClass().getName(), form.getId());
    }

    public void deregisterListeners() {
        AvTrace.traceln("SWUpgrade", 3, "in deregisterListeners");
        Iterator i = this.getFormLauncher().getForms().iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof NewItemPanel)) continue;
            AvTrace.traceln("SWUpgrade", 3, "Bogus deregister listeners");
            return;
        }
        try {
            if (this.serverToFormEvent != null) {
                this.serverToFormEvent.removeEventListener((IOWEventListener)this.getThisForm());
                this.serverToFormEvent = null;
            }
            if (this.sessionChangedEvent != null) {
                this.sessionChangedEvent.removeEventListener((IOWEventListener)this.getThisForm());
                this.sessionChangedEvent = null;
                this.sessionDeviceChangedEvent.removeEventListener((IOWEventListener)this.getThisForm());
                this.sessionDeviceChangedEvent = null;
            }
        }
        catch (Exception e) {
            AvTrace.traceStack("SWUpgrade", 3, e);
        }
    }

    public void loadDropInPanel() throws Exception {
        String dropInClass = AvLookup.get("SwUpgradePanel", this.productLine);
        AvTrace.traceln("SwUpgrade", 1, "Drop-in panel: " + dropInClass);
        this.swUpgradePanel = (IAvSwUpgradePanel)this.SwUpgradeDropInPanel.addDropInPanel(dropInClass);
        ((IOWRuntimeForm)this.swUpgradePanel).putUserProperty((Object)"FormLauncher", this.getUserProperty("FormLauncher"));
        ((IOWRuntimeForm)this.swUpgradePanel).putUserProperty((Object)"ProductLineName", (Object)this.productLine);
        this.swUpgradePanel.setHelper((IAvSwUpgradePanelHelper)this.getThisForm());
    }

    public void optionPaneButtonClicked(int pButton) {
    }

    public void performAction(String pAction) {
        AvTrace.traceln("SWUpgrade", 3, "In performAction - pAction = " + pAction);
        try {
            if ("SHOW_LOG".equals(pAction)) {
                AvLogUtil.showLogWindow(this.getFormLauncher(), "SWUpgrade", this.internationalizer);
                return;
            }
            String sessionAction = null;
            AvBeanProxy panelSession = this.swUpgradePanel.getSessionProxy(false);
            if (null == panelSession || panelSession.isChanged() || panelSession.isNewInstance()) {
                AvEmsUtil.showWarningMessage(this.getFormLauncher(), (IRCOptionPaneListener)this.getThisForm(), "YouCanNotStartNotSavedSession", "Error", this.internationalizer);
                return;
            }
            int numOfRunning = this.sessionProxy.getAsInt("NumOfRunning");
            AvTrace.traceln("SWUpgrade", 3, "numOfRunning = " + numOfRunning);
            if ("START".equals(pAction) || "RETRY".equals(pAction)) {
                long currentTime;
                long startDateLong;
                AvBeanProxy schdulerProxy = this.sessionProxy.getAsProxy("Scheduler");
                int intervalUnits = schdulerProxy.getAsInt("IntervalUnits");
                int intervalValue = schdulerProxy.getAsInt("IntervalValue");
                if (intervalUnits > 0 && intervalValue > 0 && (startDateLong = schdulerProxy.getAsLong("StartDate")) < (currentTime = System.currentTimeMillis())) {
                    AvEmsUtil.showWarningMessage(this.getFormLauncher(), (IRCOptionPaneListener)this.getThisForm(), "YouCanNotStartSessionWithStopAfterAndStartDateInPast", "Error", this.internationalizer);
                    return;
                }
                sessionAction = "START".equals(pAction) ? "AvSession_START" : "AvSession_RETRY";
            } else if (pAction.equals("STOP")) {
                sessionAction = "AvSession_STOP";
                if (numOfRunning > 0) {
                    AvSwUpgradePanelStopSessionListener optionPaneListener = new AvSwUpgradePanelStopSessionListener(this.getFormType());
                    AvEmsUtil.showConfirmDialog(this.getFormLauncher(), (IRCOptionPaneListener)optionPaneListener, "AreYouSureYouWantToStopSessionWithUploadingDevices", "Warning", this.internationalizer);
                    if (optionPaneListener.isNoButtonPressed()) {
                        return;
                    }
                }
            }
            this.swUpgradePanel.setBusy(true, pAction);
            AvSessionActionRuleParamSet sessionActionRuleParamSet = new AvSessionActionRuleParamSet();
            sessionActionRuleParamSet.setUserID(RCUserUtil.getCurrentUser().getLoginName());
            sessionActionRuleParamSet.setFormID(this.formID);
            sessionActionRuleParamSet.setCategory("AvSession_SW_UPGRADE");
            sessionActionRuleParamSet.setAction(sessionAction);
            sessionActionRuleParamSet.setSessionProxy(this.sessionProxy);
            AvTrace.traceln("SWUpgrade", 3, "Emit Event (AvSessionActionRuleParamSet) ...");
            sessionActionRuleParamSet.emit();
        }
        catch (Exception e) {
            AvTrace.traceStack("SWUpgrade", 1, e);
        }
    }

    public void processSessionActionRuleResponse(AvSessionActionRuleResponse pEvent) {
        try {
            AvTrace.traceln("SWUpgrade", 3, "In processSessionActionRuleResponse");
            String actionErrorString = pEvent.getActionErrorString();
            if (actionErrorString != null) {
                AvEmsUtil.showWarningMessage(this.getFormLauncher(), (IRCOptionPaneListener)this.getThisForm(), actionErrorString, "Warning", this.internationalizer);
            } else {
                this.sessionProxy = pEvent.getSessionProxy();
                this.swUpgradePanel.setSessionProxy(this.sessionProxy);
            }
            this.swUpgradePanel.setBusy(false, pEvent.getAction());
            this.updateControlsState(false);
        }
        catch (Exception e) {
            AvTrace.traceStack("SWUpgrade", 1, e);
        }
    }

    public void processSessionChangedEvent(AvSessionChangedEvent pEvent) {
        AvTrace.traceln("SWUpgrade", 3, "processSessionChangedEvent: " + pEvent.getNotificationType());
        if ("Modify".equals(pEvent.getNotificationType())) {
            this.sessionProxy = pEvent.getMO();
            this.swUpgradePanel.setSessionProxy(this.sessionProxy);
        }
        this.updateControlsState(false);
    }

    public void processSessionDeviceChangedEvent(AvSessionDeviceChangedEvent pEvent) {
        AvTrace.traceln("SWUpgrade", 3, "processSessionDeviceChangedEvent: " + pEvent.getNotificationType());
        if ("Modify".equals(pEvent.getNotificationType())) {
            AvBeanProxy sessionDeviceProxy = pEvent.getMO();
            this.swUpgradePanel.sessionDeviceChanged(sessionDeviceProxy);
        }
    }

    public void processSwUpgradeGetSessionEvent(AvSwUpgradeGetSessionResponse pEvent) {
        AvTrace.traceln("SWUpgrade", 2, "Processing GetSessionEvent");
        if (pEvent.getErrorString() == null || "".equals(pEvent.getErrorString())) {
            this.sessionProxy = (AvBeanProxy)pEvent.getSessionProxy();
            this.sessionDevices = (Vector)pEvent.getSessionDevices();
            this.swUpgradePanel.setSessionProxy(this.sessionProxy);
            this.swUpgradePanel.setSessionDevices((Vector)this.sessionDevices.clone());
        } else {
            AvTrace.traceln("SWUpgrade", 1, "Error: " + pEvent.getErrorString());
        }
        this.updateControlsState(false);
    }

    public void refreshSession() {
        if (this.sessionProxy == null) {
            return;
        }
        try {
            AvSwUpgradeGetSessionParamSet event = new AvSwUpgradeGetSessionParamSet();
            event.setSessionName(this.sessionProxy.getAsString("Name"));
            event.setFormID(this.formID);
            RedCellRuleEngineUtil.callRule((String)"com.ngnms.apps.swupgrade.AvSwUpgradeGetSessionRule", (OWEvent)event);
        }
        catch (Exception e) {
            AvTrace.traceStack("SWUpgrade", 3, e);
        }
    }

    public void registerNotificationListeners(String pSessionName) throws Exception {
        AvTrace.traceln("SWUpgrade", 3, "in registerNotificationListeners for " + pSessionName);
        if (this.sessionChangedEvent == null) {
            this.sessionChangedEvent = new AvSessionChangedEvent();
            OWEventSelector evs = this.sessionChangedEvent.getSelector();
            evs.addAttribValueOperator(new OWEventAttribValueOperator("SessionName", "=", (Serializable)((Object)pSessionName)));
            this.sessionChangedEvent.addEventListener((IOWEventListener)this.getThisForm());
            this.sessionDeviceChangedEvent = new AvSessionDeviceChangedEvent();
            evs = this.sessionDeviceChangedEvent.getSelector();
            evs.addAttribValueOperator(new OWEventAttribValueOperator("SessionName", "=", (Serializable)((Object)pSessionName)));
            this.sessionDeviceChangedEvent.addEventListener((IOWEventListener)this.getThisForm());
        }
    }

    public boolean saveSession() {
        AvTrace.traceln("SWUpgrade", 2, "In saveSession");
        AvBeanProxy panelSessionProxy = this.swUpgradePanel.getSessionProxy(true);
        if (panelSessionProxy == null) {
            return false;
        }
        this.sessionProxy = panelSessionProxy;
        Vector panelDevices = this.swUpgradePanel.getSessionDevices(true);
        if (panelDevices == null) {
            return false;
        }
        boolean devicesChanged = this.changedSessionDevices(panelDevices);
        if (devicesChanged) {
            this.sessionDevices = (Vector)panelDevices.clone();
        }
        AvTrace.traceln("SWUpgrade", 2, "Session Devices size: " + this.sessionDevices.size());
        try {
            if (null == this.sessionProxy.getOID()) {
                String sessionName = this.sessionProxy.getAsString("Name");
                AvTrace.traceln("SWUpgrade", 3, "New Session: Checking Existance of Session with Name: " + sessionName);
                try {
                    AvBeanProxy existSessionProxy = new AvBeanProxy("com.ngnms.apps.common.AvSession", sessionName);
                    if (null != existSessionProxy) {
                        String existSessionName = existSessionProxy.getAsString("Name");
                        AvTrace.traceln("SWUpgrade", 2, "Found Session with Name: " + existSessionName + ", Session ClassName: " + existSessionProxy.getClassName());
                        AvEmsUtil.showWarningMessage(this.getFormLauncher(), (IRCOptionPaneListener)this.getThisForm(), "SessionWithThisNameAlreadyExist", new String[]{existSessionName}, "Error", this.internationalizer);
                        return false;
                    }
                }
                catch (Exception e) {
                    AvTrace.traceln("SWUpgrade", 1, "OK - Not Found Session with Name: " + sessionName + " - Error String is: " + e.getMessage());
                }
            } else if (!this.sessionProxy.isChanged() && !devicesChanged) {
                AvTrace.traceln("SWUpgrade", 1, "Nothing changed. Bailing out.");
                return true;
            }
            String userID = RCUserUtil.getCurrentUser().getLoginName();
            this.sessionProxy.set("UserID", userID);
            this.sessionProxy.set("ProductLineName", this.productLine);
            this.sessionProxy.set("EntityType", this.productLine);
            Vector<String> _devOids = new Vector<String>(this.sessionDevices.size());
            for (AvBeanProxy deviceProxy : this.sessionDevices) {
                _devOids.add(deviceProxy.getAsProxy("TargetNR").getOID());
            }
            AvSwUpgradeUpdateRuleParamSet updateParamSet = new AvSwUpgradeUpdateRuleParamSet();
            updateParamSet.setSession(this.sessionProxy);
            updateParamSet.setDevices(_devOids);
            RedCellRuleEngineUtil.callRule((String)"com.ngnms.apps.swupgrade.AvSwUpgradeUpdateRule", (OWEvent)updateParamSet);
            String errMessage = updateParamSet.getErrorMessage();
            if (null != errMessage && 0 != errMessage.length()) {
                throw new AvException(errMessage);
            }
            this.sessionProxy = updateParamSet.getSession();
            this.registerNotificationListeners(this.sessionProxy.getAsString("Name"));
            this.refreshSession();
            return true;
        }
        catch (Exception e) {
            AvTrace.traceStack("SWUpgrade", 1, e);
            String msgText = this.editingMode ? "ErrorSavingUpdatedSession" : "ErrorSavingNewSession";
            AvEmsUtil.showWarningMessage(this.getFormLauncher(), (IRCOptionPaneListener)this.getThisForm(), msgText, "Error", this.internationalizer);
            return false;
        }
    }

    public void saveSessionAndCloseForm() {
    }

    public void setBusy(boolean pBusy, String pReason) {
        AvTrace.traceln("SWUpgrade", 3, "setBusy: " + pBusy + " " + pReason);
        this.updateControlsState(pBusy);
    }

    public void showDropInPanel() throws Exception {
        this.SwUpgradeDropInPanel.showPanel((Object)((IOWRuntimeForm)this.swUpgradePanel));
    }

    public void translate() {
        this.internationalizer.translatePanel((IOWGPanel)this.ButtonsPanel);
    }

    public void updateControlsState(boolean pBusy) {
        try {
            String sessionStatus = null != this.sessionProxy ? this.sessionProxy.getAsString("Status") : "AvSession_NEW";
            boolean savedSession = null != this.sessionProxy && this.sessionProxy.getOID() != null;
            AvTrace.traceln("SWUpgrade", 3, "sessionStatus = " + sessionStatus);
            boolean newSession = "AvSession_NEW".equals(sessionStatus);
            boolean sessionRunning = "AvSession_RUNNING".equals(sessionStatus) || "AvSession_SCHEDULED".equals(sessionStatus) || "AvSession_PAUSED".equals(sessionStatus);
            boolean sessionPaused = "AvSession_PAUSED".equals(sessionStatus);
            this.btnClose.setEnabled(!pBusy);
            this.btnSave.setEnabled(!sessionRunning && !pBusy);
            this.btnRefresh.setEnabled(!pBusy);
        }
        catch (Exception e) {
            AvTrace.traceStack("SWUpgrade", 3, e);
        }
    }

    public String getTitle() {
        return this.SwUpgradePanel_title;
    }

    public void setTitle(String s) {
        super.setTitle(s);
        this.SwUpgradePanel_title = s;
    }

    private AvSwUpgradePanelJAVAGUI getThisForm() {
        return (AvSwUpgradePanelJAVAGUI)this.getForm();
    }
}

