/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.swupgrade;

import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.bom.OWBOMQueryByKey;
import com.dorado.core.ejb.ruleengine.IOWRuleEngineRuleInterface;
import com.ngnms.apps.swupgrade.AvSwUpgradeDevice;
import com.ngnms.apps.swupgrade.AvSwUpgradeSession;
import com.ngnms.apps.swupgrade.AvSwUpgradeUtil;
import com.ngnms.common.AvException;
import com.ngnms.common.AvTrace;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AvSwUpgradeActiveSession {
    public static final String MODE_ALWAYS = "ALWAYS";
    public static final String MODE_DIF_CURRENT = "DIFFERENT_FROM_CURRENT";
    public static final String MODE_DIF_SHADOW = "DIFFERENT_FROM_SHADOW";
    public static final String MODE_DIF_BOTH = "DIFFERENT_FROM_BOTH";
    public static final String DSTATUS_EXECUTING = "AvServices_RESPONSE_EXECUTING";
    public static final String DSTATUS_OK = "AvServices_RESPONSE_OK";
    public static final String DSTATUS_ERROR = "AvServices_RESPONSE_ERROR";
    public static final String DSTATUS_TIMEOUT = "AvServices_RESPONSE_TIMEOUT";
    public static final String DSTATUS_SKIPPED = "IGNORED";
    public static final String RELATIVE_PATH_NOT_FOUND = "RelativeLocalFilePath_NotFound";
    public static final int ON_FAILURE_STOP = 0;
    public static final int ON_FAILURE_CONTINUE = 1;
    protected String name;
    protected String state;
    private static final String SW_UPGRADE_DEVICE_CLASSNAME = "com.ngnms.apps.swupgrade.AvSwUpgradeDevice";

    public abstract void initialize(IOWRuleEngineRuleInterface var1, AvSwUpgradeSession var2) throws AvException;

    public abstract void pauseSession(IOWRuleEngineRuleInterface var1) throws AvException;

    public abstract void resumeSession(IOWRuleEngineRuleInterface var1) throws AvException;

    public abstract void cancelSession(IOWRuleEngineRuleInterface var1) throws AvException;

    public abstract void startSession(IOWRuleEngineRuleInterface var1) throws AvException;

    public abstract void sessionScheduled(IOWRuleEngineRuleInterface var1);

    public abstract void updateStatus(IOWRuleEngineRuleInterface var1, String var2, String var3, String var4, String var5, String var6, Object var7);

    public abstract void logSession(IOWRuleEngineRuleInterface var1);

    public abstract boolean servicesDevice(IOWRuleEngineRuleInterface var1, String var2);

    public String getSessionName() {
        return this.name;
    }

    protected AvSwUpgradeSession getSession(IOWBOMClient pBOM) {
        try {
            OWBOMQueryByKey qbk = new OWBOMQueryByKey("com.ngnms.apps.swupgrade.AvSwUpgradeSession", this.name, false);
            return (AvSwUpgradeSession)pBOM.getObject(qbk).getRtnObject();
        }
        catch (Exception e) {
            AvTrace.traceStack("SwUpgrade", 1, e);
            return null;
        }
    }

    protected AvSwUpgradeSession getSession(IOWRuleEngineRuleInterface pRE) {
        try {
            OWBOMQueryByKey qbk = new OWBOMQueryByKey("com.ngnms.apps.swupgrade.AvSwUpgradeSession", this.name, false);
            return (AvSwUpgradeSession)pRE.getBOM().getObject(qbk).getRtnObject();
        }
        catch (Exception e) {
            AvTrace.traceStack("SwUpgrade", 1, e);
            return null;
        }
    }

    protected AvSwUpgradeSession getSessionForUpdate(IOWBOMClient pBOM) throws Exception {
        OWBOMQueryByKey qbk = new OWBOMQueryByKey("com.ngnms.apps.swupgrade.AvSwUpgradeSession", this.name, false);
        return (AvSwUpgradeSession)pBOM.getObjectForUpdate(qbk).getRtnObject();
    }

    protected AvSwUpgradeSession getSessionForUpdate(IOWRuleEngineRuleInterface pRE) throws Exception {
        OWBOMQueryByKey qbk = new OWBOMQueryByKey("com.ngnms.apps.swupgrade.AvSwUpgradeSession", this.name, false);
        return (AvSwUpgradeSession)pRE.getBOM().getObjectForUpdate(qbk).getRtnObject();
    }

    protected boolean lockSession() throws Exception {
        return AvSwUpgradeUtil.lockSession(this.name);
    }

    protected void unlockSession() throws Exception {
        AvSwUpgradeUtil.unlockSession(this.name);
    }

    protected AvSwUpgradeDevice getSwUpgradeDevice(IOWBOMClient pBOM, String pDeviceOID) throws Exception {
        OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs(SW_UPGRADE_DEVICE_CLASSNAME, false);
        qba.addAttribValueOperator(new OWBOMAttribValueOperator("SessionName", "=", (Object)this.name));
        qba.addAttribValueOperator(new OWBOMAttribValueOperator("AND", "TargetNRKey", "=", (Object)pDeviceOID));
        return (AvSwUpgradeDevice)((Vector)pBOM.getObjects((OWBOMQuery)qba).getRtnObject()).firstElement();
    }

    protected Vector getSwUpgradeDevices(IOWBOMClient pBOM) throws Exception {
        OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs(SW_UPGRADE_DEVICE_CLASSNAME, false);
        qba.addAttribValueOperator(new OWBOMAttribValueOperator("SessionName", "=", (Object)this.name));
        return (Vector)pBOM.getObjects((OWBOMQuery)qba).getRtnObject();
    }

    protected Hashtable getSwUpgradeDevicesHash(IOWBOMClient pBOM) throws Exception {
        OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs(SW_UPGRADE_DEVICE_CLASSNAME, false);
        qba.addAttribValueOperator(new OWBOMAttribValueOperator("SessionName", "=", (Object)this.name));
        Vector retVect = (Vector)pBOM.getObjects((OWBOMQuery)qba).getRtnObject();
        Hashtable<String, AvSwUpgradeDevice> ret = new Hashtable<String, AvSwUpgradeDevice>();
        for (AvSwUpgradeDevice dev : retVect) {
            ret.put(dev.getTargetNRKey(), dev);
        }
        return ret;
    }

    public static boolean checkDownloadMode(String pDownloadMode, String pSoftwareVersion, String pShadowVersion, String pVersion) {
        AvTrace.traceln("SWUpgrade", 3, "checkDownloadMode " + pDownloadMode + " " + pSoftwareVersion + " " + pShadowVersion + " " + pVersion);
        if (pDownloadMode.equals(MODE_DIF_CURRENT)) {
            if (pVersion.equals(pSoftwareVersion)) {
                AvTrace.traceln("SWUpgrade", 3, "SoftwareVersion equals session version - Skipping.");
                return false;
            }
        } else if (pDownloadMode.equals(MODE_DIF_SHADOW)) {
            if (pVersion.equals(pShadowVersion)) {
                AvTrace.traceln("SWUpgrade", 3, "ShadowVersion equals session version - Skipping.");
                return false;
            }
        } else if (pDownloadMode.equals(MODE_DIF_BOTH) && (pVersion.equals(pSoftwareVersion) || pVersion.equals(pShadowVersion))) {
            AvTrace.traceln("SWUpgrade", 3, "SoftwareVersion or shadowVersion equal to session version - Skipping.");
            return false;
        }
        return true;
    }
}

