/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.pmcollection.med;

import com.dorado.core.mediation.snmp.OWVarBindList;
import com.dorado.runtime.OWInvalidTypeException;
import com.dorado.runtime.OWSet;
import com.ngnms.apps.pmcollection.med.AvPmCollectionDefMedReqHandler;
import com.ngnms.apps.pmcollection.med.AvPmCollectionSnmpMedRequest;
import com.ngnms.apps.pmcollection.med.IAvPmCollectionMedReqHandler;
import com.ngnms.mediation.snmp.AvSnmpEquipment;
import com.ngnms.mediation.snmp.AvSnmpMediationHandler;
import com.ngnms.mediation.snmp.AvSnmpMediationRequest;
import com.ngnms.mediation.snmp.AvSnmpRequestor;
import java.io.Serializable;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class AvPmCollectionMediationHandler
extends AvSnmpMediationHandler {
    Logger logger = Logger.getLogger(AvPmCollectionMediationHandler.class);
    private int totalRequestCount = -1;
    private int responseCount = 0;
    private int errorRespCounter = 0;
    private int timeoutRespCounter = 0;
    OWSet responses = new OWSet(AvSnmpMediationRequest.class);
    private IAvPmCollectionMedReqHandler defHandler = new AvPmCollectionDefMedReqHandler();
    private static SnmpRequestorThread snmpreqth;

    public AvPmCollectionMediationHandler() {
        super(null, null);
    }

    public AvPmCollectionMediationHandler(int pRequestCount) {
        super(null, null, pRequestCount);
        this.totalRequestCount = pRequestCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpResponse(int pStatus, String pIpAddress, OWVarBindList pVBList, Object pClientData) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("snmpResponse() from " + pIpAddress + "  myStatus: " + pStatus + "  VBList status: " + pVBList.getErrorStatus()));
        }
        AvPmCollectionSnmpMedRequest req = (AvPmCollectionSnmpMedRequest)pClientData;
        req.setTimestamp(System.currentTimeMillis());
        IAvPmCollectionMedReqHandler reqHandler = req.getRequestHandler();
        if (null == reqHandler) {
            reqHandler = this.defHandler;
        }
        AvPmCollectionSnmpMedRequest updatedReq = null;
        AvSnmpEquipment nextRequest = null;
        try {
            updatedReq = reqHandler.processResponse(req, pStatus, pVBList, this);
            nextRequest = reqHandler.getNextRequest();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        switch (req.getStatus()) {
            case 11: {
                ++this.timeoutRespCounter;
                break;
            }
            case 99: {
                ++this.errorRespCounter;
            }
        }
        AvPmCollectionMediationHandler avPmCollectionMediationHandler = this;
        synchronized (avPmCollectionMediationHandler) {
            if (null != updatedReq) {
                try {
                    this.responses.add((Serializable)updatedReq);
                }
                catch (OWInvalidTypeException _ite) {
                    _ite.printStackTrace();
                }
            }
            if (null != nextRequest) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("SUMBITTING NEXT request for " + req.getBatchRequestID() + "  [" + pIpAddress + "]"));
                }
                try {
                    AvPmCollectionMediationHandler.sendSnmpReq(nextRequest);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    ++this.responseCount;
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("DONE request for " + req.getBatchRequestID() + "  [" + pIpAddress + "]"));
                }
                ++this.responseCount;
            }
            if (this.responseCount == this.totalRequestCount) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("TOTAL responses: " + this.responseCount + "   where timeouts: " + this.timeoutRespCounter + ",  errors: " + this.errorRespCounter));
                }
                this.notify();
            }
        }
    }

    public synchronized boolean setRequestCount(int pRequestCount) {
        this.totalRequestCount = pRequestCount;
        if (this.totalRequestCount == this.responseCount) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("TOTAL responses: " + this.responseCount + "   where timeouts: " + this.timeoutRespCounter + ",  errors: " + this.errorRespCounter));
            }
            return false;
        }
        return true;
    }

    public OWSet getResponses() {
        return this.responses;
    }

    private static synchronized void sendSnmpReq(AvSnmpEquipment pSnmpEq) {
        if (null == snmpreqth) {
            snmpreqth = new SnmpRequestorThread();
            snmpreqth.start();
        }
        snmpreqth.newSnmpReq(pSnmpEq);
    }

    private static synchronized void snmpReqThreadDone() {
        if (null != snmpreqth) {
            snmpreqth.done();
        }
    }

    private static class SnmpRequestorThread
    extends Thread {
        LinkedList list = new LinkedList();
        boolean bRunning = true;

        private SnmpRequestorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void newSnmpReq(AvSnmpEquipment pSnmpEq) {
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                this.list.add(pSnmpEq);
                this.list.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.bRunning = false;
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                this.list.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.bRunning) {
                AvSnmpEquipment snmpeq = null;
                LinkedList linkedList = this.list;
                synchronized (linkedList) {
                    if (this.list.isEmpty()) {
                        try {
                            this.list.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        snmpeq = (AvSnmpEquipment)this.list.removeFirst();
                    }
                }
                if (null == snmpeq) continue;
                AvSnmpRequestor.newRequest(snmpeq);
            }
        }
    }
}

