/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.pmcollection;

import RedCell.Config.NetworkResource;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.runtime.IOWBean;
import com.ngnms.common.AvDevice;
import com.ngnms.common.AvDeviceUtil;
import com.ngnms.common.AvSLAProfile;
import com.ngnms.common.AvService;
import com.ngnms.common.AvTrace;
import com.ngnms.services.common.AvMOUtil;
import java.io.Serializable;
import redcell.common.commandhandler.RCAbstractQueryAttributeInterrogator;
import redcell.common.commandhandler.RCQueryAttributeResult;

public class AvServiceEquipmentInterrogator
extends RCAbstractQueryAttributeInterrogator {
    public AvServiceEquipmentInterrogator() {
        this(null);
    }

    public AvServiceEquipmentInterrogator(IOWBOMClient pBOM) {
        this.setBOM(pBOM);
        this.setAttribName("ServingDevice");
    }

    public RCQueryAttributeResult getResultValue(IOWBean pBean) {
        AvService svc = (AvService)pBean;
        try {
            AvDevice dev = null;
            AvSLAProfile sla = svc.getSLAProfile();
            dev = null != sla ? sla.getEquipment() : AvMOUtil.getAvDeviceFromMO((NetworkResource)svc);
            if (null != dev) {
                String desc = dev.getDeviceDescription();
                boolean isParent = Class.forName("com.ngnms.common.AvChassisDevice").isAssignableFrom(dev.getClass());
                if (null != desc || 0 == desc.length()) {
                    return new RCQueryAttributeResult((Serializable)((Object)AvDeviceUtil.getDeviceDescription(desc, isParent)), true);
                }
                return new RCQueryAttributeResult((Serializable)((Object)((String)dev.readProperty("Name"))), true);
            }
        }
        catch (Exception e) {
            AvTrace.traceln("AvEms", 1, e.getMessage());
        }
        return new RCQueryAttributeResult((Serializable)((Object)""), false);
    }
}

