/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.pmcollection;

import RedCell.Config.NetworkResource;
import com.ngnms.apps.common.AvSessionUtil;
import com.ngnms.common.AvLookup;
import com.ngnms.common.AvTrace;
import com.ngnms.services.common.AvMOUtil;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class AvPmCollectionUtil
extends AvSessionUtil {
    public static final int PM_VAR_TYPE_DELETED = -1;
    public static final int PM_VAR_TYPE_GAUGE = 1;
    public static final int PM_VAR_TYPE_COUNTER = 2;
    public static final int PM_VAR_TYPE_SYNTHETIC = 4;
    private static final boolean debugOn = Boolean.getBoolean("com.ngnms.apps.pmcollection.AvPmCollectionUtil.debug");
    private static BufferedWriter logBW;
    private static char[] charsToReplace;

    public static int getCVType(int pType) {
        switch (pType) {
            case 0: 
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                return 2;
            }
        }
        return 1;
    }

    public static long getRoundTime(long pTime, int pIntervalInSeconds) {
        long interval = pIntervalInSeconds * 1000;
        long ZoneOffset = Calendar.getInstance().get(15);
        double crtZoneTime = pTime + ZoneOffset;
        long newZoneTime = Math.round(crtZoneTime / (double)interval) * interval;
        return newZoneTime - ZoneOffset;
    }

    public static void main(String[] args) {
        long _tm = System.currentTimeMillis();
        System.out.println("Initial time is " + new Date(_tm));
        _tm = AvPmCollectionUtil.getRoundTime(_tm, 43200);
        System.out.println("Rounded time is " + new Date(_tm));
    }

    private static void log(String pMsg) {
        if (debugOn) {
            try {
                logBW.write(new Date().toString() + ": ");
                logBW.write(pMsg);
                logBW.newLine();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static Hashtable getPMCollectionVariablesForNR(NetworkResource pNR, String pEntityType, String pRoot) {
        try {
            AvTrace.traceln("AvPmCollection", 3, "In getCounters: " + pNR.getHandle() + " " + pEntityType);
            String productLine = AvMOUtil.getAvDeviceFromMO(pNR).getProductLineName();
            AvTrace.traceln("AvPmCollection", 3, "Product Line: " + productLine);
            Hashtable ret = (Hashtable)AvPmCollectionUtil.getPMCollectionVarRecursive(pNR, pEntityType, productLine, pRoot);
            AvTrace.traceln("AvPmCollection", 3, "" + ret);
            return ret;
        }
        catch (Exception e) {
            AvTrace.traceStack("AvPmCollection", 3, e);
            return null;
        }
    }

    private static Object getPMCollectionVarRecursive(NetworkResource pNR, String pEntityType, String pProductLine, String pRoot) throws Exception {
        String value = null;
        try {
            value = AvLookup.get(pRoot, pProductLine + "+" + pEntityType);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (value == null) {
            try {
                value = AvLookup.get(pRoot, pNR);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        AvTrace.traceln("AvPmCollection", 3, "Got: " + pRoot + " " + value);
        if (value == null) {
            return null;
        }
        StringTokenizer plusTokenizer = new StringTokenizer(value, "+");
        Hashtable<String, Object> masterRet = new Hashtable<String, Object>();
        while (plusTokenizer.hasMoreTokens()) {
            String counterName;
            StringTokenizer pipeTokenizer;
            Vector<String[]> ret;
            String catValue;
            String catName;
            String category = plusTokenizer.nextToken();
            if (category.indexOf(";") != -1) {
                StringTokenizer semiColonTokenizer = new StringTokenizer(category, ";");
                while (semiColonTokenizer.hasMoreTokens()) {
                    Object retVal;
                    String subCat = semiColonTokenizer.nextToken();
                    if (subCat.trim().length() <= 0 || null == (retVal = AvPmCollectionUtil.getPMCollectionVarRecursive(pNR, pEntityType, pProductLine, subCat))) continue;
                    masterRet.put(subCat, retVal);
                }
                continue;
            }
            StringTokenizer colonTokenizer = new StringTokenizer(category, ":");
            int colonCount = colonTokenizer.countTokens() - 1;
            if (0 == colonCount) {
                Vector<String[]> ret2 = new Vector<String[]>();
                StringTokenizer pipeTokenizer2 = new StringTokenizer(category, "|");
                while (pipeTokenizer2.hasMoreTokens()) {
                    String counterName2 = pipeTokenizer2.nextToken();
                    ret2.add(AvPmCollectionUtil.getCounterFromToken(counterName2));
                }
                AvTrace.traceln("AvPmCollection", 3, "0 - returning: " + ret2);
                return ret2;
            }
            if (1 == colonCount) {
                catName = colonTokenizer.nextToken();
                catValue = colonTokenizer.nextToken();
                ret = new Vector<String[]>();
                pipeTokenizer = new StringTokenizer(catValue, "|");
                while (pipeTokenizer.hasMoreTokens()) {
                    counterName = pipeTokenizer.nextToken();
                    ret.add(AvPmCollectionUtil.getCounterFromToken(counterName));
                }
                AvTrace.traceln("AvPmCollection", 3, "1 - adding: " + catName + "=" + ret);
                masterRet.put(catName, ret);
                continue;
            }
            catName = colonTokenizer.nextToken();
            colonTokenizer.nextToken();
            catValue = colonTokenizer.nextToken();
            ret = new Vector();
            pipeTokenizer = new StringTokenizer(catValue, "|");
            while (pipeTokenizer.hasMoreTokens()) {
                counterName = pipeTokenizer.nextToken();
                ret.add(AvPmCollectionUtil.getCounterFromToken(counterName));
            }
            AvTrace.traceln("AvPmCollection", 3, "2 - adding: " + catName + "=" + ret);
            masterRet.put(catName, ret);
        }
        AvTrace.traceln("AvPmCollection", 3, "Returning: " + masterRet);
        return masterRet;
    }

    public static String[] getCounterFromToken(String pToken) {
        String counterName = null;
        String counterLabel = null;
        String counterType = null;
        int commaIdx = pToken.indexOf(44);
        if (commaIdx == -1) {
            counterName = counterLabel = pToken;
        } else {
            counterName = counterLabel = pToken.substring(0, commaIdx);
            counterType = pToken.substring(commaIdx + 1);
        }
        return new String[]{counterName, counterLabel, counterType};
    }

    public static String processDynamicTableSpec(String pDynamicTableSpec, Vector retVariables, Vector retVarNames) {
        StringTokenizer colonTokenizer = new StringTokenizer(pDynamicTableSpec, ":");
        String tableName = colonTokenizer.nextToken();
        String instances = colonTokenizer.nextToken();
        String vars = colonTokenizer.nextToken();
        StringTokenizer pipeTokenizer = new StringTokenizer(vars, "|");
        while (pipeTokenizer.hasMoreTokens()) {
            String varName = pipeTokenizer.nextToken();
            retVarNames.add(varName);
            retVariables.add(varName + "::" + instances + "::" + tableName);
        }
        return tableName;
    }

    public static String processScalarGroupSpec(String pScalarGroupSpec, Vector retVariables, Vector retVarNames) {
        StringTokenizer colonTokenizer = new StringTokenizer(pScalarGroupSpec, ":");
        String groupName = colonTokenizer.nextToken();
        String vars = colonTokenizer.nextToken();
        StringTokenizer pipeTokenizer = new StringTokenizer(vars, "|");
        while (pipeTokenizer.hasMoreTokens()) {
            String varName = pipeTokenizer.nextToken();
            retVarNames.add(varName);
            retVariables.add(varName + "::" + groupName);
        }
        return groupName;
    }

    public static String normalizeFileName(String pFileName) {
        String fileName = pFileName;
        for (int i = 0; i < charsToReplace.length; ++i) {
            fileName = fileName.replace(charsToReplace[i], '_');
        }
        return fileName;
    }

    static {
        if (debugOn) {
            try {
                logBW = new BufferedWriter(new FileWriter("pmutil.log"));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        charsToReplace = new char[]{' ', '/', '\\', '*', '?', '<', '>', '|', ':'};
    }
}

