/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.pmcollection;

import com.bwanms.performance.PMCollectionEntityTypeUtil;
import com.bwanms.performance.PerformanceCollectionEntity;
import com.bwanms.performance.PerformanceCollectionLookup;
import com.bwanms.performance.db.PmCollectionVariable;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.apps.pmcollection.AvPmCollectionGetProfileCountersParamSet;
import com.ngnms.apps.pmcollection.AvPmCollectionGetProfileCountersRule;
import com.ngnms.apps.pmcollection.AvPmCollectionUtil;
import com.ngnms.apps.pmcollection.AvPmGetRowInstancesRuleParamSet;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AvPmCollectionGetProfileCountersRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvPmCollectionGetProfileCountersRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        this.runRule((AvPmCollectionGetProfileCountersParamSet)event);
    }

    public void runRule(AvPmCollectionGetProfileCountersParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        try {
            String taskId = pParamSet.getSessionName();
            final String entityId = pParamSet.getEntityOID();
            String entityType = pParamSet.getEntityType();
            final ArrayList entityList = new ArrayList();
            new RunnableDatastoreDecorator(new Runnable(){

                public void run() {
                    try {
                        entityList.add((PerformanceCollectionEntity)Datastore.session().get(PerformanceCollectionEntity.class, (Serializable)new Long(entityId)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
            }).run();
            PerformanceCollectionEntity pcEntity = (PerformanceCollectionEntity)entityList.get(0);
            Vector profileCollVars = this.getCollectionVariables(taskId, pcEntity);
            LinkedHashMap<String, AbstractCollection> varCats = new LinkedHashMap<String, AbstractCollection>();
            LinkedHashMap<String, String> varOids = new LinkedHashMap<String, String>();
            LinkedHashSet<String> varNames = new LinkedHashSet<String>();
            for (PmCollectionVariable cv : profileCollVars) {
                if (-1 == cv.getType()) continue;
                String varName = cv.getName();
                String varOid = cv.getSnmpOid();
                log4j.debug((Object)("Got: " + varName + " " + varOid));
                int bracketIdx = varName.indexOf("[");
                if (bracketIdx != -1) {
                    varName = varName.substring(0, bracketIdx);
                }
                varNames.add(varName);
                int colonIndex = varOid.indexOf(":");
                varOids.put(varName, varOid.substring(0, colonIndex));
                varOid = varOid.substring(colonIndex + 1);
                int doubleColonIndex = varOid.indexOf("::");
                if (doubleColonIndex == -1) {
                    if (varCats.containsKey(varOid)) continue;
                    varCats.put(varOid, new Vector());
                    continue;
                }
                String varInstance = varOid.substring(doubleColonIndex + 2);
                LinkedHashSet<String> varInstances = (LinkedHashSet<String>)varCats.get(varOid = varOid.substring(0, doubleColonIndex));
                if (varInstances == null) {
                    varInstances = new LinkedHashSet<String>();
                    varCats.put(varOid, varInstances);
                    varInstances.add(varInstance);
                    continue;
                }
                if (varInstances.contains(varInstance)) continue;
                varInstances.add(varInstance);
            }
            log4j.debug((Object)("VarCats: " + varCats));
            log4j.debug((Object)("VarNames: " + varNames));
            Map iniCategories = AvPmCollectionGetProfileCountersRuleImpl.getPMCollectionVariablesForME(pcEntity.getEntity(), entityType, "PMCollectionCategories");
            this.pruneCategory(iniCategories, varCats, varNames);
            this.inflateInstances(iniCategories, varCats, varOids);
            this.pruneEmptyCategories(iniCategories, varCats);
            pParamSet.setResponse((Serializable)((Object)iniCategories));
        }
        catch (Exception e) {
            log4j.error((Object)e, (Throwable)e);
            pParamSet.setResponse(new LinkedHashMap());
        }
    }

    private Vector getCollectionVariables(String taskId, PerformanceCollectionEntity pcEntity) throws Exception {
        if (null == pcEntity.getEntity()) {
            return null;
        }
        List counters = (List)((Object)pcEntity.getCounters());
        if (null == counters || 0 == counters.size()) {
            return new Vector();
        }
        String sessionName = taskId;
        String nrKey = String.valueOf(pcEntity.getEntityId());
        Vector<PmCollectionVariable> ret = new Vector<PmCollectionVariable>();
        for (Object[] crtVars : counters) {
            if (null != crtVars[1]) continue;
            List _cvs = (List)crtVars[2];
            for (int j = 0; j < _cvs.size(); ++j) {
                PmCollectionVariable _cv = (PmCollectionVariable)_cvs.get(j);
                if (-1 == _cv.getType()) continue;
                PmCollectionVariable _ccv = new PmCollectionVariable();
                _ccv.setName(_cv.getName());
                _ccv.setType(_cv.getType());
                _ccv.setSnmpOid(Integer.toString(j) + ":" + crtVars[0]);
                ret.add(_ccv);
            }
        }
        AvPmGetRowInstancesRuleParamSet ps = new AvPmGetRowInstancesRuleParamSet();
        ps.setSessionID(sessionName);
        ps.setDeviceID(nrKey);
        this.callRule("com.ngnms.apps.pmcollection.AvPmGetRowInstancesRule", (OWEvent)ps);
        List rowInstances = ps.getRowInstances();
        if (null != rowInstances) {
            block4: for (String _rowInst : rowInstances) {
                int _sepIdx = _rowInst.indexOf("::");
                if (-1 == _sepIdx) continue;
                String _instName = _rowInst.substring(0, _sepIdx);
                String _instValue = _rowInst.substring(_sepIdx + 2);
                try {
                    for (int i = 0; i < counters.size(); ++i) {
                        Object[] crtVars = (Object[])counters.get(i);
                        String _tblName = (String)crtVars[0];
                        if (!_tblName.equals(_instName)) continue;
                        List _vc = (List)crtVars[2];
                        for (int j = 0; j < _vc.size(); ++j) {
                            PmCollectionVariable _cv = (PmCollectionVariable)_vc.get(j);
                            if (-1 == _cv.getType()) continue;
                            PmCollectionVariable _ccv = new PmCollectionVariable();
                            _ccv.setName(_cv.getName() + "[ " + _instValue + " ]");
                            _ccv.setType(_cv.getType());
                            _ccv.setSnmpOid(Integer.toString(j) + ":" + _rowInst);
                            ret.add(_ccv);
                        }
                        continue block4;
                    }
                }
                catch (Exception _e) {
                    _e.printStackTrace();
                }
            }
        }
        return ret;
    }

    private void pruneCategory(Map pCategoryHash, Map pSelectedCounters, Set pSelectedNames) {
        Iterator i = pCategoryHash.keySet().iterator();
        while (i.hasNext()) {
            String catName = (String)i.next();
            Object catValue = pCategoryHash.get(catName);
            if (catValue instanceof Map) {
                Map catValueHash = (Map)catValue;
                this.pruneCategory(catValueHash, pSelectedCounters, pSelectedNames);
                if (!catValueHash.isEmpty()) continue;
                log4j.debug((Object)("Pruning 1: " + catName));
                i.remove();
                continue;
            }
            Collection counters = (Collection)catValue;
            Iterator j = counters.iterator();
            while (j.hasNext()) {
                String[] counter = (String[])j.next();
                if (pSelectedNames.contains(counter[0])) continue;
                j.remove();
            }
            if (pSelectedCounters.containsKey(catName) && !counters.isEmpty()) continue;
            log4j.debug((Object)("Pruning 2: " + catName));
            i.remove();
        }
    }

    private void pruneEmptyCategories(Map pCategoryHash, Map pSelectedCounters) {
        Vector orphanCounters = new Vector();
        Iterator i = pCategoryHash.keySet().iterator();
        while (i.hasNext()) {
            String catName = (String)i.next();
            Object catValue = pCategoryHash.get(catName);
            if (catValue instanceof Map) {
                Map catValueHash = (Map)catValue;
                this.pruneEmptyCategories(catValueHash, pSelectedCounters);
                if (!catValueHash.isEmpty()) continue;
                log4j.debug((Object)("Pruning empty category: " + catName));
                i.remove();
                continue;
            }
            Collection counters = (Collection)catValue;
            Collection instances = (Collection)pSelectedCounters.get(catName);
            if (instances == null || !instances.isEmpty()) continue;
            orphanCounters.addAll(counters);
            i.remove();
        }
        if (!orphanCounters.isEmpty()) {
            pCategoryHash.put("{leafs}", orphanCounters);
        }
    }

    private void inflateInstances(Map pCategoryHash, Map pInstances, Map pOids) {
        LinkedHashMap toAdd = new LinkedHashMap();
        Iterator i = pCategoryHash.keySet().iterator();
        while (i.hasNext()) {
            String catName = (String)i.next();
            Object catValue = pCategoryHash.get(catName);
            if (catValue instanceof Map) {
                this.inflateInstances((Map)catValue, pInstances, pOids);
                continue;
            }
            Vector counters = (Vector)catValue;
            Collection instances = (Collection)pInstances.get(catName);
            if (!"{leafs}".equals(catName) && instances != null && !instances.isEmpty()) {
                i.remove();
                for (String instance : instances) {
                    Vector<String[]> newCounters = new Vector<String[]>(counters.size());
                    for (String[] counter : counters) {
                        String[] newCounter = new String[counter.length];
                        newCounter[0] = pOids.get(counter[0]) + "::" + catName + "::" + instance;
                        newCounter[1] = counter[0] + "::" + instance;
                        for (int l = 2; l < counter.length; ++l) {
                            newCounter[l] = counter[l];
                        }
                        newCounters.add(newCounter);
                    }
                    toAdd.put(catName + "::" + instance, newCounters);
                }
                continue;
            }
            for (String[] counter : counters) {
                counter[0] = (String)pOids.get(counter[0]) + "::" + catName;
            }
        }
        for (String key : toAdd.keySet()) {
            pCategoryHash.put(key, toAdd.get(key));
        }
    }

    public static Map getPMCollectionVariablesForME(Serializable me, String entityType, String pRoot) {
        try {
            PerformanceCollectionLookup lookup = PMCollectionEntityTypeUtil.getLookupByEntityType((String)entityType);
            String value = lookup.get(pRoot);
            Map ret = (Map)AvPmCollectionGetProfileCountersRuleImpl.getPMCollectionVarRecursive(lookup, me, value);
            return ret;
        }
        catch (Exception e) {
            log4j.debug((Object)e, (Throwable)e);
            return null;
        }
    }

    private static Object getPMCollectionVarRecursive(PerformanceCollectionLookup lookup, Serializable me, String value) throws Exception {
        if (value == null) {
            return null;
        }
        StringTokenizer plusTokenizer = new StringTokenizer(value, "+");
        LinkedHashMap<String, Object> masterRet = new LinkedHashMap<String, Object>();
        while (plusTokenizer.hasMoreTokens()) {
            String counterName;
            StringTokenizer pipeTokenizer;
            Vector<String[]> ret;
            String catValue;
            String catName;
            String category = plusTokenizer.nextToken();
            if (category.indexOf(";") != -1) {
                StringTokenizer semiColonTokenizer = new StringTokenizer(category, ";");
                while (semiColonTokenizer.hasMoreTokens()) {
                    Object retVal;
                    String subCat = semiColonTokenizer.nextToken();
                    if (subCat.trim().length() <= 0) continue;
                    String subValue = null;
                    try {
                        subValue = lookup.get(subCat, me);
                        if (subValue == null) {
                            continue;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (null == (retVal = AvPmCollectionGetProfileCountersRuleImpl.getPMCollectionVarRecursive(lookup, me, subValue))) continue;
                    masterRet.put(subCat, retVal);
                }
                continue;
            }
            StringTokenizer colonTokenizer = new StringTokenizer(category, ":");
            int colonCount = colonTokenizer.countTokens() - 1;
            if (0 == colonCount) {
                Vector<String[]> ret2 = new Vector<String[]>();
                StringTokenizer pipeTokenizer2 = new StringTokenizer(category, "|");
                while (pipeTokenizer2.hasMoreTokens()) {
                    String counterName2 = pipeTokenizer2.nextToken();
                    ret2.add(AvPmCollectionUtil.getCounterFromToken(counterName2));
                }
                log4j.debug((Object)("0 - returning: " + ret2));
                return ret2;
            }
            if (1 == colonCount) {
                catName = colonTokenizer.nextToken();
                catValue = colonTokenizer.nextToken();
                ret = new Vector<String[]>();
                pipeTokenizer = new StringTokenizer(catValue, "|");
                while (pipeTokenizer.hasMoreTokens()) {
                    counterName = pipeTokenizer.nextToken();
                    ret.add(AvPmCollectionUtil.getCounterFromToken(counterName));
                }
                log4j.debug((Object)("1 - adding: " + catName + "=" + ret));
                masterRet.put(catName, ret);
                continue;
            }
            catName = colonTokenizer.nextToken();
            colonTokenizer.nextToken();
            catValue = colonTokenizer.nextToken();
            ret = new Vector();
            pipeTokenizer = new StringTokenizer(catValue, "|");
            while (pipeTokenizer.hasMoreTokens()) {
                counterName = pipeTokenizer.nextToken();
                ret.add(AvPmCollectionUtil.getCounterFromToken(counterName));
            }
            log4j.debug((Object)("2 - adding: " + catName + "=" + ret));
            masterRet.put(catName, ret);
        }
        log4j.debug((Object)("Returning: " + masterRet));
        return masterRet;
    }
}

