/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.pmcollection;

import com.ngnms.apps.pmcollection.AvPMCounterNode;
import com.ngnms.common.AvClientInternationalizer;

public class AvPMCounterNodeUtil {
    public static void translateNodes(AvPMCounterNode pRootNode, AvClientInternationalizer pInternationalizer) {
        final AvClientInternationalizer fInternationalizer = pInternationalizer;
        pRootNode.visit(new AvPMCounterNode.Visitor(){

            public void visit(AvPMCounterNode pNode) {
                String formatTrans;
                String format;
                String label = pNode.getLabel();
                pNode.setLabel(fInternationalizer.translateText(label));
                String unit = label + "_unit";
                String unitTrans = fInternationalizer.translateText(unit);
                if (!unit.equals(unitTrans)) {
                    pNode.setUnit(unitTrans);
                }
                if (!(format = label + "_format").equals(formatTrans = fInternationalizer.translateText(format))) {
                    pNode.setFormat(formatTrans);
                }
            }
        });
    }

    public static void setNodesDisplayMode(AvPMCounterNode pRootNode, int pDisplayMode) {
        final int fDisplayMode = pDisplayMode;
        pRootNode.visit(new AvPMCounterNode.Visitor(){

            public void visit(AvPMCounterNode pNode) {
                pNode.setDisplayMode(fDisplayMode);
            }
        });
    }

    public static void setNodesDisplayModeByCounterType(AvPMCounterNode pRootNode) {
        pRootNode.visit(new AvPMCounterNode.Visitor(){

            public void visit(AvPMCounterNode pNode) {
                int displayMode = 0;
                switch (pNode.getCounterType()) {
                    case 1: {
                        displayMode = 2;
                        break;
                    }
                    case 2: {
                        displayMode = 1;
                        break;
                    }
                    default: {
                        displayMode = 17;
                    }
                }
                pNode.setDisplayMode(displayMode |= 0x10);
            }
        });
    }

    public static void setNodesSelected(AvPMCounterNode pRootNode, boolean pSelected) {
        final boolean fSelected = pSelected;
        pRootNode.visit(new AvPMCounterNode.Visitor(){

            public void visit(AvPMCounterNode pNode) {
                pNode.setSelected(fSelected);
            }
        });
    }

    public static void setNodesEntityLabel(AvPMCounterNode pRootNode, String pEntityLabel) {
        final String fEntityLabel = pEntityLabel;
        pRootNode.visit(new AvPMCounterNode.Visitor(){

            public void visit(AvPMCounterNode pNode) {
                pNode.setEntityLabel(fEntityLabel);
            }
        });
    }

    public static void setNodesCounterType(AvPMCounterNode pRootNode, int pCounterType) {
        final int fCounterType = pCounterType;
        pRootNode.visit(new AvPMCounterNode.Visitor(){

            public void visit(AvPMCounterNode pNode) {
                pNode.setCounterType(fCounterType);
            }
        });
    }

    public static void removeNodesCounterType(AvPMCounterNode pRootNode, int pCounterType, int pDefaultType) {
        final int fCounterType = pCounterType;
        final int fDefaultType = pDefaultType;
        pRootNode.visit(new AvPMCounterNode.Visitor(){

            public void visit(AvPMCounterNode pNode) {
                if (0 != (fCounterType & pNode.getCounterType())) {
                    int newType = pNode.getCounterType() & ~fCounterType;
                    pNode.setCounterType(0 < newType ? newType : fDefaultType);
                }
            }
        });
    }
}

