/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.pmcollection;

import com.ngnms.apps.pmcollection.AvPMCounterStyle;
import com.ngnms.apps.pmcollection.IAvGPMCounterDefinition;
import com.ngnms.apps.pmcollection.IAvPMCounterNodeListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class AvPMCounterNode
implements Serializable,
IAvGPMCounterDefinition {
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.apps.pmcollection.debug");
    private static Hashtable formatCache = new Hashtable();
    private static final String DEFAULT_FORMAT = "0.##";
    private AvPMCounterNode parent = null;
    private Vector children = null;
    private String path;
    private int depth;
    private transient IAvPMCounterNodeListener listener;
    private boolean translated;
    private String name;
    private String label;
    private double value = 0.0;
    private double scale = 1.0;
    private double minBound = 0.0;
    private double maxBound = 100.0;
    private boolean selected;
    private String entityID;
    private String style;
    private boolean loaded;
    private boolean expanded;
    private boolean category = true;
    private boolean overflow;
    private String unit;
    private int counterType = -1;
    private int displayMode = 5;
    private String entityLabel = "";
    private String format;
    private transient DecimalFormat formatter;
    private boolean grayedOut = false;
    private static HashMap<Double, String> scaleMapString = new HashMap();

    public AvPMCounterNode(AvPMCounterNode pParent, String pEntityID, String pName, String pLabel) {
        this.parent = pParent;
        this.entityID = pEntityID;
        this.name = pName;
        this.label = pLabel;
        this.style = AvPMCounterStyle.getDefaultStyleString();
        if (this.parent == null) {
            this.path = this.entityID + "/" + this.name;
            this.depth = 0;
        } else {
            this.path = this.parent.path + "/" + this.name;
            this.depth = this.parent.depth + 1;
        }
        this.loaded = false;
        this.expanded = false;
        if (debugOn) {
            System.out.println("Created: " + this.path);
        }
    }

    public boolean isCategory() {
        return this.category;
    }

    public String getPath() {
        return this.path;
    }

    public int getDepth() {
        return this.depth;
    }

    public void addChild(AvPMCounterNode pChild) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.add(pChild);
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.fireNodeChanged();
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.fireNodeChanged();
    }

    public double getMinBound() {
        return this.minBound;
    }

    public void setMinBound(double minBound) {
        this.minBound = minBound;
        this.fireNodeChanged();
    }

    public double getMaxBound() {
        return this.maxBound;
    }

    public void setMaxBound(double maxBound) {
        this.maxBound = maxBound;
        this.fireNodeChanged();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (selected != this.selected) {
            this.selected = selected;
            if (selected) {
                this.fireNodeSelected();
            } else {
                this.fireNodeDeselected();
            }
        }
    }

    public String getExtendedLabel() {
        return this.value + ", " + this.minBound + ", " + this.maxBound;
    }

    public String getEntityID() {
        return this.entityID;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
        this.fireNodeChanged();
    }

    public String toString() {
        return this.path;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    private void setCategory(boolean pCategory) {
        this.category = pCategory;
    }

    private void loadLeafs(List pData) {
        Iterator i = pData.iterator();
        while (i.hasNext()) {
            AvPMCounterNode child = null;
            String[] leaf = (String[])i.next();
            if (leaf.length > 2 && null != leaf[2]) {
                int type = Integer.parseInt(leaf[2]);
                if (type == 1 || type == 2) {
                    child = new AvPMCounterNode(this, this.entityID, leaf[0], leaf[1]);
                    child.setCounterType(type);
                }
            } else {
                child = new AvPMCounterNode(this, this.entityID, leaf[0], leaf[1]);
                child.setCounterType(-1);
            }
            if (child == null) continue;
            child.setCategory(false);
            child.setLoaded(true);
            this.addChild(child);
        }
    }

    public void load(Object pData) {
        if (pData instanceof List) {
            this.loadLeafs((List)pData);
        } else {
            Map pHashData = (Map)pData;
            for (String key : pHashData.keySet()) {
                Object data = pHashData.get(key);
                if ("{leafs}".equals(key)) {
                    this.loadLeafs((List)data);
                    continue;
                }
                AvPMCounterNode child = new AvPMCounterNode(this, this.entityID, key, key);
                child.setCategory(true);
                this.addChild(child);
                if ("".equals(data)) continue;
                child.load(data);
            }
        }
        this.loaded = true;
    }

    public boolean isChildOf(AvPMCounterNode pCandidate) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent == pCandidate) {
            return true;
        }
        return this.parent.isChildOf(pCandidate);
    }

    public boolean hasSelectedChildren() {
        if (this.children == null) {
            return this.selected;
        }
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            if (!((AvPMCounterNode)i.next()).hasSelectedChildren()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAllChildrenSelected() {
        if (this.children == null) {
            return this.selected;
        }
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            if (((AvPMCounterNode)i.next()).hasAllChildrenSelected()) continue;
            return false;
        }
        return true;
    }

    public void getSelectedChildren(Collection pRet) {
        Vector ret = new Vector();
        if (this.children != null) {
            for (AvPMCounterNode child : this.children) {
                if (child.isCategory()) {
                    child.getSelectedChildren(pRet);
                    continue;
                }
                if (!child.isSelected()) continue;
                pRet.add(child);
            }
        }
    }

    public void setChildrenSelected(boolean pSelected) {
        this.setSelected(pSelected);
        if (this.children != null) {
            for (AvPMCounterNode child : this.children) {
                child.setChildrenSelected(pSelected);
            }
        }
    }

    public Vector getChildren() {
        return this.children;
    }

    public void fillPathHash(Hashtable pRet) {
        pRet.put(this.path, this);
        if (this.children != null) {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                ((AvPMCounterNode)i.next()).fillPathHash(pRet);
            }
        }
    }

    public AvPMCounterNode getParent() {
        return this.parent;
    }

    public void setPMCounterNodeListener(IAvPMCounterNodeListener pListener) {
        final IAvPMCounterNodeListener pFinalListener = pListener;
        this.visit(new Visitor(){

            public void visit(AvPMCounterNode pNode) {
                pNode.listener = pFinalListener;
            }
        });
    }

    private void fireNodeChanged() {
        if (this.listener != null) {
            this.listener.nodeChanged(this);
        }
    }

    private void fireNodeSelected() {
        if (this.listener != null) {
            this.listener.nodeSelected(this);
        }
    }

    private void fireNodeDeselected() {
        if (this.listener != null) {
            this.listener.nodeDeselected(this);
        }
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    public void setOverflow(boolean overflow) {
        this.overflow = overflow;
    }

    public String getCounterID() {
        return this.path;
    }

    public double[] getBounds() {
        return new double[]{this.minBound, this.maxBound};
    }

    public void visit(Visitor pVisitor) {
        pVisitor.visit(this);
        if (this.children != null) {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                ((AvPMCounterNode)i.next()).visit(pVisitor);
            }
        }
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public int getCounterType() {
        return this.counterType;
    }

    public void setCounterType(int counterType) {
        this.counterType = counterType;
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(int displayMode) {
        this.displayMode = displayMode;
    }

    public String getEntityLabel() {
        return this.entityLabel;
    }

    public void setEntityLabel(String entityLabel) {
        this.entityLabel = entityLabel;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
        this.createFormat();
    }

    private void createFormat() {
        try {
            String _format = this.format == null ? DEFAULT_FORMAT : this.format;
            this.formatter = (DecimalFormat)formatCache.get(_format);
            if (this.formatter == null) {
                this.formatter = new DecimalFormat(_format);
                formatCache.put(_format, this.formatter);
            }
        }
        catch (Exception e) {
            this.formatter = new DecimalFormat(DEFAULT_FORMAT);
        }
    }

    public String getValueString() {
        return this.formatValue(this.value);
    }

    public String formatValue(double pValue) {
        if (this.formatter == null) {
            this.createFormat();
        }
        return Double.isNaN(pValue) ? "-" : this.formatter.format(pValue);
    }

    public boolean isTranslated() {
        return this.translated;
    }

    public void setTranslated(boolean translated) {
        this.translated = translated;
    }

    public static String getScaleString(double scaleValue) {
        return scaleMapString.get(scaleValue);
    }

    public boolean isGrayedOut() {
        return this.grayedOut;
    }

    public void setGrayedOut(boolean grayedOut) {
        this.grayedOut = grayedOut;
        if (grayedOut) {
            this.setSelected(false);
        }
    }

    static {
        scaleMapString.put(1.0E-8, "1.0E-8");
        scaleMapString.put(1.0E-7, "1.0E-7");
        scaleMapString.put(1.0E-6, "1.0E-6");
        scaleMapString.put(1.0E-5, "1.0E-5");
        scaleMapString.put(1.0E-4, "1.0E-4");
        scaleMapString.put(0.001, "0.001");
        scaleMapString.put(0.01, "0.01");
        scaleMapString.put(0.1, "0.1");
        scaleMapString.put(1.0, "1");
        scaleMapString.put(10.0, "10");
        scaleMapString.put(100.0, "100");
        scaleMapString.put(1000.0, "1000");
        scaleMapString.put(10000.0, "1.0E4");
        scaleMapString.put(100000.0, "1.0E5");
        scaleMapString.put(1000000.0, "1.0E6");
        scaleMapString.put(1.0E7, "1.0E7");
        scaleMapString.put(1.0E8, "1.0E8");
    }

    public static interface Visitor {
        public void visit(AvPMCounterNode var1);
    }
}

