/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.pmcollection;

import java.util.Vector;
import jclass.chart.ChartDataSupport;
import jclass.chart.Chartable;

public class AvMultiCounterGraphData
extends ChartDataSupport
implements Chartable {
    private static final long serialVersionUID = 3916974551847017347L;
    private static Double POSITIVE_OVERFLOW = new Double(101.0);
    private static Double NEGATIVE_OVERFLOW = new Double(-101.0);
    private static int MAX_SERIES_SIZE = 8640;
    String name;
    private long startTime = 0L;
    private double lastTime = 0.0;
    private double holeValue;
    Vector series = new Vector();

    public AvMultiCounterGraphData(String pName, double pHoleValue) {
        this(pName, pHoleValue, System.currentTimeMillis());
    }

    public AvMultiCounterGraphData(String pName, double pHoleValue, long pStartTime) {
        this.name = pName;
        this.holeValue = pHoleValue;
        this.startTime = pStartTime;
    }

    void setSeriesDisplayMode(int pSerIdx, int pDisplayMode) {
        ((AvMultiGraphSeries)this.series.elementAt(pSerIdx)).setMode(pDisplayMode);
        this.fireChartDataEvent(14, 0, 0);
    }

    void addSeries(String pSerId, String pSerLabel, int pDisplayMode) {
        this.series.addElement(new AvMultiGraphSeries(pSerId, pSerLabel, pDisplayMode));
    }

    void removeSeries(int pSerIdx) {
        this.series.removeElementAt(pSerIdx);
    }

    void resetSeries(int pSerIdx) {
        ((AvMultiGraphSeries)this.series.elementAt(pSerIdx)).reset();
    }

    public int getSeriesIndex(String pSerId) {
        for (int i = 0; i < this.series.size(); ++i) {
            if (!((AvMultiGraphSeries)this.series.elementAt((int)i)).id.equals(pSerId)) continue;
            return i;
        }
        return -1;
    }

    String getSeriesByIndex(int pSerIdx) {
        return ((AvMultiGraphSeries)this.series.elementAt((int)pSerIdx)).id;
    }

    int getSeriesCount() {
        return this.series.size();
    }

    public double[] getSeriesBounds(String pSerId) {
        for (int i = 0; i < this.series.size(); ++i) {
            AvMultiGraphSeries _ser = (AvMultiGraphSeries)this.series.elementAt(i);
            if (!_ser.getId().equals(pSerId)) continue;
            return _ser.getBounds();
        }
        return null;
    }

    public double[] getSeriesBounds(int pSerIdx) {
        return ((AvMultiGraphSeries)this.series.elementAt(pSerIdx)).getBounds();
    }

    public void setSeriesBounds(int pSerIdx, double pMin, double pMax) {
        ((AvMultiGraphSeries)this.series.elementAt(pSerIdx)).setBounds(pMin, pMax);
    }

    public double getSeriesScale(int pSerIdx) {
        return ((AvMultiGraphSeries)this.series.elementAt(pSerIdx)).getScale();
    }

    public void setSeriesScale(int pSerIdx, double pScale) {
        ((AvMultiGraphSeries)this.series.elementAt(pSerIdx)).setScale(pScale);
    }

    public void setSeriesLabel(int pSerIdx, String pLabel) {
        AvMultiGraphSeries _ser = (AvMultiGraphSeries)this.series.elementAt(pSerIdx);
        _ser.setLabel(pLabel);
    }

    double getLastTime() {
        return this.lastTime;
    }

    int getSize(int pSeriesIdx) {
        return pSeriesIdx < this.series.size() ? ((AvMultiGraphSeries)this.series.elementAt(pSeriesIdx)).getSize() : -1;
    }

    int addValue(int pSerIdx, Number pValue, long pTime) {
        double _time = (double)(pTime - this.startTime) / 1000.0;
        AvMultiGraphSeries _ser = (AvMultiGraphSeries)this.series.elementAt(pSerIdx);
        boolean _bReset = _ser.add(new Double(_time), pValue);
        this.lastTime = _time;
        if (_bReset) {
            return 0;
        }
        return _ser.getSize() - 1;
    }

    public Number[] getLastValue(int pSerIdx) {
        Number[] _lastValue = null;
        AvMultiGraphSeries _ser = (AvMultiGraphSeries)this.series.elementAt(pSerIdx);
        if (_ser.getSize() > 0) {
            _lastValue = new Number[]{_ser.getLastX(), _ser.getLastY()};
        }
        return _lastValue;
    }

    public Number[] getLastValueUntrimmed(int pSerIdx) {
        Number[] _lastValue = null;
        AvMultiGraphSeries _ser = (AvMultiGraphSeries)this.series.elementAt(pSerIdx);
        if (_ser.getSize() > 0) {
            _lastValue = new Number[]{_ser.getLastX(), _ser.yvalues.size() > 0 ? (Number)_ser.getYUntrimmed(_ser.yvalues.size() - 1) : (Number)null};
        }
        return _lastValue;
    }

    public int getDataInterpretation() {
        return 1;
    }

    public Object getDataItem(int pRow, int pColumn) {
        int _serIdx = pRow / 2;
        AvMultiGraphSeries _ser = (AvMultiGraphSeries)this.series.elementAt(_serIdx);
        if (2 * _serIdx == pRow) {
            return _ser.getX(pColumn);
        }
        return _ser.getY(pColumn);
    }

    public Vector getRow(int pRow) {
        int _serIdx = pRow / 2;
        AvMultiGraphSeries _ser = (AvMultiGraphSeries)this.series.elementAt(_serIdx);
        if (2 * _serIdx == pRow) {
            return _ser.getX();
        }
        return _ser.getY();
    }

    public int getNumRows() {
        return 2 * this.series.size();
    }

    public String[] getPointLabels() {
        return null;
    }

    public Vector getSeries() {
        return this.series;
    }

    public Vector getSeriesNames() {
        Vector<String> seriesNames = new Vector<String>();
        for (int i = 0; i < this.series.size(); ++i) {
            seriesNames.addElement(((AvMultiGraphSeries)this.series.elementAt((int)i)).id);
        }
        return seriesNames;
    }

    public Vector getSeriesLabels() {
        Vector<String> seriesLabels = new Vector<String>();
        for (int i = 0; i < this.series.size(); ++i) {
            seriesLabels.addElement(this.getSeriesLabel(i));
        }
        return seriesLabels;
    }

    public String getSeriesName(int pRow) {
        return ((AvMultiGraphSeries)this.series.elementAt(pRow)).getId();
    }

    public String getSeriesLabel(int pRow) {
        return ((AvMultiGraphSeries)this.series.elementAt(pRow)).getLabel();
    }

    public String getName() {
        return this.name;
    }

    private class AvMultiGraphSeries {
        String id;
        String label;
        private Vector xvalues;
        private Vector yvalues;
        private double minValue = 0.0;
        private double maxValue = 100.0;
        private double range = 100.0;
        private double scale = 1.0;
        private int mode;

        public AvMultiGraphSeries(String pId, String pLabel, int pMode) {
            this.id = pId;
            this.label = pLabel;
            this.xvalues = new Vector();
            this.yvalues = new Vector();
            this.minValue = 0.0;
            this.maxValue = 100.0;
            this.scale = 1.0;
            this.range = 100.0;
            this.mode = pMode;
        }

        public void setMode(int pMode) {
            this.mode = pMode;
        }

        public double getScale() {
            return this.scale;
        }

        public void setScale(double pScale) {
            this.scale = pScale;
        }

        public double[] getBounds() {
            return new double[]{this.minValue, this.maxValue};
        }

        public void setBounds(double pMin, double pMax) {
            this.minValue = pMin;
            this.maxValue = pMax;
            this.range = pMax - pMin;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String pLabel) {
            this.label = pLabel;
        }

        public int getSize() {
            return this.xvalues.size();
        }

        public void reset() {
            this.xvalues.clear();
            this.yvalues.clear();
        }

        public boolean add(Number px, Number py) {
            boolean _bReset = false;
            if (this.getSize() >= MAX_SERIES_SIZE) {
                _bReset = true;
                this.trim();
            }
            this.xvalues.addElement(px);
            if (!Double.isNaN(py.doubleValue())) {
                this.yvalues.addElement(py);
            } else {
                this.yvalues.addElement(new Double(AvMultiCounterGraphData.this.holeValue));
            }
            return _bReset;
        }

        public Number[] get(int pColumn) {
            return new Number[]{this.getX(pColumn), this.getY(pColumn)};
        }

        public Vector getX() {
            return (Vector)this.xvalues.clone();
        }

        public Vector getY() {
            if ((this.mode & 1) != 0 && (this.mode & 4) != 0) {
                return (Vector)this.yvalues.clone();
            }
            Vector<Number> _yvalz = new Vector<Number>(this.yvalues.size());
            for (int i = 0; i < this.yvalues.size(); ++i) {
                _yvalz.addElement(this.getY(i));
            }
            return _yvalz;
        }

        public final Number getX(int pColumn) {
            return (Number)this.xvalues.elementAt(pColumn);
        }

        public Number getY(int pColumn) {
            Number y = (this.mode & 2) != 0 ? (Number)this.getDerivedY(pColumn) : (Number)((Double)this.yvalues.elementAt(pColumn));
            double yval = y.doubleValue();
            if ((this.mode & 4) != 0 || yval == AvMultiCounterGraphData.this.holeValue) {
                return y;
            }
            if ((this.mode & 0x10) != 0) {
                if ((yval *= this.scale) > 100.0) {
                    return POSITIVE_OVERFLOW;
                }
                if (yval < -100.0) {
                    return NEGATIVE_OVERFLOW;
                }
                return new Double(yval);
            }
            return new Double(100.0 * ((yval - this.minValue) / this.range));
        }

        private Number getYUntrimmed(int pColumn) {
            Number y = null;
            y = (this.mode & 2) != 0 ? (Number)this.getDerivedY(pColumn) : (Number)((Double)this.yvalues.elementAt(pColumn));
            return y;
        }

        public Number getLastX() {
            return this.xvalues.size() > 0 ? (Number)this.getX(this.xvalues.size() - 1) : (Number)null;
        }

        public Number getLastY() {
            return this.yvalues.size() > 0 ? (Number)this.getY(this.yvalues.size() - 1) : (Number)null;
        }

        public Number getDerivedY(int pColumn) {
            Double _value = null;
            if (pColumn < 1) {
                return new Double(AvMultiCounterGraphData.this.holeValue);
            }
            double _data1 = (Double)this.yvalues.elementAt(pColumn);
            double _data2 = (Double)this.yvalues.elementAt(pColumn - 1);
            double _data = _data1 - _data2;
            double _time1 = this.getX(pColumn).doubleValue();
            double _time2 = this.getX(pColumn - 1).doubleValue();
            double _time = _time1 - _time2;
            _value = _data1 != AvMultiCounterGraphData.this.holeValue && _data2 != AvMultiCounterGraphData.this.holeValue && _time != 0.0 && _data / _time >= 0.0 ? new Double(_data / _time) : new Double(AvMultiCounterGraphData.this.holeValue);
            return _value;
        }

        public Number getLastDerivedY() {
            return this.getDerivedY(this.getSize() - 1);
        }

        private void trim() {
            Vector _x = new Vector();
            Vector _y = new Vector();
            boolean _bKeep = true;
            int n = this.xvalues.size();
            int m = n / 2 - 1;
            for (int i = 0; i < n; ++i) {
                if (i > m || _bKeep) {
                    _x.add(this.xvalues.elementAt(i));
                    _y.add(this.yvalues.elementAt(i));
                }
                _bKeep = !_bKeep;
            }
            this.xvalues = _x;
            this.yvalues = _y;
        }
    }
}

