/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.pmcollection;

import com.ngnms.apps.pmcollection.AvGenericStyle;
import com.ngnms.apps.pmcollection.AvMultiCounterGraphData;
import com.ngnms.apps.pmcollection.AvMultiGraphStyle;
import com.ngnms.apps.pmcollection.IAvCounterGraphListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import jclass.chart.ChartDataListener;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.Chartable;
import jclass.chart.JCAxis;
import jclass.chart.JCAxisTitle;
import jclass.chart.JCChart;
import jclass.chart.JCChartStyle;

public class AvMultiCounterGraph
extends JCChart
implements MouseListener,
MouseMotionListener {
    public static final int PAN = 1;
    public static final int ZOOM = 2;
    public static final int INTERACTION_MODE_PAN = 1;
    public static final int INTERACTION_MODE_ZOOM = 2;
    public static final Color[] SERIES_COLORS = new Color[]{Color.blue, Color.red, Color.yellow, Color.green.darker(), Color.magenta, Color.cyan, Color.orange, Color.pink, Color.blue.darker(), Color.magenta.darker(), Color.red.darker(), Color.green};
    private int interactionMode = 1;
    private double holeValue;
    private JCAxis xAxis;
    private JCAxis yAxis;
    private AvMultiCounterGraphData graphData;
    private long origin = System.currentTimeMillis() / 1000L;
    private Vector selectedCounters = new Vector();
    private Vector graphListeners = new Vector();
    private Point draggedFrom;
    private boolean scrollXAxis;
    private int[] numOfLabels = new int[1000];

    public AvMultiCounterGraph() {
        this.holeValue = this.getDataView(0).getHoleValue();
        this.graphData = new AvMultiCounterGraphData("", this.holeValue);
        this.xAxis = this.getDataView(0).getXAxis();
        this.yAxis = this.getDataView(0).getYAxis();
        this.init();
    }

    private void init() {
        this.setDoubleBuffered(true);
        this.setAllowUserChanges(true);
        this.getChartArea().setFastAction(true);
        this.xAxis.setAnnotationMethod(2);
        this.xAxis.setOrigin((double)this.origin);
        this.xAxis.setMin(0.0);
        this.xAxis.setMax(300.0);
        this.yAxis.setMin(-101.0);
        this.yAxis.setMax(101.0);
        this.yAxis.setGridSpacing(10.0);
        this.getDataView(0).setFastUpdate(true);
        this.getDataView(0).setDataSource((Chartable)this.graphData);
        this.getDataView(0).setChartType(0);
        this.graphData.addChartDataListener((ChartDataListener)this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setStyle(AvMultiGraphStyle.getDefaultStyle());
    }

    public void setStyle(String pStyle) {
        AvMultiGraphStyle style = new AvMultiGraphStyle(pStyle);
        if (style.getProperty("background-color") != null) {
            this.setBackground(AvMultiGraphStyle.getColor(style.getProperty("background-color")));
        }
        if (style.getProperty("chart-background-color") != null) {
            this.getChartArea().setBackground(AvMultiGraphStyle.getColor(style.getProperty("chart-background-color")));
        }
        this.getChartArea().setFont(new Font(style.getProperty("chart-font", "Helvetica"), AvMultiGraphStyle.getFontStyle(style.getProperty("chart-font-style", "normal")), Integer.parseInt(style.getProperty("chart-font-size", "12"))));
        this.getChartArea().setAxisBoundingBox(false);
        this.getChartArea().setBorderType(3);
        this.getChartArea().setBorderWidth(2);
        if (style.getProperty("legend-background-color") != null) {
            this.getLegend().setBackground(AvMultiGraphStyle.getColor(style.getProperty("legend-background-color")));
        }
        this.getLegend().setFont(new Font(style.getProperty("legend-font", "Helvetica"), AvMultiGraphStyle.getFontStyle(style.getProperty("legend-font-style", "normal")), Integer.parseInt(style.getProperty("legend-font-size", "11"))));
        this.getLegend().setForeground(AvMultiGraphStyle.getColor(style.getProperty("legend-foreground-color", "#000000")));
        this.getLegend().setBorderType(1);
        this.getLegend().setBorderWidth(1);
        this.getLegend().setAnchor(34);
        String[] axisPrefixes = new String[]{"x-", "y-"};
        JCAxis[] axisDefs = new JCAxis[]{this.xAxis, this.yAxis};
        for (int i = 0; i < 2; ++i) {
            String prefix = axisPrefixes[i];
            JCAxis axis = axisDefs[i];
            axis.setFont(new Font(style.getProperty(prefix + "font", "Helvetica"), AvMultiGraphStyle.getFontStyle(style.getProperty(prefix + "font-style", "normal")), Integer.parseInt(style.getProperty(prefix + "font-size", "11"))));
            axis.setForeground(AvMultiGraphStyle.getColor(style.getProperty(prefix + "color", AvMultiGraphStyle.getColorString(Color.lightGray.brighter()))));
            axis.setIsShowing(Boolean.valueOf(style.getProperty(prefix + "visible", "true")).booleanValue());
            axis.setGridIsShowing(Boolean.valueOf(style.getProperty(prefix + "grid-visible", "true")).booleanValue());
            Color gridColor = AvMultiGraphStyle.getColor(style.getProperty(prefix + "grid-color", "#C0C0C0"));
            axis.getGridStyle().setLineColor(gridColor);
            axis.getGridStyle().setLineWidth(1);
            axis.getGridStyle().setLinePattern(1);
        }
    }

    public void setTitle(String pTitle) {
        this.getHeader().setText("[FONT=TimesRoman-bold-16]" + pTitle);
        this.getHeader().setIsShowing(true);
    }

    public void setTimeLabel(String pLabel) {
        this.xAxis.setTitle(new JCAxisTitle(pLabel));
    }

    public void setInteractionMode(int pInteractionMode) {
        this.interactionMode = pInteractionMode;
    }

    public void setDisplayRange(long pMin, long pMax) {
        pMin = pMin / 1000L - this.origin;
        pMax = pMax / 1000L - this.origin;
        System.out.println("DisplayRange initial: " + this.xAxis.getMin() + " " + this.xAxis.getMax());
        if ((double)pMin > this.xAxis.getMax()) {
            this.xAxis.setMax((double)pMax);
            this.xAxis.setMin((double)pMin);
        } else {
            this.xAxis.setMin((double)pMin);
            this.xAxis.setMax((double)pMax);
        }
        System.out.println("DisplayRange after: " + this.xAxis.getMin() + " " + this.xAxis.getMax());
    }

    public void setPositiveOnly(boolean pPositiveOnly) {
        this.yAxis.setMin(pPositiveOnly ? 0.0 : -101.0);
    }

    public void addListener(IAvCounterGraphListener pListener) {
        this.graphListeners.add(pListener);
    }

    public void removeListener(IAvCounterGraphListener pListener) {
        this.graphListeners.remove(pListener);
    }

    public void setSeriesStyle(String pCounterId, String pCounterStyle) {
        int idx = this.graphData.getSeriesIndex(pCounterId);
        this.setSeriesStyle(this.getDataView(0).getSeries(idx), pCounterStyle);
        this.graphData.fireChartDataEvent(3, 2 * idx + 1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSeriesStyle(ChartDataViewSeries pSeries, String pSeriesStyle) {
        AvMultiCounterGraphData avMultiCounterGraphData = this.graphData;
        synchronized (avMultiCounterGraphData) {
            AvGenericStyle style = new AvGenericStyle(pSeriesStyle);
            String lineColor = style.getProperty("line-color", "#FF0000");
            String lineWidth = style.getProperty("line-width", "1");
            String symbolColor = style.getProperty("symbol-color", lineColor);
            JCChartStyle _style = pSeries.getStyle();
            _style.setSymbolShape(0);
            _style.setLineColor(AvGenericStyle.getColor(lineColor));
            _style.setSymbolColor(AvGenericStyle.getColor(symbolColor));
            _style.setSymbolSize(4);
            _style.setLineWidth(Integer.parseInt(lineWidth));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSeries(String pSeriesId, String pSeriesLabel, String pSeriesStyle, int pDisplayMode) {
        int _result = -1;
        AvMultiCounterGraphData avMultiCounterGraphData = this.graphData;
        synchronized (avMultiCounterGraphData) {
            int idx = this.graphData.getSeriesIndex(pSeriesId);
            if (-1 == idx) {
                this.graphData.addSeries(pSeriesId, pSeriesLabel, pDisplayMode);
                idx = this.graphData.getSeriesIndex(pSeriesId);
                this.getDataView(0).addSeries(idx);
                ChartDataViewSeries _series = this.getDataView(0).getSeries(idx);
                _series.setName(pSeriesLabel);
                this.setSeriesStyle(_series, pSeriesStyle);
            } else {
                ChartDataViewSeries _series = this.getDataView(0).getSeries(idx);
                this.setSeriesStyle(_series, pSeriesStyle);
                _series.setIsShowing(true);
            }
            _result = idx;
            try {
                this.graphData.fireChartDataEvent(14, 0, 0);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return _result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllChartLabels() {
        AvMultiCounterGraphData avMultiCounterGraphData = this.graphData;
        synchronized (avMultiCounterGraphData) {
            this.numOfLabels = new int[1000];
        }
        super.removeAllChartLabels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSeries(String pCounterId) {
        AvMultiCounterGraphData avMultiCounterGraphData = this.graphData;
        synchronized (avMultiCounterGraphData) {
            int idx = this.graphData.getSeriesIndex(pCounterId);
            if (idx >= 0) {
                this.graphData.removeSeries(idx);
                this.graphData.fireChartDataEvent(14, 0, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showSeries(String pCounterId) {
        AvMultiCounterGraphData avMultiCounterGraphData = this.graphData;
        synchronized (avMultiCounterGraphData) {
            int idx = this.graphData.getSeriesIndex(pCounterId);
            if (idx >= 0) {
                ChartDataViewSeries _series = this.getDataView(0).getSeries(idx);
                _series.setIsShowing(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideSeries(String pCounterId) {
        AvMultiCounterGraphData avMultiCounterGraphData = this.graphData;
        synchronized (avMultiCounterGraphData) {
            int idx = this.graphData.getSeriesIndex(pCounterId);
            if (idx >= 0) {
                ChartDataViewSeries _series = this.getDataView(0).getSeries(idx);
                _series.setIsShowing(false);
            }
        }
    }

    public Color getSeriesColor(String pCounterId) {
        int idx = this.graphData.getSeriesIndex(pCounterId);
        ChartDataViewSeries _series = this.getDataView(0).getSeries(idx);
        if (null != _series && _series.getIsShowing()) {
            JCChartStyle _style = _series.getStyle();
            return _style.getLineColor();
        }
        return null;
    }

    public Number[] getSeriesLastValue(String pCounterId) {
        int idx = this.graphData.getSeriesIndex(pCounterId);
        return this.graphData.getLastValue(idx);
    }

    public double[] getSeriesBounds(String pCounterId) {
        return this.graphData.getSeriesBounds(pCounterId);
    }

    public void setSeriesBounds(String pCounterId, double pMin, double pMax) {
        int idx = this.graphData.getSeriesIndex(pCounterId);
        this.graphData.setSeriesBounds(idx, pMin, pMax);
        this.graphData.fireChartDataEvent(3, 2 * idx + 1, 0);
    }

    public void setSeriesScale(String pCounterId, double pScale) {
        int idx = this.graphData.getSeriesIndex(pCounterId);
        this.graphData.setSeriesScale(idx, pScale);
        this.graphData.fireChartDataEvent(3, 2 * idx + 1, 0);
    }

    public void setSeriesDisplayMode(String pCounterId, int pDisplayMode) {
        int idx = this.graphData.getSeriesIndex(pCounterId);
        this.graphData.setSeriesDisplayMode(idx, pDisplayMode);
        this.graphData.fireChartDataEvent(3, 2 * idx + 1, 0);
    }

    public void setSeriesLabel(String pCounterId, String pLabel) {
        int idx = this.graphData.getSeriesIndex(pCounterId);
        this.graphData.setSeriesLabel(idx, pLabel);
        try {
            this.graphData.fireChartDataEvent(19, 0, 0);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void updateSeries(String pCounterId) {
        int idx = this.graphData.getSeriesIndex(pCounterId);
        try {
            this.graphData.fireChartDataEvent(3, 2 * idx + 1, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector getSeries() {
        return this.graphData.getSeries();
    }

    public Vector getSeriesNames() {
        return this.graphData.getSeriesNames();
    }

    public Vector getSeriesLabels() {
        return this.graphData.getSeriesLabels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedCounters(Vector pCounters) {
        AvMultiCounterGraphData avMultiCounterGraphData = this.graphData;
        synchronized (avMultiCounterGraphData) {
            this.selectedCounters.clear();
            for (String _serId : pCounters) {
                int idx = this.graphData.getSeriesIndex(_serId);
                if (-1 == idx) continue;
                this.selectedCounters.add(new Integer(idx));
            }
        }
    }

    public void addValue(String pSeriesId, Number pValue, long pTime) {
        this.addValues(new String[]{pSeriesId}, new Number[]{pValue}, pTime);
    }

    private void addDataPointLabel(String pSeriesID, int pSeriesIdx, Number pValue) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValues(String[] pSeriesIds, Number[] pValues, long pTime) {
        AvMultiCounterGraphData avMultiCounterGraphData = this.graphData;
        synchronized (avMultiCounterGraphData) {
            if (pSeriesIds.length != pValues.length) {
                throw new IllegalArgumentException("Series Ids count different from pValues count !!!");
            }
            int _seriesCount = this.graphData.getSeriesCount();
            if (0 == _seriesCount) {
                return;
            }
            double _lastTime = this.graphData.getLastTime();
            boolean seriesPointLabelNumber = false;
            for (int i = 0; i < pSeriesIds.length; ++i) {
                int _idx = this.graphData.getSeriesIndex(pSeriesIds[i]);
                if (_idx < 0) continue;
                Number _val = pValues[i];
                if (_val == null || Double.isNaN(_val.doubleValue())) {
                    _val = new Double(this.holeValue);
                }
                this.graphData.addValue(_idx, _val, pTime);
                this.addDataPointLabel(pSeriesIds[i], _idx, _val);
            }
            this.fixChartAxis(this.graphData.getLastTime() - _lastTime, false);
            this.graphData.fireChartDataEvent(14, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeriesValues(String pSeriesID, long[] pTimes, Number[] pValues) {
        AvMultiCounterGraphData avMultiCounterGraphData = this.graphData;
        synchronized (avMultiCounterGraphData) {
            int _idx = this.graphData.getSeriesIndex(pSeriesID);
            if (_idx >= 0) {
                this.graphData.resetSeries(_idx);
                for (int i = 0; i < pTimes.length; ++i) {
                    Number _val = pValues[i];
                    if (_val == null || Double.isNaN(_val.doubleValue())) {
                        _val = new Double(this.holeValue);
                    }
                    this.graphData.addValue(_idx, _val, pTimes[i]);
                }
                this.graphData.fireChartDataEvent(14, 2 * _idx + 1, 0);
            }
        }
    }

    private boolean isValueVisible(double px, double py) {
        return this.holeValue != py && px >= this.xAxis.getMin() && px <= this.xAxis.getMax() && py >= this.yAxis.getMin() && py <= this.yAxis.getMax();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixChartAxis(double pXdiff, boolean pUpdate) {
        boolean bCheckXAxis = true;
        double _minx = 0.0;
        double _maxx = 0.0;
        boolean bXValFound = false;
        boolean bCheckYAxis = false;
        double _miny = 0.0;
        double _maxy = 0.0;
        boolean bYValFound = false;
        AvMultiCounterGraphData avMultiCounterGraphData = this.graphData;
        synchronized (avMultiCounterGraphData) {
            int n = this.graphData.getSeriesCount();
            for (int i = 0; i < n; ++i) {
                double _yval;
                Number[] _lastVal = this.graphData.getLastValue(i);
                if (null == _lastVal) continue;
                if (bCheckXAxis) {
                    double _xval = _lastVal[0].doubleValue();
                    if (!bXValFound) {
                        _minx = _xval;
                        _maxx = _xval;
                        bXValFound = true;
                    } else {
                        if (_xval < _minx) {
                            _minx = _xval;
                        }
                        if (_xval > _maxx) {
                            _maxx = _xval;
                        }
                    }
                }
                if (!bCheckYAxis || (_yval = _lastVal[1].doubleValue()) == this.holeValue) continue;
                if (!bYValFound) {
                    _miny = _yval;
                    _maxy = _yval;
                    bYValFound = true;
                    continue;
                }
                if (_yval < _miny) {
                    _miny = _yval;
                }
                if (!(_yval > _maxy)) continue;
                _maxy = _yval;
            }
        }
        if (bCheckXAxis && bXValFound) {
            double xMin = this.xAxis.getMin();
            double xMax = this.xAxis.getMax();
            if (_minx < xMin || _maxx > xMax) {
                if (!this.scrollXAxis) {
                    this.scrollXAxis = true;
                }
                if (_maxx - _minx > xMax - xMin) {
                    this.zoom(_minx, _maxx, this.xAxis, pUpdate);
                } else if (_minx < xMin) {
                    this.translate(_minx - xMin, this.xAxis, pUpdate);
                } else {
                    this.translate(_maxx - xMax, this.xAxis, pUpdate);
                }
            } else if (this.scrollXAxis && pXdiff != 0.0) {
                this.translate(pXdiff, this.xAxis, pUpdate);
            }
        }
        if (bCheckYAxis && bYValFound) {
            double yMin = this.yAxis.getMin();
            double yMax = this.yAxis.getMax();
            double _marginy = (_maxy - _miny) * 0.05;
            _maxy += _marginy;
            if ((_miny -= _marginy) < yMin || _maxy > yMax) {
                if (_maxy - _miny > yMax - yMin) {
                    this.zoom(_miny, _maxy, this.yAxis, pUpdate);
                } else if (_miny < yMin) {
                    this.translate(_miny - yMin, this.yAxis, pUpdate);
                } else {
                    this.translate(_maxy - yMax, this.yAxis, pUpdate);
                }
            }
        }
    }

    private final void zoomX(double pSize, boolean update) {
        double _size = pSize * (this.xAxis.getMax() - this.xAxis.getMin());
        _size = 1.0 + Math.max(-0.5, Math.min(pSize, 0.5));
        double crtMiddle = (this.xAxis.getMax() + this.xAxis.getMin()) / 2.0;
        this.scale(_size, this.xAxis, false);
        double newMiddle = (this.xAxis.getMax() + this.xAxis.getMin()) / 2.0;
        this.translate(crtMiddle - newMiddle, this.xAxis, update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zoomY(double pSize) {
        AvMultiCounterGraphData avMultiCounterGraphData = this.graphData;
        synchronized (avMultiCounterGraphData) {
            for (int i = 0; i < this.selectedCounters.size(); ++i) {
                double _size;
                int _serIdx = (Integer)this.selectedCounters.elementAt(i);
                double[] _serBounds = this.graphData.getSeriesBounds(_serIdx);
                if (_serBounds[0] - (_size = pSize * (_serBounds[1] - _serBounds[0])) >= _serBounds[1] + _size) continue;
                this.graphData.setSeriesBounds(_serIdx, _serBounds[0] - _size, _serBounds[1] + _size);
                this.graphData.fireChartDataEvent(3, 2 * _serIdx + 1, 0);
                String _serId = this.graphData.getSeriesByIndex(_serIdx);
                _serBounds = this.graphData.getSeriesBounds(_serIdx);
                Vector vector = this.graphListeners;
                synchronized (vector) {
                    for (IAvCounterGraphListener _listener : this.graphListeners) {
                        _listener.counterBoundsChanged(_serId, _serBounds[0], _serBounds[1]);
                    }
                    continue;
                }
            }
        }
    }

    private final void panX(double pSize, boolean update) {
        double _size = pSize * (this.xAxis.getMin() - this.xAxis.getMax());
        this.translate(_size, this.xAxis, update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void panY(double pSize) {
        AvMultiCounterGraphData avMultiCounterGraphData = this.graphData;
        synchronized (avMultiCounterGraphData) {
            for (int i = 0; i < this.selectedCounters.size(); ++i) {
                int _serIdx = (Integer)this.selectedCounters.elementAt(i);
                double[] _serBounds = this.graphData.getSeriesBounds(_serIdx);
                double _size = pSize * (_serBounds[1] - _serBounds[0]);
                this.graphData.setSeriesBounds(_serIdx, _serBounds[0] + _size, _serBounds[1] + _size);
                this.graphData.fireChartDataEvent(3, 2 * _serIdx + 1, 0);
                _serBounds = this.graphData.getSeriesBounds(_serIdx);
                String _serId = this.graphData.getSeriesByIndex(_serIdx);
                Vector vector = this.graphListeners;
                synchronized (vector) {
                    for (IAvCounterGraphListener _listener : this.graphListeners) {
                        _listener.counterBoundsChanged(_serId, _serBounds[0], _serBounds[1]);
                    }
                    continue;
                }
            }
        }
    }

    public void mousePressed(MouseEvent evt) {
        Point evtPoint = evt.getPoint();
        this.draggedFrom = this.getChartArea().inside(evtPoint.x, evtPoint.y) ? evtPoint : null;
    }

    public void mouseReleased(MouseEvent evt) {
        this.draggedFrom = null;
        this.scrollXAxis = true;
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.draggedFrom == null) {
            return;
        }
        Point draggedTo = evt.getPoint();
        int dx = draggedTo.x - this.draggedFrom.x;
        int dy = draggedTo.y - this.draggedFrom.y;
        int width = this.getChartArea().getWidth();
        int height = this.getChartArea().getHeight();
        if (this.interactionMode == 2) {
            if (dx != 0) {
                double x = (double)dx / (double)width;
                this.zoomX(x, true);
            }
            if (dy != 0) {
                double y = (double)dy / (double)height;
                this.zoomY(y);
            }
        } else {
            if (dx != 0) {
                double x = (double)dx / (double)width;
                this.panX(x, true);
            }
            if (dy != 0) {
                double y = (double)dy / (double)height;
                this.panY(y);
            }
        }
        this.draggedFrom = draggedTo;
    }

    public void cleanup() {
        this.graphData.removeChartDataListener((ChartDataListener)this);
        this.getDataView(0).setDataSource(null);
        this.graphData = null;
    }

    public AvMultiCounterGraphData getGraphData() {
        return this.graphData;
    }

    public double getHoleValue() {
        return this.holeValue;
    }
}

