/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.pmcollection;

import java.awt.Color;
import java.awt.Font;
import java.util.Properties;
import java.util.StringTokenizer;

public class AvGenericStyle {
    Properties properties = new Properties();
    private static final Color[] RANDOM_COLORS = new Color[]{Color.blue, Color.red, Color.green, Color.magenta, Color.orange, Color.darkGray, Color.blue.darker(), Color.magenta.darker(), Color.red.darker(), Color.green.darker(), Color.orange.darker(), Color.darkGray.darker()};
    private static int currentRandomColor = 0;

    public AvGenericStyle(String pStyleString) {
        this.parse(pStyleString);
    }

    private void parse(String pStyleString) {
        StringTokenizer tokenizer = new StringTokenizer(pStyleString, ";");
        while (tokenizer.hasMoreTokens()) {
            String propDef = tokenizer.nextToken();
            int colonIdx = propDef.indexOf(58);
            this.properties.setProperty(propDef.substring(0, colonIdx).trim(), propDef.substring(colonIdx + 1).trim());
        }
    }

    public String getStyleString() {
        return AvGenericStyle.getStyleString(this.properties);
    }

    public String toString() {
        return this.getStyleString();
    }

    public String getProperty(String pPropertyName) {
        return this.properties.getProperty(pPropertyName);
    }

    public String getProperty(String pPropertyName, String pDefaultValue) {
        return this.properties.getProperty(pPropertyName, pDefaultValue);
    }

    public void setProperty(String pPropertyName, String pValue) {
        this.properties.setProperty(pPropertyName, pValue);
    }

    public static Color getColor(String pColorDef) {
        int rgb = Integer.parseInt(pColorDef.substring(1), 16);
        return new Color(rgb);
    }

    public static String getColorString(Color pColor) {
        String hex = Integer.toHexString(pColor.getRGB() & 0xFFFFFF);
        return "#" + hex;
    }

    public static String getStyleString(Properties pProps) {
        StringBuffer ret = new StringBuffer();
        for (String string : pProps.keySet()) {
            String propValue = pProps.getProperty(string);
            if (ret.length() > 0) {
                ret.append(';');
            }
            ret.append(string);
            ret.append(':');
            ret.append(propValue);
        }
        return ret.toString();
    }

    public static String getStyleString(String[][] pProps) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < pProps.length; ++i) {
            if (i > 0) {
                ret.append(';');
            }
            ret.append(pProps[i][0]);
            ret.append(':');
            ret.append(pProps[i][1]);
        }
        return ret.toString();
    }

    public static Color getRandomColor() {
        if (currentRandomColor == RANDOM_COLORS.length) {
            currentRandomColor = 0;
        }
        return RANDOM_COLORS[currentRandomColor++];
    }

    public static int getFontStyle(String pFontStyle) {
        if ("bold".equals(pFontStyle)) {
            return 1;
        }
        if ("italic".equals(pFontStyle)) {
            return 2;
        }
        return 0;
    }

    public static String getFontStyleString(int pFontStyle) {
        if ((pFontStyle & 3) != 0) {
            return "bold-italic";
        }
        if ((pFontStyle & 1) != 0) {
            return "bold";
        }
        if ((pFontStyle & 2) != 0) {
            return "italic";
        }
        return "normal";
    }

    public Font getFont(String pPrefix) {
        return new Font(this.getProperty(pPrefix + "-font-name", "Helvetica"), AvGenericStyle.getFontStyle(this.getProperty(pPrefix + "-font-style", "normal")), Integer.parseInt(this.getProperty(pPrefix + "-font-size", "11")));
    }

    public void setFont(String pPrefix, Font pFont) {
        this.setProperty(pPrefix + "-font-name", pFont.getFamily());
        this.setProperty(pPrefix + "-font-style", AvGenericStyle.getFontStyleString(pFont.getStyle()));
        this.setProperty(pPrefix + "-font-size", Integer.toString(pFont.getSize()));
    }
}

