/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.pmcollection;

import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.performance.PerformanceCollectionEntity;
import com.bwanms.performance.db.PmCollectionVariable;
import com.bwanms.performance.db.PmDirectDataCollectorUtil;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAPIException;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByReferenceAttribute;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.apps.pmcollection.AvFormGetPmDataResponseEvent;
import com.ngnms.apps.pmcollection.AvFormGetPmDataRule;
import com.ngnms.apps.pmcollection.AvFormGetPmDataRuleParamSet;
import com.ngnms.apps.pmcollection.AvPmSessionProfile;
import com.ngnms.apps.pmcollection.db.AvPmDisplayData;
import com.ngnms.common.AvException;
import com.ngnms.common.AvTrace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AvFormGetPmDataRuleImpl
extends BaseRuleImpl {
    private static final Logger logger = Logger.getLogger(AvFormGetPmDataRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvFormGetPmDataRule.run()");
        this.runRule((AvFormGetPmDataRuleParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvFormGetPmDataRule.run()");
    }

    public void runRule(AvFormGetPmDataRuleParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        String sessionName = pParamSet.getSessionName();
        long startTime = pParamSet.getStartTime();
        long endTime = pParamSet.getEndTime();
        PerformanceCollectionGenericTask task = AvFormGetPmDataRuleImpl.retrieveTask(sessionName);
        Hashtable collVars = pParamSet.getCollVars();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"AvFormGetPmDataRule invoked:");
            logger.debug((Object)("\t\tstartTime: " + new Date(startTime)));
            logger.debug((Object)("\t\tendTime: " + new Date(endTime)));
        }
        Iterator it = collVars.keySet().iterator();
        while (it.hasNext()) {
            try {
                String targetNRKey = (String)it.next();
                List vars = (List)collVars.get(targetNRKey);
                Map _varsByRowID = null;
                if (1 != vars.size() || !"{all}".equals((String)vars.get(0))) {
                    _varsByRowID = this.groupVarsByRowID(vars);
                    logger.debug((Object)("AvFormGetPmDataRule.groupVarsByRowID() - size is " + _varsByRowID.size()));
                }
                long _tm = System.currentTimeMillis();
                int interval = PmDirectDataCollectorUtil.getDisplayInterval((long)startTime, (long)endTime);
                if (-1 == interval) {
                    interval = task.getPollingInterval();
                }
                List dbValues = PmDirectDataCollectorUtil.getDisplayDataValues((String)sessionName, (String)targetNRKey, (Vector)(null != _varsByRowID ? new Vector(_varsByRowID.keySet()) : null), (long)startTime, (long)endTime);
                logger.debug((Object)("AvPmDataCollectorUtil.getDataValues() - size is " + dbValues.size() + "  time is " + (System.currentTimeMillis() - _tm)));
                if (null == _varsByRowID) {
                    TreeSet<String> _rowIDsSet = new TreeSet<String>();
                    for (AvPmDisplayData pmdata : dbValues) {
                        if (_rowIDsSet.contains(pmdata.getRowID())) continue;
                        _rowIDsSet.add(pmdata.getRowID());
                    }
                    PerformanceCollectionEntity entity = AvFormGetPmDataRuleImpl.getPMEntity(task, targetNRKey);
                    _varsByRowID = AvFormGetPmDataRuleImpl.groupCollVarsByRowID((List)((Object)entity.getCounters()), _rowIDsSet);
                }
                Hashtable profValues = this.processDbValues(_varsByRowID, dbValues);
                Hashtable<String, Hashtable> collValues = new Hashtable<String, Hashtable>();
                collValues.put(targetNRKey, profValues);
                AvFormGetPmDataResponseEvent responseEvent = new AvFormGetPmDataResponseEvent();
                responseEvent.setFormID(pParamSet.getFormID());
                responseEvent.setSessionName(sessionName);
                responseEvent.setCollValues(collValues);
                responseEvent.setTimeInterval(interval);
                responseEvent.emit();
                logger.debug((Object)("Response for pm data request - FormID: " + pParamSet.getFormID() + "  collValues size: " + collValues.size()));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    private static AvPmSessionProfile getSessionProfile(IOWBOMClient pBOM, String pSessionName, String pTargetNRKey) throws OWBOMAPIException {
        OWBOMQueryByReferenceAttribute qba = new OWBOMQueryByReferenceAttribute(AvPmSessionProfile.class.getName(), "TargetNR", pTargetNRKey, true);
        qba.addAttribValueOperator(new OWBOMAttribValueOperator("AND", "SessionName", "=", (Object)pSessionName));
        return (AvPmSessionProfile)((Vector)pBOM.getObjects((OWBOMQuery)qba).getRtnObject()).firstElement();
    }

    private Map groupVarsByRowID(List pVars) throws Exception {
        TreeMap<String, Vector<String>> _tm = new TreeMap<String, Vector<String>>();
        for (String _cv : pVars) {
            int _idx = _cv.indexOf("::");
            String _oid = _cv.substring(0, _idx);
            String _inst = _cv.substring(_idx + 2);
            Vector<String> _v = (Vector<String>)_tm.get(_inst);
            if (null == _v) {
                _v = new Vector<String>();
                _tm.put(_inst, _v);
            }
            _v.add(_cv);
        }
        if (logger.isDebugEnabled()) {
            Iterator<Object> it = _tm.keySet().iterator();
            while (it.hasNext()) {
                System.out.println("-------- row Instance: [" + it.next() + "]");
            }
        }
        return _tm;
    }

    Hashtable processDbValues(Map pVarsByRowID, List pValues) throws AvException {
        Hashtable<String, Object[]> ret = new Hashtable<String, Object[]>();
        Hashtable valuesByRowID = this.groupValuesByRowID(pValues);
        for (String crtRowID : pVarsByRowID.keySet()) {
            Vector _cvs = (Vector)pVarsByRowID.get(crtRowID);
            int varsSize = _cvs.size();
            Vector _vals = (Vector)valuesByRowID.get(crtRowID);
            int valuesSize = null != _vals ? _vals.size() : 0;
            int[] cvPos = new int[varsSize];
            long[][] timestamps = new long[varsSize][valuesSize];
            double[][] datavalues = new double[varsSize][valuesSize];
            for (int j = 0; j < varsSize; ++j) {
                String _cv = (String)_cvs.get(j);
                int _scolonidx = _cv.indexOf(58);
                cvPos[j] = Integer.parseInt(_cv.substring(0, _scolonidx));
                ret.put(_cv, new Object[]{timestamps[j], datavalues[j]});
            }
            for (int i = 0; i < valuesSize; ++i) {
                AvPmDisplayData pmdata = (AvPmDisplayData)_vals.get(i);
                long _cTime = pmdata.getCollectionTime();
                double[] _data = pmdata.getData();
                for (int j = 0; j < varsSize; ++j) {
                    timestamps[j][i] = _cTime;
                    if (cvPos[j] < _data.length) {
                        datavalues[j][i] = _data[cvPos[j]];
                        continue;
                    }
                    datavalues[j][i] = Double.NaN;
                    logger.debug((Object)("Invalid Position!!!  rowID: [" + crtRowID + "]    pos[" + _cvs.get(j) + "]: " + cvPos[j]));
                }
            }
        }
        return ret;
    }

    Hashtable groupValuesByRowID(List pValues) {
        Hashtable<String, Vector<AvPmDisplayData>> ret = new Hashtable<String, Vector<AvPmDisplayData>>();
        for (AvPmDisplayData pmdata : pValues) {
            Vector<AvPmDisplayData> _v = (Vector<AvPmDisplayData>)ret.get(pmdata.getRowID());
            if (null == _v) {
                _v = new Vector<AvPmDisplayData>();
                ret.put(pmdata.getRowID(), _v);
            }
            _v.add(pmdata);
        }
        return ret;
    }

    private static PerformanceCollectionGenericTask retrieveTask(final String taskId) {
        final ArrayList taskList = new ArrayList();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    PerformanceCollectionGenericTask task = (PerformanceCollectionGenericTask)Datastore.session().get(PerformanceCollectionGenericTask.class, (Serializable)new Long(taskId));
                    ArrayList some = new ArrayList();
                    some.addAll(task.getEntities());
                    taskList.add(task);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }).run();
        if (!taskList.isEmpty()) {
            return (PerformanceCollectionGenericTask)taskList.get(0);
        }
        return null;
    }

    private static PerformanceCollectionEntity getPMEntity(PerformanceCollectionGenericTask task, String managedEntityId) {
        Long meId = new Long(managedEntityId);
        for (PerformanceCollectionEntity entity : task.getEntities()) {
            if (meId.longValue() != entity.getEntityId()) continue;
            return entity;
        }
        return null;
    }

    private static Map groupCollVarsByRowID(List counters, Collection pRowIDs) {
        TreeMap ret = new TreeMap();
        if (null == counters) {
            return ret;
        }
        for (Object[] counter : counters) {
            String name = (String)counter[0];
            List keys = (List)counter[1];
            List vars = (List)counter[2];
            if (null == keys) {
                Vector<String> toAdd = new Vector<String>();
                for (int i = 0; i < vars.size(); ++i) {
                    PmCollectionVariable cv = (PmCollectionVariable)vars.get(i);
                    if (-1 == cv.getType()) continue;
                    String varID = Integer.toString(i) + ':' + cv.getName();
                    toAdd.add(varID);
                    logger.debug((Object)("groupCollVarsByRowID: " + name + " - " + varID));
                }
                ret.put(name, toAdd);
                continue;
            }
            for (String rowID : pRowIDs) {
                String rowInst;
                int dblDotIdx = rowID.indexOf("::");
                String rowName = -1 != dblDotIdx ? rowID.substring(0, dblDotIdx) : rowID;
                String string = rowInst = -1 != dblDotIdx ? rowID.substring(dblDotIdx + 2) : null;
                if (!name.equals(rowName)) continue;
                Vector<String> toAdd = new Vector<String>();
                for (int i = 0; i < vars.size(); ++i) {
                    PmCollectionVariable cv = (PmCollectionVariable)vars.get(i);
                    if (-1 == cv.getType()) continue;
                    String varID = Integer.toString(i) + ':' + cv.getName();
                    if (null != rowInst) {
                        varID = varID + "::" + rowInst;
                    }
                    toAdd.add(varID);
                    logger.debug((Object)("groupCollVarsByRowID: " + rowID + " - " + varID));
                }
                ret.put(rowID, toAdd);
            }
        }
        return ret;
    }
}

