/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.pmcollection;

import RedCell.Config.NetworkResource;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.runtime.IOWBean;
import com.ngnms.common.AvDevice;
import com.ngnms.common.AvDeviceUtil;
import com.ngnms.common.AvLookup;
import com.ngnms.common.AvService;
import com.ngnms.common.AvTrace;
import com.ngnms.services.common.AvMOUtil;
import java.io.Serializable;
import java.util.Hashtable;
import redcell.common.commandhandler.RCAbstractQueryAttributeInterrogator;
import redcell.common.commandhandler.RCQueryAttributeResult;

public class AvExportFileNameInterrogator
extends RCAbstractQueryAttributeInterrogator {
    private static Hashtable providers = new Hashtable();

    private static ExportFileNameProvider getProductLineProvider(IOWBean pBean) {
        ExportFileNameProvider ret = null;
        try {
            AvDevice device = AvMOUtil.getAvDeviceFromMO((NetworkResource)pBean);
            String productLine = device.getProductLineName();
            ret = (ExportFileNameProvider)providers.get(productLine);
            if (ret == null) {
                String _class = AvLookup.get("ExportFileNameProvider", productLine);
                ret = null != _class ? (ExportFileNameProvider)Class.forName(_class).newInstance() : new DefaultExportFileNameProvider();
                AvTrace.traceln("AvPmCollection", 2, "ProductLine: " + productLine + " ClassName: " + ret.getClass().getName());
                providers.put(productLine, ret);
            }
        }
        catch (Exception e) {
            AvTrace.traceStack("AvPmCollection", 1, e);
        }
        return ret;
    }

    public AvExportFileNameInterrogator() {
        this(null);
    }

    public AvExportFileNameInterrogator(IOWBOMClient pBOM) {
        this.setBOM(pBOM);
        this.setAttribName("ExportFileName");
    }

    public RCQueryAttributeResult getResultValue(IOWBean pBean) {
        ExportFileNameProvider provider = AvExportFileNameInterrogator.getProductLineProvider(pBean);
        if (provider == null) {
            return new RCQueryAttributeResult((Serializable)((Object)((String)pBean.readProperty("Name"))), true);
        }
        return new RCQueryAttributeResult((Serializable)((Object)provider.getExportFileName((NetworkResource)pBean)), true);
    }

    public static class DefaultExportFileNameProvider
    implements ExportFileNameProvider {
        public String getExportFileName(NetworkResource pNR) {
            try {
                if (pNR instanceof AvDevice) {
                    AvDevice device = (AvDevice)pNR;
                    String ipAddress = null;
                    try {
                        ipAddress = AvDeviceUtil.getDeviceIPAddress(device);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return ipAddress != null ? ipAddress + "_" + device.getName() : device.getName();
                }
                if (pNR instanceof AvService) {
                    AvDevice device = AvMOUtil.getAvDeviceFromMO(pNR);
                    return device.getName() + "_" + pNR.getName();
                }
            }
            catch (Exception e) {
                AvTrace.traceStack("AvPmCollection", 1, e);
            }
            return pNR.getName();
        }
    }

    public static interface ExportFileNameProvider {
        public String getExportFileName(NetworkResource var1);
    }
}

