/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.multipleconfig;

import com.dorado.common.utility.OWOID;
import com.dorado.common.widget.components.formlauncher.IOWFormLauncher;
import com.dorado.runtime.IOWRuntimeForm;
import com.ngnms.common.AvCard;
import com.ngnms.common.AvChassisDevice;
import com.ngnms.common.AvClientInternationalizer;
import com.ngnms.common.AvDevice;
import com.ngnms.common.AvLookup;
import com.ngnms.common.AvPropDefs;
import com.ngnms.common.AvTrace;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import redcell.common.commandhandler.RCAbstractCommandHandler;
import redcell.common.interfaces.IRCEntityEditor;
import redcell.common.interfaces.IRCEntityManager;
import redcell.common.interfaces.IRCEntitySelector;
import redcell.common.util.RCBeanProxy;
import redcell.common.util.RedCellRuntimeUtil;
import redcell.core.usersys.RCUserUtil;
import redcell.core.usersys.RedCellRuntimeUser;

public class AvMultipleEquipmentConfigHandler
extends RCAbstractCommandHandler {
    private boolean showUndiscoveredWarning;

    public void setProperties(HashMap pHash) {
        AvClientInternationalizer clientInternationalizer = new AvClientInternationalizer("AvMultipleEquipmentConfigBundle");
        if (pHash.get("ButtonName") == null) {
            this.setButtonName("ConfigMultiple");
        }
        if (pHash.get("ButtonText") == null) {
            this.setButtonText(clientInternationalizer.translateText("ConfigMultiple"));
        }
        if (pHash.get("HotKey") == null) {
            this.setHotKey(clientInternationalizer.translateText("ConfigMultipleHotKey"));
        }
        if (pHash.get("ToolTip") == null) {
            this.setToolTipText(clientInternationalizer.translateText("ConfigMultipleTooltip"));
        }
        if (pHash.get("IconName") == null) {
            this.setIconName("");
        }
        if (pHash.get("ButtonType") == null) {
            this.setButtonType(1);
        }
        if (pHash.get("SelectionRequired") == null) {
            this.setSelectionRequired(true);
        }
        super.setProperties(pHash);
    }

    public void execute(IOWRuntimeForm pForm) {
        String productLineName = "";
        AvClientInternationalizer clientInternationalizer = new AvClientInternationalizer("AvMultipleEquipmentConfigBundle");
        String vendor = AvPropDefs.getVendor();
        this.showUndiscoveredWarning = false;
        StringTokenizer st = new StringTokenizer(vendor);
        if (st.hasMoreTokens()) {
            vendor = st.nextToken();
        }
        if (!(pForm instanceof IRCEntitySelector) || !(pForm instanceof IRCEntityManager)) {
            return;
        }
        RedCellRuntimeUser redCellRuntimeUser = RCUserUtil.getCurrentUser();
        RCUserUtil.getCurrentUser();
        if (!redCellRuntimeUser.isFunctionAllowed("Av:ConfigureMultipleEquipment", RedCellRuntimeUser.EXECUTE_PERM)) {
            this.showMessage(pForm, false, clientInternationalizer.translateText("HaveNoPermissionToUseThisFeature"), clientInternationalizer.translateText("AccessDenied"));
            return;
        }
        IRCEntitySelector _managerPanel = (IRCEntitySelector)pForm;
        RCBeanProxy[] _selection = _managerPanel.getSelectionAsProxy();
        if (_selection == null || _selection.length == 0) {
            this.showMessage(pForm, false, clientInternationalizer.translateText("DeviceShouldBeSelected"), clientInternationalizer.translateText("Error"));
            return;
        }
        Vector<RCBeanProxy> _selectionVect = new Vector<RCBeanProxy>();
        Hashtable<OWOID, RCBeanProxy> _chassisH = new Hashtable<OWOID, RCBeanProxy>();
        Vector<RCBeanProxy> _cardsVect = new Vector<RCBeanProxy>();
        try {
            int i;
            for (i = 0; i < _selection.length; ++i) {
                Object device;
                try {
                    device = Class.forName(_selection[i].getRCClass()).newInstance();
                }
                catch (Exception _e) {
                    this.showMessage(pForm, false, clientInternationalizer.translateText("MultipleConfigurationIsSupportedForVendorDevicesOnly", new String[]{vendor}), clientInternationalizer.translateText("Error"));
                    return;
                }
                if (!(device instanceof AvDevice) && !(device instanceof AvCard)) {
                    this.showMessage(pForm, false, clientInternationalizer.translateText("MultipleConfigurationIsSupportedForVendorDevicesOnly", new String[]{vendor}), clientInternationalizer.translateText("Error"));
                    return;
                }
                if (i == 0) {
                    try {
                        productLineName = _selection[i].getAsString("ProductLineName");
                    }
                    catch (Exception _e) {
                        AvTrace.traceln("AvEms", 2, "Problem to get ProductLineName from " + _selection[i].toString());
                        this.showMessage(pForm, false, clientInternationalizer.translateText("MultipleConfigurationIsSupportedForVendorDevicesOnly", new String[]{vendor}), clientInternationalizer.translateText("Error"));
                        return;
                    }
                }
                if (!_selection[i].getAsString("ProductLineName").equals(productLineName)) {
                    this.showMessage(pForm, false, clientInternationalizer.translateText("MultipleConfigurationIsSupportedForDevicesOfTheSameProductLine"), clientInternationalizer.translateText("Error"));
                    return;
                }
                if (_selection[i].getAsString("Model").startsWith("Undiscovered")) {
                    this.showUndiscoveredWarning = true;
                    continue;
                }
                if (device instanceof AvChassisDevice) {
                    _chassisH.put(_selection[i].getAsProxy("Key").getRCOID(), _selection[i]);
                } else if (device instanceof AvCard) {
                    _cardsVect.addElement(_selection[i]);
                }
                _selectionVect.addElement(_selection[i]);
            }
            for (i = 0; i < _cardsVect.size(); ++i) {
                try {
                    RCBeanProxy dev = (RCBeanProxy)_selectionVect.elementAt(i);
                    RCBeanProxy parentKey = dev.getAsProxy("Key").getAsProxy("ParentKey");
                    AvTrace.traceln("AvEms", 1, "Device is : " + dev.getRCClass() + " parentKey is : " + parentKey.getRCOID());
                    if (parentKey == null || !_chassisH.containsKey(parentKey.getRCOID())) continue;
                    _chassisH.remove(parentKey.getRCOID());
                    AvTrace.traceln("AvEms", 1, "chassis contains parentKey  : " + parentKey);
                    continue;
                }
                catch (Exception e) {
                    AvTrace.traceStack("AvEms", 2, e);
                }
            }
            for (RCBeanProxy devBean : _chassisH.values()) {
                RCBeanProxy key = devBean.getAsProxy("Key");
                Vector components = key.getAsVector("Components");
                for (int j = 0; j < components.size(); ++j) {
                    RCBeanProxy nrKey = (RCBeanProxy)components.elementAt(j);
                    RCBeanProxy nr = nrKey.getAsProxy("NetworkResource");
                    if (nr == null) {
                        AvTrace.traceln("AvEms", 1, "WARNING: Found NetworkResourceKey without NetworkResource - " + key.getRCKEY());
                        continue;
                    }
                    if (!Class.forName("com.ngnms.common.AvCard").isAssignableFrom(Class.forName(nr.getRCClass())) || _selectionVect.contains(nr)) continue;
                    _selectionVect.add(nr);
                }
            }
            String mtd = "";
            String ipAddress = "";
            String parentName = "";
            for (RCBeanProxy devBean : _selectionVect) {
                AvTrace.traceln("AvEms", 1, "Selected device is : " + devBean.getAsString("Name"));
                RCBeanProxy key = devBean.getAsProxy("Key");
                if (Class.forName(devBean.getRCClass()).newInstance() instanceof AvDevice) {
                    parentName = devBean.getAsString("Name");
                    ipAddress = ((RCBeanProxy)devBean.getAsVector("Authentication").firstElement()).getAsString("IPAddress");
                } else {
                    RCBeanProxy parentKey = key.getAsProxy("ParentKey");
                    RCBeanProxy nr = parentKey.getAsProxy("NetworkResource");
                    if (nr != null) {
                        Vector auth = nr.getAsVector("Authentication");
                        ipAddress = ((RCBeanProxy)auth.firstElement()).getAsString("IPAddress");
                        if (ipAddress == null) {
                            ipAddress = "";
                        }
                        parentName = nr.getAsString("Name");
                    } else {
                        AvTrace.traceln("AvEms", 3, "Device " + devBean.getAsString("Name") + "has not Parent NR");
                    }
                }
                RCBeanProxy mtdBP = devBean.getAsProxy("MetaData");
                mtd = ipAddress + "+" + productLineName + "+" + parentName;
                AvTrace.traceln("AvEms", 1, "Meta Data = " + mtd);
                mtdBP.set("Description", (Object)mtd);
                devBean.set("MetaData", (Object)mtdBP);
            }
        }
        catch (Exception _e) {
            AvTrace.traceStack("AvEms", 2, _e);
            this.showMessage(pForm, false, clientInternationalizer.translateText("ProblemToStartApplication"), clientInternationalizer.translateText("Error"));
            return;
        }
        Hashtable _hash = null;
        String pTitle = clientInternationalizer.translateText("ConfigMultipleDevice") + " - " + clientInternationalizer.translateText(productLineName) + " " + clientInternationalizer.translateText("ProductLine");
        _hash = RedCellRuntimeUtil.createParameterHash((IOWFormLauncher)((IRCEntityManager)pForm).getFormLauncher());
        _hash.put("DeviceList", _selectionVect);
        _hash.put("_title", pTitle);
        try {
            String formName = AvLookup.get("MultipleEquipmentConfigurationForm", productLineName);
            if (this.showUndiscoveredWarning) {
                this.showMessage(pForm, false, clientInternationalizer.translateText("MultipleConfigurationIsNotAllowedForUndiscoveredDevices"), clientInternationalizer.translateText("Warning"));
            }
            IOWRuntimeForm multipleConfigPanel = (IOWRuntimeForm)RedCellRuntimeUtil.showPanel((Object[])new Object[]{formName, _hash});
        }
        catch (Exception _e) {
            AvTrace.traceln("AvEms", 2, "Cannot lookup MultipleEquipmentConfigurationForm for Product Line: " + productLineName + _e);
            AvTrace.traceStack("AvEms", 3, _e);
        }
    }

    public void execute(IRCEntityManager pManager) {
        this.execute((IOWRuntimeForm)pManager);
    }

    public void execute(IRCEntityEditor pEditor) {
        this.execute((IOWRuntimeForm)pEditor);
    }
}

