/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.log;

import com.bwanms.ruledelegator.BaseFormController;
import com.dorado.common.widget.components.OWFCParentPanel;
import com.dorado.common.widget.components.explorer.IOWExplorerNode;
import com.dorado.common.widget.components.explorer.IOWExplorerNodeContainer;
import com.dorado.common.widget.components.explorer.OWExplorerNode;
import com.dorado.common.widget.components.explorer.OWExplorerNodeContainer;
import com.dorado.common.widget.components.formlauncher.IOWFormLauncher;
import com.dorado.common.widget.components.interfaces.IOWGButton;
import com.dorado.common.widget.components.interfaces.IOWGCheckBox;
import com.dorado.common.widget.components.interfaces.IOWGDataWidget;
import com.dorado.common.widget.components.interfaces.IOWGDateSelect;
import com.dorado.common.widget.components.interfaces.IOWGLabel;
import com.dorado.common.widget.components.interfaces.IOWGPanel;
import com.dorado.common.widget.components.interfaces.IOWGSpinner;
import com.dorado.common.widget.components.interfaces.IOWGSplitPane;
import com.dorado.common.widget.components.interfaces.IOWGStandardPanel;
import com.dorado.common.widget.components.interfaces.IOWGTextArea;
import com.dorado.common.widget.components.interfaces.IOWGTextField;
import com.dorado.common.widget.components.interfaces.IOWGTimeSelect;
import com.dorado.core.logstorage.OWLogMsg;
import com.dorado.runtime.IOWEventListener;
import com.dorado.runtime.IOWFormController;
import com.dorado.runtime.IOWFormControllerEvent;
import com.dorado.runtime.IOWFormControllerEventInfo;
import com.dorado.runtime.IOWFormUserMethods;
import com.dorado.runtime.IOWRuntimeForm;
import com.dorado.runtime.OWEvent;
import com.dorado.runtime.OWEventAttribValueOperator;
import com.dorado.runtime.OWEventException;
import com.dorado.runtime.OWEventSelector;
import com.dorado.runtime.OWFormControllerEvent;
import com.dorado.runtime.OWSet;
import com.ngnms.apps.log.AvLogFormGetRuleParamSet;
import com.ngnms.apps.log.AvLogFormGetRuleResponseParamSet;
import com.ngnms.apps.log.AvLogFormSetRuleParamSet;
import com.ngnms.apps.log.AvLogFormSetRuleResponseParamSet;
import com.ngnms.apps.log.AvLogGetCategoriesRuleParamSet;
import com.ngnms.apps.log.AvLogPanelJAVAGUI;
import com.ngnms.apps.log.IAvLogEventTypes;
import com.ngnms.common.AvClientInternationalizer;
import com.ngnms.common.AvEmsUtil;
import com.ngnms.common.AvFormID;
import com.ngnms.common.AvServerToFormEvent;
import com.ngnms.common.AvTrace;
import java.awt.Cursor;
import java.awt.Window;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import oracle.help.Help;
import redcell.common.interfaces.IRCOptionPaneListener;
import redcell.common.util.RCOptionPaneUtil;
import redcell.common.util.RedCellHelpUtil;
import redcell.common.util.RedCellRuleEngineUtil;
import redcell.common.util.RedCellRuntimeUtil;
import redcell.common.util.RedCellWorkSpaceUtil;
import redcell.core.usersys.RCUserUtil;

public class AvLogPanelFormController
extends BaseFormController
implements IOWEventListener,
IOWFormUserMethods,
IOWRuntimeForm,
IRCOptionPaneListener {
    public String startupSelectedCategory;
    public Vector logMsgVector;
    public AvClientInternationalizer internationalizer;
    public AvFormID formID;
    public AvServerToFormEvent serverToFormEvent;
    public String crtCategory;
    public TreeSet deletedLogsSet = new TreeSet();
    IOWGStandardPanel panelButtons;
    IOWGButton btnDelete;
    IOWGButton btnExport;
    IOWGButton btnRefresh;
    IOWGButton btnClose;
    IOWGButton btnHelp;
    IOWGSplitPane splitPane;
    IOWGStandardPanel splitPaneTop;
    IOWGDataWidget popupMenuDelete;
    IOWGStandardPanel StatusPanel;
    IOWGLabel lblQueryStatus;
    IOWGSpinner spnMaxRows;
    IOWGLabel lblMaxRows;
    IOWGStandardPanel PanelOptionsRight;
    IOWGTimeSelect tsEndTime;
    IOWGDateSelect dsEndDate;
    IOWGTimeSelect tsStartTime;
    IOWGDateSelect dsStartDate;
    IOWGCheckBox chkStartTime;
    IOWGLabel lblEndTime;
    IOWGCheckBox chkEndTime;
    IOWGLabel lblStartTime;
    IOWGStandardPanel PanelOptionsLeft;
    IOWGLabel lblCategory;
    IOWGDataWidget comboCategory;
    IOWGLabel lblEntity;
    IOWGLabel lblUser;
    IOWGDataWidget comboUsers;
    IOWGCheckBox chkUser;
    IOWGCheckBox chkEntity;
    IOWGTextField tfEntity;
    IOWGDataWidget tblLogTable;
    IOWGStandardPanel splitPaneBottom;
    IOWGTextArea taLogText;
    protected String frmLog_title;

    public AvLogPanelFormController(AvLogPanelJAVAGUI form) throws SecurityException, NoSuchFieldException {
        super((OWFCParentPanel)form);
        this.bindFields();
    }

    private void bindFields() throws SecurityException, NoSuchFieldException {
        this.panelButtons = (IOWGStandardPanel)this.getComponent("panelButtons");
        this.btnDelete = (IOWGButton)this.getComponent("btnDelete");
        this.btnExport = (IOWGButton)this.getComponent("btnExport");
        this.btnRefresh = (IOWGButton)this.getComponent("btnRefresh");
        this.btnClose = (IOWGButton)this.getComponent("btnClose");
        this.btnHelp = (IOWGButton)this.getComponent("btnHelp");
        this.splitPane = (IOWGSplitPane)this.getComponent("splitPane");
        this.splitPaneTop = (IOWGStandardPanel)this.getComponent("splitPaneTop");
        this.popupMenuDelete = (IOWGDataWidget)this.getComponent("popupMenuDelete");
        this.StatusPanel = (IOWGStandardPanel)this.getComponent("StatusPanel");
        this.lblQueryStatus = (IOWGLabel)this.getComponent("lblQueryStatus");
        this.spnMaxRows = (IOWGSpinner)this.getComponent("spnMaxRows");
        this.lblMaxRows = (IOWGLabel)this.getComponent("lblMaxRows");
        this.PanelOptionsRight = (IOWGStandardPanel)this.getComponent("PanelOptionsRight");
        this.tsEndTime = (IOWGTimeSelect)this.getComponent("tsEndTime");
        this.dsEndDate = (IOWGDateSelect)this.getComponent("dsEndDate");
        this.tsStartTime = (IOWGTimeSelect)this.getComponent("tsStartTime");
        this.dsStartDate = (IOWGDateSelect)this.getComponent("dsStartDate");
        this.chkStartTime = (IOWGCheckBox)this.getComponent("chkStartTime");
        this.lblEndTime = (IOWGLabel)this.getComponent("lblEndTime");
        this.chkEndTime = (IOWGCheckBox)this.getComponent("chkEndTime");
        this.lblStartTime = (IOWGLabel)this.getComponent("lblStartTime");
        this.PanelOptionsLeft = (IOWGStandardPanel)this.getComponent("PanelOptionsLeft");
        this.lblCategory = (IOWGLabel)this.getComponent("lblCategory");
        this.comboCategory = (IOWGDataWidget)this.getComponent("comboCategory");
        this.lblEntity = (IOWGLabel)this.getComponent("lblEntity");
        this.lblUser = (IOWGLabel)this.getComponent("lblUser");
        this.comboUsers = (IOWGDataWidget)this.getComponent("comboUsers");
        this.chkUser = (IOWGCheckBox)this.getComponent("chkUser");
        this.chkEntity = (IOWGCheckBox)this.getComponent("chkEntity");
        this.tfEntity = (IOWGTextField)this.getComponent("tfEntity");
        this.tblLogTable = (IOWGDataWidget)this.getComponent("tblLogTable");
        this.splitPaneBottom = (IOWGStandardPanel)this.getComponent("splitPaneBottom");
        this.taLogText = (IOWGTextArea)this.getComponent("taLogText");
    }

    public void action(OWEvent pEvent) {
        this.taLogText.setText("");
        if (pEvent instanceof AvLogFormGetRuleResponseParamSet) {
            AvLogFormGetRuleResponseParamSet getResponseParamSet = (AvLogFormGetRuleResponseParamSet)pEvent;
            if (getResponseParamSet.getOperation().equals("GET_LOGS")) {
                this.logMsgVector = getResponseParamSet.getLogMessages();
                this.addLogsToTable();
                this.crtCategory = this.comboCategory.getSelectedValue();
                this.enableButtons(true);
            }
        } else if (pEvent instanceof AvLogFormSetRuleResponseParamSet) {
            AvLogFormSetRuleResponseParamSet setResponseParamSet = (AvLogFormSetRuleResponseParamSet)pEvent;
            if (setResponseParamSet.getOperation().equals("DeleteLogs")) {
                AvTrace.traceln("AvLog", 3, "logMsgVector size before - " + this.logMsgVector.size());
                this.logMsgVector = this.getRestLogsFromVector(this.deletedLogsSet);
                AvTrace.traceln("AvLog", 3, "logMsgVector size after  - " + this.logMsgVector.size());
            } else if (setResponseParamSet.getOperation().equals("EmptyCategory")) {
                this.logMsgVector.clear();
            }
            this.addLogsToTable();
            this.enableButtons(true);
        }
    }

    public void actionDeletePopup() {
        String _value = this.popupMenuDelete.getSelectedValue();
        String operation = null;
        String message = null;
        if (_value.equals("DeleteAllLogsInCategory")) {
            operation = "EmptyCategory";
            message = "DoYouWantToDeleteAllLogsInCategory";
        }
        final String deleteOperation = operation;
        final int formType = this.getFormType();
        IRCOptionPaneListener optionPaneListener = new IRCOptionPaneListener(){

            public void optionPaneButtonClicked(int pButton) {
                if (pButton == 0 && null != deleteOperation) {
                    AvLogPanelFormController.this.sendDeleteLogsEvent(deleteOperation);
                }
            }

            public int getFormType() {
                return formType;
            }
        };
        AvEmsUtil.showConfirmDialog(this.getFormLauncher(), optionPaneListener, message, "DeleteLogsConfirmation", this.internationalizer);
    }

    public void actionEndTimeSelChanged() {
        boolean timeSelected = this.chkEndTime.isSelected();
        this.lblEndTime.setEnabled(timeSelected);
        this.dsEndDate.setEnabled(timeSelected);
        this.tsEndTime.setEnabled(timeSelected);
    }

    public void actionStartTimeSelChanged() {
        boolean timeSelected = this.chkStartTime.isSelected();
        this.lblStartTime.setEnabled(timeSelected);
        this.dsStartDate.setEnabled(timeSelected);
        this.tsStartTime.setEnabled(timeSelected);
    }

    public void addLogsToTable() {
        this.getFormController().setBusy(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy");
        SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm:ss a");
        this.tblLogTable.clearNodes();
        OWExplorerNodeContainer root = (OWExplorerNodeContainer)this.tblLogTable.getRoot();
        for (int i = 0; i < this.logMsgVector.size(); ++i) {
            OWLogMsg msg = (OWLogMsg)this.logMsgVector.get(i);
            Date dateLogged = msg.getDateLogged();
            String category = msg.getCategory();
            String userID = msg.getUserLabel();
            String entity = msg.getEntity();
            Long logNumber = msg.getLogNumber();
            String dateStr = dateFormat.format(dateLogged);
            String timeStr = timeFormat.format(dateLogged);
            String _logNo = logNumber.toString();
            OWExplorerNodeContainer rowContainer = new OWExplorerNodeContainer("", "", _logNo, "");
            rowContainer.add((IOWExplorerNodeContainer)new OWExplorerNodeContainer("TIME", dateStr + " " + timeStr.toLowerCase(), _logNo, "LogTableDateStyle"));
            rowContainer.add((IOWExplorerNodeContainer)new OWExplorerNodeContainer("USER_LABEL", userID, _logNo, "LogTableStyle"));
            rowContainer.add((IOWExplorerNodeContainer)new OWExplorerNodeContainer("ENTITY", entity, _logNo, "LogTableStyle"));
            root.add((IOWExplorerNodeContainer)rowContainer);
        }
        if (0 == this.logMsgVector.size()) {
            this.lblQueryStatus.setText(this.internationalizer.translateText("NoLogsFound"));
        } else {
            this.lblQueryStatus.setText(this.internationalizer.translateText("LogsRetrieved", new String[]{"" + this.logMsgVector.size()}));
        }
        this.tblLogTable.refresh();
        this.getFormController().setBusy(false);
    }

    public void enableButtons(boolean pEnable) {
        this.btnRefresh.setEnabled(pEnable);
        this.btnDelete.setEnabled(pEnable);
        this.btnExport.setEnabled(pEnable);
        this.comboCategory.setEnabled(pEnable);
    }

    public void fillComboCategories(OWSet pCategoriesSet) {
        AvTrace.traceln("AvLog", 3, "in fillComboCategories - startupSelectedCategory = " + this.startupSelectedCategory);
        try {
            Vector _categories = pCategoriesSet.getContents();
            AvTrace.traceln("AvLog", 3, "_categories.size() = " + _categories.size());
            this.startupSelectedCategory = this.internationalizer.translateText(this.startupSelectedCategory);
            AvEmsUtil.fillComboBox(_categories, this.startupSelectedCategory, this.comboCategory, _categories);
            AvTrace.traceln("AvLog", 3, "After fillComboBox");
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
    }

    public void fillComboUsers(Vector pUsersVector) {
        AvTrace.traceln("AvLog", 1, "In fillComboUsers.");
        try {
            OWExplorerNodeContainer root = (OWExplorerNodeContainer)this.comboUsers.getRoot();
            for (int i = 0; i < pUsersVector.size(); ++i) {
                Hashtable hash = (Hashtable)pUsersVector.elementAt(i);
                String userID = (String)hash.get("UserId");
                OWExplorerNode cell = new OWExplorerNode();
                cell.setText(new String(userID));
                cell.setValue(new String(userID));
                root.add((IOWExplorerNodeContainer)new OWExplorerNodeContainer((IOWExplorerNode)cell));
                AvTrace.traceln("AvLog", 1, "UserID = " + userID);
            }
            this.comboUsers.refresh();
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
    }

    public Date getFullDate(String pDateString, String pTimeString) {
        AvTrace.traceln("AvLog", 3, "In getFullDate.");
        try {
            SimpleDateFormat timeFormatFull = new SimpleDateFormat("M/d/yy h:m:s a");
            String fullDateString = pDateString + " " + pTimeString;
            AvTrace.traceln("AvLog", 3, "Original String Time is: " + fullDateString);
            Date retVal = timeFormatFull.parse(fullDateString);
            return retVal;
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
            return null;
        }
    }

    public OWLogMsg getLogFromVector(long pLogNumber) {
        for (int i = 0; i < this.logMsgVector.size(); ++i) {
            OWLogMsg msg = (OWLogMsg)this.logMsgVector.get(i);
            if (msg.getLogNumber() != pLogNumber) continue;
            return msg;
        }
        return null;
    }

    public Vector getLogsFromVector(Collection pColl) {
        Vector<OWLogMsg> _result = new Vector<OWLogMsg>(pColl.size());
        for (int i = 0; i < this.logMsgVector.size(); ++i) {
            OWLogMsg msg = (OWLogMsg)this.logMsgVector.get(i);
            if (!pColl.contains(msg.getLogNumber())) continue;
            _result.add(msg);
        }
        return _result;
    }

    public Vector getRestLogsFromVector(Collection pColl) {
        Vector<OWLogMsg> _result = new Vector<OWLogMsg>(this.logMsgVector.size() - pColl.size());
        for (int i = 0; i < this.logMsgVector.size(); ++i) {
            OWLogMsg msg = (OWLogMsg)this.logMsgVector.get(i);
            if (pColl.contains(msg.getLogNumber())) continue;
            _result.add(msg);
        }
        return _result;
    }

    public void onAllCategories() {
        AvTrace.traceln("AvLog", 3, "In onAllCategories.");
        try {
            if (this.tfEntity.getText().equalsIgnoreCase("AllCategories")) {
                System.setProperty("AvLogCategories", "LOG_ALL");
                this.tfEntity.setText("");
            } else if (this.tfEntity.getText().equalsIgnoreCase("APPOnly")) {
                System.setProperty("AvLogCategories", "LOG_APP_ONLY");
                this.tfEntity.setText("");
            }
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 3, e);
        }
    }

    public void onDeleteButton() {
        AvTrace.traceln("AvLog", 3, "In onDeleteButton.");
        try {
            IOWExplorerNode[] selectedNodes = this.tblLogTable.getSelectedNodesArray();
            this.deletedLogsSet.clear();
            if (null != selectedNodes && selectedNodes.length > 0) {
                for (int i = 0; i < selectedNodes.length; ++i) {
                    String val = selectedNodes[i].getValue();
                    this.deletedLogsSet.add(new Long(val));
                }
            }
            if (this.deletedLogsSet.size() > 0) {
                final int formType = this.getFormType();
                IRCOptionPaneListener optionPaneListener = new IRCOptionPaneListener(){

                    public void optionPaneButtonClicked(int pButton) {
                        if (pButton == 0) {
                            try {
                                AvLogFormSetRuleParamSet setRuleParamSet = new AvLogFormSetRuleParamSet();
                                setRuleParamSet.setFormID(AvLogPanelFormController.this.formID.getID());
                                setRuleParamSet.setOperation("DeleteLogs");
                                setRuleParamSet.setDeletedLogs(AvLogPanelFormController.this.getLogsFromVector(AvLogPanelFormController.this.deletedLogsSet));
                                AvLogPanelFormController.this.enableButtons(false);
                                setRuleParamSet.emit();
                            }
                            catch (Exception e) {
                                AvTrace.traceStack("AvLog", 1, e);
                                AvLogPanelFormController.this.enableButtons(true);
                            }
                        }
                    }

                    public int getFormType() {
                        return formType;
                    }
                };
                AvEmsUtil.showConfirmDialog(this.getFormLauncher(), optionPaneListener, "AreYouSureYouWantToDelete", new String[]{Integer.toString(this.deletedLogsSet.size())}, "DeleteLogsConfirmation", this.internationalizer);
            }
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
    }

    public void onEntitySelected() {
        AvTrace.traceln("AvLog", 1, "In onEntitySelected.");
        this.tfEntity.setEnabled(this.chkEntity.isSelected());
        this.lblEntity.setEnabled(this.chkEntity.isSelected());
    }

    public void onExit() {
        try {
            IOWFormLauncher formLauncher = (IOWFormLauncher)this.getUserProperty("FormLauncher");
            OWFCParentPanel form = (OWFCParentPanel)formLauncher.getSelectedPanelContainer().getPanel();
            formLauncher.removePanel(form.getClass().getName(), form.getId());
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
    }

    public void onHelp() {
        AvTrace.traceln("AvLog", 1, "In onHelp/");
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Help.registerClientWindow((Window)RedCellRuntimeUtil.getLaunchConsole());
            RedCellHelpUtil.showHelp((Window)RedCellRuntimeUtil.getLaunchConsole(), (String)RedCellWorkSpaceUtil.getProperty((String)"redcell.ngnms.help.log", (String)"NgnmsGeneralHelp"));
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 2, e);
            AvEmsUtil.showWarningMessage(this.getFormLauncher(), (IRCOptionPaneListener)this.getThisForm(), "HelpNotAvailable", "Error", this.internationalizer);
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.requestFocus();
    }

    public void onInitialize() {
        try {
            this.formID = new AvFormID("AvLogPanel");
            this.serverToFormEvent = new AvServerToFormEvent();
            OWEventSelector evs = this.serverToFormEvent.getSelector();
            evs.addAttribValueOperator(new OWEventAttribValueOperator("FormID", "=", (Serializable)((Object)this.formID.getID())));
            this.serverToFormEvent.addEventListener((IOWEventListener)this.getThisForm());
            IOWFormController formController = this.getFormController();
            IOWFormControllerEventInfo[] events = IAvLogEventTypes.EVENTS;
            for (int i = 0; i < events.length; ++i) {
                formController.registerEvent(events[i]);
            }
            formController.addEventListener((Object)this.getThisForm(), IAvLogEventTypes.SHOW_LOG_EVENT);
            this.internationalizer = new AvClientInternationalizer("AvLogTitlesBundle");
            this.translate();
            String logCategories = System.getProperty("AvLogCategories", "GET_CATEGORIES");
            AvTrace.traceln("AvLog", 2, "logCategories (From System Property) = " + logCategories);
            AvLogGetCategoriesRuleParamSet getLogCategoriesParamSet = new AvLogGetCategoriesRuleParamSet();
            if (logCategories.equals("LOG_ALL")) {
                getLogCategoriesParamSet.setOperation("GET_ALL_CATEGORIES");
            } else {
                getLogCategoriesParamSet.setOperation("GET_CATEGORIES");
            }
            RedCellRuleEngineUtil.callRule((String)"com.ngnms.apps.log.AvLogGetCategoriesRule", (OWEvent)getLogCategoriesParamSet);
            this.fillComboCategories(getLogCategoriesParamSet.getCategories());
            Vector users = RCUserUtil.filterUsers((String)"UserId", (String)"", (int)1000);
            Hashtable<String, String> hash = new Hashtable<String, String>(1);
            hash.put("UserId", AvTrace.LOG_USER_ID_APP);
            users.add(hash);
            this.fillComboUsers(users);
            SimpleDateFormat timeFormatFull = new SimpleDateFormat("M/d/yyyy h:m:s a");
            Date _dateTime = new Date();
            String _dateTimeString = timeFormatFull.format(_dateTime);
            int timeInd = _dateTimeString.indexOf(" ", 0);
            this.dsEndDate.setText(_dateTimeString.substring(0, timeInd));
            this.tsEndTime.setText(_dateTimeString.substring(timeInd + 1));
            _dateTime = new Date(_dateTime.getTime() - 86400000L);
            _dateTimeString = timeFormatFull.format(_dateTime);
            timeInd = _dateTimeString.indexOf(" ", 0);
            this.dsStartDate.setText(_dateTimeString.substring(0, timeInd));
            this.tsStartTime.setText(_dateTimeString.substring(timeInd + 1));
            this.spnMaxRows.setValue(1000);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
    }

    public void onRefreshButton() {
        AvTrace.traceln("AvLog", 3, "In onRefreshButton.");
        AvLogFormGetRuleParamSet formGetRuleParamSet = new AvLogFormGetRuleParamSet();
        formGetRuleParamSet.setFormID(this.formID.getID());
        formGetRuleParamSet.setDisplayLength(this.spnMaxRows.getValue());
        Date _startDate = null;
        Date _endDate = null;
        if (this.chkStartTime.isSelected()) {
            AvTrace.traceln("AvLog", 3, "StartTime: " + this.dsStartDate.getDate() + " " + this.tsStartTime.getTime());
            _startDate = this.getFullDate(this.dsStartDate.getDate(), this.tsStartTime.getTime());
            formGetRuleParamSet.setStartDate(_startDate);
        }
        if (this.chkEndTime.isSelected()) {
            AvTrace.traceln("AvLog", 3, "  EndTime: " + this.dsEndDate.getDate() + " " + this.tsEndTime.getTime());
            _endDate = this.getFullDate(this.dsEndDate.getDate(), this.tsEndTime.getTime());
            formGetRuleParamSet.setEndDate(_endDate);
        }
        if (null != _startDate && null != _endDate && _startDate.after(_endDate)) {
            AvEmsUtil.showWarningMessage(this.getFormController().getCurrentFormLauncher(), (IRCOptionPaneListener)this.getThisForm(), "StartDateCantBeAfterEndDate", "Error", this.internationalizer);
            return;
        }
        if (this.chkUser.isSelected()) {
            formGetRuleParamSet.setUserID(this.comboUsers.getSelectedValue());
        }
        if (this.chkEntity.isSelected()) {
            formGetRuleParamSet.setEntity(this.tfEntity.getText());
        }
        formGetRuleParamSet.setCategory(this.comboCategory.getSelectedValue());
        formGetRuleParamSet.setOperation("GET_LOGS");
        try {
            this.enableButtons(false);
            this.lblQueryStatus.setText(this.internationalizer.translateText("RetrievingLogDataMessage"));
            formGetRuleParamSet.emit();
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
            this.enableButtons(true);
            this.lblQueryStatus.setText("");
        }
    }

    public void onShowLogEvent() {
        AvTrace.traceln("AvLog", 3, "in onShowLogEvent.");
        try {
            IOWFormControllerEventInfo eventInfo = IAvLogEventTypes.SHOW_LOG_EVENT;
            String userPropertyName = eventInfo.getUserPropertyName();
            this.startupSelectedCategory = this.internationalizer.translateText((String)this.getUserProperty(userPropertyName));
            AvTrace.traceln("AvLog", 3, "In onShowLogEvent - startupSelectedCategory = " + this.startupSelectedCategory);
            try {
                AvEmsUtil.selectNodeByValue(this.comboCategory, this.startupSelectedCategory);
            }
            catch (Exception e) {
                AvTrace.traceln("AvLog", 1, "Failed to selectNodeByValue - " + e.getMessage());
            }
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
    }

    public void onTableSelect() {
        AvTrace.traceln("AvLog", 3, "In onTableSelect.");
        try {
            IOWExplorerNode[] selectedNodes = this.tblLogTable.getSelectedNodesArray();
            long logNumber = 0L;
            AvTrace.traceln("AvLog", 3, "In onTableSelect - getSelectedNodesArray");
            if (selectedNodes != null && selectedNodes.length > 0) {
                for (int i = 0; i < selectedNodes.length; ++i) {
                    AvTrace.traceln("AvLog", 1, i + 1 + ". Name: " + selectedNodes[i].getName() + ", Text:" + selectedNodes[i].getText() + ", Value: " + selectedNodes[i].getValue());
                    String val = selectedNodes[i].getValue();
                    if (logNumber == 0L) {
                        logNumber = Long.parseLong(val);
                        continue;
                    }
                    if (val.equals("" + logNumber)) continue;
                    AvTrace.traceln("AvLog", 1, i + 1 + " Multiple Selection - Skipping ...");
                    this.taLogText.setText("");
                    return;
                }
                this.taLogText.setText(this.getLogFromVector(logNumber).getLogText());
            }
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
    }

    public void onTimeSelected() {
        AvTrace.traceln("AvLog", 3, "In onTimeSelected.");
        try {
            boolean timeSelected = this.chkStartTime.isSelected();
            this.lblStartTime.setEnabled(timeSelected);
            this.lblEndTime.setEnabled(timeSelected);
            this.dsStartDate.setEnabled(timeSelected);
            this.dsEndDate.setEnabled(timeSelected);
            this.tsStartTime.setEnabled(timeSelected);
            this.tsEndTime.setEnabled(timeSelected);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
    }

    public void onUserSelected() {
        AvTrace.traceln("AvLog", 3, "In onUserSelected.");
        this.comboUsers.setEnabled(this.chkUser.isSelected());
        this.lblUser.setEnabled(this.chkUser.isSelected());
    }

    public void openExportPanel() {
        AvTrace.traceln("AvLog", 1, "In openExportPanel.");
        try {
            String exportLogTitle = this.internationalizer.translateText("ExportLog");
            if (this.logMsgVector == null || this.logMsgVector.size() == 0) {
                String msgText = this.internationalizer.translateText("TheLogIsEmpty");
                RCOptionPaneUtil.showWarningMessage((IOWFormLauncher)this.getFormController().getCurrentFormLauncher(), (IRCOptionPaneListener)this.getThisForm(), (String)msgText, (String)exportLogTitle);
                return;
            }
            IOWFormLauncher formLauncher = this.getFormController().getCurrentFormLauncher();
            Hashtable<String, Object> params = new Hashtable<String, Object>();
            params.put("LogsVector", this.logMsgVector);
            if (this.chkStartTime.isSelected()) {
                params.put("StartDate", this.dsStartDate.getDate() + " " + this.tsStartTime.getTime());
                params.put("EndDate", this.dsEndDate.getDate() + " " + this.tsEndTime.getTime());
            }
            if (this.chkUser.isSelected()) {
                params.put("UserID", this.comboUsers.getSelectedValue());
            }
            if (this.chkEntity.isSelected()) {
                params.put("Entity", this.tfEntity.getText());
            }
            params.put("Category", this.comboCategory.getSelectedValue());
            formLauncher.showPanel("com.ngnms.apps.log.AvLogExportPanel", exportLogTitle, true);
            OWFormControllerEvent event = new OWFormControllerEvent(IAvLogEventTypes.SHOW_LOG_EXPORT_EVENT, params);
            this.getFormController().fireEvent((IOWFormControllerEvent)event);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
    }

    public void optionPaneButtonClicked(int pButton) {
        AvTrace.traceln("AvLog", 3, "In optionPaneButtonClicked - pButton = " + pButton);
    }

    public void refreshForm() {
    }

    public void removeServerEventsListener() {
        try {
            this.serverToFormEvent.removeEventListener((IOWEventListener)this.getThisForm());
        }
        catch (OWEventException e) {
            AvTrace.traceStack("AvLog", 1, (Exception)((Object)e));
        }
    }

    public void sendDeleteLogsEvent(String pOperation) {
        AvLogFormSetRuleParamSet setRuleParamSet = new AvLogFormSetRuleParamSet();
        setRuleParamSet.setFormID(this.formID.getID());
        setRuleParamSet.setOperation(pOperation);
        setRuleParamSet.setCategory(this.crtCategory);
        try {
            this.enableButtons(false);
            setRuleParamSet.emit();
        }
        catch (Exception _e) {
            AvTrace.traceStack("AvLog", 2, _e);
            this.enableButtons(true);
        }
    }

    public void translate() {
        if (null != this.internationalizer) {
            this.internationalizer.translatePanel((IOWGPanel)this.splitPaneTop);
            this.internationalizer.translatePanel((IOWGPanel)this.splitPaneBottom);
            this.internationalizer.translatePanel((IOWGPanel)this.panelButtons);
            this.internationalizer.translateNodes(this.popupMenuDelete);
        }
    }

    public String getTitle() {
        return this.frmLog_title;
    }

    public void setTitle(String s) {
        super.setTitle(s);
        this.frmLog_title = s;
    }

    private AvLogPanelJAVAGUI getThisForm() {
        return (AvLogPanelJAVAGUI)this.getForm();
    }
}

