/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.log;

import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.collections.OWAVPVector;
import com.dorado.common.exception.OWUserException;
import com.dorado.common.utility.OWAttributeValuePair;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.IOWBOMInternalUseMarker;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMEnumeration;
import com.dorado.core.bom.OWBOMFatClient;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.ejb.log.IOWLogDef;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.oware.core.logstorage.OWCategorySetBean;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.dorado.runtime.OWSet;
import com.ngnms.apps.log.AvLogGetCategoriesRule;
import com.ngnms.apps.log.AvLogGetCategoriesRuleParamSet;
import com.ngnms.common.AvClientInternationalizer;
import com.ngnms.common.AvLookup;
import com.ngnms.common.AvTrace;
import org.apache.log4j.Logger;

public class AvLogGetCategoriesRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvLogGetCategoriesRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvLogGetCategoriesRule.run()");
        this.runRule((AvLogGetCategoriesRuleParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvLogGetCategoriesRule.run()");
    }

    public void runRule(AvLogGetCategoriesRuleParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        String operation = pParamSet.getOperation();
        try {
            if (operation.equals("GET_CATEGORIES")) {
                pParamSet.setCategories(this.getCategories());
                return;
            }
            if (operation.equals("GET_ALL_CATEGORIES")) {
                IOWBOMInternalUseMarker marker = new IOWBOMInternalUseMarker(){};
                OWBOMFatClient bomClient = new OWBOMFatClient(marker, "com.dorado.log_dbase", "com.dorado.log_server", false, false, false);
                pParamSet.setCategories(this.getAllCategories((IOWBOMClient)bomClient));
                return;
            }
            AvTrace.traceln("AvLog", 3, "Invalid Operation: " + operation);
            return;
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
            return;
        }
    }

    private OWSet getCategories() {
        AvTrace.traceln("AvLog", 2, "In getCategories");
        OWSet categoriesSet = new OWSet(String.class);
        try {
            OWAVPVector apvVector = AvLookup.getSectionContent("LogCategories");
            AvClientInternationalizer cli = new AvClientInternationalizer("AvLogTitlesBundle");
            for (int i = 0; i < apvVector.size(); ++i) {
                OWAttributeValuePair valuePair = apvVector.elementAt(i);
                String category = cli.translateText(valuePair.getAttributeName());
                AvTrace.traceln("AvLog", 2, "Adding category: " + category);
                categoriesSet.add(category);
            }
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
        return categoriesSet;
    }

    private OWSet getAllCategories(IOWBOMClient pBOM) {
        AvTrace.traceln("AvLog", 2, "In getAllCategories");
        OWSet categoriesSet = new OWSet(String.class);
        try {
            OWBOMQueryByAttribs query = new OWBOMQueryByAttribs(IOWLogDef.CATEGORY_CLASS_NAME, new OWBOMAttribValueOperator("Dropped", "=", (Object)Boolean.FALSE));
            OWBOMEnumeration theEnum = pBOM.getObjectsEnumeration((OWBOMQuery)query);
            while (theEnum.hasNext()) {
                OWCategorySetBean categorySetBean = (OWCategorySetBean)theEnum.next();
                String category = categorySetBean.getCategoryName();
                AvTrace.traceln("AvLog", 3, "Adding category: " + category);
                categoriesSet.add(category);
            }
        }
        catch (OWBOMNotFoundException e) {
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
        return categoriesSet;
    }
}

