/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.log;

import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.core.logstorage.OWLogMsg;
import com.dorado.oware.core.logstorage.OWLogMsgBean;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.apps.log.AvLogClientHelper;
import com.ngnms.apps.log.AvLogFormGetRule;
import com.ngnms.apps.log.AvLogFormGetRuleParamSet;
import com.ngnms.apps.log.AvLogFormGetRuleResponseParamSet;
import com.ngnms.common.AvTrace;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AvLogFormGetRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvLogFormGetRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvLogFormGetRule.run()");
        this.runRule((AvLogFormGetRuleParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvLogFormGetRule.run()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRule(AvLogFormGetRuleParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        String formID = pParamSet.getFormID();
        String operation = pParamSet.getOperation();
        AvLogFormGetRuleResponseParamSet responseParamSet = new AvLogFormGetRuleResponseParamSet();
        responseParamSet.setFormID(formID);
        responseParamSet.setOperation(operation);
        AvLogClientHelper helper = new AvLogClientHelper(this.getLogStorageClient());
        try {
            Date startDate = pParamSet.getStartDate();
            Date endDate = pParamSet.getEndDate();
            String category = pParamSet.getCategory();
            String userID = pParamSet.getUserID();
            String entity = pParamSet.getEntity();
            int displayLength = pParamSet.getDisplayLength();
            if (AvTrace.isTracing("AvLog", 3)) {
                AvTrace.traceln("AvLog", 3, "In AvLogFormGetRule - " + formID);
                AvTrace.traceln("AvLog", 3, "    operation = " + operation);
                AvTrace.traceln("AvLog", 3, "    StartDate = " + startDate);
                AvTrace.traceln("AvLog", 3, "      EndDate = " + endDate);
                AvTrace.traceln("AvLog", 3, "     Category = " + category);
                AvTrace.traceln("AvLog", 3, "       UserID = " + userID);
                AvTrace.traceln("AvLog", 3, "       Entity = " + entity);
                AvTrace.traceln("AvLog", 3, "DisplayLength = " + displayLength);
            }
            Vector _logs = helper.getLogs(category, startDate, endDate, userID, entity, displayLength);
            Vector<OWLogMsg> msgProxySet = new Vector<OWLogMsg>(_logs.size());
            Iterator it = _logs.iterator();
            while (it.hasNext()) {
                msgProxySet.add(new OWLogMsg((OWLogMsgBean)it.next()));
            }
            responseParamSet.setLogMessages(msgProxySet);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
        finally {
            helper.closeLogDB();
            responseParamSet.emit();
        }
    }
}

