/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.log;

import com.bwanms.ruledelegator.BaseFormController;
import com.dorado.common.widget.components.OWFCParentPanel;
import com.dorado.common.widget.components.formlauncher.IOWFormLauncher;
import com.dorado.common.widget.components.interfaces.IOWGButton;
import com.dorado.common.widget.components.interfaces.IOWGLabel;
import com.dorado.common.widget.components.interfaces.IOWGPathSelect;
import com.dorado.core.logstorage.OWLogMsg;
import com.dorado.runtime.IOWEventListener;
import com.dorado.runtime.IOWFormController;
import com.dorado.runtime.IOWFormControllerEventInfo;
import com.dorado.runtime.IOWFormUserMethods;
import com.dorado.runtime.IOWRuntimeForm;
import com.dorado.runtime.OWEvent;
import com.ngnms.apps.log.AvLogExportPanelJAVAGUI;
import com.ngnms.apps.log.IAvLogEventTypes;
import com.ngnms.common.AvClientInternationalizer;
import com.ngnms.common.AvEmsUtil;
import com.ngnms.common.AvTrace;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import redcell.common.interfaces.IRCOptionPaneListener;
import redcell.common.util.RCOptionPaneUtil;

public class AvLogExportPanelFormController
extends BaseFormController
implements IOWEventListener,
IOWFormUserMethods,
IOWRuntimeForm,
IRCOptionPaneListener {
    public String category;
    public String entity;
    public String userID;
    public String endDateString;
    public String startDateString;
    public AvClientInternationalizer clientInternationalizer;
    public Vector logsVector;
    IOWGButton btnCancel;
    IOWGButton btnSave;
    IOWGLabel lblSelect;
    IOWGPathSelect pathSelect;
    protected String frmLogExport_title;

    public AvLogExportPanelFormController(AvLogExportPanelJAVAGUI form) throws SecurityException, NoSuchFieldException {
        super((OWFCParentPanel)form);
        this.bindFields();
    }

    private void bindFields() throws SecurityException, NoSuchFieldException {
        this.btnCancel = (IOWGButton)this.getComponent("btnCancel");
        this.btnSave = (IOWGButton)this.getComponent("btnSave");
        this.lblSelect = (IOWGLabel)this.getComponent("lblSelect");
        this.pathSelect = (IOWGPathSelect)this.getComponent("pathSelect");
    }

    public void action(OWEvent pEvent) {
    }

    public void closeForm() {
        try {
            IOWFormLauncher formLauncher = (IOWFormLauncher)this.getUserProperty("FormLauncher");
            OWFCParentPanel form = (OWFCParentPanel)formLauncher.getSelectedPanelContainer().getPanel();
            formLauncher.removePanel(form.getClass().getName(), form.getId());
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
    }

    public void onInitialize() {
        try {
            AvTrace.traceln("AvLog", 1, "In onInit of LogExport");
            IOWFormController formController = this.getFormController();
            IOWFormControllerEventInfo[] events = IAvLogEventTypes.EVENTS;
            for (int i = 0; i < events.length; ++i) {
                formController.registerEvent(events[i]);
            }
            this.getFormController().addEventListener((Object)this.getThisForm(), IAvLogEventTypes.SHOW_LOG_EXPORT_EVENT);
            this.clientInternationalizer = new AvClientInternationalizer("AvLogTitlesBundle");
            this.translate();
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
    }

    public void onShowLogExportEvent() {
        try {
            IOWFormControllerEventInfo eventInfo = IAvLogEventTypes.SHOW_LOG_EXPORT_EVENT;
            String userPropertyName = eventInfo.getUserPropertyName();
            Hashtable params = (Hashtable)this.getUserProperty(userPropertyName);
            this.logsVector = (Vector)params.get("LogsVector");
            this.startDateString = (String)params.get("StartDate");
            this.endDateString = (String)params.get("EndDate");
            this.userID = (String)params.get("UserID");
            this.entity = (String)params.get("Entity");
            this.category = (String)params.get("Category");
            AvTrace.traceln("AvLog", 1, "In onShowLogExportEvent of LogExport - logsVector.size() = " + this.logsVector.size());
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
    }

    public void optionPaneButtonClicked(int pButton) {
        AvTrace.traceln("AvLog", 3, "In optionPaneButtonClicked - pButton = " + pButton);
        if (0 == pButton) {
            this.saveLogsToFile();
        }
    }

    public void saveLogs() {
        String filePath = this.pathSelect.getPath();
        if (filePath == null || filePath.length() == 0) {
            return;
        }
        File file = new File(filePath);
        if (file.exists()) {
            AvEmsUtil.showConfirmDialog(this.getFormController().getCurrentFormLauncher(), (IRCOptionPaneListener)this.getThisForm(), "LogExportFileExistsConfirmOverwrite", "Warning", this.clientInternationalizer);
            return;
        }
        this.saveLogsToFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLogsToFile() {
        String filePath = this.pathSelect.getPath();
        if (filePath == null || filePath.length() == 0) {
            return;
        }
        String newLine = "\r\n";
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(filePath, false));
            StringBuffer header = new StringBuffer("Log Export file");
            header.append(newLine);
            header.append(newLine);
            header.append("Criteria:");
            header.append(newLine);
            header.append("----------------------------------");
            header.append(newLine);
            if (this.category != null) {
                header.append("Category:   " + this.category + newLine);
            }
            if (this.startDateString != null && this.startDateString.length() > 0 && this.endDateString != null && this.endDateString.length() > 0) {
                header.append("Start Date: " + this.startDateString + newLine);
                header.append("End Date:   " + this.endDateString + newLine);
            }
            if (this.userID != null) {
                header.append("User ID:    " + this.userID + newLine);
            }
            if (this.entity != null) {
                header.append("Entity:     " + this.entity + newLine);
            }
            header.append(newLine);
            header.append(newLine);
            bw.write(header.toString());
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy");
            SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm:ss a");
            for (int i = 0; i < this.logsVector.size(); ++i) {
                OWLogMsg msg = (OWLogMsg)this.logsVector.elementAt(i);
                Date dateLogged = msg.getDateLogged();
                String category = msg.getCategory();
                String userID = msg.getUserLabel();
                String entity = msg.getEntity();
                Long logNumber = msg.getLogNumber();
                String logText = msg.getLogText();
                String dateStr = dateFormat.format(dateLogged);
                String timeStr = timeFormat.format(dateLogged);
                StringBuffer sb = new StringBuffer("<<<<<<<<<<<<<<< Start Of Log >>>>>>>>>>>>>>>");
                sb.append(newLine);
                sb.append("Log Number: ");
                sb.append(logNumber);
                sb.append(newLine);
                sb.append("Log Date:   ");
                sb.append(dateStr + " " + timeStr);
                sb.append(newLine);
                sb.append("Category:   ");
                sb.append(category);
                sb.append(newLine);
                sb.append("User ID:    ");
                sb.append(userID);
                sb.append(newLine);
                sb.append("Entity:     ");
                sb.append(entity);
                sb.append(newLine);
                sb.append("Log Text:   ");
                sb.append(logText);
                sb.append(newLine);
                sb.append("<<<<<<<<<<<<<<<< End Of Log >>>>>>>>>>>>>>>>");
                sb.append(newLine);
                sb.append(newLine);
                bw.write(sb.toString());
            }
            this.closeForm();
        }
        catch (FileNotFoundException e) {
        }
        catch (SecurityException e) {
            RCOptionPaneUtil.showWarningMessage((IOWFormLauncher)this.getFormController().getCurrentFormLauncher(), (IRCOptionPaneListener)this.getThisForm(), (String)e.getMessage(), (String)"Error");
        }
        catch (IOException e) {
            RCOptionPaneUtil.showWarningMessage((IOWFormLauncher)this.getFormController().getCurrentFormLauncher(), (IRCOptionPaneListener)this.getThisForm(), (String)e.getMessage(), (String)"Error");
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
        finally {
            if (null != bw) {
                try {
                    bw.close();
                }
                catch (IOException ioe) {
                    AvTrace.traceStack("AvLog", 1, ioe);
                }
            }
        }
    }

    public void translate() {
        try {
            this.lblSelect.setText(this.clientInternationalizer.translateText(this.lblSelect.getText()));
            this.btnCancel.setText(this.clientInternationalizer.translateText(this.btnCancel.getText()));
            this.btnSave.setText(this.clientInternationalizer.translateText(this.btnSave.getText()));
            this.pathSelect.setTitle(this.clientInternationalizer.translateText(this.pathSelect.getTitle()));
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLog", 1, e);
        }
    }

    public String getTitle() {
        return this.frmLogExport_title;
    }

    public void setTitle(String s) {
        super.setTitle(s);
        this.frmLogExport_title = s;
    }

    private AvLogExportPanelJAVAGUI getThisForm() {
        return (AvLogExportPanelJAVAGUI)this.getForm();
    }
}

