/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.log;

import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.IOWBOMInternalUseMarker;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMClientUtility;
import com.dorado.core.bom.OWBOMEnumeration;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.bom.OWBOMQueryByKey;
import com.dorado.core.ejb.log.IOWLogDef;
import com.dorado.core.ejb.log.IOWLogStorageClient;
import com.dorado.core.ejb.log.OWLogMsgNotFoundException;
import com.dorado.core.ejb.log.OWLogStorageException;
import com.dorado.core.logstorage.OWLogMsg;
import com.dorado.oware.core.logstorage.OWLogMsgBean;
import com.dorado.runtime.IOWBean;
import com.ngnms.common.AvTrace;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class AvLogClientHelper
implements IOWBOMInternalUseMarker {
    public static final String OP_EMPTY_CATEGORY = "EmptyCategory";
    public static final String OP_DELETE_LOGS = "DeleteLogs";
    private IOWBOMClient logDBClient;
    private IOWLogStorageClient logStorageClient;
    private static final String CATEGORY_STRING = "Category";
    private static final String DATE_LOGGED_STRING = "DateLogged";
    private static final String USER_LABEL_STRING = "UserLabel";
    private static final String ENTITY_STRING = "Entity";
    private static final String DROPPED_STRING = "Dropped";
    private boolean isCSB = false;
    private int batchSize = 200;

    public AvLogClientHelper(IOWLogStorageClient pLogStorageClient) {
        this.logStorageClient = pLogStorageClient;
    }

    public Vector getLogs(String pCategory, Date pStartDate, Date pEndDate, String pUserID, String pEntity, int pMaxSize) throws OWLogStorageException {
        Vector _result = new Vector();
        try {
            this.connectToLogDB();
            OWBOMQueryByAttribs query = new OWBOMQueryByAttribs(IOWLogDef.LOGMSG_CLASS_NAME);
            if (this.isCSB) {
                query.addAttribValueOperator(new OWBOMAttribValueOperator(DROPPED_STRING, "=", (Object)Boolean.FALSE));
            }
            if (null != pCategory && pCategory.length() > 0) {
                query.addAttribValueOperator(new OWBOMAttribValueOperator("AND", CATEGORY_STRING, "=", (Object)pCategory));
            }
            if (null != pStartDate) {
                query.addAttribValueOperator(new OWBOMAttribValueOperator("AND", DATE_LOGGED_STRING, ">=", (Object)pStartDate));
            }
            if (null != pEndDate) {
                query.addAttribValueOperator(new OWBOMAttribValueOperator("AND", DATE_LOGGED_STRING, "<=", (Object)pEndDate));
            }
            if (null != pUserID && pUserID.length() > 0) {
                query.addAttribValueOperator(new OWBOMAttribValueOperator("AND", USER_LABEL_STRING, "=", (Object)pUserID));
            }
            if (null != pEntity && pEntity.length() > 0) {
                query.addAttribValueOperator(new OWBOMAttribValueOperator("AND", ENTITY_STRING, "LIKE", (Object)pEntity));
            }
            if (pMaxSize > 0) {
                query.setMaxQuerySize(pMaxSize);
            }
            _result = (Vector)this.logDBClient.getObjects((OWBOMQuery)query).getRtnObject();
        }
        catch (OWBOMNotFoundException nfe) {
        }
        catch (Exception _e) {
            throw new OWLogStorageException((Object)_e.getMessage(), 0, 0);
        }
        return _result;
    }

    public void dropLog(String pCategory, Long pLogNumber) throws OWLogStorageException {
        if (this.isCSB || null == this.logStorageClient) {
            try {
                this.connectToLogDB();
                OWBOMQueryByKey query = new OWBOMQueryByKey(IOWLogDef.LOGMSG_CLASS_NAME, pCategory + pLogNumber);
                OWLogMsgBean logBean = (OWLogMsgBean)this.logDBClient.getObjectForUpdate(query).getRtnObject();
                logBean.setDropped(true);
                this.logDBClient.commitObject((IOWBean)logBean);
            }
            catch (OWBOMNotFoundException nfe) {
                AvTrace.traceln("AvLog", 3, "Log not found for delete.");
            }
            catch (Exception e) {
                throw new OWLogStorageException((Object)e.getMessage(), 0, 0);
            }
        } else {
            try {
                this.logStorageClient.dropLog(pCategory, pLogNumber);
            }
            catch (OWLogMsgNotFoundException oWLogMsgNotFoundException) {
                // empty catch block
            }
        }
    }

    public void emptyCategory(String pCategory) throws OWLogStorageException {
        if (this.isCSB || null == this.logStorageClient) {
            this.dropLogs(pCategory, null, null, null, null);
        } else {
            this.logStorageClient.emptyCategory(pCategory);
        }
    }

    public void dropLogs(String pCategory, Date pStartDate, Date pEndDate, String pUserID, String pEntity) throws OWLogStorageException {
        try {
            OWBOMEnumeration _enumeration;
            this.connectToLogDB();
            OWBOMQueryByAttribs query = new OWBOMQueryByAttribs(IOWLogDef.LOGMSG_CLASS_NAME, new OWBOMAttribValueOperator("AND", CATEGORY_STRING, "=", (Object)pCategory));
            if (null != pStartDate) {
                query.addAttribValueOperator(new OWBOMAttribValueOperator("AND", DATE_LOGGED_STRING, ">=", (Object)pStartDate));
            }
            if (null != pEndDate) {
                query.addAttribValueOperator(new OWBOMAttribValueOperator("AND", DATE_LOGGED_STRING, "<=", (Object)pEndDate));
            }
            if (null != pUserID && pUserID.length() > 0) {
                query.addAttribValueOperator(new OWBOMAttribValueOperator("AND", USER_LABEL_STRING, "=", (Object)pUserID));
            }
            if (null != pEntity && pEntity.length() > 0) {
                query.addAttribValueOperator(new OWBOMAttribValueOperator("AND", ENTITY_STRING, "LIKE", (Object)pEntity));
            }
            if (null == (_enumeration = this.logDBClient.getObjectsEnumeration((OWBOMQuery)query))) {
                return;
            }
            _enumeration.setBatchSize(this.batchSize);
            ArrayList _objs = null;
            while (null != (_objs = _enumeration.nextBlock())) {
                this.dropLogsBatch(_objs);
            }
        }
        catch (OWBOMNotFoundException nfe) {
        }
        catch (Exception e) {
            throw new OWLogStorageException((Object)e.getMessage(), 0, 0);
        }
    }

    public void dropLogs(List pLogs) throws OWLogStorageException {
        try {
            this.connectToLogDB();
            int _idx = 0;
            int _logsSize = pLogs.size();
            Vector<OWLogMsgBean> _crtBatch = new Vector<OWLogMsgBean>(this.batchSize);
            while (_idx < _logsSize) {
                OWLogMsg _msg = (OWLogMsg)pLogs.get(_idx++);
                OWLogMsgBean _msgBean = (OWLogMsgBean)_msg.getBean();
                _crtBatch.add(_msgBean);
                if (0 != _idx % this.batchSize && _idx != _logsSize) continue;
                this.dropLogsBatch(_crtBatch);
                _crtBatch.clear();
            }
        }
        catch (Exception e) {
            throw new OWLogStorageException((Object)e.getMessage(), 0, 0);
        }
    }

    private void dropLogsBatch(List pLogs) throws Exception {
        boolean bIsCSB;
        boolean bl = bIsCSB = this.isCSB || null == this.logStorageClient;
        if (bIsCSB) {
            for (OWLogMsgBean _msgBean : pLogs) {
                _msgBean.setDropped(true);
            }
            this.logDBClient.commitObjects(pLogs);
        } else {
            this.logDBClient.deleteObjects(pLogs);
        }
    }

    private void connectToLogDB() throws Exception {
        if (null == this.logDBClient) {
            this.logDBClient = OWBOMClientUtility.getIOWBOMClient((IOWBOMInternalUseMarker)this, (String)"com.dorado.log_dbase", (String)"com.dorado.log_server", (boolean)false, (boolean)false, (boolean)false);
            this.isCSB = 2 == this.logDBClient.getDBType();
        }
    }

    public void closeLogDB() {
        if (null != this.logDBClient) {
            this.logDBClient.closeAPI();
            this.logDBClient = null;
        }
    }
}

