/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.location;

import RedCell.Config.Location;
import RedCell.Config.LocationNameChangedEvent;
import com.bwanms.ruledelegator.redcell.RCGenericSaveRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.common.utility.OWOID;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMCommitObjectException;
import com.dorado.core.bom.OWBOMDupAddObjectException;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.oware.core.security.OWObjectGroup;
import com.dorado.redcell.inventory.base.commandhandler.RCRuleStatus;
import com.dorado.redcell.inventory.location.ILocationDefs;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.apps.location.AvSaveLocationRule;
import com.ngnms.apps.location.AvSaveLocationRuleParamSet;
import com.ngnms.common.AvDeviceUtil;
import com.ngnms.common.AvException;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvWorkSpace;
import com.ngnms.security.AvSecurityUtil;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import redcell.common.util.RCBOMUtil;
import redcell.common.util.RCBeanProxy;
import redcell.core.security.RCObjectGroupUtility;

public class AvSaveLocationRuleImpl
extends RCGenericSaveRuleImpl {
    String oldLocationID = null;
    OWObjectGroup definedObjGroup = null;
    OWObjectGroup crtObjGroup = null;
    private static final Logger log4j = Logger.getLogger(AvSaveLocationRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvSaveLocationRule.run()");
        this.runRule((AvSaveLocationRuleParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvSaveLocationRule.run()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRule(AvSaveLocationRuleParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        RCRuleStatus _status = new RCRuleStatus();
        RCBeanProxy locationProxy = pParamSet.getEntity();
        String _name = locationProxy.getAsString("LocationID");
        if (_name == null || 0 == _name.trim().length()) {
            String _msg = ILocationDefs.locationMsgUtil.getString(2003L);
            _status.setSuccess(false);
            _status.setMessage(_msg);
            pParamSet.setStatus(_status);
            return;
        }
        locationProxy.set("SecurityEnabled", (Object)new Boolean(pParamSet.getSecurityEnabled()));
        AvWorkSpace ws = null;
        try {
            Vector commitVector;
            ws = AvWorkSpace.getAndLockWorkSpace("AvDeviceUtil_WorkSpace");
            boolean _adding = null == locationProxy.getRCOID() || locationProxy.getRCOID().toString().equals("null");
            Location location = null;
            if (!_adding) {
                try {
                    location = (Location)RCBOMUtil.getOWObject((IOWBOMClient)this.getBOM(), (OWOID)locationProxy.getRCOID());
                    this.oldLocationID = location.getLocationID();
                    this.crtObjGroup = AvSecurityUtil.getObjectGroup(this.getBOM(), this.oldLocationID + " Location_", null);
                    this.definedObjGroup = AvSecurityUtil.getObjectGroup(this.getBOM(), this.oldLocationID + " Location", null);
                }
                catch (Exception e) {
                    AvTrace.traceStack("AvLocation", 1, e);
                }
            }
            if (this.isUnique(locationProxy, _adding)) {
                commitVector = this.getBeans(locationProxy, _adding);
                location = (Location)commitVector.get(0);
                boolean bSecurityEnabled = (Boolean)locationProxy.get("SecurityEnabled");
                if (bSecurityEnabled) {
                    if (null == this.definedObjGroup) {
                        this.definedObjGroup = RCObjectGroupUtility.getInstance().newObjectGroup(location.getLocationID() + " Location");
                        commitVector.add(this.definedObjGroup);
                    }
                } else if (null != this.definedObjGroup) {
                    this.getBOM().deleteObject((IOWBean)this.definedObjGroup);
                    commitVector.add(this.definedObjGroup);
                    this.definedObjGroup = null;
                }
                Location parent = null;
                if (null != location.getParent() && location.getParent().length() > 0) {
                    try {
                        parent = (Location)RCBOMUtil.getOWObjectByKey((IOWBOMClient)this.getBOM(), (String)"RedCell.Config.Location", (String)location.getParent());
                    }
                    catch (OWBOMNotFoundException nfe) {
                        AvTrace.traceln("AvLocation", 1, "Parent with ID " + location.getParent() + " NOT FOUND!!!");
                    }
                }
                AvTrace.traceln("AvLocation", 3, " SaveLocationRule commitVector before updateSecRec: " + commitVector.size());
                String newLocationID = location.getLocationID();
                if (null != this.oldLocationID) {
                    location.setLocationID(this.oldLocationID);
                }
                AvDeviceUtil.updateLocationSecurityRec(this.getBOM(), location, parent, this.definedObjGroup, commitVector);
                if (null != this.oldLocationID) {
                    location.setLocationID(newLocationID);
                }
            } else {
                _status.setSuccess(false);
                _status.setMessage(this.getIsDuplicateMessage());
                pParamSet.setStatus(_status);
                return;
            }
            AvTrace.traceln("AvLocation", 3, " SaveLocationRule commitVector after updateSecRec: " + commitVector.size());
            this.getBOM().commitObjects((List)commitVector);
            this.getBOM().commitAll();
            pParamSet.setOid(location.getHandle());
            _status.setSuccess(true);
        }
        catch (OWBOMDupAddObjectException _bdaoe) {
            _status.setSuccess(false);
            _status.setMessage(this.getIsDuplicateMessage());
        }
        catch (OWBOMCommitObjectException _bcoe) {
            String _msg = _bcoe.getMessage();
            switch (_bcoe.getMsgNum()) {
                case 116: {
                    _msg = "You must supply a key value.";
                    break;
                }
                case 118: {
                    _msg = "Cannot update. Object's timestamp expired.";
                }
            }
            _status.setSuccess(false);
            _status.setMessage(_msg);
        }
        catch (Exception _e) {
            _e.printStackTrace();
            _status.setSuccess(false);
            _status.setMessage(_e.getMessage());
        }
        finally {
            if (null != ws) {
                try {
                    ws.closeWorkSpace();
                }
                catch (AvException ave) {
                    ave.printStackTrace();
                }
            }
        }
        pParamSet.setStatus(_status);
        String newName = locationProxy.getAsString("LocationID");
        if (!newName.equals(this.oldLocationID)) {
            LocationNameChangedEvent _locationEvent = new LocationNameChangedEvent();
            _locationEvent.setInstanceOID((Serializable)locationProxy.getRCOID());
            _locationEvent.setNewLocName(newName);
            _locationEvent.setOldLocName(this.oldLocationID);
            _locationEvent.emit();
        }
    }

    public Vector getBeans(RCBeanProxy pProxy, boolean pAdding) throws Exception {
        Vector<OWObjectGroup> localBeans = new Vector<OWObjectGroup>();
        String locationID = pProxy.getAsString("LocationID");
        AvTrace.traceln("AvLocation", 2, " SaveLocationRule getBeans():  locationID: " + locationID + "   oldLocationID: " + this.oldLocationID);
        if (null != this.oldLocationID && !locationID.equals(this.oldLocationID)) {
            if (null != this.crtObjGroup) {
                this.crtObjGroup.setGroupID(locationID + " Location_");
                localBeans.add(this.crtObjGroup);
                AvTrace.traceln("AvLocation", 2, " SaveLocationRule getBeans():  updated objGroup: " + this.crtObjGroup.getGroupID());
            }
            if (null != this.definedObjGroup) {
                this.definedObjGroup.setGroupID(locationID + " Location");
                localBeans.add(this.definedObjGroup);
                AvTrace.traceln("AvLocation", 2, " SaveLocationRule getBeans():  updated objGroup: " + this.definedObjGroup.getGroupID());
            }
            try {
                OWBOMQueryByAttribs _qba = new OWBOMQueryByAttribs("RedCell.Config.Location", new OWBOMAttribValueOperator("Parent", (Object)this.oldLocationID));
                Vector _objs = (Vector)this.getBOM().getObjects((OWBOMQuery)_qba).getRtnObject();
                Enumeration _objList = _objs.elements();
                while (_objList.hasMoreElements()) {
                    Location _loc = (Location)_objList.nextElement();
                    _loc.setParent(locationID);
                    AvTrace.traceln("AvLocation", 2, " SaveLocationRule getBeans():  updated subLocation: " + _loc.getLocationID());
                }
                localBeans.addAll(_objs);
            }
            catch (OWBOMNotFoundException nfe) {
                // empty catch block
            }
        }
        AvTrace.traceln("AvLocation", 2, " SaveLocationRule getBeans():  localBeans size: " + localBeans.size());
        Vector _beans = super.getBeans(pProxy, pAdding);
        if (null == _beans) {
            _beans = new Vector();
        }
        _beans.addAll(localBeans);
        return _beans;
    }

    public boolean isUnique(RCBeanProxy pProxy, boolean pAdding) throws Exception {
        if (pAdding || null != this.oldLocationID && !pProxy.getAsString("LocationID").equals(this.oldLocationID)) {
            try {
                RCBOMUtil.getOWObjectByKey((IOWBOMClient)this.getBOM(), (String)pProxy.getRCClass(), (String)pProxy.getAsString("LocationID"));
                return false;
            }
            catch (OWBOMNotFoundException oWBOMNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public String getIsDuplicateMessage() {
        return ILocationDefs.locationMsgUtil.getString(5000L);
    }
}

