/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.location;

import RedCell.Config.Location;
import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQueryByKey;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.oware.core.security.OWObjectGroup;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.apps.location.AvGetLocationObjGroupsParamSet;
import com.ngnms.apps.location.AvGetLocationObjGroupsRule;
import com.ngnms.common.AvDeviceUtil;
import com.ngnms.common.AvTrace;
import com.ngnms.security.AvSecurityUtil;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AvGetLocationObjGroupsRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvGetLocationObjGroupsRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvGetLocationObjGroupsRule.run()");
        this.runRule((AvGetLocationObjGroupsParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvGetLocationObjGroupsRule.run()");
    }

    public void runRule(AvGetLocationObjGroupsParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        Vector<OWObjectGroup> ret = new Vector<OWObjectGroup>();
        try {
            Location startLocation;
            Location location = startLocation = AvDeviceUtil.getLocation(this.getBOM(), pParamSet.getLocationID(), false);
            try {
                while (null != location) {
                    String parentID;
                    OWObjectGroup objGroup = AvSecurityUtil.getObjectGroup(this.getBOM(), location.getLocationID(), "Location");
                    if (null != objGroup) {
                        ret.add(objGroup);
                        AvTrace.traceln("AvDeviceUtil", 3, "getLocationObjectGroups - Found objGroup: " + objGroup.getGroupID());
                    }
                    if (null != (parentID = location.getParent()) && 0 != parentID.trim().length()) {
                        OWBOMQueryByKey qbk = new OWBOMQueryByKey("RedCell.Config.Location", parentID);
                        location = (Location)this.getBOM().getObject(qbk).getRtnObject();
                        continue;
                    }
                    break;
                }
            }
            catch (OWBOMNotFoundException nfe) {
                // empty catch block
            }
            AvTrace.traceln("AvDeviceUtil", 3, "getLocationObjectGroups Location: " + startLocation.getLocationID() + " objGroups count: " + ret.size());
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLocation", 1, e);
            pParamSet.setMessage(e.getMessage());
        }
        pParamSet.setObjectGroups(ret);
        pParamSet.setSuccess(true);
    }
}

