/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.location;

import RedCell.Config.Location;
import com.bwanms.ruledelegator.redcell.RCGenericDeleteRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.bom.OWBOMQueryByReferenceAttribute;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.core.message.OWMSGQuery;
import com.dorado.oware.core.security.OWObjectGroup;
import com.dorado.redcell.inventory.base.commandhandler.RCDeleteCommandParamSet;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.apps.location.AvDeleteLocationRule;
import com.ngnms.common.AvDeviceUtil;
import com.ngnms.common.AvException;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvWorkSpace;
import com.ngnms.security.AvSecurityUtil;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;
import redcell.common.util.RCBOMUtil;

public class AvDeleteLocationRuleImpl
extends RCGenericDeleteRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvDeleteLocationRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvDeleteLocationRule.run()");
        this.runRule((RCDeleteCommandParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvDeleteLocationRule.run()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRule(RCDeleteCommandParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvWorkSpace ws = null;
        try {
            ws = AvWorkSpace.getAndLockWorkSpace("AvDeviceUtil_WorkSpace");
            super.runRule(pParamSet);
        }
        finally {
            if (null != ws) {
                try {
                    ws.closeWorkSpace();
                }
                catch (AvException ave) {
                    ave.printStackTrace();
                }
            }
        }
    }

    public boolean checkRefIntegrity(IOWBean pBean, boolean pCheckChildren) {
        OWMSGQuery _msgQuery = new OWMSGQuery();
        try {
            OWBOMQueryByReferenceAttribute _qbr = new OWBOMQueryByReferenceAttribute("RedCell.Config.Equipment", "Location", pBean, false);
            this.getBOM().getObjects((OWBOMQuery)_qbr);
            _msgQuery = new OWMSGQuery();
            String _entityName = OWMSGQuery.fetchMessageByNumber((long)30L, (String)"RC_ENTITY_TYPES");
            String _refEntityName = OWMSGQuery.fetchMessageByNumber((long)10L, (String)"RC_ENTITY_TYPES");
            this.setRefIntegrityFailedMsg(_entityName, _refEntityName);
            return false;
        }
        catch (OWBOMNotFoundException _bnfe) {
            if (pCheckChildren) {
                try {
                    String _locId = ((Location)pBean).getLocationID();
                    OWBOMQueryByAttribs _qba = new OWBOMQueryByAttribs("RedCell.Config.Location", new OWBOMAttribValueOperator("Parent", (Object)_locId));
                    Enumeration _beanList = ((Vector)this.getBOM().getObjects((OWBOMQuery)_qba).getRtnObject()).elements();
                    while (_beanList.hasMoreElements()) {
                        if (this.checkRefIntegrity((IOWBean)_beanList.nextElement(), pCheckChildren)) continue;
                        _msgQuery = new OWMSGQuery();
                        String _entityName = OWMSGQuery.fetchMessageByNumber((long)30L, (String)"RC_ENTITY_TYPES");
                        String _refEntityName = OWMSGQuery.fetchMessageByNumber((long)10L, (String)"RC_ENTITY_TYPES");
                        this.setRefIntegrityFailedMsg(_entityName, _refEntityName);
                        return false;
                    }
                }
                catch (Throwable _e2) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (Throwable _e) {
            return false;
        }
    }

    public void deleteBean(IOWBean pBean, boolean pDeleteChildren) throws Exception {
        OWObjectGroup crtObjGroup;
        Location _bean = (Location)pBean;
        String _locID = _bean.getLocationID();
        String _parent = _bean.getParent();
        Location parentBean = null;
        if (null != _parent && _parent.length() > 0) {
            try {
                parentBean = (Location)RCBOMUtil.getOWObjectByKey((IOWBOMClient)this.getBOM(), (String)"RedCell.Config.Location", (String)_parent);
            }
            catch (OWBOMNotFoundException nfe) {
                AvTrace.traceln("AvLocation", 1, "Parent Location Defined But Not Found!!!");
            }
        }
        Vector<Object> commitVector = new Vector<Object>();
        Vector<Object> deleteVector = new Vector<Object>();
        commitVector.add(pBean);
        deleteVector.add(pBean);
        OWObjectGroup definedObjGroup = AvSecurityUtil.getObjectGroup(this.getBOM(), _locID + " Location", null);
        if (null != definedObjGroup) {
            commitVector.add(definedObjGroup);
            deleteVector.add(definedObjGroup);
        }
        if (null != (crtObjGroup = AvSecurityUtil.getObjectGroup(this.getBOM(), _locID + " Location_", null))) {
            commitVector.add(crtObjGroup);
            deleteVector.add(crtObjGroup);
        }
        this.handleChildren(pDeleteChildren, _locID, _parent, deleteVector, commitVector);
        if (!pDeleteChildren) {
            AvDeviceUtil.updateLocationSecurityRec(this.getBOM(), _bean, parentBean, null, commitVector);
        }
        this.getBOM().deleteObjects(deleteVector);
        this.getBOM().commitObjects(commitVector);
    }

    public void handleChildren(boolean pDeleteChildren, String pLocationID, String pParent, Vector pDeleteVector, Vector pCommitVector) throws Exception {
        OWBOMQueryByAttribs _qba = new OWBOMQueryByAttribs("RedCell.Config.Location", new OWBOMAttribValueOperator("Parent", (Object)pLocationID));
        try {
            Vector _objs = (Vector)this.getBOM().getObjects((OWBOMQuery)_qba).getRtnObject();
            Enumeration _objList = _objs.elements();
            if (pDeleteChildren) {
                while (_objList.hasMoreElements()) {
                    OWObjectGroup crtObjGroup;
                    Location _childLoc = (Location)_objList.nextElement();
                    String _locID = _childLoc.getLocationID();
                    OWObjectGroup definedObjGroup = AvSecurityUtil.getObjectGroup(this.getBOM(), _locID + " Location", null);
                    if (null != definedObjGroup) {
                        pCommitVector.add(definedObjGroup);
                        pDeleteVector.add(definedObjGroup);
                    }
                    if (null != (crtObjGroup = AvSecurityUtil.getObjectGroup(this.getBOM(), _locID + " Location_", null))) {
                        pCommitVector.add(crtObjGroup);
                        pDeleteVector.add(crtObjGroup);
                    }
                    pCommitVector.add(_childLoc);
                    pDeleteVector.add(_childLoc);
                    this.handleChildren(pDeleteChildren, _locID, null, pDeleteVector, pCommitVector);
                }
            } else {
                while (_objList.hasMoreElements()) {
                    Location _childLoc = (Location)_objList.nextElement();
                    _childLoc.setParent(pParent);
                    pCommitVector.add(_childLoc);
                }
            }
        }
        catch (OWBOMNotFoundException _e) {
            // empty catch block
        }
    }
}

